module Array(module Ix,    -- export all of Ix for convenience
       	     Array, array, listArray, (!), bounds, indices, elems, assocs,
	     accumArray, (//), accum, ixmap, amap) where
import Ix
infixl 9 !

data Array a = Array (Int,Int) (Vector a)

array      :: (Int,Int) -> [(Int,a)] -> Array a
array b ixs =
  Array b (vupd (vinit (rangeSize b) undefined) (map (shift b) ixs))

listArray  :: (Int,Int) -> [a] -> Array a
listArray b xs = Array b (vupd (vinit n undefined) (take n (zip [0..] xs)))
  where n = rangeSize b

(!)	   :: Array a -> Int -> a
Array b v ! i | inRange b i = vget v (index b i)

bounds     :: Array a -> (Int,Int)
bounds (Array b _) = b

indices    :: Array a -> [Int]
indices (Array b _) = range b

elems      :: Array a -> [a]
elems (Array b v) = map (vget v) [0 .. rangeSize b - 1]

assocs	   :: Array a -> [(Int,a)]
assocs a = zip (indices a) (elems a)

(//)       :: Array a -> [(Int,a)] -> Array a
Array b v // ixs = Array b (vupd (vcopy v) (map (shift b) ixs))

accum      :: (a -> b -> a) -> Array a -> [(Int,b)] -> Array a
accum f a ixs = a // [(i,f (a!i) x) | (i,x) <- ixs]

accumArray :: (a -> b -> a) -> a -> (Int,Int) -> [(Int,b)] -> Array a
accumArray f z b = accum f (array b [(i,z) | i <- range b])

ixmap	   :: (Int,Int) -> (Int -> Int) -> Array a -> Array a
ixmap b f a = array b [(i,a ! f i) | i <- range b]

-- amap replace the functor instace of Haskell arrays
amap       :: (a -> b) -> Array a -> Array b
amap f a = array b [(i,f (a!i)) | i <- range b]
  where b = bounds a

-- Primitive vectors
-- N.B.: vupd is not referentially transparent as it uses in-place updates!

data Vector a

external primitive vinit :: Int -> a -> Vector a
external primitive vcopy :: Vector a -> Vector a
external primitive vget :: Vector a -> Int -> a
external primitive vset :: Vector a -> Int -> a -> Vector a

shift :: (Int,Int) -> (Int,a) -> (Int,a)
shift b (i,x) = (index b i,x)

vupd :: Vector a -> [(Int,a)] -> Vector a
vupd = foldr (\(i,x) v -> vset v i x)
