##############################################################################
#
# Copyright (c) 2001 Zope Corporation and Contributors. All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
"""

import Forum, Post, DiscussionTool, ForumPermissions
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import ToolInit, ContentInit
from Products.CMFCore.DirectoryView import registerDirectory

# ADD_CONTENT_PERMISSION = CMFCorePermissions.AddPortalContent

# contentClasses = ( Forum.Forum
#                  , Post.Post
#                  )


# contentConstructors = ( Forum.addForum
#                       , Post.addPost
#                       )

# bases = contentClasses

# fti = ( Forum.factory_type_information,
#         Post.factory_type_information )

tools = ( DiscussionTool.DiscussionTool, )

# Make the skins available as DirectoryViews.
registerDirectory('skins', globals())
cmfforum_globals=globals()

def initialize( context ):

    ToolInit('CMFForum Discussion Tool', tools=tools,
                   product_name='CMFForum', icon='tool.gif',
                   ).initialize( context )

    ContentInit( 'CMFForum Content'
               , content_types=(Forum.Forum,)
               , permission=ForumPermissions.AddForum
               , extra_constructors=(Forum.addForum,)
               , fti=(Forum.factory_type_information, )
               ).initialize( context )

    # Register manually for each type instead of using utils.ContentInit, 
    # as they need different permissions.
    #     context.registerClass(Forum.Forum,
    #                           constructors = (Forum.addForum,),
    #                           permission = ForumPermissions.AddForum)

    context.registerClass(Post.Post,
                          constructors = (Post.addPost,),
                          permission = ForumPermissions.AddForumPosting)
