##############################################################################
#
# Copyright (c) 2001 Zope Corporation and Contributors. All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

from Interface import Base

class IPost(Base):
    def thread_top():
        """ returns the top ancestor """
    def ancestors():
        """Return a list of ancestral posts"""
    def children(sort_key='id', REQUEST=None):
        """Return a list of replies to this item"""
    def inReplyTo():
        """ Return the object for which this object is a reply. """
    def nextReply():
        """ Return the next object that is reply. """
    def nextMessage():
        """ Return the next object on the same level. """
    def previousMessage():
        """ Return the previous object on the same level. """
    def in_reply_to():
        """ Return the id of the object for which this object is a reply. """
    def childMessageCount():
        """ Counts the number of chilren of this message, including this message """
    def threadMessageCount():
        """ Looks at the topmost ancestor, and then counts children """
    def childNewestMessageDate():
        """ Looks through children and returns the newest message date """
    def threadNewestMessageDate():
        """ Looks at the topmost ancestor, and then recurses
	    through the messages finding the last created message
        """
    def hasAttachments():
        """ Boolean value to test if the message has any attachment """
    def getAttachments():
        """ Return a list of attachment objects """
    def addPost(id='', title='', text='', author='', email='', file=None, REQUEST=None):
        """ Add a Post to its container """

	
	
	
	
	    
