from Acquisition import aq_base, aq_parent
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass
from OFS.History import Historical
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.PortalContent  import PortalContent
from Products.CMFCore.utils import getToolByName

#from debug import log, log_exc
from Products.Archetypes.BaseContent import BaseContent, BaseContentMixin
from Products.Archetypes.public import BaseSchema
from Products.Archetypes.interfaces.metadata import IExtensibleMetadata
from global_symbols import *

from ArticleAttachments import ArticleAttachments as Attachments
from ArticleImages import ArticleImages as Images
from ArticleLock import ArticleLock as Lock
from ArticleModel import ArticleModel as Model
from ArticleCore import ArticleCore as Core

class BaseArchetypesArticle(BaseContent, Core, Attachments, Images, Lock, Model):
    """
    A not-so-basic CMF/Archetypes-based Article implementation.
    """

    __implements__ = (BaseContentMixin.__implements__ +
                      (IExtensibleMetadata,))

    security = ClassSecurityInfo()

    schema = BaseSchema

    def __init__(self, oid, **kwargs):
        BaseContent.__init__(self, oid, **kwargs)
        Core.__init__(self, oid, **kwargs)
        Attachments.__init__(self, **kwargs)
        Images.__init__(self, **kwargs)
        Lock.__init__(self, **kwargs)
        Model.__init__(self, **kwargs)


    # Dummy permission methods.
    # This is done to "create" the permissions
    security.declareProtected(PloneArticle_editPermission, "dummyEdit")
    security.declareProtected(PloneArticle_lockPermission, "dummyLock")

    def manage_afterAdd(self, item, container):
        Lock._post_init(self,)
        BaseContent.manage_afterAdd(self, item, container)

    #                                                                           #
    #                           Lock support (core part)                        #
    #                                                                           #

    security.declareProtected(CMFCorePermissions.View, 'isLocked')
    def isLocked(self):
        """Returns 1 if the article is locked otherwise 0"""
        if not getToolByName(self, "portal_article").hasLockSupport():
            return 0
        locked = getattr(self, '_article_locked', 0)
        return locked


    security.declarePublic("checkLockStatus")
    def checkLockStatus(self,):
        """
        checkLockStatus(self,) => raise an exception if the user cannot edit
        things because the article is locked.
        """
        # No lock support => we ignore
        if not getToolByName(self, "portal_article").hasLockSupport():
            return
        if not self.hasLockToken():
            raise RuntimeError, "You cannot modify a locked article"


    security.declareProtected(CMFCorePermissions.View, 'hasLockToken')
    def hasLockToken(self,):
        """
        hasLockToken(self,) => Return 1 if and only if the document is locked by the current user.
        If lock support is not enabled, return 1 anyway.
        This method won't perform more in-depth security checks.

        Each and every editing method must call this method first to ensure that the user
        has the right to edit things.
        """
        # If no lock support => return true anyway
        if not getToolByName(self, "portal_article").hasLockSupport():
            return 1
        if not getattr(self, '_has_lock_support', None):
            return 1

        # If not locked => return false anyway
        if not self.isLocked():
            return 0

        # Check current user's id against locked user's id
        portal_membership = getToolByName(self, 'portal_membership')
        username = portal_membership.getAuthenticatedMember().getUserName()
        return username == self.getLockUser()



InitializeClass(BaseArchetypesArticle)



#### HERE IS AN EXAMPLE CODE YOU CAN COPY/PASTE IN YOUR NEW PRODUCT:
#### The product is called MyArticle.

##from Products.Archetypes.public import Schema, BaseSchema
##from Products.Archetypes.BaseContent import BaseContent, BaseContentMixin
##from Products.Archetypes.public import TextField, StringField
##from Products.Archetypes.public import TextAreaWidget, RichWidget, SelectionWidget, EpozWidget, VisualWidget
##from Products.Archetypes.public import BaseContent, registerType
##from Products.Archetypes.interfaces.metadata import IExtensibleMetadata

##from Products.CMFCore import CMFCorePermissions

##from Products.PloneArticle.BaseArchetypesArticle import BaseArchetypesArticle

##from AccessControl import ClassSecurityInfo
##import string


##class MyArticle(BaseArchetypesArticle, ):
##    """An Archetype example type"""

##    # Since we have customized the default Metadata schema into ArticleInfos...
##    schema = BaseContentMixin.schema # + .... (add your own schemas)

##    actions = (
##    {
##    'id'           : 'view',
##    'name'         : 'View',
##    'action'       : 'string:${object_url}/MyArticle_view',
##    'permissions'   : (CMFCorePermissions.View, ),
##    'category'      : 'object',
##    },
##    {
##    'id'            : 'metadata',
##    'name'          : 'Properties',
##    'action'        : 'string:${object_url}/metadata_edit_form',
##    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
##    'category'      : 'object',
##    },
##    {
##    'id'           : 'image',
##    'name'         : 'Images',
##    'action'       : 'string:${object_url}/PloneArticle_imageForm2',
##    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
##    'category'      : 'object',
##    },
##    {
##    'id'           : 'attach',
##    'name'         : 'Attachments',
##    'action'       : 'string:${object_url}/PloneArticle_attachmentForm2',
##    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
##    'category'      : 'object',
##    },
##    {
##    'id'            : 'metadata',
##    'name'          : 'Properties',
##    'action'        : 'string:${object_url}/metadata_edit_form',
##    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
##    'condition'     : 'object/hasLockToken',
##    'category'      : 'object',
##    },
##    {
##    'id'            : 'content_status_history',
##    'name'          : 'State',
##    'action'        : 'string:${object_url}/content_status_history',
##    'condition'     : 'python:object and portal.portal_workflow.getTransitionsFor(object, object.getParentNode())',
##    'permissions'   : (CMFCorePermissions.View,),
##    'category'      : 'object_tabs',
##    'visible'       : 0
##    },
##    {
##    'id'            : 'toggle_article_lock',
##    'name'          : 'Toggle Lock',
##    'action'        : 'string:${object_url}/toggleArticleLock',
##    'permissions'   : (CMFCorePermissions.View, ),
##    'condition'     : 'python:object.canToggleLock()',
##    'category'      : 'document_actions',
##    },
##    )

##    # Standard security settings
##    security = ClassSecurityInfo()


##    def __init__(self, oid, **kwargs):
##        BaseArchetypesArticle.__init__(self, oid, **kwargs)


##    #                                                                           #
##    #                    SPECIFIC CMF CATALOG SUPPORT                           #
##    #                                                                           #

##    security.declareProtected(CMFCorePermissions.View, 'SearchableText')
##    def SearchableText(self):
##        "Returns a concatanation of all searchable text"
##        ret = "%s %s %s %s" % (
##            self.Title(),                                                        # Essential metadata
##            self.Description(),
##            self.getText(),                                                      # Use the accessor for the 'text' field
##            string.join(map(lambda x: x.SearchableText(), self.listAttachments()), " ") +
##            string.join(map(lambda x: x.title_or_id(), self.listImages()), " ") 
##            )
##        return ret


##registerType(MyArticle)

