import time
import Globals 
from Products.CMFCore.SkinsTool import SkinsTool as BaseTool
from Products.CMFCore.CMFCorePermissions import ManagePortal
from Products.CMFCore import DirectoryView
from AccessControl import ClassSecurityInfo
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Products.CMFCore.utils import getToolByName
from Products.SpeedPack import SPEEDPACK_CACHE_TTL

_marker = []

orig_manage_options      = BaseTool.manage_options

class SkinsToolPatch:

    allowed_meta_types = ('Skin Custom Folder', 'Filesystem Directory View')

    security = ClassSecurityInfo()

    manage_options = ( orig_manage_options +
                      ({ 'label' : 'Reload', 'action' : 'manage_reload' }
                     , 
                     ) 
                     )
    
    security.declareProtected(ManagePortal, 'manage_reload')
    manage_reload = PageTemplateFile( 'www/reloadPortalSkins', globals()  )
    
    security.declareProtected(ManagePortal, 'manage_skinLayers')
    def manage_skinLayers(self, chosen=(), add_skin=0, del_skin=0,
                          skinname='', skinpath='', REQUEST=None):
        """Modify manage_skinLayers so that it clears the skin cache"""
        retval = self._monkey_manage_skinLayers(chosen, add_skin, del_skin, \
                                            skinname, skinpath, REQUEST)
        self.clearSkinCache()
        return retval


    security.declareProtected(ManagePortal, 'manage_properties')
    def manage_properties(self, default_skin='', request_varname='',
                          allow_any=0, chosen=(), add_skin=0,
                          del_skin=0, skinname='', skinpath='',
                          cookie_persistence=0, REQUEST=None):
        """Modify manage_properties so that it clears the skin cache"""
        retval = self._monkey_manage_properties(default_skin, request_varname, \
                                   allow_any, chosen, add_skin, del_skin, \
                                   skinname, skinpath, cookie_persistence, \
                                   REQUEST)
        self.clearSkinCache()
        return retval


    security.declareProtected(ManagePortal, 'addSkinSelection')
    def addSkinSelection(self, skinname, skinpath, test=0, make_default=0):
        """Modify addSkinSelection so that it clears the skin cache"""
        retval = self._monkey_addSkinSelection(skinname, skinpath, test, make_default)
        self.clearSkinCache()
        return retval
    

    security.declarePrivate('getSkinByName')
    def getSkinByName(self, name):
        now = time.time()
        skincache = getattr(self, '_v_skincache', None)
        if skincache is None:
            self.clearSkinCache()
            skincache = self._v_skincache
        else:
            skinob, t = skincache.get(name, (_marker, 0))
            if skinob != _marker:
                if not Globals.DevelopmentMode or (now-t < SPEEDPACK_CACHE_TTL):  # expire cache in dev mode
                    return skinob
        path = self.getSkinPath(name)
        if path is None:
            skinob = None
        else:
            skinob = self.getSkinByPath(path)
        skincache[name] = (skinob, time.time())
        return skinob

    security.declarePrivate('all_meta_types')
    def all_meta_types(self):
        """Allow only specific meta types
        """
        all_meta_types = self._monkey_all_meta_types()

        objects_meta_types = []
        for obj in self.objectValues():
            if obj.meta_type not in objects_meta_types:
                objects_meta_types.append(obj.meta_type)

        allowed = [ meta_type
                    for meta_type in all_meta_types
                    if meta_type['name'] in self.allowed_meta_types or
                      meta_type['name'] in objects_meta_types
                  ]

        if not allowed:
            allowed = all_meta_types
        return allowed

    security.declareProtected(ManagePortal, 'clearSkinCache')
    def clearSkinCache(self):
        """force rebuilding the skin cache
        """
        self._v_skincache = {}
        try:
            self.getParentNode()._invalidateHitCache()  # invalidate ignore/resolve info
        except AttributeError:
            pass # ignore attribute error that occurs during manage_afterAdd

    security.declarePrivate('manage_afterAdd')
    def manage_afterAdd(self, item, container):
        """Clear cache after a new folder was added
        """
        self.clearSkinCache()
        self._monkey_manage_afterAdd(item, container)

    security.declarePrivate('manage_beforeDelete')
    def manage_beforeDelete(self, item, container):
        """Clear cache before a folder was deleted
        """
        self.clearSkinCache()
        self._monkey_manage_beforeDelete(item, container)

    security.declarePrivate('manage_afterClone')
    def manage_afterClone(self, item):
        """Clear cache after an object was copied
        
        XXX Do we need this or is manage_afterAdd sufficient?
        """
        self.clearSkinCache()
        self._monkey_manage_afterClone(item)

    security.declareProtected(ManagePortal, 'manage_reloadSkins')
    def manage_reloadSkins(self, REQUEST = None):
        """reload all files in the skin directories
        """
        self.clearSkinCache()
        stool = getToolByName(self, 'portal_skins')
        retval = []
        # iterate over all directory view surrogates and remove the parsed
        # state to force reloading
        for folder in stool.objectValues():
            if isinstance(folder, DirectoryView.DirectoryViewSurrogate):
                retval.extend(self.reloadDVS(folder))

        # dvs don't have a reload method. We must get the directory from the
        # registry and refresh this to register new files and remove deleted files.
        # XXX Is this save for multiple sites? DirectoryView is using a global var
        registry=DirectoryView._dirreg
        for path in DirectoryView.manage_listAvailableDirectories():
            # get the directory view and set data to None to force a reload
            # and registering of new files
            directory = registry.getDirectoryInfo(path)
            directory.reload()
        return retval
        # ignored
        #if REQUEST:
        #    REQUEST.RESPONSE.redirect('manage_main')
                        
    security.declarePrivate('reloadDVS')
    def reloadDVS(self, dvs, parent=''):
        """reloads a directory view surrogate
        """
        parent += '%s/' % dvs.getId()
        retval=[]
        for item in dvs.objectValues():
            if isinstance(item, DirectoryView.DirectoryViewSurrogate):
                # recursive
                retval.extend(self.reloadDVS(item, parent))
            elif item._parsed:
                # set _parsed to 0 to force the reload of the FSObject
                retval.append("Reloading %s%s" % (parent, item.getId()) )
                item._parsed = 0
        return retval

Globals.InitializeClass(SkinsToolPatch)
