##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import os.path
import string
import re

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

import striphtml


class MSWordAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    MSWord file abstraction
    """
    
    icon_file = "word.gif"
    small_icon_file = "word_small.gif"
    content_types = ('application/msword', )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => index a MSWord file and store it in the index variable.
        This method is called only once (in the __init__) during the class's lifetime.
        """
        # If no converter present, just return an empty string
        if not self.hasConverter():
            return ""

        # Call the converter normally
        fn = self.writeAttachmentFile()
        try:
            ret = self.callConverter(arguments = "%s" % (fn, ))
        finally:
            self.deleteAttachmentFile()
        return striphtml.strip(ret)


    def isPreviewAvailable(self,):
        return 1

    def convertPreview(self,):
        """
        Let's convert things into pretty HTML !
        """
        # Perform conversion and retreive files as well
        fn = self.writeAttachmentFile()
        try:
            # Actual HTML conversion
            ret = self.callConverter(arguments = "-d %s %s" % (self.getAttachmentFileDir(), fn, ))

            # Retreive images
            Log(LOG_DEBUG, "Temporary files:", os.listdir(self.getAttachmentFileDir()))
            for fn in os.listdir(self.getAttachmentFileDir()):
                ext = string.lower(string.split(fn, ".")[-1])
                if ext in ('png', 'jpg', 'gif', 'wmz', 'wmf', 'tif', 'tiff', 'jpeg', ):
                    filename = os.path.join(self.getAttachmentFileDir(), fn,)
                    img = open(filename, "rb")
                    self.addRelatedFile(fn, img.read(), "image/%s" % ext)
                    Log(LOG_DEBUG, "Filename to delete", filename)

                    # Close and delete file
                    # We ignore temp file deletion problems
                    img.close()
                    try:        os.unlink(filename)
                    except:     LogException()
            
        finally:
            self.deleteAttachmentFile()

        return self.stripBody(ret)



ZAttachmentRegistry.AttachmentRegistry.registerClass(
    MSWordAttachment, 
    globals(),
    WVWARE_PROGRAM,
    )

