##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from Acquisition import Implicit
from Globals import Persistent
from Globals import MessageDialog, DTMLFile      # fakes a method from a DTML file
from AccessControl import ClassSecurityInfo
from global_symbols import *

import ZAbstractAttachment

INVALID_VALUE = "****** INVALID VALUE *******"


class ZAttachmentRegistry(Implicit, ):
    """
    ZAttachmentRegistry : this class handles ZAbstractAttachment-derived classes
    """
    def __init__(self,):
        Log(LOG_DEBUG, "Refreshing plugins list")
        self.__classes__ = []
    
    def registerClass(self, attachmentClass, module_globals, converterPath = None, ):
        """
        registerClass(self, attachmentClass, module_globals, )
        Register attachmentClass as an attachment class, ensuring it's properly formed.
        """
        # Ensure attachmentClass conformance with the model
        for property in ZAbstractAttachment.ZAbstractAttachment.__must_derive__:
            if getattr(attachmentClass, property, INVALID_VALUE) == getattr(ZAbstractAttachment.ZAbstractAttachment, property, INVALID_VALUE):
                # Works for properties
                try:
                    raise NotImplementedError, "Attribute '%s' of class '%s' must be derived. This plugin won't be enabled." % (property, attachmentClass.__name__)
                except:
                    LogException()
                    return None
            # There's nothing to enforce method-overriding, but, one day I'll put some code snippet here to do so ;-)

        # Store the class
        self.__classes__.insert(0, (attachmentClass, module_globals, converterPath))         # We insert so that the last registered plugin will be the first available
        self.__classes__ = self.__classes__
        Log(LOG_NOTICE, "Registered '%s' class for %s MIME types" % (attachmentClass.__name__, attachmentClass.content_types, ))
        Log(LOG_DEBUG, "%s plugins registered" % (len(self.__classes__), ))
        
    def getAttachmentClass(self, contentType):
        """
        getAttachmentClass(self, contentType) => tuple(class, globs) where class is a ZAbstractAttachment-derived class

        According to a given content type, return a class matching this kind of file
        """
        # Find a content type matching
        for (c, g, cnvt) in self.__classes__:
            if contentType in c.content_types:
                return (c, g, cnvt)

        # If not found, return a dummy class
        import ZDummyAttachment                         # Avoid 'deadlock' in import procedures
        return (ZDummyAttachment.ZDummyAttachment, ZDummyAttachment.attach_globals, None)
    

# Registry instanciation
AttachmentRegistry = ZAttachmentRegistry()


