// Berkeley Open Infrastructure for Network Computing
// http://boinc.berkeley.edu
// Copyright (C) 2005 University of California
//
// This is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation;
// either version 2.1 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Lesser General Public License for more details.
//
// To view the GNU Lesser General Public License visit
// http://www.gnu.org/copyleft/lesser.html
// or write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef h_BASE64
#define h_BASE64

#ifndef _WIN32
#include <cstdio>
#include <cstdlib>
#include <string>
#endif

class InvalidBase64Exception
{
};

std::string r_base64_encode (const char* from, size_t length);
  std::string r_base64_decode (const char* from, size_t length);
inline std::string r_base64_decode (std::string const& from)
{
    return r_base64_decode(from.c_str(), from.length());
}


#endif
