BEGIN TRANSACTION;
/* objects */
CREATE TABLE commands (id INTEGER PRIMARY KEY, name TEXT, command_line TEXT);
CREATE TABLE contacts (id INTEGER PRIMARY KEY, name TEXT, alias TEXT, email TEXT, pager TEXT, address TEXT, notify_on_service_unknown NUMERIC, notify_on_service_warning NUMERIC, notify_on_service_critical NUMERIC, notify_on_service_recovery NUMERIC, notify_on_service_flapping NUMERIC, notify_on_service_downtime NUMERIC, notify_on_host_down NUMERIC, notify_on_host_unreachable NUMERIC, notify_on_host_recovery NUMERIC, notify_on_host_flapping NUMERIC, notify_on_host_downtime NUMERIC, host_notification_period TEXT, service_notification_period TEXT, host_notifications_enabled NUMERIC, service_notifications_enabled NUMERIC, can_submit_commands NUMERIC, retain_status_information NUMERIC, retain_nonstatus_information NUMERIC);
CREATE TABLE contactgroups (id INTEGER PRIMARY KEY, group_name TEXT, alias TEXT);
CREATE TABLE custom_variables (id INTEGER PRIMARY KEY, variable_name TEXT, variable_value TEXT);
CREATE TABLE dateranges (id INTEGER PRIMARY KEY, type NUMERIC, syear NUMERIC, smon NUMERIC, smday NUMERIC, swday NUMERIC, swday_offset NUMERIC, eyear NUMERIC, emon NUMERIC, emday NUMERIC, ewday NUMERIC, ewday_offset NUMERIC, int skip_interval NUMERIC);
CREATE TABLE hosts (id INTEGER PRIMARY KEY, host_name TEXT, display_name TEXT, alias, address TEXT,	host_check_command TEXT, initial_state NUMERIC, check_interval NUMERIC, retry_interval NUMERIC, max_attempts NUMERIC, notification_interval NUMERIC, first_notification_delay NUMERIC, notify_on_down NUMERIC, notify_on_unreachable NUMERIC, notify_on_recovery NUMERIC, notify_on_flapping NUMERIC, notify_on_downtime NUMERIC, stalk_on_up NUMERIC, stalk_on_down NUMERIC, stalk_on_unreachable NUMERIC, notification_period TEXT, check_period TEXT, flap_detection_enabled NUMERIC, low_flap_threshold NUMERIC, high_flap_threshold NUMERIC, flap_detection_on_up NUMERIC, flap_detection_on_down NUMERIC, flap_detection_on_unreachable NUMERIC, check_freshness NUMERIC, freshness_threshold NUMERIC, process_performance_data NUMERIC, checks_enabled NUMERIC, accept_passive_host_checks NUMERIC, event_handler_enabled NUMERIC, retain_status_information NUMERIC, retain_nonstatus_information NUMERIC, obsess_over_host NUMERIC, failure_prediction_enabled NUMERIC, failure_prediction_options TEXT, notes TEXT, notes_url TEXT, action_url TEXT, icon_image TEXT, icon_image_alt TEXT, vrml_image TEXT, statusmap_image TEXT, have_2d_coords NUMERIC, x_2d NUMERIC, y_2d NUMERIC, have_3d_coords NUMERIC, x_3d NUMERIC, y_3d NUMERIC, z_3d NUMERIC, should_be_drawn NUMERIC);
CREATE TABLE hostgroups (id INTEGER PRIMARY KEY, group_name TEXT, alias TEXT, notes TEXT, notes_url TEXT, action_url TEXT);
CREATE TABLE services (id INTEGER PRIMARY KEY, host_name TEXT, service_description TEXT, display_name TEXT, service_check_command TEXT, event_handler TEXT, initial_state NUMERIC, check_interval NUMERIC, retry_interval NUMERIC, max_attempts NUMERIC, parallelize NUMERIC,	notification_interval NUMERIC, first_notification_delay NUMERIC, notify_on_unknown NUMERIC, notify_on_warning NUMERIC, notify_on_critical NUMERIC,	notify_on_recovery NUMERIC, notify_on_flapping NUMERIC, notify_on_downtime NUMERIC, stalk_on_ok NUMERIC, stalk_on_warning NUMERIC, stalk_on_unknown NUMERIC, stalk_on_critical NUMERIC, is_volatile NUMERIC, notification_period TEXT, check_period TEXT, flap_detection_enabled NUMERIC, low_flap_threshold NUMERIC, high_flap_threshold NUMERIC, flap_detection_on_ok NUMERIC, flap_detection_on_warning NUMERIC, flap_detection_on_unknown NUMERIC, flap_detection_on_critical NUMERIC,	check_freshness NUMERIC, freshness_threshold NUMERIC, process_performance_data NUMERIC, checks_enabled NUMERIC, accept_passive_service_checks NUMERIC,	event_handler_enabled NUMERIC, retain_status_information NUMERIC, retain_nonstatus_information NUMERIC, notifications_enabled NUMERIC,	obsess_over_service NUMERIC,	failure_prediction_enabled NUMERIC, failure_prediction_options TEXT, notes TEXT, notes_url TEXT, action_url TEXT, icon_image TEXT, icon_image_alt TEXT);
CREATE TABLE servicegroups (id INTEGER PRIMARY KEY, group_name TEXT, alias TEXT, notes TEXT, notes_url TEXT, action_url TEXT);
CREATE TABLE timeperiods (id INTEGER PRIMARY KEY, name TEXT, alias TEXT);
CREATE TABLE timeranges (id INTEGER PRIMARY KEY, range_start NUMERIC, range_end NUMERIC);

/* relations */
CREATE TABLE commands_to_contacts (command_id NUMERIC, contact_id NUMERIC);
CREATE TABLE contacts_to_hosts (contact_id NUMERIC, host_id NUMERIC);
CREATE TABLE contactgroups_to_hosts (contactgroup_id NUMERIC, host_id NUMERIC);
CREATE TABLE custom_variables_to_contacts (custom_variable_id NUMERIC, contact_id NUMERIC);
CREATE TABLE custom_variables_to_hosts (custom_variable_id NUMERIC, host_id NUMERIC);
CREATE TABLE custom_variables_to_services (custom_variable_id NUMERIC, service_id NUMERIC);
CREATE TABLE dateranges_to_timeranges (daterange_id NUMERIC, timerange_id NUMERIC);
CREATE TABLE hostgroups_to_hosts (hostgroup_id NUMERIC, host_id NUMERIC);
CREATE TABLE host_parents_to_hosts (parent_id NUMERIC, child_id NUMERIC);
CREATE TABLE servicegroups_to_services (servicegroup_id NUMERIC, service_id NUMERIC);
CREATE TABLE timeperiod_excusions (timeperiod_id NUMERIC, timeperiod_source_id NUMERIC, timeperiod_exclusion_id NUMERIC);
CREATE TABLE timeperiods_to_dateranges (timeperiod_id NUMERIC daterange_id NUMERIC);
CREATE TABLE timeperiods_to_timeranges (timeperiod_id NUMERIC timerange_id NUMERIC);

/* information */
CREATE TABLE acknowledgement_data (id INTEGER PRIMARY KEY, acknowledgement_type NUMERIC, host_name TEXT, service_descripTion TEXT, state NUMERIC, author_name TEXT, comment_data TEXT, is_sticky NUMERIC, persistent_comment NUMERIC, notify_contacts NUMERIC);
CREATE TABLE adaptive_contact_data (id INTEGER PRIMARY KEY, command_type NUMERIC, modified_attribute NUMERIC, modified_attributes NUMERIC, modified_host_attribute NUMERIC, modified_host_attributes NUMERIC, modified_service_attribute NUMERIC, modified_service_attributes NUMERIC);
CREATE TABLE adaptive_host_data (id INTEGER PRIMARY KEY, command_type NUMERIC, modified_attribute NUMERIC, modified_attributes NUMERIC);
CREATE TABLE adaptive_program_data (id INTEGER PRIMARY KEY, command_type NUMERIC, modified_host_attribute NUMERIC, modified_host_attributes NUMERIC, modified_service_attribute NUMERIC, modified_service_attributes NUMERIC);
CREATE TABLE comment_data (id INTEGER PRIMARY KEY, comment_type NUMERIC, host_name TEXT, service_description TEXT, entry_time NUMERIC, author_name TEXT, comment_data TEXT, persistent NUMERIC, source NUMERIC, entry_type NUMERIC, expires NUMERIC, expire_time NUMERIC, comment_id NUMERIC);
CREATE TABLE contact_notification_data (id INTEGER PRIMARY KEY, notification_type NUMERIC, start_time NUMERIC, end_time NUMERIC, host_name TEXT, service_descripTion TEXT, contact_name TEXT, reason_type NUMERIC, state NUMERIC, output TEXT, ack_author TEXT, ack_data TEXT, escalated NUMERIC);
CREATE TABLE contact_notification_method_data (id INTEGER PRIMARY KEY, notification_type NUMERIC, start_time NUMERIC, end_time NUMERIC, host_name TEXT, service_descripTion TEXT, contact_name TEXT, command_name TEXT, command_args TEXT, reason_type NUMERIC, state NUMERIC, output TEXT, ack_author TEXT, ack_data TEXT, escalated NUMERIC);
CREATE TABLE downtime_data (id INTEGER PRIMARY KEY, downtime_type NUMERIC, host_name TEXT, service_description TEXT, entry_time NUMERIC, author_name TEXT, comment_data TEXT, start_time NUMERIC, end_time NUMERIC, fixed NUMERIC, duration NUMERIC, triggered_by NUMERIC, downtime_id NUMERIC);
CREATE TABLE event_handler_data (id INTEGER PRIMARY KEY, eventhandler_type NUMERIC, host_name TEXT, service_description TEXT, state_type NUMERIC, state NUMERIC, timeout NUMERIC, command_name TEXT, command_args TEXT, command_line TEXT, start_time NUMERIC, end_time NUMERIC, early_timeout NUMERIC, execution_time NUMERIC, return_code NUMERIC, output TEXT);
CREATE TABLE external_command_data (id INTEGER PRIMARY KEY, command_type NUMERIC, entry_time NUMERIC, command_string TEXT, command_args TEXT);
CREATE TABLE flapping_data (id INTEGER PRIMARY KEY, flapping_type NUMERIC, host_name TEXT, service_description TEXT, percent_change NUMERIC, high_threshold NUMERIC, low_threshold NUMERIC, comment_id NUMERIC);
CREATE TABLE host_check_data (id INTEGER PRIMARY KEY, host_name TEXT, check_type NUMERIC, current_attempt NUMERIC, max_attempts NUMERIC, state_type NUMERIC, state NUMERIC, timeout NUMERIC, command_name TEXT, command_args TEXT, command_line TEXT, start_time NUMERIC, end_time NUMERIC, early_timeout NUMERIC, execution_time NUMERIC, latency NUMERIC, return_code NUMERIC, output TEXT, long_output TEXT, perf_data TEXT);
CREATE TABLE log_data (id INTEGER PRIMARY KEY, timestamp NUMERIC, message TEXT);
CREATE TABLE notification_data (id INTEGER PRIMARY KEY, notification_type NUMERIC, start_time NUMERIC, end_time NUMERIC, host_name TEXT, service_descripTion TEXT, reason_type NUMERIC, state NUMERIC, output TEXT, ack_author TEXT, ack_data TEXT, escalated NUMERIC, contacts_notified NUMERIC);
CREATE TABLE program_status_data (id INTEGER PRIMARY KEY, program_start NUMERIC, pid NUMERIC, daemon_mode NUMERIC, last_command_check NUMERIC, last_log_rotation NUMERIC, notifications_enabled NUMERIC, active_service_checks_enabled NUMERIC, passive_service_checks_enabled NUMERIC, active_host_checks_enabled NUMERIC, passive_host_checks_enabled NUMERIC, event_handlers_enabled NUMERIC, flap_detection_enabled NUMERIC, failure_prediction_enabled NUMERIC, process_performance_data NUMERIC, obsess_over_hosts NUMERIC, obsess_over_services NUMERIC, modified_host_attributes NUMERIC, modified_service_attributes NUMERIC, global_host_event_handler TEXT, global_service_event_handler TEXT);
CREATE TABLE service_check_data (id INTEGER PRIMARY KEY, host_name TEXT, service_description TEXT, check_type NUMERIC, current_attempt NUMERIC, max_attempts NUMERIC, state_type NUMERIC, state NUMERIC, timeout NUMERIC, command_name TEXT, command_args TEXT, command_line TEXT, start_time NUMERIC, end_time NUMERIC, early_timeout NUMERIC, execution_time NUMERIC, latency NUMERIC, return_code NUMERIC, output TEXT, long_output TEXT, perf_data TEXT);
CREATE TABLE state_change_data (id INTEGER PRIMARY KEY, statechange_type NUMERIC, host_name TEXT, service_description TEXT, state NUMERIC, state_type NUMERIC, current_attempt NUMERIC, max_attempts NUMERIC, output TEXT);
CREATE TABLE system_command_data (id INTEGER PRIMARY KEY, start_time NUMERIC, end_time NUMERIC, timeout NUMERIC, command_line TEXT, early_timeout NUMERIC, execution_time NUMERIC, return_code NUMERIC, output TEXT);
COMMIT;