/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * DevIGen - devices system overhead
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb980717   Tammo Hinrichs <opencp@gmx.net>
 *    -changed INI reading of driver symbols to _dllinfo lookup
 */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "imsdev.h"
#include "boot/psetting.h"
#include "boot/plinkman.h"
#include "devigen.h"

int deviReadDevices(const char *list, struct devinfonode **devs)
{
	int handlfn=1;

	while (1)
	{
		char drvhand[9];
		struct devinfonode *n;
		int i;
		char dname[10];
		char *dsym;
		struct sounddevice *dev;
		int bypass;
/*		char str[100];*/
	
		if (!cfGetSpaceListEntry(drvhand, &list, 8))
			break;

		n=malloc(sizeof(struct devinfonode));
		if (!n)
			return 0;
		n->next=0;
		strcpy(n->handle, drvhand);

		fprintf(stderr, " %s", drvhand);
		for (i=strlen(drvhand); i<8; i++)
			fprintf(stderr, " ");
		fprintf(stderr, ": ");
		
		strncpy(dname,cfGetProfileString(drvhand, "link", ""),9);

		n->linkhand=lnkLink(dname);
		if (n->linkhand<=0)
		{
			fprintf(stderr, "link error\n");
			free(n);
			continue;
		}

		if (!(dsym=lnkReadInfoReg(n->linkhand, "driver")))
		{
			fprintf(stderr, "not a driver\n");
			lnkFree(n->linkhand);
			free(n);
			continue;
		}
		if (!*dsym) /* can this shit occure? that a driver string is zero-size long... and why care? */
		{
			fprintf(stderr, "no driver found\n");
			lnkFree(n->linkhand);
			free(n);
			continue;
		}
#ifdef LD_DEBUG
		fprintf(stderr, "dsym: \"%s\"\n", dsym);
#endif
		if (!(dev=(struct sounddevice*)_lnkGetSymbol(dsym)))
		{
			fprintf(stderr, "sym error\n");
			lnkFree(n->linkhand);
			free(n);
			continue;
		}

		if ((dsym=lnkReadInfoReg(n->linkhand, "addprocs")))
/*		if (*dsym)*/
			n->addprocs=(struct devaddstruct *)_lnkGetSymbol(dsym);
		else
			n->addprocs=NULL;

		bypass=cfGetProfileBool(drvhand, "bypass", 0, 0);
		n->ihandle=handlfn++;
		n->keep=cfGetProfileBool(drvhand, "keep", 0, 0);
		n->dev.port=cfGetProfileInt(drvhand, "port", -1, 16);
		n->dev.port2=cfGetProfileInt(drvhand, "port2", -1, 16);
/*		n->dev.irq=cfGetProfileInt(drvhand, "irq", -1, 10);
		n->dev.irq2=cfGetProfileInt(drvhand, "irq2", -1, 10);
		n->dev.dma=cfGetProfileInt(drvhand, "dma", -1, 10);
		n->dev.dma2=cfGetProfileInt(drvhand, "dma2", -1, 10);*/
		n->dev.subtype=cfGetProfileInt(drvhand, "subtype", -1, 10);
		strncpy(n->dev.path, cfGetProfileString(drvhand, "path", ""), 128);
		n->dev.path[127]=0;
		strncpy(n->dev.mixer, cfGetProfileString(drvhand, "mixer", ""), 128);
		n->dev.mixer[127]=0;
		n->dev.chan=0;
		n->dev.mem=0;
		n->dev.opt=0;

		strcpy(n->name, dev->name);
		if (n->addprocs)
			if (n->addprocs->GetOpt)
				n->dev.opt=n->addprocs->GetOpt(drvhand);
		n->dev.opt|=cfGetProfileInt(drvhand, "options", 0, 16);

		fprintf(stderr, "%s", n->name);
		for (i=strlen(n->name); i<32; i++)
			fprintf(stderr, ".");
		if (!bypass)
		{
			if (!dev->Detect(&n->dev))
			{
				fprintf(stderr, " not found: optimize ocp.ini!\n");
				lnkFree(n->linkhand);
				free(n);
			        continue;
			}
		} else
			n->dev.dev=dev;

		if (!n->keep)
		{
			lnkFree(n->linkhand);
			n->linkhand=-1;
		}

		fprintf(stderr, " (#%d", n->ihandle);
		if (n->dev.subtype!=-1)
			fprintf(stderr, " t%d", n->dev.subtype);
		if (n->dev.port!=-1)
			fprintf(stderr, " p%x", n->dev.port);
		if (n->dev.port2!=-1)
			fprintf(stderr, " q%x", n->dev.port2);
		if (n->dev.mem)
			fprintf(stderr, " m%d", (int)(n->dev.mem>>10));
		fprintf(stderr, ")\n"); 
		
/*		strcpy(str, " (");
		strcat(str, "#");
		ltoa(n->ihandle, str+strlen(str), 10);
		if (n->dev.subtype!=-1)
		{
			strcat(str, " t");
			ltoa(n->dev.subtype, str+strlen(str), 10);
		}
		if (n->dev.port!=-1)
		{
			strcat(str, " p");
			ltoa(n->dev.port, str+strlen(str), 16);
		}
		if (n->dev.port2!=-1)
		{
			strcat(str, " q");
			ltoa(n->dev.port2, str+strlen(str), 16);
		}
		if (n->dev.irq!=-1)
		{
			strcat(str, " i");
			ltoa(n->dev.irq, str+strlen(str), 10);
		}
		if (n->dev.irq2!=-1)
		{
			strcat(str, " j");
			ltoa(n->dev.irq2, str+strlen(str), 10);
		}
		if (n->dev.dma!=-1)
		{
			strcat(str, " d");
			ltoa(n->dev.dma, str+strlen(str), 10);
		}
		if (n->dev.dma2!=-1)
		{
			strcat(str, " e");
			ltoa(n->dev.dma2, str+strlen(str), 10);
		}
		if (n->dev.mem)
		{
			strcat(str, " m");
			ltoa(n->dev.mem>>10, str+strlen(str), 10);
		}
		printf("%s)\n", str);*/

		*devs=n;
		devs=&(*devs)->next;
	}
	return 1;
}

struct linkinfostruct dllextinfo = {"devi", "OpenCP Devices Auxiliary Routines (c) 1994-04 Niklas Beisert, Tammo Hinrichs", DLLVERSION, 0};
