/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* iterator.cpp - implements a template class for iterating over a vector

   Scott Cantor
   2/13/02

   $History:$
*/

/*
 * gcc4 refuses to emit clone member specialization if templates are explicit
 */
#if !(__GNUC__ >= 4)
# define SAML_INSTANTIATE
#endif
#include "internal.h"

#define SIMPLECLONE(T) \
    template<> SAML_EXPORTS std::vector<T> Iterator<T>::clone() const { return m_vector; }

#define SAMLCLONE(T) \
    template<> SAML_EXPORTS std::vector<T> Iterator<T>::clone() const \
    { \
        std::vector<T> copy; \
        for (std::vector<T>::const_iterator i=m_vector.begin(); i!=m_vector.end(); i++) \
            copy.push_back(static_cast<T>((*i)->clone())); \
        return copy; \
    } \

namespace saml {

#ifdef HAVE_GOOD_STL
SIMPLECLONE(xstring)
#endif
SIMPLECLONE(std::string)
SIMPLECLONE(QName)
SIMPLECLONE(const XMLCh*)
SAMLCLONE(SAMLArtifact*)
SAMLCLONE(SAMLAttribute*)
SAMLCLONE(SAMLAttributeDesignator*)
SAMLCLONE(SAMLStatement*)
SAMLCLONE(SAMLAssertion*)
SAMLCLONE(SAMLCondition*)
SAMLCLONE(SAMLAuthorityBinding*)
SAMLCLONE(SAMLAction*)

};
