#ifndef __ORPHEUSCONF_H__
#define __ORPHEUSCONF_H__

#include <string>
#include <config.h>

using namespace std;

#ifdef ENABLE_NLS

#include <libintl.h>
#define _(s)    gettext(s)

#else

#define _(s)    (s)

#endif

enum PlayMode {
    Normal,
    TrackRepeat,
    ListRepeat,
    Random,
    PlayMode_size
};

enum SortOrder {
    byFileName,
    byTrackName,
    byTrackLength,
    byLastModified,
    noSort,
    SortOrder_size
};

class OrpheusConfiguration {
    private:
	string mp3player, oggplayer, cddev, mixerdev, proxy, dname;
	bool cdautofetch, russian, autosavepl, autoplay, sortasc;
	PlayMode playmode;
	SortOrder sortorder;

    public:
	OrpheusConfiguration();
	~OrpheusConfiguration();

	void load();
	void save() const;

	string getbasedir() const { return dname; }

	string getmp3player() const { return mp3player; }
	void setmp3player(const string &amp3player) { mp3player = amp3player; }

	string getoggplayer() const { return oggplayer; }
	void setoggplayer(const string &aoggplayer) { oggplayer = aoggplayer; }

	string getcddevice() const { return cddev; }
	void setcddevice(const string &adevice) { cddev = adevice; }

	string getmixerdevice() const { return mixerdev; }
	void setmixerdevice(const string &adevice) { mixerdev = adevice; }

	string getproxy() const { return proxy; }
	void setproxy(const string &aproxy) { proxy = aproxy; }

	bool getautofetch() const { return cdautofetch; }
	void setautofetch(bool aautofetch) { cdautofetch = aautofetch; }

	bool getrussian() const { return russian; }
	void setrussian(bool arussian) { russian = arussian; }

	bool getautosaveplaylist() const { return autosavepl; }
	void setautosaveplaylist(bool aautosavepl) { autosavepl = aautosavepl; }

	bool getautoplay() const { return autoplay; }
	void setautoplay(bool aautoplay) { autoplay = aautoplay; }

	PlayMode getplaymode() const { return playmode; }
	void setplaymode(PlayMode m) { playmode = m; }

	SortOrder getsortorder() const { return sortorder; }
	void setsortorder(SortOrder m) { sortorder = m; }

	bool getsortasc() const { return sortasc; }
	void setsortasc(bool m) { sortasc = m; }
};

extern OrpheusConfiguration conf;

string rusconv(const string &tdir, const string &text);
string strplaymode(PlayMode mode);
string strsortorder(SortOrder order);
string up(string s);

#endif
