module Schleuder
  # Parent-class for plugins. Sets up stub and helper methods.
  class Plugin
    # match() is called to determine whether the plugin wants to be executed. 
    # If it returns +true+ process() ist called otherwise not.
    def match(mailcontext)
      false
    end
  
    # Plugin action. Only called when match() returned true. 
    def process(mailcontext)
      raise 'Method not implemented!'
    end
  
    # Helper: creates a reply to the sender of the incoming message. The
    # destination address is detemined by finding the list-member connected to
    # the key that signed the incoming message. +msg+ is used as body for the
    # outgoing mail.
    def reply(mail, msg)
      Schleuder.log.info "Building reply mail"
      out = Mail.new

      out.subject = "Re: #{mail.subject}"
      key = mail.crypt.get_key(mail.in_signed.fpr)

      Schleuder.log.debug "Finding member by key: #{key.inspect}"
      mem = Schleuder.list.find_member_by_key(key)
      unless mem
        Schleuder.log.error "No member found for signing key, aborting Plugin::process and returning to Processor"
        return false
      end
      Schleuder.log.debug "Found #{mem.inspect}"

      imail = out.individualize(mem)
      imail.in_reply_to = mail.message_id
      imail.body = msg

      unless imail.encrypt! mem
        Schleuder.log.debug 'encrypting failed, replacing body with please-fix-message'
        imail.body = "Encrypting to #{imail.to} failed. Please fix."
      end

      Schleuder.log.info "Sending to #{imail.to}"
      Mailer.send(imail)

      Schleuder.log.info "Exiting"
      exit 0
    end
  end
end
