module Schleuder
  require 'logger'
  # Extends Logger, adds notification sending
  class SchleuderLogger < Logger
    # instantiates a Logger and sets @+progname+ and @+sev_threshold+
    def initialize(progname, logfile, loglevel="warn")
      # rotate daily
      super logfile, 'daily'
      @progname = progname
      # By specifying the log-level we can define what messages are actually
      # logged.  For 'ageing' logfiles and/or set a maximum size see
      # documentation for +Logger+.
      @sev_threshold = eval("Logger::" + loglevel.upcase)
    end

    # extends Logger#error by sending notification to admin
    def error(*msg)
      super(*msg)
      notify_admin unless Schleuder.list.nil?
    end

    # extends Logger#fatal by sending notification to admin and superadmin,
    # closing self and exiting (actually dieing is what "fatal" means, no?)
    def fatal(*msg)
      super(*msg)
      notify_admin unless Schleuder.list.nil?
      self.close
      exit 1
    end

    def notify_admin msg=nil, subject=nil
      self.info 'notifying (super)admin'
      m = Mail.new
      m.subject = subject || "Error"
      m.date = Time.now
      m.from = Schleuder.list.config.myaddr

      if msg.nil?
        msg = "Hello,\n\nan error has occurred working for list #{Schleuder.list.listname}:\n\n"
        logfile = File.expand_path(@logdev.instance_variable_get('@filename'))
        File.read(logfile).split(/\n[IDEFW]{1}, /).each do |line|
          msg << "#{line}\n" if line.match(/ ##{$$}\]/)
        end
      end

      m.body = msg
      altmsg = "Hello,\n\nsending an encrypted error message to you failed. Therefore you receive only\nthis message and are kindly requested to take care of the encryption problem\n(e.g. fix your keys) and have a look at the logs to find the error.\n\nYours,  Schleuder\n"

      begin
        if Schleuder.list.config.adminaddr.kind_of?(Array) and not Schleuder.list.config.adminaddr.empty?
          Schleuder.list.config.adminaddr.each do |addr|
            r = Member.new('email' => addr)
            mail = m.individualize(r)
            if not Processor.send(mail, r)
              mail.body = altmsg
              Processor.send(mail, r, false)
            end
          end
        else
          m.to = Schleuder.config.superadminaddr
          m.body = "[Working for list #{Schleuder.list.listname} I found adminaddr is not (correctly) set.\nPlease fix this!\n\nThe errormessage is appended.]\n\n#{m.body}"
          Processor.send(m, Member.new('email' => Schleuder.config.superadminaddr))
        end
      rescue => e
        puts "Something's seriously wrong: #{e}\n#{e.backtrace.join("\n")}\n\nThe message:\n#{m.to_s}"
        exit 1
      end
    end
  end
end
