/*
 *  my_strescape.c - escape hazardous characters in a string for bash 
 *  Copyright (C) 2005 Lee Bigelow <ligelowbee@yahoo.com> 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include<string.h>
#include<glib.h>

gint 
is_escaped_char(gchar c)
{
  switch ( c )
  {
    case ' ':   
    case '\'':  
    case '"':   
    case '(':   
    case ')':   
    case '$':   
    case '\\':  
    case ';':   
    case '<':   
    case '>':   
    case '&':   
    case '#':   
    case '*':   
    case '|':   
    case '`':   
    case '!':   
      return 1;
    default:    
      return 0;
  }
}

extern gchar *
my_strescape(gchar *string)
{
  gchar *q;
  gchar *escaped;
  gint escapechars = 0;
  gchar *p = string;

  while (*p != '\000') 
  {
    if (is_escaped_char(*p)) escapechars++;
    p++;
  }

  if (!escapechars) return g_strdup(string);

  escaped = (gchar *) g_malloc (strlen(string) + escapechars + 1);

  p = string;
  q = escaped;

  while (*p != '\000')
  {
    if (is_escaped_char(*p)) *q++ = '\\';
    *q++ = *p++;
  }
  *q = '\000';

  return escaped;
}

