/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <grp.h>
#include <pwd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "modules.h"

#include "basic_row.h"

#include "callbacks.h"

#include "basic_local.h"
#include "dnd.h"
#include "entry.h"

#ifdef USE_FILTER_BAR
#include "filter.h"
#endif

#include "goto.h"
#include "icons.h"
#include "input.h"
#include "keybindings.h"
#include "ls.h"
#include "menu.h"
#include "misc.h"
#include "monitor.h"
#include "run.h"
#include "password_dialog.h"
#include "treeview.h"
#include "treestore.h"
#include "widgets.h"
#include "keybindings.h"
#include "uri.h"

/* bug workaround (double click signals click first)*/
static gboolean skip_second_release = FALSE;
static GtkTreeRowReference *title_reference=NULL;
static gboolean mousedown=FALSE;
static gdouble mouseX,mouseY;
static GtkTreePath *clickpath;
G_MODULE_EXPORT
gboolean easy_mode=FALSE;



static gboolean unsel(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data);

static gboolean valid_iter(GtkTreeView * treeview,GtkTreeIter * iter){
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
    if (!en) return FALSE;
    if (IS_PATH(en->type) && access(en->path,F_OK)!=0) return FALSE;
    return TRUE;
}

extern gboolean no_sorting;/* see explanation in treeview.c */
G_MODULE_EXPORT
void open_dir(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * treepath, gpointer user_data)
{
    tree_entry_t *en;
    struct stat st;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter child;
    static gchar **window_title=NULL;
    static gboolean red_light=FALSE;
    GtkTreeSortable *sortable=GTK_TREE_SORTABLE(treemodel);

    
#ifdef DEBUG
	printf("DBG: open_dir ...\n");
#endif
    mousedown=FALSE; /* gtk bug workaround:click on expander passes button_press but not button_release */
    if (clickpath){
        clear_path_from_selection_list(treeview,clickpath);
    }

    if (!valid_iter(treeview,iter)){
	    local_monitor(TRUE);
	    return;
    }
   if (!window_title) {
	    window_title=(gchar **)malloc(sizeof(gchar *));
	    *window_title=NULL;
    }
  
    if(!set_load_wait())
    {
	gtk_tree_view_collapse_row(treeview, treepath);
	return;
    }
    if (red_light){
#ifdef DEBUG
	printf("DBG: open_dir red_light return...\n");
#endif
	return;
    }
    red_light=TRUE;
/* disable internal sorting while loading... **/
    no_sorting=TRUE;
	
    cursor_wait();
    gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
#ifdef DEBUG
	printf("DBG: open_dir callback...\n");
#endif
    if(!en || !en->path) goto time2return;
    if (!IS_FSTAB_TYPE(en->type) && 
	!IS_TRASH_TYPE(en->type) && 
	!IS_NETWORK_TYPE(en->type) && 
	!IS_BOOKMARK_TYPE(en->type) && 
	!IS_RECENT_TYPE(en->type) && 
	!IS_FREQUENT_TYPE(en->type) && 
	!en->st
       ) goto time2return;

#ifdef USE_FILTER_BAR
    if(en->filter && strcmp(en->filter, get_filter(tree_details->window))){
	/*printf("DBG: UNSET_LOADED filter && strcmp(filter, get_filter) filter=%s get_filter=%s\n",en->filter,get_filter(tree_details->window));*/
	UNSET_LOADED(en->type);
    }
#endif

    if(stat(en->path, &st) >= 0)
    {
	if(st.st_mtime != en->st->st_mtime || st.st_ctime != en->st->st_ctime)
	{
	    /*printf("DBG: UNSET_LOADED st.st_mtime != en->st->st_mtime\n");*/
	    memcpy(en->st, &st, sizeof(struct stat));
	    UNSET_LOADED(en->type);
	}
        if(access(en->path, X_OK)!=0){ /* abort the expand... */
	   reset_dummy_row(treemodel, iter,NULL,en,"xfce/error",strerror(errno));
    	   hide_stop();
	   unset_load_wait();
	   cursor_reset();
	   red_light=FALSE;
	   return;
	}
	
    }
    else if(IS_PATH(en->type) && lstat(en->path, &st) < 0)
    {
	/* bye bye */
	GtkTreePath *path = gtk_tree_model_get_path(treemodel, iter);
	GtkTreeRowReference *ref = gtk_tree_row_reference_new(treemodel, path);
	    /*printf("DBG: bye bye remove_it\n");*/
	remove_it(treeview, ref);
	gtk_tree_path_free(path);
	gtk_tree_row_reference_free(ref);
	goto time2return;

    }
    SET_EXPANDED(en->type);
    if(IS_ROOT_TYPE(en->type) && 
       (IS_BOOKMARK_TYPE(en->type) || 
	IS_TRASH_TYPE(en->type) || 
	IS_RECENT_TYPE(en->type) || 
	IS_FREQUENT_TYPE(en->type) || 
	IS_FSTAB_TYPE(en->type)
       )
      )
    {
	if(!IS_LOADED(en->type))
	{
            if(IS_RECENT_TYPE(en->type) || IS_FREQUENT_TYPE(en->type))
	    {
		if(RECENT_open_history(treeview, iter, treepath, user_data) < 0)
		{
		    print_status("xfce/error", 
				    strerror(errno),NULL);
		}
	        goto time2return;
	    }
            if(IS_FSTAB_TYPE(en->type))
	    {
		/*while(gtk_events_pending()) gtk_main_iteration();*/
		if(FSTAB_open_fstab(treeview, iter, treepath, user_data) < 0)
		{
		    print_status("xfce/error", 
				    strerror(errno),NULL);
		}
    		/*hide_stop();*/
	        goto time2return;
	    }
	    if(IS_BOOKMARK_TYPE(en->type))
	    {
		if(BOOK_open_bookmarks(treeview, iter, treepath, user_data) < 0)
		{
		    reset_dummy_row(treemodel, iter, NULL,en,"xfce/info",_("Use drag+drop to add"));
		}
		print_status(NULL,"", NULL);
	        goto time2return;
	    }
	    if(IS_TRASH_TYPE(en->type))
	    {
		int result;
		gtk_tree_view_collapse_row(treeview, treepath);
		if((result = TRASH_open_trash(treeview, iter, treepath, user_data)) < 0)
		{

		    if (result == -2) print_status_tmp(resolve_icon_small(en), 
			    _("Trash load aborted."), NULL);
		    else {
			print_status(NULL,"",NULL);
			reset_dummy_row (treemodel, iter, NULL,en,"xfce/info", _("No trash has been collected.")); 
		    }
		}
		else
		{
		    hide_stop();
		    print_status(NULL,"",NULL);
		}
		unset_load_wait();
		gtk_tree_view_expand_row(treeview, treepath, FALSE);
	    }
	    goto time2return;
	}
	print_status(NULL,"", NULL);
	/*set_select_path(treemodel,iter,tree_details); */
	/* when expand icon is different: set_icon(treemodel, iter); */

    }
    if(!IS_LOADED(en->type) && 
	(IS_NETWORK_TYPE(en->type) ||
	IS_XF_NETWS(en->subtype) ||     /* will enable bookmarks */
	IS_XF_NETSHARE(en->subtype) ||
	IS_NETDIR(en->subtype) )
      )
    {
	    /*printf("DBG: network...\n");*/
	process_pending_gtk();
#ifdef USE_SMB_BRANCH
	if(!XF_open_smb(treeview, iter, treepath, user_data))
	{
	}
#endif
        goto time2return;
    }
    if(IS_NETWORK_TYPE(en->type) && IS_LOADED(en->type)){
	SET_EXPANDED(en->type);
    }
    if(IS_DIR(en->type)) {
	open_folder_local(treeview,iter,treepath,en);
    }

time2return:
#ifdef DEBUG
	printf("DBG: opendir time2return.\n"); 
#endif
    set_icon(treemodel, iter);
	
    if(!gtk_tree_model_iter_children(treemodel, &child, iter)){
	insert_dummy_row(treemodel, iter,NULL,en,NULL,"");
    }
    else {
#ifdef DEBUG
	printf("DBG: doing children\n"); 
#endif
      do {
	tree_entry_t *c_en;    
        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	if (c_en && IS_DIR(c_en->type)) {
#ifdef DEBUG
	      printf("DBG: icon setting for %s\n",c_en->path); 
#endif
		set_icon(treemodel, &child);
	}
      } while(gtk_tree_model_iter_next(treemodel, &child));
    }
    
    hide_stop();
    if(!tree_details->window) exit(1);

#ifdef DEBUG
	printf("DBG: open_dir, unsetting load wait\n"); 
#endif
    unset_load_wait();

    if (!gtk_tree_view_row_expanded(treeview,treepath)) {
	    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    }
#ifdef DEBUG
	printf("DBG: open_dir, setting title\n"); 
#endif
    if(en && en->path){
	g_free(*window_title);
	*window_title=NULL;
	 /* ascii readable conversion for smb items are here */
	if (title_reference) gtk_tree_row_reference_free(title_reference);
       	title_reference = gtk_tree_row_reference_new(treemodel, treepath);
	
        *window_title=g_strdup((en&&en->path)?en->path:"xffm");
	if (IS_NETTHING(en->subtype) && !IS_SAMBA_SERVER(en->subtype)){
	    ascii_readable(*window_title);
	} 
	set_title(treeview,window_title);
    }
    if(tree_details->preferences & AUTOSCROLL){
	gdk_flush();
	/*XXX gtk bug, scrolling does not always occur...
	 * bugzilla bug report 120269
	 * printf("DBG-a:scrolling...\n");*/
	gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    }

    cursor_reset();
    
   
    red_light=FALSE;
    /*{
      GdkRectangle rect;
      rect.x=rect.y=0;
      rect.width=tree_details->window->allocation.width;
      rect.height=tree_details->window->allocation.height;
      gdk_window_invalidate_rect(gtk_widget_get_toplevel(tree_details->window)->window,&rect,TRUE);
      gdk_window_process_updates(gtk_widget_get_toplevel(tree_details->window)->window,TRUE);
    }*/
    
#ifdef DEBUG
	printf("DBG: open_dir, all done!\n"); 
#endif
    unset_load_wait();
     /* reenable internal sorting now... */
    no_sorting=FALSE;
    gtk_tree_sortable_sort_column_changed (sortable);
  
}


G_MODULE_EXPORT
void close_dir(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * path, gpointer user_data)
{
    tree_entry_t *en, *p_en;
    GtkTreeIter parent,child;
    static gchar **window_title=NULL;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);


    mousedown=FALSE; /* gtk bug workaround:click on expander passes button_press but not button_release */
    if (clickpath){
        clear_path_from_selection_list(treeview,clickpath);
    }

    if (!valid_iter(treeview,iter)){
	    local_monitor(TRUE);
	    return;
    }
    if(tree_details->loading)
    {
	/* this creates an endless loop: 
	 * gtk_tree_view_expand_row (treeview,treepath,FALSE);*/
	return;			/* Hey, push the stop button man! */
    }
    if (!window_title) {
	    window_title=(gchar **)malloc(sizeof(gchar *));
	    *window_title=NULL;
    }

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en) goto time2return;


    UNSET_EXPANDED(en->type);
    if(gtk_tree_model_iter_children(treemodel, &child, iter)){
      do {
	tree_entry_t *c_en;    
        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	if (en && IS_DIR(en->type)) UNSET_EXPANDED(c_en->type);
      } while(gtk_tree_model_iter_next(treemodel, &child));
    }

    set_icon(treemodel, iter);
    
    
   if(IS_TRASH_TYPE(en->type))
    {
	/*set_select_path(treemodel,iter,tree_details); */
	print_status(NULL,"", NULL);
    }
    if(en->path)
    {
	g_free(*window_title);
	*window_title=NULL;
	if(gtk_tree_model_iter_parent(treemodel, &parent, iter))
	{
	    GtkTreePath *tpath=gtk_tree_path_copy(path);
	    gtk_tree_path_up(tpath);
	    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
	    *window_title=g_strdup(p_en->path);
    	    if (title_reference) gtk_tree_row_reference_free(title_reference);
       	    title_reference = gtk_tree_row_reference_new(treemodel, tpath);
	    if (p_en->tag) {
	     if (strchr(p_en->tag,'%')){	 
	      char *p=g_strdup(en->tag);
	      p=strtok(p,"%");
	      print_status((char *)resolve_folder_icon(p_en),p, NULL);
	      g_free(p);
	     } else print_status((char *)resolve_folder_icon(p_en), p_en->tag, NULL);
	    }
	    else  print_status(NULL,"", NULL);
	    set_path_reference(treeview,tpath);
	    gtk_tree_path_free(tpath);
	}
	else
	{
	    *window_title=g_strdup(en->path);
    	    if (title_reference) gtk_tree_row_reference_free(title_reference);
       	    title_reference = gtk_tree_row_reference_new(treemodel, path);
	    if (en->tag) {
   	     if (strchr(en->tag,'%')){	 
	      char *p=g_strdup(en->tag);
	      p=strtok(p,"%");
	      print_status((char *)resolve_folder_icon(en),p, NULL);
	      g_free(p);
	     } else print_status((char *)resolve_folder_icon(en), en->tag, NULL);
	    }
	    else  print_status(NULL,"", NULL);
	}
	set_title(treeview,window_title);
    }
  time2return:
    turn_on();
    tree_details->loading = FALSE;
}


/********************* callbacks **************************/

static int reselecttimer=0;
static gint do_reselect(gpointer data){
	GtkTreeView * treeview=(GtkTreeView * )data;
 	reselect_dnd_list(treeview);
	/*printf("DBG:at reselecttimer = %d\n",reselecttimer );*/
	reselecttimer=0;
	return FALSE;
}

static gint delayed_selection(gpointer data){
	GtkTreeView * treeview=(GtkTreeView * )data;
        GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
#ifdef DEBUG
	 printf("delayed selection...\n");
#endif
     	gtk_tree_selection_selected_foreach(selection, get_dnd_selection, (gpointer) treeview);
#if DEBUG_IN_DND
	/* DEBUG must be enabled in dnd.c for this to work: */
#ifdef DEBUG
	{
	    extern void the_sl(void);
	    the_sl();
	}
#endif
#endif
	return FALSE;
}


G_MODULE_EXPORT
gboolean button_releaseF(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath;
    tree_entry_t *en;
    GtkTreeIter iter;

   mousedown=FALSE; 
    TRACE("release event... ignore second releas=%d... \n",tree_details->comm & COMM_IGNORE_RELEASE); 
    if(tree_details->loading)	return FALSE;
    mouseX=event->x;
    mouseY=event->y;
    { 
        int i;
        for (i=0;i<TREECOUNT;i++) {
	   gtk_tree_view_set_drag_dest_row (tree_details->treestuff[i].treeview,NULL,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
	}
    }

   if(event->button == 1 && skip_second_release) 
    {
	skip_second_release = FALSE;
	/*printf("skip_second_release = 1\n");*/
	return FALSE;
    }
    /* this corrupts the double click because the treeview gets moved:
     *  hide_text(widget);
     *  */
    switch (event->button)
    {
	default:
	    break;
	case 4:
	case 5: /* these don't work ... */
	    break;
	case 1: case 3:
	if (event->button == 3)
	    break;		/* not working for button 3 */
	/* BUTTON_1: */
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, 
				    &treepath, NULL, NULL, NULL))
	    {
#if 0		
		gtk_tree_model_get_iter(treemodel, &iter, treepath);
		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		update_status_line(en);
		if (!en || !en->path){
			print_status_tmp(NULL, "",NULL);
	        } else {
		  gchar *readable_path=g_path_get_basename(en->path);
		  if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype))
			ascii_readable(readable_path);
		  print_status_tmp(resolve_icon_small(en), 
				readable_path,
				NULL);
		  g_free(readable_path);
		  set_path_reference(treeview,treepath);
		}
#endif		
	        gtk_tree_path_free(treepath);
	        turn_on();
	    }
	    if (tree_details->comm & COMM_IGNORE_RELEASE){
		/* nautilus sends the release event back to
		 * originating window after drop. We don't
		 * want it... */
		TRACE("ignoring release signal");
	    }
	    else clear_dnd_selection_list();
	    break; /* case 1 */
	case 2:
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, &treepath, NULL, NULL, NULL))
	    {
		gtk_tree_model_get_iter(treemodel, &iter, treepath);
		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		/* This is user%password for smb stuff: 
		 * printf("DBG: tag=%s\n",en->tag);*/
		/* trash and find entries always printout full path somewhere */
		if( en->path && 
		    (IS_LOCAL_TYPE(en->type) || !IS_ROOT_TYPE(en->type)) )
		{
		    const gchar *typeinfo=NULL;
		    gchar *readable_path;
		    const gchar *mimetype = NULL;
		    
		    readable_path=g_strdup(en->path);
		    if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype)){
			ascii_readable(readable_path);
		    }
		  
		    if (IS_PATH(en->type) ){
			    mimetype = MIME_get_type(en->path,TRUE);
			    typeinfo = MIME_typeinfo(mimetype);  
		    } else {
			    mimetype = resolve_icon_id(en);
			    if (!mimetype) mimetype = MIME_get_type(en->path,FALSE);
		    }
		    /* printout full file information: */
		    
		    if (IS_XF_LNK(en->type)){
			char lpath[_POSIX_PATH_MAX+1];
			memset(lpath,0,_POSIX_PATH_MAX+1);
			if (readlink(en->path, lpath, _POSIX_PATH_MAX)>0) {
			    print_diagnostics("xfce/info",en->path,"->",lpath,"\n", NULL);
			} 
		    }
			    
		    if (typeinfo && strcmp(typeinfo,"Unknown")!=0){
		       print_diagnostics((char *)mimetype,readable_path," (",mimetype,": ",typeinfo,")\n",NULL);
		    } else {
		       print_diagnostics((char *)mimetype,readable_path," (",mimetype,")\n", NULL);
		    }
		    if (en->st) {
    		      struct group *g;
		      struct passwd *p;
		      char *grupo,*owner;
		      const gchar *tag = sizetag((off_t)en->st->st_size, -1);
		      if((g = getgrgid(en->st->st_gid)) != NULL)	grupo = g->gr_name;
		      else if ((int)en->st->st_gid < 0) grupo = ""; else grupo = "?";
		      if((p = getpwuid(en->st->st_uid)) != NULL) owner = p->pw_name;
		      else if ((int)en->st->st_uid < 0) owner = ""; else owner = "?";
		      print_diagnostics("nonverbose",
			    my_utf_string(time_to_string(en->st->st_mtime)),"; ",
			    tag,", ", 
			    owner,":",
			    grupo," ",
			    mode_string(en->st->st_mode),"\n", NULL);
		    }
		    g_free(readable_path);
		}
		gtk_tree_path_free(treepath);
	    }
	    clear_dnd_selection_list();
	    break; /* case 2 */
    } /* end switch */
    return FALSE;
}

static gboolean unsel(GtkTreeModel *,GtkTreePath *, GtkTreeIter *, gpointer);


G_MODULE_EXPORT
gboolean treeclick(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    treestuff_t *treestuff=get_treestuff(treeview);
    tree_entry_t *en;
    GtkTreePath *treepath;
    GtkTreeIter iter,child;
    gchar *newpath=NULL;
    int type;
    gint tree_id;
    gboolean double_click=FALSE;

    mousedown=TRUE;
    easy_mode=FALSE;

    tree_details->comm &= (COMM_IGNORE_RELEASE^0xffffffff);
    TRACE("callbacks ignore second releas=%d... \n",tree_details->comm & COMM_IGNORE_RELEASE); 

    /*dnd_mouse_moved=FALSE;*/
    if(tree_details->loading)
	return TRUE;

    if(tree_details->input)
    {
	cancel_input(NULL,NULL);
    }
    skip_second_release = FALSE;

    for (tree_id=0; tree_id<TREECOUNT; tree_id++) {      
      /*printf("DBG: treeview is  0x%x==0x%x\n",tree_details->treestuff[tree_id].treeview,treeview);*/
      if (treeview != tree_details->treestuff[tree_id].treeview){
        /* unselect all in auxiliary treeview */
        GtkTreeSelection *selection = gtk_tree_view_get_selection(tree_details->treestuff[tree_id].treeview);
	gtk_tree_model_foreach(tree_details->treestuff[tree_id].treemodel,unsel,selection);
      }
    }
    
    if((event->type == GDK_2BUTTON_PRESS) && (event->button == 1) && !(event->state & GDK_CONTROL_MASK)){ 
	gdouble h=(event->x - mouseX)*(event->x - mouseX)+(event->y - mouseY)*(event->y - mouseY);
	/*printf("h is %lf (%lf,%lf)--(%lf,%lf)\n",h,event->x ,event->y,mouseX,mouseY);*/
	if (h < 25) double_click=TRUE;
    }
		
	
    if(double_click)
    {	/* this works because item is selected at first click of double click */
	skip_second_release=TRUE; /* skip the second button release event */
	if (reselecttimer)g_source_remove(reselecttimer);
		    /*printf("DBG:canceled reselecttimer = %d\n",reselecttimer );*/
	reselecttimer=0;
	

	gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
	if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
	{
	    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	    newpath = g_strdup(en->path);
	    type = en->type;
	    if ((IS_FSTAB_TYPE(en->type) && IS_XF_FSTAB(en->type))
		    || IS_XF_NETSHARE(en->subtype)){
		    FSTAB_fstab_mount(treeview,en->path,IS_MOUNTED(en->type),en);	
		    goto done;
	    }
	    if(IS_DUMMY_TYPE(en->type) && en->path && strcmp(en->path, "..") == 0)
	    {
		tb_go_up((GtkButton *) tree_details->window, NULL);
		goto done;
	    }
	    if (IS_DUMMY_TYPE(en->type)) goto done;
#ifdef USE_SMB_BRANCH
	    if(IS_NETFILE(en->subtype)){
		/* do double click action */
		/* double click on downloaded file */
		const gchar *file=XF_SMBget_cache_file(treeview,en);
		tree_entry_t *tmp_en = stat_entry ((gchar *)file, __LOCAL_TYPE);
		if (!tmp_en){
		    print_diagnostics("xfce/error",strerror(EINVAL),": ",file,NULL);
		} else {
		    DBG("created entry for %s",file);
		    double_click_open_with(tmp_en);
		    destroy_entry(tmp_en); 
		}
	    }
#endif
	    

	    if(IS_PATH(en->type))
	    {
		if (IS_DIR(en->type))
		{
		    /*pushgo(treestuff, newpath);*/
		    if (!IS_LOCAL_TYPE(en->type)){
    			GtkTreePath *treepath;
			treepath = gtk_tree_model_get_path(treemodel, &iter);
		    	gtk_tree_selection_unselect_path (selection,treepath);
		    	gtk_tree_path_free(treepath);
		    }
		    /* this is always an absolute path */
		    go_to(treestuff, newpath);
		}

		else if(IS_EXE(en->type) )
		{	/* run it (if not registered)*/
			const gchar *prg = MIME_command (en->path);
			if (prg) double_click_open_with(en);
			else {
    				/*  assume in_term to be safe */
    				SET_IN_TERM(en->subtype);
				double_click_run(en);
			}
			if (en->path) RECENT_add2history(en->path);
		} else 
		{      /* open with */
			double_click_open_with(en);
			if (en->path) RECENT_add2history(en->path);
		}
	    }
       	    else if(gtk_tree_model_iter_children(treemodel, &child, &iter)){
       		GtkTreePath *treepath;
       		treepath = gtk_tree_model_get_path(treemodel, &iter);
		gtk_tree_view_expand_row(treeview, treepath, FALSE);
       		gtk_tree_path_free(treepath);
	    }
done:
	    g_free(newpath);
	    newpath=NULL;
	}
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	return TRUE;
    }

    switch (event->button)
    {
	default:
	    break;
	case 2:		
	    return TRUE;	
	    /* this disables dnd (wrong), but also selection (right)*/
#if 0
	       return FALSE; 
	    /* this enables dnd(right), but also selection(wrong)*/
#endif
	case 3:
	    clear_dnd_selection_list(); /* only currently selected items */
	    /* if control not pressed, unselect other rows...*/
	    /*if (event->state != GDK_CONTROL_MASK){*/
	    if (!(event->state & GDK_CONTROL_MASK)){
    		gtk_tree_model_foreach(treemodel,unsel,selection);
	    }
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, 
				    event->y, &treepath, 
				    NULL, NULL, NULL))
	    {
		gtk_tree_selection_select_path(selection,treepath);    
		gtk_tree_model_get_iter (treemodel,&iter,treepath); 
	        gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		if (!IS_PATH(en->type) && ! IS_NETTHING(en->subtype) ) {
		    /*this unselects other stuff: */
		    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
		} else {
    	           gtk_tree_selection_selected_foreach(selection, get_dnd_selection, (gpointer) treeview);
		}
	       	gtk_tree_path_free(treepath);
	    }
	    do_popup(treeview, event);
	    return TRUE;
	case 1: 
	/* case BUTTON_1: */
	    clear_dnd_selection_list();
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, 
				    &treepath, NULL, NULL, NULL))
	    {
		gtk_tree_model_get_iter(treemodel, &iter, treepath);
		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		update_status_line(en);	
		set_path_reference(treeview,treepath);
	        gtk_tree_path_free(treepath);
	    }
	    if (tree_details->preferences & ENABLE_GTK_CLICK){
		 g_timeout_add_full(0, 50, (GtkFunction) delayed_selection, (gpointer) treeview, NULL);
	    } else { /* !ENABLE_GTK_CLICK */
		gtk_tree_selection_selected_foreach(selection, get_dnd_selection, (gpointer) treeview);
	        if (event->state & GDK_CONTROL_MASK || event->state & GDK_SHIFT_MASK){
		    if (event->state & GDK_SHIFT_MASK){
		       g_timeout_add_full(0, 50, (GtkFunction) delayed_selection, (gpointer) treeview, NULL);
		    }
		} else {
		    reselecttimer = g_timeout_add_full(0, 150, (GtkFunction) do_reselect, (gpointer) treeview, NULL);
		    /*printf("DBG:reselecttimer = %d\n",reselecttimer );*/
		}
	    }
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x,  event->y, &treepath, NULL, NULL, NULL))
	    {	
	      easy_mode = gtk_tree_selection_path_is_selected (selection,treepath);
	      if (!is_in_dnd_selection(treepath)){
		if (gtk_tree_model_get_iter (treemodel,&iter,treepath)) 
		{
		  get_dnd_selection(treemodel, treepath, &iter, (gpointer) treeview);
		}
		if (clickpath) gtk_tree_path_free(clickpath);
		clickpath=gtk_tree_path_copy(treepath);
		gtk_tree_path_free(treepath);
	      } else {
		if (clickpath) gtk_tree_path_free(clickpath);
		clickpath=NULL;
	      }
	    }
#if DEBUG_IN_DND
	/* DEBUG must be enabled in dnd.c for this to work: */
#ifdef DEBUG
	    {
	      extern void the_sl(void);
	      the_sl();
	    }
#endif
#endif
	    return FALSE;
    }
    return FALSE;
}

G_MODULE_EXPORT
void on_double_click_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GdkEventButton event;
    event.button = 1;
    event.type = GDK_2BUTTON_PRESS;
    event.x = mouseX;
    event.y = mouseY;
    treeclick((GtkWidget *) menuitem, &event, user_data);
}

/**** callbacks ********/

static gboolean unsel(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    GtkTreeSelection *selection = (GtkTreeSelection *)data;
    gtk_tree_selection_unselect_path (selection,treepath);
    return FALSE;
}

G_MODULE_EXPORT
void on_unselect_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;
    gtk_tree_model_foreach(treemodel,unsel,selection);

}

G_MODULE_EXPORT
void on_select_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;
    GtkTreeIter child,parent;
    tree_entry_t *en;
     
    	if (!title_reference) return;
	if(!gtk_tree_row_reference_valid(title_reference))
	   return ;
        if(!get_entry_from_reference(treeview, title_reference, &child, &en))
	   return ;
	
    	on_unselect_activate(menuitem,user_data);
	
	if (!IS_EXPANDED(en->type)){
	    if (!gtk_tree_model_iter_parent(treemodel,&parent,&child))
	         return;
	} else {
	    get_entry_from_reference(treeview, title_reference, &parent, &en);
	}
    
    	if (!gtk_tree_model_iter_children(treemodel,&child,&parent)) return;
    	do {
      	  gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &en, -1);
      	  if (!IS_DUMMY_TYPE(en->type))
   		gtk_tree_selection_select_iter (selection,&child);
    	}
    	while (gtk_tree_model_iter_next(treemodel,&child));
}


/***   properties_callbacks  ***/

static void on_prop(GtkWidget *w){
   GtkTreeView *treeview = tree_details->treestuff[get_active_tree_id()].treeview;
   xfprop_functions *xfprop_fun = load_prop_module();
   (*(xfprop_fun->do_prop))(treeview,tree_details->window);
   unload_prop_module();
   local_monitor(TRUE);
}
G_MODULE_EXPORT
void on_properties_activate(GtkMenuItem * menuitem, gpointer user_data) {
   on_prop((GtkWidget *)menuitem);
}

G_MODULE_EXPORT
void tb_properties(GtkWidget * w) {
   on_prop(w);
}

/*********   find callbacks   *********/


G_MODULE_EXPORT
void tb_find(GtkButton * button, gpointer user_data)
{
    xffind_functions *xffind_fun = load_find_module();
    (*(xffind_fun->do_find))((GtkWidget *) button);
    /* XXX: function returns before find is done, so
     * we should not unload here, but later. 
     * Can a gmodule unload itself when done? */
    /*unload_find_module();*/
}

G_MODULE_EXPORT
void sb_find(GtkWidget * widget)
{
    tb_find((GtkButton *)widget,NULL);
}

G_MODULE_EXPORT
void on_find_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tb_find((GtkButton *)menuitem,NULL);
}

/* FIXME: this is duplicated above*/
G_MODULE_EXPORT
void on_view_find1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tb_find((GtkButton *)menuitem,NULL);
}



G_MODULE_EXPORT
void on_remove_from_results_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    GtkTreeIter iter, parent;
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    /*get selection */
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
    {
	remove_row(treemodel, &iter,NULL,NULL);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    get_find_root(treeview, &parent, &en);
    if (!gtk_tree_model_iter_has_child(treemodel,&parent)) {
	insert_dummy_row(treemodel, &parent,NULL,en,"xfce/info",_("Nothing searched"));
    }
}


G_MODULE_EXPORT
void on_clear_all_results_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeIter parent;
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;

    get_find_root(treeview, &parent, &en);
    prune_row(treemodel,&parent,NULL,en);
    insert_dummy_row(treemodel, &parent,NULL,en,"xfce/info",_("Nothing searched"));

}

/* book stuff */
G_MODULE_EXPORT
void on_clear_all_bookmarks_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    BOOK_clear_all_bookmarks(menuitem,user_data);
}

G_MODULE_EXPORT
void on_purge_bookmarks1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    BOOK_purge();
}

G_MODULE_EXPORT
void on_remove_from_bookmarks_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    BOOK_remove_from_book();
}



G_MODULE_EXPORT
void
on_save_book                           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_input(SAVE_BOOK_INPUT);

}

G_MODULE_EXPORT
void
on_rememberbook_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    BOOK_rememberbook(menuitem,user_data);
}

/* trash */


G_MODULE_EXPORT
void on_collect_trash1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    TRASH_collect_trash_callback(menuitem, user_data);
}

G_MODULE_EXPORT
void on_uncollect_trash(GtkMenuItem * menuitem, gpointer user_data)
{

    TRASH_uncollect_trash_callback(menuitem, user_data);
}


G_MODULE_EXPORT
void on_delete_all_trash(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    TRASH_delete_all_trash(treeview);
}


G_MODULE_EXPORT
void on_schred_all_trash(GtkMenuItem * menuitem, gpointer user_data)
{

}


G_MODULE_EXPORT
void on_uncollect_from_trash_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    TRASH_uncollect_from_trash_callback (menuitem, user_data);
}

/* recent */

G_MODULE_EXPORT
void on_set_frequency_threshold_activate(GtkMenuItem * menuitem, gpointer user_data){
    show_input(FREQUENCY_INPUT);
}
G_MODULE_EXPORT
void on_set_recent_threshold_activate(GtkMenuItem * menuitem, gpointer user_data){
    show_input(RECENT_INPUT);
}

G_MODULE_EXPORT
void on_undo_history_activate(GtkMenuItem * menuitem, gpointer user_data){
    RECENT_undo_history(menuitem, user_data);
}

void on_clear_recent_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   RECENT_on_clear((GtkWidget *) menuitem,FALSE);    
}
G_MODULE_EXPORT
void on_clear_frequent_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   RECENT_on_clear((GtkWidget *) menuitem,TRUE);    
}

