/*  xffm4
 *
 *  Copyright (C) 2003 olivier fourdan <xfce@users.sourceforge.net>
 *  Copyright (C) 2003-2004 edscott wilson garcia <edscott@xfce.org>
 *  Copyright (C) 2002 Jasper Huijsmans <huysmans@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-common.h>
#include <libxfce4mcs/mcs-manager.h>
#include <xfce-mcs-manager/manager-plugin.h>
#include <libxfce4util/libxfce4util.h>

#include "constants.h"
#include "types.h"


#ifndef XFFM_MCS_PLUGIN
#define XFFM_MCS_PLUGIN
#endif

#define	OLDRCFILE	g_get_home_dir(),".xfce4","settings","xffm.xml"
#define CHANNEL  "xffm"

#ifndef PACKAGE_DATADIR
#define PACKAGE_DATADIR "/usr/local/share/xffm4"
#endif

#define BORDER 6
#define SKIP BORDER

static McsManager *mcs_manager;

static GSList *remove_group=NULL;
GtkWidget *radio_cancel,*radio_waste,*radio_unlink;
GtkWidget *hide_book,*hide_local,*hide_network,
    *hide_find,*hide_trash,*hide_fstab,
    *hide_recent,*hide_frequent,
    *hold_xterm,*diagnostics,*use_sudo;

#if 0
static GtkWidget **preference_w;
static GtkWidget **view_w;
#endif

typedef struct
{
  gchar   *variable;
  gchar   *value;
  gboolean editable;
}
Item;

enum
{
  COLUMN_VARIABLE,
  COLUMN_VALUE,
  COLUMN_EDITABLE,
  NUM_COLUMNS
};

/*static GtkWidget *layer_menu;*/

/*static gboolean is_running = FALSE;*/
static GtkWidget *dialog = NULL;
#include "pixmaps/xffm_icon.xpm"

/********************************************************/
static McsManager *mcs_manager = NULL;

enum {
    /* these are set by checkboxes */
    XFFM_USE_SUDO,
    XFFM_DEFAULT_UNLINK,
    XFFM_HOLD_XTERM,
    XFFM_DIAGNOSTICS_DISABLED,
    /* these are editable: */
    TERMCMD,
    XFFM_HOME,
    SMB_USER,
    SMB_CODESET,
    XFFM_STATUS_LINE_LENGTH,
    XFFM_MAX_PREVIEW_SIZE,
    XFFM_OPTIONS
};

typedef struct
{
  gchar   *name;
  gchar   *value;
}
Options;

static Options xffm_options[XFFM_OPTIONS]={
	{ "XFFM_USE_SUDO",	     NULL },
	{ "XFFM_DEFAULT_UNLINK",     NULL },
	{ "XFFM_HOLD_XTERM",         NULL },
	{ "XFFM_DIAGNOSTICS_DISABLED",                 NULL },
	{ "TERMCMD",                 NULL },
	{ "XFFM_HOME",               NULL },
	{ "SMB_USER",                NULL },
	{ "SMB_CODESET",             NULL },
	{ "XFFM_STATUS_LINE_LENGTH", NULL }, /* FIXME: should be set by spinbutton */
	{ "XFFM_MAX_PREVIEW_SIZE",   NULL }, /* FIXME: should be set by spinbutton */
};

/* Fwd. decl. */
static void run_xffm_settings_dialog(McsPlugin *);
static void create_channel(void);
static gboolean write_options(void);

McsPluginInitResult mcs_plugin_init(McsPlugin *mp)
{
    xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");

    mcs_manager = mp->manager;
    create_channel();
    mp->plugin_name = g_strdup(CHANNEL);
    mp->caption = g_strdup(_("File manager"));
    mp->run_dialog = run_xffm_settings_dialog;
    mp->icon = gdk_pixbuf_new_from_xpm_data((const char **)xffm_icon_xpm);
    mcs_manager_notify(mp->manager, CHANNEL);

    return MCS_PLUGIN_INIT_OK;
}

static void set_option_buttons(void){
	int i;
    for (i = 0; i < XFFM_OPTIONS; i++)
    {
	switch (i) {
		case XFFM_DEFAULT_UNLINK:
			if (strcmp(xffm_options[i].value,"waste")==0) gtk_toggle_button_set_active ((GtkToggleButton *)radio_waste,TRUE);
			else if (strcmp(xffm_options[i].value,"unlink")==0) gtk_toggle_button_set_active ((GtkToggleButton *)radio_unlink,TRUE);
			else gtk_toggle_button_set_active ((GtkToggleButton *)radio_cancel,TRUE);
			break;
		case XFFM_USE_SUDO:
			if (strlen(xffm_options[i].value)) gtk_toggle_button_set_active ((GtkToggleButton *)use_sudo,TRUE);
			break;
		case XFFM_HOLD_XTERM:
			if (strlen(xffm_options[i].value)) gtk_toggle_button_set_active ((GtkToggleButton *)hold_xterm,TRUE);
			break;
	}
    }
}

static void create_channel(void)
{
    McsSetting *setting;

    /*const gchar *home = g_get_home_dir();*/
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",TRUE);
    gchar *rcfile;
    gint i;

    rcfile=g_build_filename(xdg_dir,MCS_PLUGIN_FILE,NULL);
    g_free(xdg_dir);
    
    /*
     * seems 4.0 config file causes problems.
     * better let the user reconfigure 
     * */
    /*if (!g_file_test (rcfile, G_FILE_TEST_EXISTS)){
	g_free(rcfile);
	rcfile=g_build_filename(OLDRCFILE,NULL);
    }*/

    if (g_file_test (rcfile, G_FILE_TEST_EXISTS))
    {
	mcs_manager_add_channel_from_file(mcs_manager, CHANNEL, rcfile);
    }
    else
    {
        mcs_manager_add_channel(mcs_manager, CHANNEL);
    }
    g_free(rcfile);

    for (i = 0; i < XFFM_OPTIONS; i++)
    {
        setting = mcs_manager_setting_lookup(mcs_manager, xffm_options[i].name, CHANNEL);
        if(setting)
        {
            if(xffm_options[i].value)
            {
                g_free(xffm_options[i].value);
		xffm_options[i].value=NULL;
            }
            if (getenv(xffm_options[i].name) && strlen(getenv(xffm_options[i].name)) && strcmp(getenv(xffm_options[i].name),setting->data.v_string)!=0)
	    {
		xffm_options[i].value = g_strdup(getenv(xffm_options[i].name));
	    }
	    else
	    {
		xffm_options[i].value = g_strdup(setting->data.v_string);
	    }
        }
        else
        {   /* if not previously defined, inherit from environment */
            if(strcmp("LANG",xffm_options[i].name)==0 && getenv(xffm_options[i].name) ) 
	    {
		xffm_options[i].value = g_strdup(getenv(xffm_options[i].name));
	    }
	    else {
		xffm_options[i].value = g_strdup("");
	    }
            mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        }
			
    }
}

static gboolean write_options(void)
{
    /*const gchar *home = g_get_home_dir();*/
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",TRUE);
    gchar *rcfile;
    gboolean result;

    rcfile=g_build_filename(xdg_dir,MCS_PLUGIN_FILE,NULL);
    g_free(xdg_dir);
    result = mcs_manager_save_channel_to_file(mcs_manager, CHANNEL, rcfile);
    g_free(rcfile);
    return result;
}


/* macro defined in manager-plugin.h */
MCS_PLUGIN_CHECK_INIT
/********************************************************/

/* the dialog ******************************************/
static void add_spacer(GtkBox * box)
{
    GtkWidget *eventbox = gtk_alignment_new(0,0,0,0);

    gtk_widget_set_size_request(eventbox, SKIP, SKIP);
    gtk_widget_show(eventbox);
    gtk_box_pack_start(box, eventbox, FALSE, TRUE, 0);
}

static gboolean environment_changed(GtkCellRendererText *cell,
	     const gchar         *path_string,
	     const gchar         *new_text,
	     gpointer             data)
{             
    GtkTreeModel *model = (GtkTreeModel *)data;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter iter;

    gint *column;

    column = g_object_get_data (G_OBJECT (cell), "column");

    gtk_tree_model_get_iter (model, &iter, path);

    if (GPOINTER_TO_INT (column) == COLUMN_VALUE) {
    
	gint i;
	gchar *old_text;

        gtk_tree_model_get (model, &iter, column, &old_text, -1);
	g_free (old_text);
	old_text=NULL;
	i = gtk_tree_path_get_indices (path)[0] + TERMCMD;
        if (xffm_options[i].value)
        {
            g_free(xffm_options[i].value);
            xffm_options[i].value = NULL;
        }
	if (new_text && strlen(new_text)) {
		xffm_options[i].value = g_strdup (new_text);
	} else {
		xffm_options[i].value = g_strdup("");
	}
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, column,
                            xffm_options[i].value, -1);
        mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        write_options();
    }
    gtk_tree_path_free (path);
    
    return FALSE;
}

/* the dialog */
static void dialog_delete(GtkWidget *dialog)
{
    gtk_widget_destroy(dialog);
    dialog = NULL;
}

void remove_toggled(GtkToggleButton *togglebutton, gpointer user_data){
	gchar *new_text = NULL;
	if(gtk_toggle_button_get_active((GtkToggleButton *)radio_cancel)) {
		new_text=g_strdup("");
	} 
	else if(gtk_toggle_button_get_active((GtkToggleButton *)radio_waste)) {
		new_text=g_strdup("waste");
	}
	else if(gtk_toggle_button_get_active((GtkToggleButton *)radio_unlink)) {
		new_text=g_strdup("unlink");
	}
        if (xffm_options[XFFM_DEFAULT_UNLINK].value)
        {
            g_free(xffm_options[XFFM_DEFAULT_UNLINK].value);
        }
	xffm_options[XFFM_DEFAULT_UNLINK].value = new_text;
        mcs_manager_set_string(mcs_manager, xffm_options[XFFM_DEFAULT_UNLINK].name, CHANNEL, xffm_options[XFFM_DEFAULT_UNLINK].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        write_options();

}

void option_toggled(GtkToggleButton *togglebutton, gpointer user_data){
	int i = (int)((long) user_data);
	if (xffm_options[i].value)
        {
            g_free(xffm_options[i].value);
        }
	if (gtk_toggle_button_get_active(togglebutton)){
	       	xffm_options[XFFM_DEFAULT_UNLINK].value = g_strdup("yes");
	}
	else {
		xffm_options[XFFM_DEFAULT_UNLINK].value = g_strdup("");
	}
        mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        write_options();

}


static void run_xffm_settings_dialog(McsPlugin *mp)
{
    GtkWidget *header, *vbox,*frame, *hbox, *sw;
    int i;
    GtkListStore *model;
    GtkTreeIter iter;
    GtkCellRenderer *renderer;
    GtkWidget *treeview; 

    xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");

    dialog = gtk_dialog_new_with_buttons(_("File manager"),
                                    	 NULL, GTK_DIALOG_NO_SEPARATOR, 
					 GTK_STOCK_CLOSE, GTK_RESPONSE_OK,
					 NULL);

    g_signal_connect(dialog, "response", G_CALLBACK(dialog_delete), NULL);
    g_signal_connect(dialog, "delete_event", G_CALLBACK(dialog_delete), NULL);
    g_signal_connect(dialog, "destroy", G_CALLBACK(dialog_delete), NULL);
    
    /* pretty header */
    vbox = GTK_DIALOG(dialog)->vbox;
#ifndef XFCE4_O_X_LIBRARIES
    header = xfce_create_header(mp->icon, _("Xffm Settings"));
#else
    header = create_header(mp->icon, _("Xffm Settings"));
#endif
    gtk_box_pack_start(GTK_BOX(vbox), header, FALSE, TRUE, 0);
    
    add_spacer(GTK_BOX(vbox));

#if 0
    frame = xfce_framebox_new (_("Global Configuration"), FALSE);
    gtk_widget_show(frame);
    gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

    vbox=gtk_vbox_new(FALSE,6);
    label = (GtkWidget *) gtk_label_new(_("Default remove action:"));
    gtk_widget_show(label);
    gtk_box_pack_start ((GtkBox *)vbox,label,FALSE,FALSE,0);
    
    hbox=gtk_hbox_new(TRUE,2);
    gtk_box_pack_start ((GtkBox *)vbox,hbox,FALSE,FALSE,0);
#endif
    frame = xfce_framebox_new (_("Default remove action:"), TRUE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

    hbox = gtk_hbox_new (FALSE, 6);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), hbox);
    
    radio_cancel = gtk_radio_button_new_with_label (NULL,_("Cancel"));
    remove_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_cancel));
    gtk_box_pack_start ((GtkBox *)hbox,radio_cancel,FALSE,FALSE,0);
    radio_waste = gtk_radio_button_new_with_label (remove_group,_("Wastebasket"));
    remove_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_waste));
    gtk_box_pack_start ((GtkBox *)hbox,radio_waste,FALSE,FALSE,0);
    radio_unlink = gtk_radio_button_new_with_label (remove_group,_("Unlink"));
    remove_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_unlink));
    gtk_box_pack_start ((GtkBox *)hbox,radio_unlink,FALSE,FALSE,0);

    gtk_widget_show_all (hbox);

#if 0
    label = (GtkWidget *) gtk_label_new(_("Other useful options:"));
    gtk_widget_show(label);
    gtk_box_pack_start ((GtkBox *)vbox,label,FALSE,FALSE,0);
    
    hbox=gtk_hbox_new(TRUE,2);
    gtk_box_pack_start ((GtkBox *)vbox,hbox,FALSE,FALSE,0);
#endif
    add_spacer(GTK_BOX(vbox));

    frame = xfce_framebox_new (_("Other useful options:"), TRUE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new (FALSE, 6);
    gtk_widget_show (vbox);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), vbox);
    
    diagnostics = gtk_check_button_new_with_label (_("Disable diagnostics"));
    hold_xterm = gtk_check_button_new_with_label (_("Hold xterms"));
    use_sudo = gtk_check_button_new_with_label (_("Mount with sudo"));
    gtk_box_pack_start ((GtkBox *)vbox,diagnostics,FALSE,FALSE,0);
    gtk_box_pack_start ((GtkBox *)vbox,hold_xterm,FALSE,FALSE,0);
    gtk_box_pack_start ((GtkBox *)vbox,use_sudo,FALSE,FALSE,0);

    set_option_buttons();
    
    g_signal_connect(radio_cancel, "toggled", G_CALLBACK(remove_toggled), NULL);
    g_signal_connect(radio_waste, "toggled", G_CALLBACK(remove_toggled), NULL);
    g_signal_connect(radio_unlink, "toggled", G_CALLBACK(remove_toggled), NULL);


    g_signal_connect(diagnostics, "toggled", G_CALLBACK(option_toggled), (gpointer)((long)(XFFM_DIAGNOSTICS_DISABLED)));
    g_signal_connect(hold_xterm, "toggled", G_CALLBACK(option_toggled), (gpointer)((long)(XFFM_HOLD_XTERM)));
    g_signal_connect(use_sudo, "toggled", G_CALLBACK(option_toggled), (gpointer)((long)(XFFM_USE_SUDO)));

    gtk_widget_show_all(vbox);

    {
      gchar *g;
      g=g_find_program_in_path("sudo");
      if (g){
	g_free(g);
      } else {
	  gtk_widget_hide(use_sudo);
      }
    }
#if 0
    xfce_framebox_add (XFCE_FRAMEBOX (frame), vbox);
    label = (GtkWidget *) gtk_label_new(_("Environment variables:"));
    gtk_widget_show(label);
    gtk_box_pack_start ((GtkBox *)vbox,label,FALSE,FALSE,0);
#endif
    
    vbox = GTK_DIALOG(dialog)->vbox;
    
    add_spacer(GTK_BOX(vbox));

    frame = xfce_framebox_new (_("Environment variables:"), FALSE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
    
    sw = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
					 GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				    GTK_POLICY_NEVER,
				    GTK_POLICY_NEVER);
    gtk_widget_show(sw);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), sw);

#if 0
    gtk_container_set_border_width(GTK_CONTAINER(sw), BORDER);
    gtk_box_pack_start ((GtkBox *)vbox,sw,FALSE,FALSE,0);
    /*xfce_framebox_add (XFCE_FRAMEBOX (frame), sw);*/
#endif
    
    model = gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING,
			      G_TYPE_BOOLEAN);
    for (i=TERMCMD; i < XFFM_OPTIONS; i++) {
        gtk_list_store_append (model, &iter);
        gtk_list_store_set (model, &iter,
			  COLUMN_VARIABLE,
			  g_strdup (xffm_options[i].name),
			  COLUMN_VALUE,
			  g_strdup (xffm_options[i].value),
			  COLUMN_EDITABLE,
			  TRUE,
			  -1);
    }
    treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(model));
    g_object_unref (G_OBJECT (model));
    gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
    gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)),
				 GTK_SELECTION_SINGLE);
    /* variable column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited",
		      G_CALLBACK (environment_changed), model);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_VARIABLE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					         -1, _("Variable"), renderer,
					         "text", COLUMN_VARIABLE,
					         NULL);
    /* value column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited",
		      G_CALLBACK (environment_changed), model);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_VALUE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					         -1, _("Value"), renderer,
					         "text", COLUMN_VALUE,
					         "editable", COLUMN_EDITABLE,
					         NULL);

    gtk_widget_set_size_request(treeview, 350, -1);
    gtk_widget_show(treeview);
    gtk_container_add (GTK_CONTAINER (sw), treeview);

    xfce_gtk_window_center_on_monitor_with_pointer (GTK_WINDOW (dialog));
    gtk_widget_show(dialog);
}

