/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__SETTINGS_H_
#define _XFMEDIA__SETTINGS_H_

#include <glib.h>
#include <gtk/gtkliststore.h>

#include "xfmedia-common.h"

G_BEGIN_DECLS

void xfmedia_settings_add_string(const gchar *key, const gchar *value);
void xfmedia_settings_add_int(const gchar *key, gint value);
void xfmedia_settings_add_bool(const gchar *key, gboolean value);
void xfmedia_settings_add_float(const gchar *key, gdouble value);

G_CONST_RETURN gchar *xfmedia_settings_get_string(const gchar *key);
gint     xfmedia_settings_get_int(const gchar *key);
gboolean xfmedia_settings_get_bool(const gchar *key);
gdouble  xfmedia_settings_get_float(const gchar *key);

void xfmedia_settings_set_string(const gchar *key, const gchar *value);
void xfmedia_settings_set_int(const gchar *key, gint value);
void xfmedia_settings_set_bool(const gchar *key, gboolean value);
void xfmedia_settings_set_float(const gchar *key, gdouble value);

G_END_DECLS

#endif
