if(NOT DEFINED DEFAULT_Fortran_FLAGS_SET OR RESET_FLAGS)

    # custom flags are defined by setup --custom-fc-flags
    if(DEFINED CUSTOM_Fortran_FLAGS)
        # set custom compiler flags (for every build type)
        set(CMAKE_Fortran_FLAGS "${CUSTOM_Fortran_FLAGS}")
        # special flags for build types will be empty
        set(CMAKE_Fortran_FLAGS_DEBUG "")
        set(CMAKE_Fortran_FLAGS_RELEASE "")
        set(CMAKE_Fortran_FLAGS_PROFILE "")
    else()
        # custom flags are not defined
        if(CMAKE_Fortran_COMPILER_ID MATCHES GNU) # this is gfortran
            set(Fcheck_all "")
            # Try to compile with -fcheck=all if failing use
            check_fortran_compiler_flag("-fcheck=all" has_check_all)
            if(has_check_all)
                set(Fcheck_all "-fcheck=all")
            else()
                set(Fcheck_all "-fbounds-check -fcheck-array-temporaries")
            endif()
            set(CMAKE_Fortran_FLAGS         "-fcray-pointer -DVAR_GFORTRAN -DVAR_MFDS -fno-range-check -fautomatic -fPIC -fimplicit-none")
            # -fcray-pointer is for VAR_MPI2
            set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -g -fbacktrace -Wall -Wextra -pedantic-errors")
            set(CMAKE_Fortran_FLAGS_RELEASE "-O3 -funroll-all-loops -w -ftree-vectorize")
            set(CMAKE_Fortran_FLAGS_PROFILE "${CMAKE_Fortran_FLAGS_RELEASE} -g -pg")
            if(ENABLE_STATIC_LINKING)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -static")
            endif()
            if(ENABLE_BOUNDS_CHECK)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${Fcheck_all}")
            endif()
            if(ENABLE_CODE_COVERAGE)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -fprofile-arcs -ftest-coverage")
            endif()
            if(ENABLE_VECTORIZATION)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${Fortran_ARCHITECTURE_FLAGS}")
            endif()
        elseif(CMAKE_Fortran_COMPILER_ID MATCHES Intel)
            set(CMAKE_Fortran_FLAGS         "-w -fpp -assume byterecl -DVAR_IFORT -fPIC -nosave")
            set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -g -warn all -traceback")
            # Check if xHost flag is available and add it CMAKE_Fortran_FLAGS_RELEASE
            set(xHost "")
            if(ENABLE_XHOST)
                check_fortran_compiler_flag("-xHost" has_xHost)
                if(has_xHost)
                    set(xHost "-xHost")
                endif()
            endif()
            set(CMAKE_Fortran_FLAGS_RELEASE "-O3 -ip ${xHost}")

            set(CMAKE_Fortran_FLAGS_PROFILE "${CMAKE_Fortran_FLAGS_RELEASE} -g -pg")
            if(DEFINED MKL_FLAG)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${MKL_FLAG}")
            endif()
            if(ENABLE_STATIC_LINKING)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -static-libstdc++ -static-libgcc -static-intel -wd10237")
                # for Intel & static, want Fortran_IMPLICIT_LINK for psi4 exe to reduce to:
                #  -Wl,-Bstatic -lifport -lifcore -lpthread
                LIST(INSERT CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES 0 "-Wl,-Bstatic")
                # for Intel & static, want Fortran_IMPLICIT_LINK for psi4.so lib to reduce to:
                #  -Wl,-Bstatic -lifport -lifcore_pic -lpthread -Wl,-Bdynamic -liomp5
                #  below computes the correct list, but unable to replace Fortran_IMPLICIT_LINK on per-target basis
                set(CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES_PSI4SO ${CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES})
                LIST(FIND CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES_PSI4SO "ifcore" IFCORE_IDX)
                LIST(REMOVE_ITEM CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES_PSI4SO "ifcore")
                LIST(INSERT CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES_PSI4SO ${IFCORE_IDX} "ifcore_pic")
                LIST(APPEND CMAKE_Fortran_IMPLICIT_LINK_LIBRARIES_PSI4SO "-Wl,-Bdynamic" "iomp5")
            endif()
            if(ENABLE_BOUNDS_CHECK)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -ftrapuv -check all -fpstkchk")
            endif()
            if(ENABLE_VECTORIZATION)
                set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${Fortran_ARCHITECTURE_FLAGS}")
            endif()
        else()
            message(FATAL_ERROR "Vendor of your Fortran compiler is not supported")
        endif()

        if(DEFINED EXTRA_Fortran_FLAGS)
            set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${EXTRA_Fortran_FLAGS}")
        endif()
    endif()

    save_compiler_flags(Fortran)
endif()
