require 'spec_helper'

describe command('/usr/sbin/varnishd -C -f /etc/varnish/default.vcl') do
  its(:exit_status) { should eq 0 }
end

describe command('/usr/share/varnish/reload-vcl') do
  its(:exit_status) { should eq 0 }
  its(:stdout) { should eq '' }
  its(:stderr) { should contain('VCL reloaded') }
end

describe command('systemctl is-enabled varnish') do
  its(:exit_status) { should eq 0 }
  its(:stderr) { should eq '' }
  its(:stdout) { should eq("enabled\n") }
end

describe command('systemctl is-active varnish') do
  its(:exit_status) { should eq 0 }
  its(:stderr) { should eq '' }
  its(:stdout) { should eq("active\n") }
end

describe command('systemctl reload varnish') do
  its(:exit_status) { should eq 3 }
  its(:stderr) { is_expected.to include('Job type reload is not applicable for unit varnish.service.') }
  its(:stdout) { should eq('') }
end
