/* fontdef.h */

/*
 * Copyright (C) 1998-1999  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

struct s_font_info  font_info[] = {

  /*** 14 ***/
  /* ascii */
  {14, CS_ASCII,      FAM_FIXED, FACE_NORMAL, "iso8859_1:14:f"   },
  {14, CS_ASCII,      FAM_FIXED, FACE_ITALIC, "iso8859_1:14I:f"  },
  {14, CS_ASCII,      FAM_FIXED, FACE_BOLD,   "iso8859_1:14B:f"  },
  {14, CS_ASCII,      FAM_TIMES, FACE_NORMAL, "iso8859_1:14:t"   },
  {14, CS_ASCII,      FAM_TIMES, FACE_ITALIC, "iso8859_1:14I:t"  },
  {14, CS_ASCII,      FAM_TIMES, FACE_BOLD,   "iso8859_1:14B:t"  },
  {14, CS_ASCII,      FAM_HELV,  FACE_NORMAL, "iso8859_1:14:h"   },
  {14, CS_ASCII,      FAM_HELV,  FACE_ITALIC, "iso8859_1:14I:h"  },
  {14, CS_ASCII,      FAM_HELV,  FACE_BOLD,   "iso8859_1:14B:h"  },
  {14, CS_ASCII,      FAM_COUR,  FACE_NORMAL, "iso8859_1:14:c"   },
  {14, CS_ASCII,      FAM_COUR,  FACE_ITALIC, "iso8859_1:14I:c"  },
  {14, CS_ASCII,      FAM_COUR,  FACE_BOLD,   "iso8859_1:14B:c"  },
  /* iso8859-1 */
  {14, CS_ISO8859_1,  FAM_FIXED, FACE_NORMAL, "iso8859_1:14:f"   },
  {14, CS_ISO8859_1,  FAM_FIXED, FACE_ITALIC, "iso8859_1:14I:f"  },
  {14, CS_ISO8859_1,  FAM_FIXED, FACE_BOLD,   "iso8859_1:14B:f"  },
  {14, CS_ISO8859_1,  FAM_TIMES, FACE_NORMAL, "iso8859_1:14:t"   },
  {14, CS_ISO8859_1,  FAM_TIMES, FACE_ITALIC, "iso8859_1:14I:t"  },
  {14, CS_ISO8859_1,  FAM_TIMES, FACE_BOLD,   "iso8859_1:14B:t"  },
  {14, CS_ISO8859_1,  FAM_HELV,  FACE_NORMAL, "iso8859_1:14:h"   },
  {14, CS_ISO8859_1,  FAM_HELV,  FACE_ITALIC, "iso8859_1:14I:h"  },
  {14, CS_ISO8859_1,  FAM_HELV,  FACE_BOLD,   "iso8859_1:14B:h"  },
  {14, CS_ISO8859_1,  FAM_COUR,  FACE_NORMAL, "iso8859_1:14:c"   },
  {14, CS_ISO8859_1,  FAM_COUR,  FACE_ITALIC, "iso8859_1:14I:c"  },
  {14, CS_ISO8859_1,  FAM_COUR,  FACE_BOLD,   "iso8859_1:14B:c"  },
  /* iso8859-2 */
  {14, CS_ISO8859_2,  FAM_FIXED, FACE_NORMAL, "iso8859_2:14:f"   },
  {14, CS_ISO8859_2,  FAM_FIXED, FACE_ITALIC, "iso8859_2:14I:f"  },
  {14, CS_ISO8859_2,  FAM_FIXED, FACE_BOLD,   "iso8859_2:14B:f"  },
  {14, CS_ISO8859_2,  FAM_TIMES, FACE_NORMAL, "iso8859_2:14:t"   },
  {14, CS_ISO8859_2,  FAM_TIMES, FACE_ITALIC, "iso8859_2:14I:t"  },
  {14, CS_ISO8859_2,  FAM_TIMES, FACE_BOLD,   "iso8859_2:14B:t"  },
  {14, CS_ISO8859_2,  FAM_HELV,  FACE_NORMAL, "iso8859_2:14:h"   },
  {14, CS_ISO8859_2,  FAM_HELV,  FACE_ITALIC, "iso8859_2:14I:h"  },
  {14, CS_ISO8859_2,  FAM_HELV,  FACE_BOLD,   "iso8859_2:14B:h"  },
  {14, CS_ISO8859_2,  FAM_COUR,  FACE_NORMAL, "iso8859_2:14:c"   },
  {14, CS_ISO8859_2,  FAM_COUR,  FACE_ITALIC, "iso8859_2:14I:c"  },
  {14, CS_ISO8859_2,  FAM_COUR,  FACE_BOLD,   "iso8859_2:14B:c"  },
  /* iso8859-3 */
  {14, CS_ISO8859_3,  FAM_FIXED, FACE_NORMAL, "iso8859_3:14:f"   },
  {14, CS_ISO8859_3,  FAM_FIXED, FACE_ITALIC, "iso8859_3:14I:f"  },
  {14, CS_ISO8859_3,  FAM_FIXED, FACE_BOLD,   "iso8859_3:14B:f"  },
  {14, CS_ISO8859_3,  FAM_TIMES, FACE_NORMAL, "iso8859_3:14:t"   },
  {14, CS_ISO8859_3,  FAM_TIMES, FACE_ITALIC, "iso8859_3:14I:t"  },
  {14, CS_ISO8859_3,  FAM_TIMES, FACE_BOLD,   "iso8859_3:14B:t"  },
  {14, CS_ISO8859_3,  FAM_HELV,  FACE_NORMAL, "iso8859_3:14:h"   },
  {14, CS_ISO8859_3,  FAM_HELV,  FACE_ITALIC, "iso8859_3:14I:h"  },
  {14, CS_ISO8859_3,  FAM_HELV,  FACE_BOLD,   "iso8859_3:14B:h"  },
  {14, CS_ISO8859_3,  FAM_COUR,  FACE_NORMAL, "iso8859_3:14:c"   },
  {14, CS_ISO8859_3,  FAM_COUR,  FACE_ITALIC, "iso8859_3:14I:c"  },
  {14, CS_ISO8859_3,  FAM_COUR,  FACE_BOLD,   "iso8859_3:14B:c"  },
  /* iso8859-4 */
  {14, CS_ISO8859_4,  FAM_FIXED, FACE_NORMAL, "iso8859_4:14:f"   },
  {14, CS_ISO8859_4,  FAM_FIXED, FACE_ITALIC, "iso8859_4:14I:f"  },
  {14, CS_ISO8859_4,  FAM_FIXED, FACE_BOLD,   "iso8859_4:14B:f"  },
  {14, CS_ISO8859_4,  FAM_TIMES, FACE_NORMAL, "iso8859_4:14:t"   },
  {14, CS_ISO8859_4,  FAM_TIMES, FACE_ITALIC, "iso8859_4:14I:t"  },
  {14, CS_ISO8859_4,  FAM_TIMES, FACE_BOLD,   "iso8859_4:14B:t"  },
  {14, CS_ISO8859_4,  FAM_HELV,  FACE_NORMAL, "iso8859_4:14:h"   },
  {14, CS_ISO8859_4,  FAM_HELV,  FACE_ITALIC, "iso8859_4:14I:h"  },
  {14, CS_ISO8859_4,  FAM_HELV,  FACE_BOLD,   "iso8859_4:14B:h"  },
  {14, CS_ISO8859_4,  FAM_COUR,  FACE_NORMAL, "iso8859_4:14:c"   },
  {14, CS_ISO8859_4,  FAM_COUR,  FACE_ITALIC, "iso8859_4:14I:c"  },
  {14, CS_ISO8859_4,  FAM_COUR,  FACE_BOLD,   "iso8859_4:14B:c"  },
  /* iso8859-5 */
  {14, CS_ISO8859_5,  FAM_FIXED, FACE_NORMAL, "iso8859_5:14:f"   },
  {14, CS_ISO8859_5,  FAM_FIXED, FACE_ITALIC, "iso8859_5:14I:f"  },
  {14, CS_ISO8859_5,  FAM_FIXED, FACE_BOLD,   "iso8859_5:14B:f"  },
  {14, CS_ISO8859_5,  FAM_TIMES, FACE_NORMAL, "iso8859_5:14:t"   },
  {14, CS_ISO8859_5,  FAM_TIMES, FACE_ITALIC, "iso8859_5:14I:t"  },
  {14, CS_ISO8859_5,  FAM_TIMES, FACE_BOLD,   "iso8859_5:14B:t"  },
  {14, CS_ISO8859_5,  FAM_HELV,  FACE_NORMAL, "iso8859_5:14:h"   },
  {14, CS_ISO8859_5,  FAM_HELV,  FACE_ITALIC, "iso8859_5:14I:h"  },
  {14, CS_ISO8859_5,  FAM_HELV,  FACE_BOLD,   "iso8859_5:14B:h"  },
  {14, CS_ISO8859_5,  FAM_COUR,  FACE_NORMAL, "iso8859_5:14:c"   },
  {14, CS_ISO8859_5,  FAM_COUR,  FACE_ITALIC, "iso8859_5:14I:c"  },
  {14, CS_ISO8859_5,  FAM_COUR,  FACE_BOLD,   "iso8859_5:14B:c"  },
  /* iso8859-7 */
  {14, CS_ISO8859_7,  FAM_FIXED, FACE_NORMAL, "iso8859_7:14:f"   },
  {14, CS_ISO8859_7,  FAM_FIXED, FACE_ITALIC, "iso8859_7:14I:f"  },
  {14, CS_ISO8859_7,  FAM_FIXED, FACE_BOLD,   "iso8859_7:14B:f"  },
  {14, CS_ISO8859_7,  FAM_TIMES, FACE_NORMAL, "iso8859_7:14:t"   },
  {14, CS_ISO8859_7,  FAM_TIMES, FACE_ITALIC, "iso8859_7:14I:t"  },
  {14, CS_ISO8859_7,  FAM_TIMES, FACE_BOLD,   "iso8859_7:14B:t"  },
  {14, CS_ISO8859_7,  FAM_HELV,  FACE_NORMAL, "iso8859_7:14:h"   },
  {14, CS_ISO8859_7,  FAM_HELV,  FACE_ITALIC, "iso8859_7:14I:h"  },
  {14, CS_ISO8859_7,  FAM_HELV,  FACE_BOLD,   "iso8859_7:14B:h"  },
  {14, CS_ISO8859_7,  FAM_COUR,  FACE_NORMAL, "iso8859_7:14:c"   },
  {14, CS_ISO8859_7,  FAM_COUR,  FACE_ITALIC, "iso8859_7:14I:c"  },
  {14, CS_ISO8859_7,  FAM_COUR,  FACE_BOLD,   "iso8859_7:14B:c"  },
  /* iso8859-8 */
  {14, CS_ISO8859_8,  FAM_FIXED, FACE_NORMAL, "iso8859_8:14:f"   },
  {14, CS_ISO8859_8,  FAM_FIXED, FACE_ITALIC, "iso8859_8:14I:f"  },
  {14, CS_ISO8859_8,  FAM_FIXED, FACE_BOLD,   "iso8859_8:14B:f"  },
  {14, CS_ISO8859_8,  FAM_TIMES, FACE_NORMAL, "iso8859_8:14:t"   },
  {14, CS_ISO8859_8,  FAM_TIMES, FACE_ITALIC, "iso8859_8:14I:t"  },
  {14, CS_ISO8859_8,  FAM_TIMES, FACE_BOLD,   "iso8859_8:14B:t"  },
  {14, CS_ISO8859_8,  FAM_HELV,  FACE_NORMAL, "iso8859_8:14:h"   },
  {14, CS_ISO8859_8,  FAM_HELV,  FACE_ITALIC, "iso8859_8:14I:h"  },
  {14, CS_ISO8859_8,  FAM_HELV,  FACE_BOLD,   "iso8859_8:14B:h"  },
  {14, CS_ISO8859_8,  FAM_COUR,  FACE_NORMAL, "iso8859_8:14:c"   },
  {14, CS_ISO8859_8,  FAM_COUR,  FACE_ITALIC, "iso8859_8:14I:c"  },
  {14, CS_ISO8859_8,  FAM_COUR,  FACE_BOLD,   "iso8859_8:14B:c"  },
  /* iso8859-9 */
  {14, CS_ISO8859_9,  FAM_FIXED, FACE_NORMAL, "iso8859_9:14:f"   },
  {14, CS_ISO8859_9,  FAM_FIXED, FACE_ITALIC, "iso8859_9:14I:f"  },
  {14, CS_ISO8859_9,  FAM_FIXED, FACE_BOLD,   "iso8859_9:14B:f"  },
  {14, CS_ISO8859_9,  FAM_TIMES, FACE_NORMAL, "iso8859_9:14:t"   },
  {14, CS_ISO8859_9,  FAM_TIMES, FACE_ITALIC, "iso8859_9:14I:t"  },
  {14, CS_ISO8859_9,  FAM_TIMES, FACE_BOLD,   "iso8859_9:14B:t"  },
  {14, CS_ISO8859_9,  FAM_HELV,  FACE_NORMAL, "iso8859_9:14:h"   },
  {14, CS_ISO8859_9,  FAM_HELV,  FACE_ITALIC, "iso8859_9:14I:h"  },
  {14, CS_ISO8859_9,  FAM_HELV,  FACE_BOLD,   "iso8859_9:14B:h"  },
  {14, CS_ISO8859_9,  FAM_COUR,  FACE_NORMAL, "iso8859_9:14:c"   },
  {14, CS_ISO8859_9,  FAM_COUR,  FACE_ITALIC, "iso8859_9:14I:c"  },
  {14, CS_ISO8859_9,  FAM_COUR,  FACE_BOLD,   "iso8859_9:14B:c"  },
  /* japanese */
  {14, CS_JISX0201K,  FAM_FIXED, FACE_NORMAL, "jisx0201k:14:f"   },
  {14, CS_JISX0201R,  FAM_FIXED, FACE_NORMAL, "jisx0201r:14:f"   },
  {14, CS_JISX0208,   FAM_FIXED, FACE_NORMAL, "jisx0208:14:f"    },
  {14, CS_JISX0208,   FAM_FIXED, FACE_ITALIC, "jisx0208:14I:f"   },
  {14, CS_JISX0208,   FAM_FIXED, FACE_BOLD,   "jisx0208:14B:f"   },
  {14, CS_JISX0208,   FAM_TIMES, FACE_NORMAL, "jisx0208:14:t"    },
  {14, CS_JISX0208,   FAM_TIMES, FACE_ITALIC, "jisx0208:14I:t"   },
  {14, CS_JISX0208,   FAM_TIMES, FACE_BOLD,   "jisx0208:14B:t"   },
  {14, CS_JISX0208,   FAM_HELV,  FACE_NORMAL, "jisx0208:14:h"    },
  {14, CS_JISX0208,   FAM_HELV,  FACE_ITALIC, "jisx0208:14I:h"   },
  {14, CS_JISX0208,   FAM_HELV,  FACE_BOLD,   "jisx0208:14B:h"   },
  {14, CS_JISX0208,   FAM_COUR,  FACE_NORMAL, "jisx0208:14:c"    },
  {14, CS_JISX0208,   FAM_COUR,  FACE_ITALIC, "jisx0208:14I:c"   },
  {14, CS_JISX0208,   FAM_COUR,  FACE_BOLD,   "jisx0208:14B:c"   },
  {14, CS_JISX0212,   FAM_FIXED, FACE_NORMAL, "jisx0212:14:f"    },
  /* hangle */
  {14, CS_KSC5601,    FAM_FIXED, FACE_NORMAL, "ksc5601:14:f"     },
  {14, CS_KSC5601,    FAM_FIXED, FACE_ITALIC, "ksc5601:14I:f"    },
  {14, CS_KSC5601,    FAM_FIXED, FACE_BOLD,   "ksc5601:14B:f"    },
  {14, CS_KSC5601,    FAM_TIMES, FACE_NORMAL, "ksc5601:14:t"     },
  {14, CS_KSC5601,    FAM_TIMES, FACE_ITALIC, "ksc5601:14I:t"    },
  {14, CS_KSC5601,    FAM_TIMES, FACE_BOLD,   "ksc5601:14B:t"    },
  {14, CS_KSC5601,    FAM_HELV,  FACE_NORMAL, "ksc5601:14:h"     },
  {14, CS_KSC5601,    FAM_HELV,  FACE_ITALIC, "ksc5601:14I:h"    },
  {14, CS_KSC5601,    FAM_HELV,  FACE_BOLD,   "ksc5601:14B:h"    },
  {14, CS_KSC5601,    FAM_COUR,  FACE_NORMAL, "ksc5601:14:c"     },
  {14, CS_KSC5601,    FAM_COUR,  FACE_ITALIC, "ksc5601:14I:c"    },
  {14, CS_KSC5601,    FAM_COUR,  FACE_BOLD,   "ksc5601:14B:c"    },
  /* chinese */
  {14, CS_GB2312,     FAM_FIXED, FACE_NORMAL, "gb2312:14:f"      },
  {14, CS_GB2312,     FAM_FIXED, FACE_ITALIC, "gb2312:14I:f"     },
  {14, CS_GB2312,     FAM_FIXED, FACE_BOLD,   "gb2312:14B:f"     },
  {14, CS_GB2312,     FAM_TIMES, FACE_NORMAL, "gb2312:14:t"      },
  {14, CS_GB2312,     FAM_TIMES, FACE_ITALIC, "gb2312:14I:t"     },
  {14, CS_GB2312,     FAM_TIMES, FACE_BOLD,   "gb2312:14B:t"     },
  {14, CS_GB2312,     FAM_HELV,  FACE_NORMAL, "gb2312:14:h"      },
  {14, CS_GB2312,     FAM_HELV,  FACE_ITALIC, "gb2312:14I:h"     },
  {14, CS_GB2312,     FAM_HELV,  FACE_BOLD,   "gb2312:14B:h"     },
  {14, CS_GB2312,     FAM_COUR,  FACE_NORMAL, "gb2312:14:c"      },
  {14, CS_GB2312,     FAM_COUR,  FACE_ITALIC, "gb2312:14I:c"     },
  {14, CS_GB2312,     FAM_COUR,  FACE_BOLD,   "gb2312:14B:c"     },
  {14, CS_CNS11643_1, FAM_FIXED, FACE_NORMAL, "cns11643_1:14:f"  },
  {14, CS_CNS11643_1, FAM_FIXED, FACE_ITALIC, "cns11643_1:14I:f" },
  {14, CS_CNS11643_1, FAM_FIXED, FACE_BOLD,   "cns11643_1:14B:f" },
  {14, CS_CNS11643_1, FAM_TIMES, FACE_NORMAL, "cns11643_1:14:t"  },
  {14, CS_CNS11643_1, FAM_TIMES, FACE_ITALIC, "cns11643_1:14I:t" },
  {14, CS_CNS11643_1, FAM_TIMES, FACE_BOLD,   "cns11643_1:14B:t" },
  {14, CS_CNS11643_1, FAM_HELV,  FACE_NORMAL, "cns11643_1:14:h"  },
  {14, CS_CNS11643_1, FAM_HELV,  FACE_ITALIC, "cns11643_1:14I:h" },
  {14, CS_CNS11643_1, FAM_HELV,  FACE_BOLD,   "cns11643_1:14B:h" },
  {14, CS_CNS11643_1, FAM_COUR,  FACE_NORMAL, "cns11643_1:14:c"  },
  {14, CS_CNS11643_1, FAM_COUR,  FACE_ITALIC, "cns11643_1:14I:c" },
  {14, CS_CNS11643_1, FAM_COUR,  FACE_BOLD,   "cns11643_1:14B:c" },
  {14, CS_CNS11643_2, FAM_FIXED, FACE_NORMAL, "cns11643_2:14:f"  },
  {14, CS_CNS11643_2, FAM_FIXED, FACE_ITALIC, "cns11643_2:14I:f" },
  {14, CS_CNS11643_2, FAM_FIXED, FACE_BOLD,   "cns11643_2:14B:f" },
  {14, CS_CNS11643_2, FAM_TIMES, FACE_NORMAL, "cns11643_2:14:t"  },
  {14, CS_CNS11643_2, FAM_TIMES, FACE_ITALIC, "cns11643_2:14I:t" },
  {14, CS_CNS11643_2, FAM_TIMES, FACE_BOLD,   "cns11643_2:14B:t" },
  {14, CS_CNS11643_2, FAM_HELV,  FACE_NORMAL, "cns11643_2:14:h"  },
  {14, CS_CNS11643_2, FAM_HELV,  FACE_ITALIC, "cns11643_2:14I:h" },
  {14, CS_CNS11643_2, FAM_HELV,  FACE_BOLD,   "cns11643_2:14B:h" },
  {14, CS_CNS11643_2, FAM_COUR,  FACE_NORMAL, "cns11643_2:14:c"  },
  {14, CS_CNS11643_2, FAM_COUR,  FACE_ITALIC, "cns11643_2:14I:c" },
  {14, CS_CNS11643_2, FAM_COUR,  FACE_BOLD,   "cns11643_2:14B:c" },
  {14, CS_CNS11643_3, FAM_FIXED, FACE_NORMAL, "cns11643_3:14:f"  },
  {14, CS_CNS11643_4, FAM_FIXED, FACE_NORMAL, "cns11643_4:14:f"  },
  {14, CS_CNS11643_5, FAM_FIXED, FACE_NORMAL, "cns11643_5:14:f"  },
  {14, CS_CNS11643_5, FAM_FIXED, FACE_NORMAL, "cns11643_6:14:f"  },
  {14, CS_CNS11643_7, FAM_FIXED, FACE_NORMAL, "cns11643_7:14:f"  },
  /* mule big 5 */
  {14, CS_MULE_BIG5_L1,  FAM_FIXED, FACE_NORMAL, "big5:14:f"  },
  {14, CS_MULE_BIG5_L2,  FAM_FIXED, FACE_NORMAL, "big5:14:f"  },
  /* mule arabic */
  {14, CS_MULE_ARAB0,    FAM_FIXED, FACE_NORMAL, "mule_arab0:14:f"     },
  {14, CS_MULE_ARAB1,    FAM_FIXED, FACE_NORMAL, "mule_arab1:14:f"     },
  {14, CS_MULE_ARAB2,    FAM_FIXED, FACE_NORMAL, "mule_arab2:14:f"     },
  /* mule ethiopic */
  {14, CS_MULE_ETHIOPIC, FAM_FIXED, FACE_NORMAL, "mule_ethio:14:f"     },
  /* mule viscii */
  {14, CS_MULE_VISCII_L, FAM_FIXED, FACE_NORMAL, "mule_viscii_l:14:f"  },
  {14, CS_MULE_VISCII_U, FAM_FIXED, FACE_NORMAL, "mule_viscii_u:14:f"  },

  /*** 16 ***/
  /* ascii */
  {16, CS_ASCII,      FAM_FIXED, FACE_NORMAL, "iso8859_1:16:f"   },
  {16, CS_ASCII,      FAM_FIXED, FACE_ITALIC, "iso8859_1:16I:f"  },
  {16, CS_ASCII,      FAM_FIXED, FACE_BOLD,   "iso8859_1:16B:f"  },
  {16, CS_ASCII,      FAM_TIMES, FACE_NORMAL, "iso8859_1:16:t"   },
  {16, CS_ASCII,      FAM_TIMES, FACE_ITALIC, "iso8859_1:16I:t"  },
  {16, CS_ASCII,      FAM_TIMES, FACE_BOLD,   "iso8859_1:16B:t"  },
  {16, CS_ASCII,      FAM_HELV,  FACE_NORMAL, "iso8859_1:16:h"   },
  {16, CS_ASCII,      FAM_HELV,  FACE_ITALIC, "iso8859_1:16I:h"  },
  {16, CS_ASCII,      FAM_HELV,  FACE_BOLD,   "iso8859_1:16B:h"  },
  {16, CS_ASCII,      FAM_COUR,  FACE_NORMAL, "iso8859_1:16:c"   },
  {16, CS_ASCII,      FAM_COUR,  FACE_ITALIC, "iso8859_1:16I:c"  },
  {16, CS_ASCII,      FAM_COUR,  FACE_BOLD,   "iso8859_1:16B:c"  },
  /* iso8859-1 */
  {16, CS_ISO8859_1,  FAM_FIXED, FACE_NORMAL, "iso8859_1:16:f"   },
  {16, CS_ISO8859_1,  FAM_FIXED, FACE_ITALIC, "iso8859_1:16I:f"  },
  {16, CS_ISO8859_1,  FAM_FIXED, FACE_BOLD,   "iso8859_1:16B:f"  },
  {16, CS_ISO8859_1,  FAM_TIMES, FACE_NORMAL, "iso8859_1:16:t"   },
  {16, CS_ISO8859_1,  FAM_TIMES, FACE_ITALIC, "iso8859_1:16I:t"  },
  {16, CS_ISO8859_1,  FAM_TIMES, FACE_BOLD,   "iso8859_1:16B:t"  },
  {16, CS_ISO8859_1,  FAM_HELV,  FACE_NORMAL, "iso8859_1:16:h"   },
  {16, CS_ISO8859_1,  FAM_HELV,  FACE_ITALIC, "iso8859_1:16I:h"  },
  {16, CS_ISO8859_1,  FAM_HELV,  FACE_BOLD,   "iso8859_1:16B:h"  },
  {16, CS_ISO8859_1,  FAM_COUR,  FACE_NORMAL, "iso8859_1:16:c"   },
  {16, CS_ISO8859_1,  FAM_COUR,  FACE_ITALIC, "iso8859_1:16I:c"  },
  {16, CS_ISO8859_1,  FAM_COUR,  FACE_BOLD,   "iso8859_1:16B:c"  },
  /* iso8859-2 */
  {16, CS_ISO8859_2,  FAM_FIXED, FACE_NORMAL, "iso8859_2:16:f"   },
  {16, CS_ISO8859_2,  FAM_FIXED, FACE_ITALIC, "iso8859_2:16I:f"  },
  {16, CS_ISO8859_2,  FAM_FIXED, FACE_BOLD,   "iso8859_2:16B:f"  },
  {16, CS_ISO8859_2,  FAM_TIMES, FACE_NORMAL, "iso8859_2:16:t"   },
  {16, CS_ISO8859_2,  FAM_TIMES, FACE_ITALIC, "iso8859_2:16I:t"  },
  {16, CS_ISO8859_2,  FAM_TIMES, FACE_BOLD,   "iso8859_2:16B:t"  },
  {16, CS_ISO8859_2,  FAM_HELV,  FACE_NORMAL, "iso8859_2:16:h"   },
  {16, CS_ISO8859_2,  FAM_HELV,  FACE_ITALIC, "iso8859_2:16I:h"  },
  {16, CS_ISO8859_2,  FAM_HELV,  FACE_BOLD,   "iso8859_2:16B:h"  },
  {16, CS_ISO8859_2,  FAM_COUR,  FACE_NORMAL, "iso8859_2:16:c"   },
  {16, CS_ISO8859_2,  FAM_COUR,  FACE_ITALIC, "iso8859_2:16I:c"  },
  {16, CS_ISO8859_2,  FAM_COUR,  FACE_BOLD,   "iso8859_2:16B:c"  },
  /* iso8859-3 */
  {16, CS_ISO8859_3,  FAM_FIXED, FACE_NORMAL, "iso8859_3:16:f"   },
  {16, CS_ISO8859_3,  FAM_FIXED, FACE_ITALIC, "iso8859_3:16I:f"  },
  {16, CS_ISO8859_3,  FAM_FIXED, FACE_BOLD,   "iso8859_3:16B:f"  },
  {16, CS_ISO8859_3,  FAM_TIMES, FACE_NORMAL, "iso8859_3:16:t"   },
  {16, CS_ISO8859_3,  FAM_TIMES, FACE_ITALIC, "iso8859_3:16I:t"  },
  {16, CS_ISO8859_3,  FAM_TIMES, FACE_BOLD,   "iso8859_3:16B:t"  },
  {16, CS_ISO8859_3,  FAM_HELV,  FACE_NORMAL, "iso8859_3:16:h"   },
  {16, CS_ISO8859_3,  FAM_HELV,  FACE_ITALIC, "iso8859_3:16I:h"  },
  {16, CS_ISO8859_3,  FAM_HELV,  FACE_BOLD,   "iso8859_3:16B:h"  },
  {16, CS_ISO8859_3,  FAM_COUR,  FACE_NORMAL, "iso8859_3:16:c"   },
  {16, CS_ISO8859_3,  FAM_COUR,  FACE_ITALIC, "iso8859_3:16I:c"  },
  {16, CS_ISO8859_3,  FAM_COUR,  FACE_BOLD,   "iso8859_3:16B:c"  },
  /* iso8859-4 */
  {16, CS_ISO8859_4,  FAM_FIXED, FACE_NORMAL, "iso8859_4:16:f"   },
  {16, CS_ISO8859_4,  FAM_FIXED, FACE_ITALIC, "iso8859_4:16I:f"  },
  {16, CS_ISO8859_4,  FAM_FIXED, FACE_BOLD,   "iso8859_4:16B:f"  },
  {16, CS_ISO8859_4,  FAM_TIMES, FACE_NORMAL, "iso8859_4:16:t"   },
  {16, CS_ISO8859_4,  FAM_TIMES, FACE_ITALIC, "iso8859_4:16I:t"  },
  {16, CS_ISO8859_4,  FAM_TIMES, FACE_BOLD,   "iso8859_4:16B:t"  },
  {16, CS_ISO8859_4,  FAM_HELV,  FACE_NORMAL, "iso8859_4:16:h"   },
  {16, CS_ISO8859_4,  FAM_HELV,  FACE_ITALIC, "iso8859_4:16I:h"  },
  {16, CS_ISO8859_4,  FAM_HELV,  FACE_BOLD,   "iso8859_4:16B:h"  },
  {16, CS_ISO8859_4,  FAM_COUR,  FACE_NORMAL, "iso8859_4:16:c"   },
  {16, CS_ISO8859_4,  FAM_COUR,  FACE_ITALIC, "iso8859_4:16I:c"  },
  {16, CS_ISO8859_4,  FAM_COUR,  FACE_BOLD,   "iso8859_4:16B:c"  },
  /* iso8859-5 */
  {16, CS_ISO8859_5,  FAM_FIXED, FACE_NORMAL, "iso8859_5:16:f"   },
  {16, CS_ISO8859_5,  FAM_FIXED, FACE_ITALIC, "iso8859_5:16I:f"  },
  {16, CS_ISO8859_5,  FAM_FIXED, FACE_BOLD,   "iso8859_5:16B:f"  },
  {16, CS_ISO8859_5,  FAM_TIMES, FACE_NORMAL, "iso8859_5:16:t"   },
  {16, CS_ISO8859_5,  FAM_TIMES, FACE_ITALIC, "iso8859_5:16I:t"  },
  {16, CS_ISO8859_5,  FAM_TIMES, FACE_BOLD,   "iso8859_5:16B:t"  },
  {16, CS_ISO8859_5,  FAM_HELV,  FACE_NORMAL, "iso8859_5:16:h"   },
  {16, CS_ISO8859_5,  FAM_HELV,  FACE_ITALIC, "iso8859_5:16I:h"  },
  {16, CS_ISO8859_5,  FAM_HELV,  FACE_BOLD,   "iso8859_5:16B:h"  },
  {16, CS_ISO8859_5,  FAM_COUR,  FACE_NORMAL, "iso8859_5:16:c"   },
  {16, CS_ISO8859_5,  FAM_COUR,  FACE_ITALIC, "iso8859_5:16I:c"  },
  {16, CS_ISO8859_5,  FAM_COUR,  FACE_BOLD,   "iso8859_5:16B:c"  },
  /* iso8859-7 */
  {16, CS_ISO8859_7,  FAM_FIXED, FACE_NORMAL, "iso8859_7:16:f"   },
  {16, CS_ISO8859_7,  FAM_FIXED, FACE_ITALIC, "iso8859_7:16I:f"  },
  {16, CS_ISO8859_7,  FAM_FIXED, FACE_BOLD,   "iso8859_7:16B:f"  },
  {16, CS_ISO8859_7,  FAM_TIMES, FACE_NORMAL, "iso8859_7:16:t"   },
  {16, CS_ISO8859_7,  FAM_TIMES, FACE_ITALIC, "iso8859_7:16I:t"  },
  {16, CS_ISO8859_7,  FAM_TIMES, FACE_BOLD,   "iso8859_7:16B:t"  },
  {16, CS_ISO8859_7,  FAM_HELV,  FACE_NORMAL, "iso8859_7:16:h"   },
  {16, CS_ISO8859_7,  FAM_HELV,  FACE_ITALIC, "iso8859_7:16I:h"  },
  {16, CS_ISO8859_7,  FAM_HELV,  FACE_BOLD,   "iso8859_7:16B:h"  },
  {16, CS_ISO8859_7,  FAM_COUR,  FACE_NORMAL, "iso8859_7:16:c"   },
  {16, CS_ISO8859_7,  FAM_COUR,  FACE_ITALIC, "iso8859_7:16I:c"  },
  {16, CS_ISO8859_7,  FAM_COUR,  FACE_BOLD,   "iso8859_7:16B:c"  },
  /* iso8859-8 */
  {16, CS_ISO8859_8,  FAM_FIXED, FACE_NORMAL, "iso8859_8:16:f"   },
  {16, CS_ISO8859_8,  FAM_FIXED, FACE_ITALIC, "iso8859_8:16I:f"  },
  {16, CS_ISO8859_8,  FAM_FIXED, FACE_BOLD,   "iso8859_8:16B:f"  },
  {16, CS_ISO8859_8,  FAM_TIMES, FACE_NORMAL, "iso8859_8:16:t"   },
  {16, CS_ISO8859_8,  FAM_TIMES, FACE_ITALIC, "iso8859_8:16I:t"  },
  {16, CS_ISO8859_8,  FAM_TIMES, FACE_BOLD,   "iso8859_8:16B:t"  },
  {16, CS_ISO8859_8,  FAM_HELV,  FACE_NORMAL, "iso8859_8:16:h"   },
  {16, CS_ISO8859_8,  FAM_HELV,  FACE_ITALIC, "iso8859_8:16I:h"  },
  {16, CS_ISO8859_8,  FAM_HELV,  FACE_BOLD,   "iso8859_8:16B:h"  },
  {16, CS_ISO8859_8,  FAM_COUR,  FACE_NORMAL, "iso8859_8:16:c"   },
  {16, CS_ISO8859_8,  FAM_COUR,  FACE_ITALIC, "iso8859_8:16I:c"  },
  {16, CS_ISO8859_8,  FAM_COUR,  FACE_BOLD,   "iso8859_8:16B:c"  },
  /* iso8859-9 */
  {16, CS_ISO8859_9,  FAM_FIXED, FACE_NORMAL, "iso8859_9:16:f"   },
  {16, CS_ISO8859_9,  FAM_FIXED, FACE_ITALIC, "iso8859_9:16I:f"  },
  {16, CS_ISO8859_9,  FAM_FIXED, FACE_BOLD,   "iso8859_9:16B:f"  },
  {16, CS_ISO8859_9,  FAM_TIMES, FACE_NORMAL, "iso8859_9:16:t"   },
  {16, CS_ISO8859_9,  FAM_TIMES, FACE_ITALIC, "iso8859_9:16I:t"  },
  {16, CS_ISO8859_9,  FAM_TIMES, FACE_BOLD,   "iso8859_9:16B:t"  },
  {16, CS_ISO8859_9,  FAM_HELV,  FACE_NORMAL, "iso8859_9:16:h"   },
  {16, CS_ISO8859_9,  FAM_HELV,  FACE_ITALIC, "iso8859_9:16I:h"  },
  {16, CS_ISO8859_9,  FAM_HELV,  FACE_BOLD,   "iso8859_9:16B:h"  },
  {16, CS_ISO8859_9,  FAM_COUR,  FACE_NORMAL, "iso8859_9:16:c"   },
  {16, CS_ISO8859_9,  FAM_COUR,  FACE_ITALIC, "iso8859_9:16I:c"  },
  {16, CS_ISO8859_9,  FAM_COUR,  FACE_BOLD,   "iso8859_9:16B:c"  },
  /* japanese */
  {16, CS_JISX0201K,  FAM_FIXED, FACE_NORMAL, "jisx0201k:16:f"   },
  {16, CS_JISX0201R,  FAM_FIXED, FACE_NORMAL, "jisx0201r:16:f"   },
  {16, CS_JISX0208,   FAM_FIXED, FACE_NORMAL, "jisx0208:16:f"    },
  {16, CS_JISX0208,   FAM_FIXED, FACE_ITALIC, "jisx0208:16I:f"   },
  {16, CS_JISX0208,   FAM_FIXED, FACE_BOLD,   "jisx0208:16B:f"   },
  {16, CS_JISX0208,   FAM_TIMES, FACE_NORMAL, "jisx0208:16:t"    },
  {16, CS_JISX0208,   FAM_TIMES, FACE_ITALIC, "jisx0208:16I:t"   },
  {16, CS_JISX0208,   FAM_TIMES, FACE_BOLD,   "jisx0208:16B:t"   },
  {16, CS_JISX0208,   FAM_HELV,  FACE_NORMAL, "jisx0208:16:h"    },
  {16, CS_JISX0208,   FAM_HELV,  FACE_ITALIC, "jisx0208:16I:h"   },
  {16, CS_JISX0208,   FAM_HELV,  FACE_BOLD,   "jisx0208:16B:h"   },
  {16, CS_JISX0208,   FAM_COUR,  FACE_NORMAL, "jisx0208:16:c"    },
  {16, CS_JISX0208,   FAM_COUR,  FACE_ITALIC, "jisx0208:16I:c"   },
  {16, CS_JISX0208,   FAM_COUR,  FACE_BOLD,   "jisx0208:16B:c"   },
  {16, CS_JISX0212,   FAM_FIXED, FACE_NORMAL, "jisx0212:16:f"    },
  /* hangle */
  {16, CS_KSC5601,    FAM_FIXED, FACE_NORMAL, "ksc5601:16:f"     },
  {16, CS_KSC5601,    FAM_FIXED, FACE_ITALIC, "ksc5601:16I:f"    },
  {16, CS_KSC5601,    FAM_FIXED, FACE_BOLD,   "ksc5601:16B:f"    },
  {16, CS_KSC5601,    FAM_TIMES, FACE_NORMAL, "ksc5601:16:t"     },
  {16, CS_KSC5601,    FAM_TIMES, FACE_ITALIC, "ksc5601:16I:t"    },
  {16, CS_KSC5601,    FAM_TIMES, FACE_BOLD,   "ksc5601:16B:t"    },
  {16, CS_KSC5601,    FAM_HELV,  FACE_NORMAL, "ksc5601:16:h"     },
  {16, CS_KSC5601,    FAM_HELV,  FACE_ITALIC, "ksc5601:16I:h"    },
  {16, CS_KSC5601,    FAM_HELV,  FACE_BOLD,   "ksc5601:16B:h"    },
  {16, CS_KSC5601,    FAM_COUR,  FACE_NORMAL, "ksc5601:16:c"     },
  {16, CS_KSC5601,    FAM_COUR,  FACE_ITALIC, "ksc5601:16I:c"    },
  {16, CS_KSC5601,    FAM_COUR,  FACE_BOLD,   "ksc5601:16B:c"    },
  /* chinese */
  {16, CS_GB2312,     FAM_FIXED, FACE_NORMAL, "gb2312:16:f"      },
  {16, CS_GB2312,     FAM_FIXED, FACE_ITALIC, "gb2312:16I:f"     },
  {16, CS_GB2312,     FAM_FIXED, FACE_BOLD,   "gb2312:16B:f"     },
  {16, CS_GB2312,     FAM_TIMES, FACE_NORMAL, "gb2312:16:t"      },
  {16, CS_GB2312,     FAM_TIMES, FACE_ITALIC, "gb2312:16I:t"     },
  {16, CS_GB2312,     FAM_TIMES, FACE_BOLD,   "gb2312:16B:t"     },
  {16, CS_GB2312,     FAM_HELV,  FACE_NORMAL, "gb2312:16:h"      },
  {16, CS_GB2312,     FAM_HELV,  FACE_ITALIC, "gb2312:16I:h"     },
  {16, CS_GB2312,     FAM_HELV,  FACE_BOLD,   "gb2312:16B:h"     },
  {16, CS_GB2312,     FAM_COUR,  FACE_NORMAL, "gb2312:16:c"      },
  {16, CS_GB2312,     FAM_COUR,  FACE_ITALIC, "gb2312:16I:c"     },
  {16, CS_GB2312,     FAM_COUR,  FACE_BOLD,   "gb2312:16B:c"     },
  {16, CS_CNS11643_1, FAM_FIXED, FACE_NORMAL, "cns11643_1:16:f"  },
  {16, CS_CNS11643_1, FAM_FIXED, FACE_ITALIC, "cns11643_1:16I:f" },
  {16, CS_CNS11643_1, FAM_FIXED, FACE_BOLD,   "cns11643_1:16B:f" },
  {16, CS_CNS11643_1, FAM_TIMES, FACE_NORMAL, "cns11643_1:16:t"  },
  {16, CS_CNS11643_1, FAM_TIMES, FACE_ITALIC, "cns11643_1:16I:t" },
  {16, CS_CNS11643_1, FAM_TIMES, FACE_BOLD,   "cns11643_1:16B:t" },
  {16, CS_CNS11643_1, FAM_HELV,  FACE_NORMAL, "cns11643_1:16:h"  },
  {16, CS_CNS11643_1, FAM_HELV,  FACE_ITALIC, "cns11643_1:16I:h" },
  {16, CS_CNS11643_1, FAM_HELV,  FACE_BOLD,   "cns11643_1:16B:h" },
  {16, CS_CNS11643_1, FAM_COUR,  FACE_NORMAL, "cns11643_1:16:c"  },
  {16, CS_CNS11643_1, FAM_COUR,  FACE_ITALIC, "cns11643_1:16I:c" },
  {16, CS_CNS11643_1, FAM_COUR,  FACE_BOLD,   "cns11643_1:16B:c" },
  {16, CS_CNS11643_2, FAM_FIXED, FACE_NORMAL, "cns11643_2:16:f"  },
  {16, CS_CNS11643_2, FAM_FIXED, FACE_ITALIC, "cns11643_2:16I:f" },
  {16, CS_CNS11643_2, FAM_FIXED, FACE_BOLD,   "cns11643_2:16B:f" },
  {16, CS_CNS11643_2, FAM_TIMES, FACE_NORMAL, "cns11643_2:16:t"  },
  {16, CS_CNS11643_2, FAM_TIMES, FACE_ITALIC, "cns11643_2:16I:t" },
  {16, CS_CNS11643_2, FAM_TIMES, FACE_BOLD,   "cns11643_2:16B:t" },
  {16, CS_CNS11643_2, FAM_HELV,  FACE_NORMAL, "cns11643_2:16:h"  },
  {16, CS_CNS11643_2, FAM_HELV,  FACE_ITALIC, "cns11643_2:16I:h" },
  {16, CS_CNS11643_2, FAM_HELV,  FACE_BOLD,   "cns11643_2:16B:h" },
  {16, CS_CNS11643_2, FAM_COUR,  FACE_NORMAL, "cns11643_2:16:c"  },
  {16, CS_CNS11643_2, FAM_COUR,  FACE_ITALIC, "cns11643_2:16I:c" },
  {16, CS_CNS11643_2, FAM_COUR,  FACE_BOLD,   "cns11643_2:16B:c" },
  {16, CS_CNS11643_3, FAM_FIXED, FACE_NORMAL, "cns11643_3:16:f"  },
  {16, CS_CNS11643_4, FAM_FIXED, FACE_NORMAL, "cns11643_4:16:f"  },
  {16, CS_CNS11643_5, FAM_FIXED, FACE_NORMAL, "cns11643_5:16:f"  },
  {16, CS_CNS11643_6, FAM_FIXED, FACE_NORMAL, "cns11643_6:16:f"  },
  {16, CS_CNS11643_7, FAM_FIXED, FACE_NORMAL, "cns11643_7:16:f"  },
  /* mule big 5 */
  {16, CS_MULE_BIG5_L1,  FAM_FIXED, FACE_NORMAL, "big5:16:f"  },
  {16, CS_MULE_BIG5_L2,  FAM_FIXED, FACE_NORMAL, "big5:16:f"  },
  /* mule arabic */
  {16, CS_MULE_ARAB0,    FAM_FIXED, FACE_NORMAL, "mule_arab0:16:f"     },
  {16, CS_MULE_ARAB1,    FAM_FIXED, FACE_NORMAL, "mule_arab1:16:f"     },
  {16, CS_MULE_ARAB2,    FAM_FIXED, FACE_NORMAL, "mule_arab2:16:f"     },
  /* mule ethiopic */
  {16, CS_MULE_ETHIOPIC, FAM_FIXED, FACE_NORMAL, "mule_ethio:16:f"     },
  /* mule viscii */
  {16, CS_MULE_VISCII_L, FAM_FIXED, FACE_NORMAL, "mule_viscii_l:16:f"  },
  {16, CS_MULE_VISCII_U, FAM_FIXED, FACE_NORMAL, "mule_viscii_u:16:f"  },

  /*** 18 ***/
  /* ascii */
  {18, CS_ASCII,      FAM_FIXED, FACE_NORMAL, "iso8859_1:18:f"   },
  {18, CS_ASCII,      FAM_FIXED, FACE_ITALIC, "iso8859_1:18I:f"  },
  {18, CS_ASCII,      FAM_FIXED, FACE_BOLD,   "iso8859_1:18B:f"  },
  {18, CS_ASCII,      FAM_TIMES, FACE_NORMAL, "iso8859_1:18:t"   },
  {18, CS_ASCII,      FAM_TIMES, FACE_ITALIC, "iso8859_1:18I:t"  },
  {18, CS_ASCII,      FAM_TIMES, FACE_BOLD,   "iso8859_1:18B:t"  },
  {18, CS_ASCII,      FAM_HELV,  FACE_NORMAL, "iso8859_1:18:h"   },
  {18, CS_ASCII,      FAM_HELV,  FACE_ITALIC, "iso8859_1:18I:h"  },
  {18, CS_ASCII,      FAM_HELV,  FACE_BOLD,   "iso8859_1:18B:h"  },
  {18, CS_ASCII,      FAM_COUR,  FACE_NORMAL, "iso8859_1:18:c"   },
  {18, CS_ASCII,      FAM_COUR,  FACE_ITALIC, "iso8859_1:18I:c"  },
  {18, CS_ASCII,      FAM_COUR,  FACE_BOLD,   "iso8859_1:18B:c"  },
  /* iso8859-1 */
  {18, CS_ISO8859_1,  FAM_FIXED, FACE_NORMAL, "iso8859_1:18:f"   },
  {18, CS_ISO8859_1,  FAM_FIXED, FACE_ITALIC, "iso8859_1:18I:f"  },
  {18, CS_ISO8859_1,  FAM_FIXED, FACE_BOLD,   "iso8859_1:18B:f"  },
  {18, CS_ISO8859_1,  FAM_TIMES, FACE_NORMAL, "iso8859_1:18:t"   },
  {18, CS_ISO8859_1,  FAM_TIMES, FACE_ITALIC, "iso8859_1:18I:t"  },
  {18, CS_ISO8859_1,  FAM_TIMES, FACE_BOLD,   "iso8859_1:18B:t"  },
  {18, CS_ISO8859_1,  FAM_HELV,  FACE_NORMAL, "iso8859_1:18:h"   },
  {18, CS_ISO8859_1,  FAM_HELV,  FACE_ITALIC, "iso8859_1:18I:h"  },
  {18, CS_ISO8859_1,  FAM_HELV,  FACE_BOLD,   "iso8859_1:18B:h"  },
  {18, CS_ISO8859_1,  FAM_COUR,  FACE_NORMAL, "iso8859_1:18:c"   },
  {18, CS_ISO8859_1,  FAM_COUR,  FACE_ITALIC, "iso8859_1:18I:c"  },
  {18, CS_ISO8859_1,  FAM_COUR,  FACE_BOLD,   "iso8859_1:18B:c"  },
  /* iso8859-2 */
  {18, CS_ISO8859_2,  FAM_FIXED, FACE_NORMAL, "iso8859_2:18:f"   },
  {18, CS_ISO8859_2,  FAM_FIXED, FACE_ITALIC, "iso8859_2:18I:f"  },
  {18, CS_ISO8859_2,  FAM_FIXED, FACE_BOLD,   "iso8859_2:18B:f"  },
  {18, CS_ISO8859_2,  FAM_TIMES, FACE_NORMAL, "iso8859_2:18:t"   },
  {18, CS_ISO8859_2,  FAM_TIMES, FACE_ITALIC, "iso8859_2:18I:t"  },
  {18, CS_ISO8859_2,  FAM_TIMES, FACE_BOLD,   "iso8859_2:18B:t"  },
  {18, CS_ISO8859_2,  FAM_HELV,  FACE_NORMAL, "iso8859_2:18:h"   },
  {18, CS_ISO8859_2,  FAM_HELV,  FACE_ITALIC, "iso8859_2:18I:h"  },
  {18, CS_ISO8859_2,  FAM_HELV,  FACE_BOLD,   "iso8859_2:18B:h"  },
  {18, CS_ISO8859_2,  FAM_COUR,  FACE_NORMAL, "iso8859_2:18:c"   },
  {18, CS_ISO8859_2,  FAM_COUR,  FACE_ITALIC, "iso8859_2:18I:c"  },
  {18, CS_ISO8859_2,  FAM_COUR,  FACE_BOLD,   "iso8859_2:18B:c"  },
  /* iso8859-3 */
  {18, CS_ISO8859_3,  FAM_FIXED, FACE_NORMAL, "iso8859_3:18:f"   },
  {18, CS_ISO8859_3,  FAM_FIXED, FACE_ITALIC, "iso8859_3:18I:f"  },
  {18, CS_ISO8859_3,  FAM_FIXED, FACE_BOLD,   "iso8859_3:18B:f"  },
  {18, CS_ISO8859_3,  FAM_TIMES, FACE_NORMAL, "iso8859_3:18:t"   },
  {18, CS_ISO8859_3,  FAM_TIMES, FACE_ITALIC, "iso8859_3:18I:t"  },
  {18, CS_ISO8859_3,  FAM_TIMES, FACE_BOLD,   "iso8859_3:18B:t"  },
  {18, CS_ISO8859_3,  FAM_HELV,  FACE_NORMAL, "iso8859_3:18:h"   },
  {18, CS_ISO8859_3,  FAM_HELV,  FACE_ITALIC, "iso8859_3:18I:h"  },
  {18, CS_ISO8859_3,  FAM_HELV,  FACE_BOLD,   "iso8859_3:18B:h"  },
  {18, CS_ISO8859_3,  FAM_COUR,  FACE_NORMAL, "iso8859_3:18:c"   },
  {18, CS_ISO8859_3,  FAM_COUR,  FACE_ITALIC, "iso8859_3:18I:c"  },
  {18, CS_ISO8859_3,  FAM_COUR,  FACE_BOLD,   "iso8859_3:18B:c"  },
  /* iso8859-4 */
  {18, CS_ISO8859_4,  FAM_FIXED, FACE_NORMAL, "iso8859_4:18:f"   },
  {18, CS_ISO8859_4,  FAM_FIXED, FACE_ITALIC, "iso8859_4:18I:f"  },
  {18, CS_ISO8859_4,  FAM_FIXED, FACE_BOLD,   "iso8859_4:18B:f"  },
  {18, CS_ISO8859_4,  FAM_TIMES, FACE_NORMAL, "iso8859_4:18:t"   },
  {18, CS_ISO8859_4,  FAM_TIMES, FACE_ITALIC, "iso8859_4:18I:t"  },
  {18, CS_ISO8859_4,  FAM_TIMES, FACE_BOLD,   "iso8859_4:18B:t"  },
  {18, CS_ISO8859_4,  FAM_HELV,  FACE_NORMAL, "iso8859_4:18:h"   },
  {18, CS_ISO8859_4,  FAM_HELV,  FACE_ITALIC, "iso8859_4:18I:h"  },
  {18, CS_ISO8859_4,  FAM_HELV,  FACE_BOLD,   "iso8859_4:18B:h"  },
  {18, CS_ISO8859_4,  FAM_COUR,  FACE_NORMAL, "iso8859_4:18:c"   },
  {18, CS_ISO8859_4,  FAM_COUR,  FACE_ITALIC, "iso8859_4:18I:c"  },
  {18, CS_ISO8859_4,  FAM_COUR,  FACE_BOLD,   "iso8859_4:18B:c"  },
  /* iso8859-5 */
  {18, CS_ISO8859_5,  FAM_FIXED, FACE_NORMAL, "iso8859_5:18:f"   },
  {18, CS_ISO8859_5,  FAM_FIXED, FACE_ITALIC, "iso8859_5:18I:f"  },
  {18, CS_ISO8859_5,  FAM_FIXED, FACE_BOLD,   "iso8859_5:18B:f"  },
  {18, CS_ISO8859_5,  FAM_TIMES, FACE_NORMAL, "iso8859_5:18:t"   },
  {18, CS_ISO8859_5,  FAM_TIMES, FACE_ITALIC, "iso8859_5:18I:t"  },
  {18, CS_ISO8859_5,  FAM_TIMES, FACE_BOLD,   "iso8859_5:18B:t"  },
  {18, CS_ISO8859_5,  FAM_HELV,  FACE_NORMAL, "iso8859_5:18:h"   },
  {18, CS_ISO8859_5,  FAM_HELV,  FACE_ITALIC, "iso8859_5:18I:h"  },
  {18, CS_ISO8859_5,  FAM_HELV,  FACE_BOLD,   "iso8859_5:18B:h"  },
  {18, CS_ISO8859_5,  FAM_COUR,  FACE_NORMAL, "iso8859_5:18:c"   },
  {18, CS_ISO8859_5,  FAM_COUR,  FACE_ITALIC, "iso8859_5:18I:c"  },
  {18, CS_ISO8859_5,  FAM_COUR,  FACE_BOLD,   "iso8859_5:18B:c"  },
  /* iso8859-7 */
  {18, CS_ISO8859_7,  FAM_FIXED, FACE_NORMAL, "iso8859_7:18:f"   },
  {18, CS_ISO8859_7,  FAM_FIXED, FACE_ITALIC, "iso8859_7:18I:f"  },
  {18, CS_ISO8859_7,  FAM_FIXED, FACE_BOLD,   "iso8859_7:18B:f"  },
  {18, CS_ISO8859_7,  FAM_TIMES, FACE_NORMAL, "iso8859_7:18:t"   },
  {18, CS_ISO8859_7,  FAM_TIMES, FACE_ITALIC, "iso8859_7:18I:t"  },
  {18, CS_ISO8859_7,  FAM_TIMES, FACE_BOLD,   "iso8859_7:18B:t"  },
  {18, CS_ISO8859_7,  FAM_HELV,  FACE_NORMAL, "iso8859_7:18:h"   },
  {18, CS_ISO8859_7,  FAM_HELV,  FACE_ITALIC, "iso8859_7:18I:h"  },
  {18, CS_ISO8859_7,  FAM_HELV,  FACE_BOLD,   "iso8859_7:18B:h"  },
  {18, CS_ISO8859_7,  FAM_COUR,  FACE_NORMAL, "iso8859_7:18:c"   },
  {18, CS_ISO8859_7,  FAM_COUR,  FACE_ITALIC, "iso8859_7:18I:c"  },
  {18, CS_ISO8859_7,  FAM_COUR,  FACE_BOLD,   "iso8859_7:18B:c"  },
  /* iso8859-8 */
  {18, CS_ISO8859_8,  FAM_FIXED, FACE_NORMAL, "iso8859_8:18:f"   },
  {18, CS_ISO8859_8,  FAM_FIXED, FACE_ITALIC, "iso8859_8:18I:f"  },
  {18, CS_ISO8859_8,  FAM_FIXED, FACE_BOLD,   "iso8859_8:18B:f"  },
  {18, CS_ISO8859_8,  FAM_TIMES, FACE_NORMAL, "iso8859_8:18:t"   },
  {18, CS_ISO8859_8,  FAM_TIMES, FACE_ITALIC, "iso8859_8:18I:t"  },
  {18, CS_ISO8859_8,  FAM_TIMES, FACE_BOLD,   "iso8859_8:18B:t"  },
  {18, CS_ISO8859_8,  FAM_HELV,  FACE_NORMAL, "iso8859_8:18:h"   },
  {18, CS_ISO8859_8,  FAM_HELV,  FACE_ITALIC, "iso8859_8:18I:h"  },
  {18, CS_ISO8859_8,  FAM_HELV,  FACE_BOLD,   "iso8859_8:18B:h"  },
  {18, CS_ISO8859_8,  FAM_COUR,  FACE_NORMAL, "iso8859_8:18:c"   },
  {18, CS_ISO8859_8,  FAM_COUR,  FACE_ITALIC, "iso8859_8:18I:c"  },
  {18, CS_ISO8859_8,  FAM_COUR,  FACE_BOLD,   "iso8859_8:18B:c"  },
  /* iso8859-9 */
  {18, CS_ISO8859_9,  FAM_FIXED, FACE_NORMAL, "iso8859_9:18:f"   },
  {18, CS_ISO8859_9,  FAM_FIXED, FACE_ITALIC, "iso8859_9:18I:f"  },
  {18, CS_ISO8859_9,  FAM_FIXED, FACE_BOLD,   "iso8859_9:18B:f"  },
  {18, CS_ISO8859_9,  FAM_TIMES, FACE_NORMAL, "iso8859_9:18:t"   },
  {18, CS_ISO8859_9,  FAM_TIMES, FACE_ITALIC, "iso8859_9:18I:t"  },
  {18, CS_ISO8859_9,  FAM_TIMES, FACE_BOLD,   "iso8859_9:18B:t"  },
  {18, CS_ISO8859_9,  FAM_HELV,  FACE_NORMAL, "iso8859_9:18:h"   },
  {18, CS_ISO8859_9,  FAM_HELV,  FACE_ITALIC, "iso8859_9:18I:h"  },
  {18, CS_ISO8859_9,  FAM_HELV,  FACE_BOLD,   "iso8859_9:18B:h"  },
  {18, CS_ISO8859_9,  FAM_COUR,  FACE_NORMAL, "iso8859_9:18:c"   },
  {18, CS_ISO8859_9,  FAM_COUR,  FACE_ITALIC, "iso8859_9:18I:c"  },
  {18, CS_ISO8859_9,  FAM_COUR,  FACE_BOLD,   "iso8859_9:18B:c"  },
  /* japanese */
  {18, CS_JISX0201K,  FAM_FIXED, FACE_NORMAL, "jisx0201k:18:f"   },
  {18, CS_JISX0201R,  FAM_FIXED, FACE_NORMAL, "jisx0201r:18:f"   },
  {18, CS_JISX0208,   FAM_FIXED, FACE_NORMAL, "jisx0208:18:f"    },
  {18, CS_JISX0208,   FAM_FIXED, FACE_ITALIC, "jisx0208:18I:f"   },
  {18, CS_JISX0208,   FAM_FIXED, FACE_BOLD,   "jisx0208:18B:f"   },
  {18, CS_JISX0208,   FAM_TIMES, FACE_NORMAL, "jisx0208:18:t"    },
  {18, CS_JISX0208,   FAM_TIMES, FACE_ITALIC, "jisx0208:18I:t"   },
  {18, CS_JISX0208,   FAM_TIMES, FACE_BOLD,   "jisx0208:18B:t"   },
  {18, CS_JISX0208,   FAM_HELV,  FACE_NORMAL, "jisx0208:18:h"    },
  {18, CS_JISX0208,   FAM_HELV,  FACE_ITALIC, "jisx0208:18I:h"   },
  {18, CS_JISX0208,   FAM_HELV,  FACE_BOLD,   "jisx0208:18B:h"   },
  {18, CS_JISX0208,   FAM_COUR,  FACE_NORMAL, "jisx0208:18:c"    },
  {18, CS_JISX0208,   FAM_COUR,  FACE_ITALIC, "jisx0208:18I:c"   },
  {18, CS_JISX0208,   FAM_COUR,  FACE_BOLD,   "jisx0208:18B:c"   },
  {18, CS_JISX0212,   FAM_FIXED, FACE_NORMAL, "jisx0212:18:f"    },
  /* hangle */
  {18, CS_KSC5601,    FAM_FIXED, FACE_NORMAL, "ksc5601:18:f"     },
  {18, CS_KSC5601,    FAM_FIXED, FACE_ITALIC, "ksc5601:18I:f"    },
  {18, CS_KSC5601,    FAM_FIXED, FACE_BOLD,   "ksc5601:18B:f"    },
  {18, CS_KSC5601,    FAM_TIMES, FACE_NORMAL, "ksc5601:18:t"     },
  {18, CS_KSC5601,    FAM_TIMES, FACE_ITALIC, "ksc5601:18I:t"    },
  {18, CS_KSC5601,    FAM_TIMES, FACE_BOLD,   "ksc5601:18B:t"    },
  {18, CS_KSC5601,    FAM_HELV,  FACE_NORMAL, "ksc5601:18:h"     },
  {18, CS_KSC5601,    FAM_HELV,  FACE_ITALIC, "ksc5601:18I:h"    },
  {18, CS_KSC5601,    FAM_HELV,  FACE_BOLD,   "ksc5601:18B:h"    },
  {18, CS_KSC5601,    FAM_COUR,  FACE_NORMAL, "ksc5601:18:c"     },
  {18, CS_KSC5601,    FAM_COUR,  FACE_ITALIC, "ksc5601:18I:c"    },
  {18, CS_KSC5601,    FAM_COUR,  FACE_BOLD,   "ksc5601:18B:c"    },
  /* chinese */
  {18, CS_GB2312,     FAM_FIXED, FACE_NORMAL, "gb2312:18:f"      },
  {18, CS_GB2312,     FAM_FIXED, FACE_ITALIC, "gb2312:18I:f"     },
  {18, CS_GB2312,     FAM_FIXED, FACE_BOLD,   "gb2312:18B:f"     },
  {18, CS_GB2312,     FAM_TIMES, FACE_NORMAL, "gb2312:18:t"      },
  {18, CS_GB2312,     FAM_TIMES, FACE_ITALIC, "gb2312:18I:t"     },
  {18, CS_GB2312,     FAM_TIMES, FACE_BOLD,   "gb2312:18B:t"     },
  {18, CS_GB2312,     FAM_HELV,  FACE_NORMAL, "gb2312:18:h"      },
  {18, CS_GB2312,     FAM_HELV,  FACE_ITALIC, "gb2312:18I:h"     },
  {18, CS_GB2312,     FAM_HELV,  FACE_BOLD,   "gb2312:18B:h"     },
  {18, CS_GB2312,     FAM_COUR,  FACE_NORMAL, "gb2312:18:c"      },
  {18, CS_GB2312,     FAM_COUR,  FACE_ITALIC, "gb2312:18I:c"     },
  {18, CS_GB2312,     FAM_COUR,  FACE_BOLD,   "gb2312:18B:c"     },
  {18, CS_CNS11643_1, FAM_FIXED, FACE_NORMAL, "cns11643_1:18:f"  },
  {18, CS_CNS11643_1, FAM_FIXED, FACE_ITALIC, "cns11643_1:18I:f" },
  {18, CS_CNS11643_1, FAM_FIXED, FACE_BOLD,   "cns11643_1:18B:f" },
  {18, CS_CNS11643_1, FAM_TIMES, FACE_NORMAL, "cns11643_1:18:t"  },
  {18, CS_CNS11643_1, FAM_TIMES, FACE_ITALIC, "cns11643_1:18I:t" },
  {18, CS_CNS11643_1, FAM_TIMES, FACE_BOLD,   "cns11643_1:18B:t" },
  {18, CS_CNS11643_1, FAM_HELV,  FACE_NORMAL, "cns11643_1:18:h"  },
  {18, CS_CNS11643_1, FAM_HELV,  FACE_ITALIC, "cns11643_1:18I:h" },
  {18, CS_CNS11643_1, FAM_HELV,  FACE_BOLD,   "cns11643_1:18B:h" },
  {18, CS_CNS11643_1, FAM_COUR,  FACE_NORMAL, "cns11643_1:18:c"  },
  {18, CS_CNS11643_1, FAM_COUR,  FACE_ITALIC, "cns11643_1:18I:c" },
  {18, CS_CNS11643_1, FAM_COUR,  FACE_BOLD,   "cns11643_1:18B:c" },
  {18, CS_CNS11643_2, FAM_FIXED, FACE_NORMAL, "cns11643_2:18:f"  },
  {18, CS_CNS11643_2, FAM_FIXED, FACE_ITALIC, "cns11643_2:18I:f" },
  {18, CS_CNS11643_2, FAM_FIXED, FACE_BOLD,   "cns11643_2:18B:f" },
  {18, CS_CNS11643_2, FAM_TIMES, FACE_NORMAL, "cns11643_2:18:t"  },
  {18, CS_CNS11643_2, FAM_TIMES, FACE_ITALIC, "cns11643_2:18I:t" },
  {18, CS_CNS11643_2, FAM_TIMES, FACE_BOLD,   "cns11643_2:18B:t" },
  {18, CS_CNS11643_2, FAM_HELV,  FACE_NORMAL, "cns11643_2:18:h"  },
  {18, CS_CNS11643_2, FAM_HELV,  FACE_ITALIC, "cns11643_2:18I:h" },
  {18, CS_CNS11643_2, FAM_HELV,  FACE_BOLD,   "cns11643_2:18B:h" },
  {18, CS_CNS11643_2, FAM_COUR,  FACE_NORMAL, "cns11643_2:18:c"  },
  {18, CS_CNS11643_2, FAM_COUR,  FACE_ITALIC, "cns11643_2:18I:c" },
  {18, CS_CNS11643_2, FAM_COUR,  FACE_BOLD,   "cns11643_2:18B:c" },
  {18, CS_CNS11643_3, FAM_FIXED, FACE_NORMAL, "cns11643_3:18:f"  },
  {18, CS_CNS11643_4, FAM_FIXED, FACE_NORMAL, "cns11643_4:18:f"  },
  {18, CS_CNS11643_5, FAM_FIXED, FACE_NORMAL, "cns11643_5:18:f"  },
  {18, CS_CNS11643_6, FAM_FIXED, FACE_NORMAL, "cns11643_6:18:f"  },
  {18, CS_CNS11643_7, FAM_FIXED, FACE_NORMAL, "cns11643_7:18:f"  },
  /* mule big 5 */
  {18, CS_MULE_BIG5_L1,  FAM_FIXED, FACE_NORMAL, "big5:18:f"  },
  {18, CS_MULE_BIG5_L2,  FAM_FIXED, FACE_NORMAL, "big5:18:f"  },
  /* mule arabic */
  {18, CS_MULE_ARAB0,    FAM_FIXED, FACE_NORMAL, "mule_arab0:18:f"     },
  {18, CS_MULE_ARAB1,    FAM_FIXED, FACE_NORMAL, "mule_arab1:18:f"     },
  {18, CS_MULE_ARAB2,    FAM_FIXED, FACE_NORMAL, "mule_arab2:18:f"     },
  /* mule ethiopic */
  {18, CS_MULE_ETHIOPIC, FAM_FIXED, FACE_NORMAL, "mule_ethio:18:f"     },
  /* mule viscii */
  {18, CS_MULE_VISCII_L, FAM_FIXED, FACE_NORMAL, "mule_viscii_l:18:f"  },
  {18, CS_MULE_VISCII_U, FAM_FIXED, FACE_NORMAL, "mule_viscii_u:18:f"  },

  /*** 24 ***/
  /* ascii */
  {24, CS_ASCII,      FAM_FIXED, FACE_NORMAL, "iso8859_1:24:f"   },
  {24, CS_ASCII,      FAM_FIXED, FACE_ITALIC, "iso8859_1:24I:f"  },
  {24, CS_ASCII,      FAM_FIXED, FACE_BOLD,   "iso8859_1:24B:f"  },
  {24, CS_ASCII,      FAM_TIMES, FACE_NORMAL, "iso8859_1:24:t"   },
  {24, CS_ASCII,      FAM_TIMES, FACE_ITALIC, "iso8859_1:24I:t"  },
  {24, CS_ASCII,      FAM_TIMES, FACE_BOLD,   "iso8859_1:24B:t"  },
  {24, CS_ASCII,      FAM_HELV,  FACE_NORMAL, "iso8859_1:24:h"   },
  {24, CS_ASCII,      FAM_HELV,  FACE_ITALIC, "iso8859_1:24I:h"  },
  {24, CS_ASCII,      FAM_HELV,  FACE_BOLD,   "iso8859_1:24B:h"  },
  {24, CS_ASCII,      FAM_COUR,  FACE_NORMAL, "iso8859_1:24:c"   },
  {24, CS_ASCII,      FAM_COUR,  FACE_ITALIC, "iso8859_1:24I:c"  },
  {24, CS_ASCII,      FAM_COUR,  FACE_BOLD,   "iso8859_1:24B:c"  },
  /* iso8859-1 */
  {24, CS_ISO8859_1,  FAM_FIXED, FACE_NORMAL, "iso8859_1:24:f"   },
  {24, CS_ISO8859_1,  FAM_FIXED, FACE_ITALIC, "iso8859_1:24I:f"  },
  {24, CS_ISO8859_1,  FAM_FIXED, FACE_BOLD,   "iso8859_1:24B:f"  },
  {24, CS_ISO8859_1,  FAM_TIMES, FACE_NORMAL, "iso8859_1:24:t"   },
  {24, CS_ISO8859_1,  FAM_TIMES, FACE_ITALIC, "iso8859_1:24I:t"  },
  {24, CS_ISO8859_1,  FAM_TIMES, FACE_BOLD,   "iso8859_1:24B:t"  },
  {24, CS_ISO8859_1,  FAM_HELV,  FACE_NORMAL, "iso8859_1:24:h"   },
  {24, CS_ISO8859_1,  FAM_HELV,  FACE_ITALIC, "iso8859_1:24I:h"  },
  {24, CS_ISO8859_1,  FAM_HELV,  FACE_BOLD,   "iso8859_1:24B:h"  },
  {24, CS_ISO8859_1,  FAM_COUR,  FACE_NORMAL, "iso8859_1:24:c"   },
  {24, CS_ISO8859_1,  FAM_COUR,  FACE_ITALIC, "iso8859_1:24I:c"  },
  {24, CS_ISO8859_1,  FAM_COUR,  FACE_BOLD,   "iso8859_1:24B:c"  },
  /* iso8859-2 */
  {24, CS_ISO8859_2,  FAM_FIXED, FACE_NORMAL, "iso8859_2:24:f"   },
  {24, CS_ISO8859_2,  FAM_FIXED, FACE_ITALIC, "iso8859_2:24I:f"  },
  {24, CS_ISO8859_2,  FAM_FIXED, FACE_BOLD,   "iso8859_2:24B:f"  },
  {24, CS_ISO8859_2,  FAM_TIMES, FACE_NORMAL, "iso8859_2:24:t"   },
  {24, CS_ISO8859_2,  FAM_TIMES, FACE_ITALIC, "iso8859_2:24I:t"  },
  {24, CS_ISO8859_2,  FAM_TIMES, FACE_BOLD,   "iso8859_2:24B:t"  },
  {24, CS_ISO8859_2,  FAM_HELV,  FACE_NORMAL, "iso8859_2:24:h"   },
  {24, CS_ISO8859_2,  FAM_HELV,  FACE_ITALIC, "iso8859_2:24I:h"  },
  {24, CS_ISO8859_2,  FAM_HELV,  FACE_BOLD,   "iso8859_2:24B:h"  },
  {24, CS_ISO8859_2,  FAM_COUR,  FACE_NORMAL, "iso8859_2:24:c"   },
  {24, CS_ISO8859_2,  FAM_COUR,  FACE_ITALIC, "iso8859_2:24I:c"  },
  {24, CS_ISO8859_2,  FAM_COUR,  FACE_BOLD,   "iso8859_2:24B:c"  },
  /* iso8859-3 */
  {24, CS_ISO8859_3,  FAM_FIXED, FACE_NORMAL, "iso8859_3:24:f"   },
  {24, CS_ISO8859_3,  FAM_FIXED, FACE_ITALIC, "iso8859_3:24I:f"  },
  {24, CS_ISO8859_3,  FAM_FIXED, FACE_BOLD,   "iso8859_3:24B:f"  },
  {24, CS_ISO8859_3,  FAM_TIMES, FACE_NORMAL, "iso8859_3:24:t"   },
  {24, CS_ISO8859_3,  FAM_TIMES, FACE_ITALIC, "iso8859_3:24I:t"  },
  {24, CS_ISO8859_3,  FAM_TIMES, FACE_BOLD,   "iso8859_3:24B:t"  },
  {24, CS_ISO8859_3,  FAM_HELV,  FACE_NORMAL, "iso8859_3:24:h"   },
  {24, CS_ISO8859_3,  FAM_HELV,  FACE_ITALIC, "iso8859_3:24I:h"  },
  {24, CS_ISO8859_3,  FAM_HELV,  FACE_BOLD,   "iso8859_3:24B:h"  },
  {24, CS_ISO8859_3,  FAM_COUR,  FACE_NORMAL, "iso8859_3:24:c"   },
  {24, CS_ISO8859_3,  FAM_COUR,  FACE_ITALIC, "iso8859_3:24I:c"  },
  {24, CS_ISO8859_3,  FAM_COUR,  FACE_BOLD,   "iso8859_3:24B:c"  },
  /* iso8859-4 */
  {24, CS_ISO8859_4,  FAM_FIXED, FACE_NORMAL, "iso8859_4:24:f"   },
  {24, CS_ISO8859_4,  FAM_FIXED, FACE_ITALIC, "iso8859_4:24I:f"  },
  {24, CS_ISO8859_4,  FAM_FIXED, FACE_BOLD,   "iso8859_4:24B:f"  },
  {24, CS_ISO8859_4,  FAM_TIMES, FACE_NORMAL, "iso8859_4:24:t"   },
  {24, CS_ISO8859_4,  FAM_TIMES, FACE_ITALIC, "iso8859_4:24I:t"  },
  {24, CS_ISO8859_4,  FAM_TIMES, FACE_BOLD,   "iso8859_4:24B:t"  },
  {24, CS_ISO8859_4,  FAM_HELV,  FACE_NORMAL, "iso8859_4:24:h"   },
  {24, CS_ISO8859_4,  FAM_HELV,  FACE_ITALIC, "iso8859_4:24I:h"  },
  {24, CS_ISO8859_4,  FAM_HELV,  FACE_BOLD,   "iso8859_4:24B:h"  },
  {24, CS_ISO8859_4,  FAM_COUR,  FACE_NORMAL, "iso8859_4:24:c"   },
  {24, CS_ISO8859_4,  FAM_COUR,  FACE_ITALIC, "iso8859_4:24I:c"  },
  {24, CS_ISO8859_4,  FAM_COUR,  FACE_BOLD,   "iso8859_4:24B:c"  },
  /* iso8859-5 */
  {24, CS_ISO8859_5,  FAM_FIXED, FACE_NORMAL, "iso8859_5:24:f"   },
  {24, CS_ISO8859_5,  FAM_FIXED, FACE_ITALIC, "iso8859_5:24I:f"  },
  {24, CS_ISO8859_5,  FAM_FIXED, FACE_BOLD,   "iso8859_5:24B:f"  },
  {24, CS_ISO8859_5,  FAM_TIMES, FACE_NORMAL, "iso8859_5:24:t"   },
  {24, CS_ISO8859_5,  FAM_TIMES, FACE_ITALIC, "iso8859_5:24I:t"  },
  {24, CS_ISO8859_5,  FAM_TIMES, FACE_BOLD,   "iso8859_5:24B:t"  },
  {24, CS_ISO8859_5,  FAM_HELV,  FACE_NORMAL, "iso8859_5:24:h"   },
  {24, CS_ISO8859_5,  FAM_HELV,  FACE_ITALIC, "iso8859_5:24I:h"  },
  {24, CS_ISO8859_5,  FAM_HELV,  FACE_BOLD,   "iso8859_5:24B:h"  },
  {24, CS_ISO8859_5,  FAM_COUR,  FACE_NORMAL, "iso8859_5:24:c"   },
  {24, CS_ISO8859_5,  FAM_COUR,  FACE_ITALIC, "iso8859_5:24I:c"  },
  {24, CS_ISO8859_5,  FAM_COUR,  FACE_BOLD,   "iso8859_5:24B:c"  },
  /* iso8859-7 */
  {24, CS_ISO8859_7,  FAM_FIXED, FACE_NORMAL, "iso8859_7:24:f"   },
  {24, CS_ISO8859_7,  FAM_FIXED, FACE_ITALIC, "iso8859_7:24I:f"  },
  {24, CS_ISO8859_7,  FAM_FIXED, FACE_BOLD,   "iso8859_7:24B:f"  },
  {24, CS_ISO8859_7,  FAM_TIMES, FACE_NORMAL, "iso8859_7:24:t"   },
  {24, CS_ISO8859_7,  FAM_TIMES, FACE_ITALIC, "iso8859_7:24I:t"  },
  {24, CS_ISO8859_7,  FAM_TIMES, FACE_BOLD,   "iso8859_7:24B:t"  },
  {24, CS_ISO8859_7,  FAM_HELV,  FACE_NORMAL, "iso8859_7:24:h"   },
  {24, CS_ISO8859_7,  FAM_HELV,  FACE_ITALIC, "iso8859_7:24I:h"  },
  {24, CS_ISO8859_7,  FAM_HELV,  FACE_BOLD,   "iso8859_7:24B:h"  },
  {24, CS_ISO8859_7,  FAM_COUR,  FACE_NORMAL, "iso8859_7:24:c"   },
  {24, CS_ISO8859_7,  FAM_COUR,  FACE_ITALIC, "iso8859_7:24I:c"  },
  {24, CS_ISO8859_7,  FAM_COUR,  FACE_BOLD,   "iso8859_7:24B:c"  },
  /* iso8859-8 */
  {24, CS_ISO8859_8,  FAM_FIXED, FACE_NORMAL, "iso8859_8:24:f"   },
  {24, CS_ISO8859_8,  FAM_FIXED, FACE_ITALIC, "iso8859_8:24I:f"  },
  {24, CS_ISO8859_8,  FAM_FIXED, FACE_BOLD,   "iso8859_8:24B:f"  },
  {24, CS_ISO8859_8,  FAM_TIMES, FACE_NORMAL, "iso8859_8:24:t"   },
  {24, CS_ISO8859_8,  FAM_TIMES, FACE_ITALIC, "iso8859_8:24I:t"  },
  {24, CS_ISO8859_8,  FAM_TIMES, FACE_BOLD,   "iso8859_8:24B:t"  },
  {24, CS_ISO8859_8,  FAM_HELV,  FACE_NORMAL, "iso8859_8:24:h"   },
  {24, CS_ISO8859_8,  FAM_HELV,  FACE_ITALIC, "iso8859_8:24I:h"  },
  {24, CS_ISO8859_8,  FAM_HELV,  FACE_BOLD,   "iso8859_8:24B:h"  },
  {24, CS_ISO8859_8,  FAM_COUR,  FACE_NORMAL, "iso8859_8:24:c"   },
  {24, CS_ISO8859_8,  FAM_COUR,  FACE_ITALIC, "iso8859_8:24I:c"  },
  {24, CS_ISO8859_8,  FAM_COUR,  FACE_BOLD,   "iso8859_8:24B:c"  },
  /* iso8859-9 */
  {24, CS_ISO8859_9,  FAM_FIXED, FACE_NORMAL, "iso8859_9:24:f"   },
  {24, CS_ISO8859_9,  FAM_FIXED, FACE_ITALIC, "iso8859_9:24I:f"  },
  {24, CS_ISO8859_9,  FAM_FIXED, FACE_BOLD,   "iso8859_9:24B:f"  },
  {24, CS_ISO8859_9,  FAM_TIMES, FACE_NORMAL, "iso8859_9:24:t"   },
  {24, CS_ISO8859_9,  FAM_TIMES, FACE_ITALIC, "iso8859_9:24I:t"  },
  {24, CS_ISO8859_9,  FAM_TIMES, FACE_BOLD,   "iso8859_9:24B:t"  },
  {24, CS_ISO8859_9,  FAM_HELV,  FACE_NORMAL, "iso8859_9:24:h"   },
  {24, CS_ISO8859_9,  FAM_HELV,  FACE_ITALIC, "iso8859_9:24I:h"  },
  {24, CS_ISO8859_9,  FAM_HELV,  FACE_BOLD,   "iso8859_9:24B:h"  },
  {24, CS_ISO8859_9,  FAM_COUR,  FACE_NORMAL, "iso8859_9:24:c"   },
  {24, CS_ISO8859_9,  FAM_COUR,  FACE_ITALIC, "iso8859_9:24I:c"  },
  {24, CS_ISO8859_9,  FAM_COUR,  FACE_BOLD,   "iso8859_9:24B:c"  },
  /* japanese */
  {24, CS_JISX0201K,  FAM_FIXED, FACE_NORMAL, "jisx0201k:24:f"   },
  {24, CS_JISX0201R,  FAM_FIXED, FACE_NORMAL, "jisx0201r:24:f"   },
  {24, CS_JISX0208,   FAM_FIXED, FACE_NORMAL, "jisx0208:24:f"    },
  {24, CS_JISX0208,   FAM_FIXED, FACE_ITALIC, "jisx0208:24I:f"   },
  {24, CS_JISX0208,   FAM_FIXED, FACE_BOLD,   "jisx0208:24B:f"   },
  {24, CS_JISX0208,   FAM_TIMES, FACE_NORMAL, "jisx0208:24:t"    },
  {24, CS_JISX0208,   FAM_TIMES, FACE_ITALIC, "jisx0208:24I:t"   },
  {24, CS_JISX0208,   FAM_TIMES, FACE_BOLD,   "jisx0208:24B:t"   },
  {24, CS_JISX0208,   FAM_HELV,  FACE_NORMAL, "jisx0208:24:h"    },
  {24, CS_JISX0208,   FAM_HELV,  FACE_ITALIC, "jisx0208:24I:h"   },
  {24, CS_JISX0208,   FAM_HELV,  FACE_BOLD,   "jisx0208:24B:h"   },
  {24, CS_JISX0208,   FAM_COUR,  FACE_NORMAL, "jisx0208:24:c"    },
  {24, CS_JISX0208,   FAM_COUR,  FACE_ITALIC, "jisx0208:24I:c"   },
  {24, CS_JISX0208,   FAM_COUR,  FACE_BOLD,   "jisx0208:24B:c"   },
  {24, CS_JISX0212,   FAM_FIXED, FACE_NORMAL, "jisx0212:24:f"    },
  /* hangle */
  {24, CS_KSC5601,    FAM_FIXED, FACE_NORMAL, "ksc5601:24:f"     },
  {24, CS_KSC5601,    FAM_FIXED, FACE_ITALIC, "ksc5601:24I:f"    },
  {24, CS_KSC5601,    FAM_FIXED, FACE_BOLD,   "ksc5601:24B:f"    },
  {24, CS_KSC5601,    FAM_TIMES, FACE_NORMAL, "ksc5601:24:t"     },
  {24, CS_KSC5601,    FAM_TIMES, FACE_ITALIC, "ksc5601:24I:t"    },
  {24, CS_KSC5601,    FAM_TIMES, FACE_BOLD,   "ksc5601:24B:t"    },
  {24, CS_KSC5601,    FAM_HELV,  FACE_NORMAL, "ksc5601:24:h"     },
  {24, CS_KSC5601,    FAM_HELV,  FACE_ITALIC, "ksc5601:24I:h"    },
  {24, CS_KSC5601,    FAM_HELV,  FACE_BOLD,   "ksc5601:24B:h"    },
  {24, CS_KSC5601,    FAM_COUR,  FACE_NORMAL, "ksc5601:24:c"     },
  {24, CS_KSC5601,    FAM_COUR,  FACE_ITALIC, "ksc5601:24I:c"    },
  {24, CS_KSC5601,    FAM_COUR,  FACE_BOLD,   "ksc5601:24B:c"    },
  /* chinese */
  {24, CS_GB2312,     FAM_FIXED, FACE_NORMAL, "gb2312:24:f"      },
  {24, CS_GB2312,     FAM_FIXED, FACE_ITALIC, "gb2312:24I:f"     },
  {24, CS_GB2312,     FAM_FIXED, FACE_BOLD,   "gb2312:24B:f"     },
  {24, CS_GB2312,     FAM_TIMES, FACE_NORMAL, "gb2312:24:t"      },
  {24, CS_GB2312,     FAM_TIMES, FACE_ITALIC, "gb2312:24I:t"     },
  {24, CS_GB2312,     FAM_TIMES, FACE_BOLD,   "gb2312:24B:t"     },
  {24, CS_GB2312,     FAM_HELV,  FACE_NORMAL, "gb2312:24:h"      },
  {24, CS_GB2312,     FAM_HELV,  FACE_ITALIC, "gb2312:24I:h"     },
  {24, CS_GB2312,     FAM_HELV,  FACE_BOLD,   "gb2312:24B:h"     },
  {24, CS_GB2312,     FAM_COUR,  FACE_NORMAL, "gb2312:24:c"      },
  {24, CS_GB2312,     FAM_COUR,  FACE_ITALIC, "gb2312:24I:c"     },
  {24, CS_GB2312,     FAM_COUR,  FACE_BOLD,   "gb2312:24B:c"     },
  {24, CS_CNS11643_1, FAM_FIXED, FACE_NORMAL, "cns11643_1:24:f"  },
  {24, CS_CNS11643_1, FAM_FIXED, FACE_ITALIC, "cns11643_1:24I:f" },
  {24, CS_CNS11643_1, FAM_FIXED, FACE_BOLD,   "cns11643_1:24B:f" },
  {24, CS_CNS11643_1, FAM_TIMES, FACE_NORMAL, "cns11643_1:24:t"  },
  {24, CS_CNS11643_1, FAM_TIMES, FACE_ITALIC, "cns11643_1:24I:t" },
  {24, CS_CNS11643_1, FAM_TIMES, FACE_BOLD,   "cns11643_1:24B:t" },
  {24, CS_CNS11643_1, FAM_HELV,  FACE_NORMAL, "cns11643_1:24:h"  },
  {24, CS_CNS11643_1, FAM_HELV,  FACE_ITALIC, "cns11643_1:24I:h" },
  {24, CS_CNS11643_1, FAM_HELV,  FACE_BOLD,   "cns11643_1:24B:h" },
  {24, CS_CNS11643_1, FAM_COUR,  FACE_NORMAL, "cns11643_1:24:c"  },
  {24, CS_CNS11643_1, FAM_COUR,  FACE_ITALIC, "cns11643_1:24I:c" },
  {24, CS_CNS11643_1, FAM_COUR,  FACE_BOLD,   "cns11643_1:24B:c" },
  {24, CS_CNS11643_2, FAM_FIXED, FACE_NORMAL, "cns11643_2:24:f"  },
  {24, CS_CNS11643_2, FAM_FIXED, FACE_ITALIC, "cns11643_2:24I:f" },
  {24, CS_CNS11643_2, FAM_FIXED, FACE_BOLD,   "cns11643_2:24B:f" },
  {24, CS_CNS11643_2, FAM_TIMES, FACE_NORMAL, "cns11643_2:24:t"  },
  {24, CS_CNS11643_2, FAM_TIMES, FACE_ITALIC, "cns11643_2:24I:t" },
  {24, CS_CNS11643_2, FAM_TIMES, FACE_BOLD,   "cns11643_2:24B:t" },
  {24, CS_CNS11643_2, FAM_HELV,  FACE_NORMAL, "cns11643_2:24:h"  },
  {24, CS_CNS11643_2, FAM_HELV,  FACE_ITALIC, "cns11643_2:24I:h" },
  {24, CS_CNS11643_2, FAM_HELV,  FACE_BOLD,   "cns11643_2:24B:h" },
  {24, CS_CNS11643_2, FAM_COUR,  FACE_NORMAL, "cns11643_2:24:c"  },
  {24, CS_CNS11643_2, FAM_COUR,  FACE_ITALIC, "cns11643_2:24I:c" },
  {24, CS_CNS11643_2, FAM_COUR,  FACE_BOLD,   "cns11643_2:24B:c" },
  {24, CS_CNS11643_3, FAM_FIXED, FACE_NORMAL, "cns11643_3:24:f"  },
  {24, CS_CNS11643_4, FAM_FIXED, FACE_NORMAL, "cns11643_4:24:f"  },
  {24, CS_CNS11643_5, FAM_FIXED, FACE_NORMAL, "cns11643_5:24:f"  },
  {24, CS_CNS11643_6, FAM_FIXED, FACE_NORMAL, "cns11643_6:24:f"  },
  {24, CS_CNS11643_7, FAM_FIXED, FACE_NORMAL, "cns11643_7:24:f"  },
  /* mule big 5 */
  {24, CS_MULE_BIG5_L1,  FAM_FIXED, FACE_NORMAL, "big5:24:f"  },
  {24, CS_MULE_BIG5_L2,  FAM_FIXED, FACE_NORMAL, "big5:24:f"  },
  /* mule arabic */
  {24, CS_MULE_ARAB0,    FAM_FIXED, FACE_NORMAL, "mule_arab0:24:f"     },
  {24, CS_MULE_ARAB1,    FAM_FIXED, FACE_NORMAL, "mule_arab1:24:f"     },
  {24, CS_MULE_ARAB2,    FAM_FIXED, FACE_NORMAL, "mule_arab2:24:f"     },
  /* mule ethiopic */
  {24, CS_MULE_ETHIOPIC, FAM_FIXED, FACE_NORMAL, "mule_ethio:24:f"     },
  /* mule viscii */
  {24, CS_MULE_VISCII_L, FAM_FIXED, FACE_NORMAL, "mule_viscii_l:24:f"  },
  {24, CS_MULE_VISCII_U, FAM_FIXED, FACE_NORMAL, "mule_viscii_u:24:f"  },

  /*** scalable ***/
  /* ascii */
  {0,  CS_ASCII,      FAM_FIXED, FACE_NORMAL, "iso8859_1:n:f"    },
  {0,  CS_ASCII,      FAM_FIXED, FACE_ITALIC, "iso8859_1:nI:f"   },
  {0,  CS_ASCII,      FAM_FIXED, FACE_BOLD,   "iso8859_1:nB:f"   },
  {0,  CS_ASCII,      FAM_TIMES, FACE_NORMAL, "iso8859_1:n:t"    },
  {0,  CS_ASCII,      FAM_TIMES, FACE_ITALIC, "iso8859_1:nI:t"   },
  {0,  CS_ASCII,      FAM_TIMES, FACE_BOLD,   "iso8859_1:nB:t"   },
  {0,  CS_ASCII,      FAM_HELV,  FACE_NORMAL, "iso8859_1:n:h"    },
  {0,  CS_ASCII,      FAM_HELV,  FACE_ITALIC, "iso8859_1:nI:h"   },
  {0,  CS_ASCII,      FAM_HELV,  FACE_BOLD,   "iso8859_1:nB:h"   },
  {0,  CS_ASCII,      FAM_COUR,  FACE_NORMAL, "iso8859_1:n:c"    },
  {0,  CS_ASCII,      FAM_COUR,  FACE_ITALIC, "iso8859_1:nI:c"   },
  {0,  CS_ASCII,      FAM_COUR,  FACE_BOLD,   "iso8859_1:nB:c"   },
  /*  iso8859-1 */
  {0,  CS_ISO8859_1,  FAM_FIXED, FACE_NORMAL, "iso8859_1:n:f"    },
  {0,  CS_ISO8859_1,  FAM_FIXED, FACE_ITALIC, "iso8859_1:nI:f"   },
  {0,  CS_ISO8859_1,  FAM_FIXED, FACE_BOLD,   "iso8859_1:nB:f"   },
  {0,  CS_ISO8859_1,  FAM_TIMES, FACE_NORMAL, "iso8859_1:n:t"    },
  {0,  CS_ISO8859_1,  FAM_TIMES, FACE_ITALIC, "iso8859_1:nI:t"   },
  {0,  CS_ISO8859_1,  FAM_TIMES, FACE_BOLD,   "iso8859_1:nB:t"   },
  {0,  CS_ISO8859_1,  FAM_HELV,  FACE_NORMAL, "iso8859_1:n:h"    },
  {0,  CS_ISO8859_1,  FAM_HELV,  FACE_ITALIC, "iso8859_1:nI:h"   },
  {0,  CS_ISO8859_1,  FAM_HELV,  FACE_BOLD,   "iso8859_1:nB:h"   },
  {0,  CS_ISO8859_1,  FAM_COUR,  FACE_NORMAL, "iso8859_1:n:c"    },
  {0,  CS_ISO8859_1,  FAM_COUR,  FACE_ITALIC, "iso8859_1:nI:c"   },
  {0,  CS_ISO8859_1,  FAM_COUR,  FACE_BOLD,   "iso8859_1:nB:c"   },
  /* iso8859-2 */
  {0,  CS_ISO8859_2,  FAM_FIXED, FACE_NORMAL, "iso8859_2:n:f"    },
  {0,  CS_ISO8859_2,  FAM_FIXED, FACE_ITALIC, "iso8859_2:nI:f"   },
  {0,  CS_ISO8859_2,  FAM_FIXED, FACE_BOLD,   "iso8859_2:nB:f"   },
  {0,  CS_ISO8859_2,  FAM_TIMES, FACE_NORMAL, "iso8859_2:n:t"    },
  {0,  CS_ISO8859_2,  FAM_TIMES, FACE_ITALIC, "iso8859_2:nI:t"   },
  {0,  CS_ISO8859_2,  FAM_TIMES, FACE_BOLD,   "iso8859_2:nB:t"   },
  {0,  CS_ISO8859_2,  FAM_HELV,  FACE_NORMAL, "iso8859_2:n:h"    },
  {0,  CS_ISO8859_2,  FAM_HELV,  FACE_ITALIC, "iso8859_2:nI:h"   },
  {0,  CS_ISO8859_2,  FAM_HELV,  FACE_BOLD,   "iso8859_2:nB:h"   },
  {0,  CS_ISO8859_2,  FAM_COUR,  FACE_NORMAL, "iso8859_2:n:c"    },
  {0,  CS_ISO8859_2,  FAM_COUR,  FACE_ITALIC, "iso8859_2:nI:c"   },
  {0,  CS_ISO8859_2,  FAM_COUR,  FACE_BOLD,   "iso8859_2:nB:c"   },
  /* iso8859-3 */
  {0,  CS_ISO8859_3,  FAM_FIXED, FACE_NORMAL, "iso8859_3:n:f"    },
  {0,  CS_ISO8859_3,  FAM_FIXED, FACE_ITALIC, "iso8859_3:nI:f"   },
  {0,  CS_ISO8859_3,  FAM_FIXED, FACE_BOLD,   "iso8859_3:nB:f"   },
  {0,  CS_ISO8859_3,  FAM_TIMES, FACE_NORMAL, "iso8859_3:n:t"    },
  {0,  CS_ISO8859_3,  FAM_TIMES, FACE_ITALIC, "iso8859_3:nI:t"   },
  {0,  CS_ISO8859_3,  FAM_TIMES, FACE_BOLD,   "iso8859_3:nB:t"   },
  {0,  CS_ISO8859_3,  FAM_HELV,  FACE_NORMAL, "iso8859_3:n:h"    },
  {0,  CS_ISO8859_3,  FAM_HELV,  FACE_ITALIC, "iso8859_3:nI:h"   },
  {0,  CS_ISO8859_3,  FAM_HELV,  FACE_BOLD,   "iso8859_3:nB:h"   },
  {0,  CS_ISO8859_3,  FAM_COUR,  FACE_NORMAL, "iso8859_3:n:c"    },
  {0,  CS_ISO8859_3,  FAM_COUR,  FACE_ITALIC, "iso8859_3:nI:c"   },
  {0,  CS_ISO8859_3,  FAM_COUR,  FACE_BOLD,   "iso8859_3:nB:c"   },
  /* iso8859-4 */
  {0,  CS_ISO8859_4,  FAM_FIXED, FACE_NORMAL, "iso8859_4:n:f"    },
  {0,  CS_ISO8859_4,  FAM_FIXED, FACE_ITALIC, "iso8859_4:nI:f"   },
  {0,  CS_ISO8859_4,  FAM_FIXED, FACE_BOLD,   "iso8859_4:nB:f"   },
  {0,  CS_ISO8859_4,  FAM_TIMES, FACE_NORMAL, "iso8859_4:n:t"    },
  {0,  CS_ISO8859_4,  FAM_TIMES, FACE_ITALIC, "iso8859_4:nI:t"   },
  {0,  CS_ISO8859_4,  FAM_TIMES, FACE_BOLD,   "iso8859_4:nB:t"   },
  {0,  CS_ISO8859_4,  FAM_HELV,  FACE_NORMAL, "iso8859_4:n:h"    },
  {0,  CS_ISO8859_4,  FAM_HELV,  FACE_ITALIC, "iso8859_4:nI:h"   },
  {0,  CS_ISO8859_4,  FAM_HELV,  FACE_BOLD,   "iso8859_4:nB:h"   },
  {0,  CS_ISO8859_4,  FAM_COUR,  FACE_NORMAL, "iso8859_4:n:c"    },
  {0,  CS_ISO8859_4,  FAM_COUR,  FACE_ITALIC, "iso8859_4:nI:c"   },
  {0,  CS_ISO8859_4,  FAM_COUR,  FACE_BOLD,   "iso8859_4:nB:c"   },
  /* iso8859-5 */
  {0,  CS_ISO8859_5,  FAM_FIXED, FACE_NORMAL, "iso8859_5:n:f"    },
  {0,  CS_ISO8859_5,  FAM_FIXED, FACE_ITALIC, "iso8859_5:nI:f"   },
  {0,  CS_ISO8859_5,  FAM_FIXED, FACE_BOLD,   "iso8859_5:nB:f"   },
  {0,  CS_ISO8859_5,  FAM_TIMES, FACE_NORMAL, "iso8859_5:n:t"    },
  {0,  CS_ISO8859_5,  FAM_TIMES, FACE_ITALIC, "iso8859_5:nI:t"   },
  {0,  CS_ISO8859_5,  FAM_TIMES, FACE_BOLD,   "iso8859_5:nB:t"   },
  {0,  CS_ISO8859_5,  FAM_HELV,  FACE_NORMAL, "iso8859_5:n:h"    },
  {0,  CS_ISO8859_5,  FAM_HELV,  FACE_ITALIC, "iso8859_5:nI:h"   },
  {0,  CS_ISO8859_5,  FAM_HELV,  FACE_BOLD,   "iso8859_5:nB:h"   },
  {0,  CS_ISO8859_5,  FAM_COUR,  FACE_NORMAL, "iso8859_5:n:c"    },
  {0,  CS_ISO8859_5,  FAM_COUR,  FACE_ITALIC, "iso8859_5:nI:c"   },
  {0,  CS_ISO8859_5,  FAM_COUR,  FACE_BOLD,   "iso8859_5:nB:c"   },
  /*  iso8859-7 */
  {0,  CS_ISO8859_7,  FAM_FIXED, FACE_NORMAL, "iso8859_7:n:f"    },
  {0,  CS_ISO8859_7,  FAM_FIXED, FACE_ITALIC, "iso8859_7:nI:f"   },
  {0,  CS_ISO8859_7,  FAM_FIXED, FACE_BOLD,   "iso8859_7:nB:f"   },
  {0,  CS_ISO8859_7,  FAM_TIMES, FACE_NORMAL, "iso8859_7:n:t"    },
  {0,  CS_ISO8859_7,  FAM_TIMES, FACE_ITALIC, "iso8859_7:nI:t"   },
  {0,  CS_ISO8859_7,  FAM_TIMES, FACE_BOLD,   "iso8859_7:nB:t"   },
  {0,  CS_ISO8859_7,  FAM_HELV,  FACE_NORMAL, "iso8859_7:n:h"    },
  {0,  CS_ISO8859_7,  FAM_HELV,  FACE_ITALIC, "iso8859_7:nI:h"   },
  {0,  CS_ISO8859_7,  FAM_HELV,  FACE_BOLD,   "iso8859_7:nB:h"   },
  {0,  CS_ISO8859_7,  FAM_COUR,  FACE_NORMAL, "iso8859_7:n:c"    },
  {0,  CS_ISO8859_7,  FAM_COUR,  FACE_ITALIC, "iso8859_7:nI:c"   },
  {0,  CS_ISO8859_7,  FAM_COUR,  FACE_BOLD,   "iso8859_7:nB:c"   },
  /* iso8859-8 */
  {0,  CS_ISO8859_8,  FAM_FIXED, FACE_NORMAL, "iso8859_8:n:f"    },
  {0,  CS_ISO8859_8,  FAM_FIXED, FACE_ITALIC, "iso8859_8:nI:f"   },
  {0,  CS_ISO8859_8,  FAM_FIXED, FACE_BOLD,   "iso8859_8:nB:f"   },
  {0,  CS_ISO8859_8,  FAM_TIMES, FACE_NORMAL, "iso8859_8:n:t"    },
  {0,  CS_ISO8859_8,  FAM_TIMES, FACE_ITALIC, "iso8859_8:nI:t"   },
  {0,  CS_ISO8859_8,  FAM_TIMES, FACE_BOLD,   "iso8859_8:nB:t"   },
  {0,  CS_ISO8859_8,  FAM_HELV,  FACE_NORMAL, "iso8859_8:n:h"    },
  {0,  CS_ISO8859_8,  FAM_HELV,  FACE_ITALIC, "iso8859_8:nI:h"   },
  {0,  CS_ISO8859_8,  FAM_HELV,  FACE_BOLD,   "iso8859_8:nB:h"   },
  {0,  CS_ISO8859_8,  FAM_COUR,  FACE_NORMAL, "iso8859_8:n:c"    },
  {0,  CS_ISO8859_8,  FAM_COUR,  FACE_ITALIC, "iso8859_8:nI:c"   },
  {0,  CS_ISO8859_8,  FAM_COUR,  FACE_BOLD,   "iso8859_8:nB:c"   },
  /* iso8859-9 */
  {0,  CS_ISO8859_9,  FAM_FIXED, FACE_NORMAL, "iso8859_9:n:f"    },
  {0,  CS_ISO8859_9,  FAM_FIXED, FACE_ITALIC, "iso8859_9:nI:f"   },
  {0,  CS_ISO8859_9,  FAM_FIXED, FACE_BOLD,   "iso8859_9:nB:f"   },
  {0,  CS_ISO8859_9,  FAM_TIMES, FACE_NORMAL, "iso8859_9:n:t"    },
  {0,  CS_ISO8859_9,  FAM_TIMES, FACE_ITALIC, "iso8859_9:nI:t"   },
  {0,  CS_ISO8859_9,  FAM_TIMES, FACE_BOLD,   "iso8859_9:nB:t"   },
  {0,  CS_ISO8859_9,  FAM_HELV,  FACE_NORMAL, "iso8859_9:n:h"    },
  {0,  CS_ISO8859_9,  FAM_HELV,  FACE_ITALIC, "iso8859_9:nI:h"   },
  {0,  CS_ISO8859_9,  FAM_HELV,  FACE_BOLD,   "iso8859_9:nB:h"   },
  {0,  CS_ISO8859_9,  FAM_COUR,  FACE_NORMAL, "iso8859_9:n:c"    },
  {0,  CS_ISO8859_9,  FAM_COUR,  FACE_ITALIC, "iso8859_9:nI:c"   },
  {0,  CS_ISO8859_9,  FAM_COUR,  FACE_BOLD,   "iso8859_9:nB:c"   },
  /* japanese */
  {0,  CS_JISX0201K,  FAM_FIXED, FACE_NORMAL, "jisx0201k:n:f"    },
  {0,  CS_JISX0201R,  FAM_FIXED, FACE_NORMAL, "jisx0201r:n:f"    },
  {0,  CS_JISX0208,   FAM_FIXED, FACE_NORMAL, "jisx0208:n:f"     },
  {0,  CS_JISX0208,   FAM_FIXED, FACE_ITALIC, "jisx0208:nI:f"    },
  {0,  CS_JISX0208,   FAM_FIXED, FACE_BOLD,   "jisx0208:nB:f"    },
  {0,  CS_JISX0208,   FAM_TIMES, FACE_NORMAL, "jisx0208:n:t"     },
  {0,  CS_JISX0208,   FAM_TIMES, FACE_ITALIC, "jisx0208:nI:t"    },
  {0,  CS_JISX0208,   FAM_TIMES, FACE_BOLD,   "jisx0208:nB:t"    },
  {0,  CS_JISX0208,   FAM_HELV,  FACE_NORMAL, "jisx0208:n:h"     },
  {0,  CS_JISX0208,   FAM_HELV,  FACE_ITALIC, "jisx0208:nI:h"    },
  {0,  CS_JISX0208,   FAM_HELV,  FACE_BOLD,   "jisx0208:nB:h"    },
  {0,  CS_JISX0208,   FAM_COUR,  FACE_NORMAL, "jisx0208:n:c"     },
  {0,  CS_JISX0208,   FAM_COUR,  FACE_ITALIC, "jisx0208:nI:c"    },
  {0,  CS_JISX0208,   FAM_COUR,  FACE_BOLD,   "jisx0208:nB:c"    },
  {0,  CS_JISX0212,   FAM_FIXED, FACE_NORMAL, "jisx0212:n:f"     },
  /* hangle */
  {0,  CS_KSC5601,    FAM_FIXED, FACE_NORMAL, "ksc5601:n:f"      },
  {0,  CS_KSC5601,    FAM_FIXED, FACE_ITALIC, "ksc5601:nI:f"     },
  {0,  CS_KSC5601,    FAM_FIXED, FACE_BOLD,   "ksc5601:nB:f"     },
  {0,  CS_KSC5601,    FAM_TIMES, FACE_NORMAL, "ksc5601:n:t"      },
  {0,  CS_KSC5601,    FAM_TIMES, FACE_ITALIC, "ksc5601:nI:t"     },
  {0,  CS_KSC5601,    FAM_TIMES, FACE_BOLD,   "ksc5601:nB:t"     },
  {0,  CS_KSC5601,    FAM_HELV,  FACE_NORMAL, "ksc5601:n:h"      },
  {0,  CS_KSC5601,    FAM_HELV,  FACE_ITALIC, "ksc5601:nI:h"     },
  {0,  CS_KSC5601,    FAM_HELV,  FACE_BOLD,   "ksc5601:nB:h"     },
  {0,  CS_KSC5601,    FAM_COUR,  FACE_NORMAL, "ksc5601:n:c"      },
  {0,  CS_KSC5601,    FAM_COUR,  FACE_ITALIC, "ksc5601:nI:c"     },
  {0,  CS_KSC5601,    FAM_COUR,  FACE_BOLD,   "ksc5601:nB:c"     },
  /* chinese */
  {0,  CS_GB2312,     FAM_FIXED, FACE_NORMAL, "gb2312:n:f"       },
  {0,  CS_GB2312,     FAM_FIXED, FACE_ITALIC, "gb2312:nI:f"      },
  {0,  CS_GB2312,     FAM_FIXED, FACE_BOLD,   "gb2312:nB:f"      },
  {0,  CS_GB2312,     FAM_TIMES, FACE_NORMAL, "gb2312:n:t"       },
  {0,  CS_GB2312,     FAM_TIMES, FACE_ITALIC, "gb2312:nI:t"      },
  {0,  CS_GB2312,     FAM_TIMES, FACE_BOLD,   "gb2312:nB:t"      },
  {0,  CS_GB2312,     FAM_HELV,  FACE_NORMAL, "gb2312:n:h"       },
  {0,  CS_GB2312,     FAM_HELV,  FACE_ITALIC, "gb2312:nI:h"      },
  {0,  CS_GB2312,     FAM_HELV,  FACE_BOLD,   "gb2312:nB:h"      },
  {0,  CS_GB2312,     FAM_COUR,  FACE_NORMAL, "gb2312:n:c"       },
  {0,  CS_GB2312,     FAM_COUR,  FACE_ITALIC, "gb2312:nI:c"      },
  {0,  CS_GB2312,     FAM_COUR,  FACE_BOLD,   "gb2312:nB:c"      },
  {0,  CS_CNS11643_1, FAM_FIXED, FACE_NORMAL, "cns11643_1:n:f"   },
  {0,  CS_CNS11643_1, FAM_FIXED, FACE_ITALIC, "cns11643_1:nI:f"  },
  {0,  CS_CNS11643_1, FAM_FIXED, FACE_BOLD,   "cns11643_1:nB:f"  },
  {0,  CS_CNS11643_1, FAM_TIMES, FACE_NORMAL, "cns11643_1:n:t"   },
  {0,  CS_CNS11643_1, FAM_TIMES, FACE_ITALIC, "cns11643_1:nI:t"  },
  {0,  CS_CNS11643_1, FAM_TIMES, FACE_BOLD,   "cns11643_1:nB:t"  },
  {0,  CS_CNS11643_1, FAM_HELV,  FACE_NORMAL, "cns11643_1:n:h"   },
  {0,  CS_CNS11643_1, FAM_HELV,  FACE_ITALIC, "cns11643_1:nI:h"  },
  {0,  CS_CNS11643_1, FAM_HELV,  FACE_BOLD,   "cns11643_1:nB:h"  },
  {0,  CS_CNS11643_1, FAM_COUR,  FACE_NORMAL, "cns11643_1:n:c"   },
  {0,  CS_CNS11643_1, FAM_COUR,  FACE_ITALIC, "cns11643_1:nI:c"  },
  {0,  CS_CNS11643_1, FAM_COUR,  FACE_BOLD,   "cns11643_1:nB:c"  },
  {0,  CS_CNS11643_2, FAM_FIXED, FACE_NORMAL, "cns11643_2:n:f"   },
  {0,  CS_CNS11643_2, FAM_FIXED, FACE_ITALIC, "cns11643_2:nI:f"  },
  {0,  CS_CNS11643_2, FAM_FIXED, FACE_BOLD,   "cns11643_2:nB:f"  },
  {0,  CS_CNS11643_2, FAM_TIMES, FACE_NORMAL, "cns11643_2:n:t"   },
  {0,  CS_CNS11643_2, FAM_TIMES, FACE_ITALIC, "cns11643_2:nI:t"  },
  {0,  CS_CNS11643_2, FAM_TIMES, FACE_BOLD,   "cns11643_2:nB:t"  },
  {0,  CS_CNS11643_2, FAM_HELV,  FACE_NORMAL, "cns11643_2:n:h"   },
  {0,  CS_CNS11643_2, FAM_HELV,  FACE_ITALIC, "cns11643_2:nI:h"  },
  {0,  CS_CNS11643_2, FAM_HELV,  FACE_BOLD,   "cns11643_2:nB:h"  },
  {0,  CS_CNS11643_2, FAM_COUR,  FACE_NORMAL, "cns11643_2:n:c"   },
  {0,  CS_CNS11643_2, FAM_COUR,  FACE_ITALIC, "cns11643_2:nI:c"  },
  {0,  CS_CNS11643_2, FAM_COUR,  FACE_BOLD,   "cns11643_2:nB:c"  },
  {0,  CS_CNS11643_3, FAM_FIXED, FACE_NORMAL, "cns11643_3:n:f"   },
  {0,  CS_CNS11643_4, FAM_FIXED, FACE_NORMAL, "cns11643_4:n:f"   },
  {0,  CS_CNS11643_5, FAM_FIXED, FACE_NORMAL, "cns11643_5:n:f"   },
  {0,  CS_CNS11643_6, FAM_FIXED, FACE_NORMAL, "cns11643_6:n:f"   },
  {0,  CS_CNS11643_7, FAM_FIXED, FACE_NORMAL, "cns11643_7:n:f"   },
  /* mule big 5 */
  {0, CS_MULE_BIG5_L1,  FAM_FIXED, FACE_NORMAL, "big5:n:f"  },
  {0, CS_MULE_BIG5_L2,  FAM_FIXED, FACE_NORMAL, "big5:n:f"  },
  /* mule arabic */
  {0,  CS_MULE_ARAB0,   FAM_FIXED, FACE_NORMAL, "mule_arab0:n:f"   },
  {0,  CS_MULE_ARAB1,   FAM_FIXED, FACE_NORMAL, "mule_arab1:n:f"   },
  {0,  CS_MULE_ARAB2,   FAM_FIXED, FACE_NORMAL, "mule_arab2:n:f"   },
  /* mule ethiopic */
  {0, CS_MULE_ETHIOPIC, FAM_FIXED, FACE_NORMAL, "mule_ethio:n:f"  },
  /* mule viscii */
  {0, CS_MULE_VISCII_L, FAM_FIXED, FACE_NORMAL, "mule_viscii_l:n:f"  },
  {0, CS_MULE_VISCII_U, FAM_FIXED, FACE_NORMAL, "mule_viscii_u:n:f"  },

  /*** end ***/
  {-1, -1, -1, -1, NULL, -1},
};

/*EOF*/
