/* Nessus Attack Scripting Language
 *
 * Copyright (C) 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <includes.h>
#include <nasl_raw.h>
#include "function_call.h"
#include "init.h"
#include "sanitize.h"
#include "defines.h"
#include "strutils.h"
#include "pkt_utils.h"
#include "boolean.h"
#include "nasl_memory.h"

/*
 * Input : 'function(a:1, b, c:3)'
 *
 * Output : 
 * 	- function
 *	- args :
 *		'a' : 1
 *		''  : b
 *		'c' : 3
 *
 */
static harglst * split_function_args(globals, args)
 harglst * globals;
 char * args;
{
 harglst * ret = harg_create(10);
			/* The arglists use emalloc() for creating
			   all the 'nexts'. So the head is not
			   created with nasl_malloc()
			 */
 struct arglist * fargs = emalloc(sizeof(struct arglist));
 char * copy; 
 char * v, *e;
 char * end;
#ifdef DEBUG 
 printf("split %s\n", args);
#endif 
 copy = nasl_strdup(globals,args);
 v = strchr(copy, START_FUNCTION);
 e = my_strchr(copy, START_FUNCTION, END_FUNCTION);
 if(!e){
 	printf("ERROR : no %c in  %s\n", END_FUNCTION, copy);
	return(NULL);
	}
 v[0] = '\0';v++;
 e[0] = '\0';
 
 end = e+1;
 harg_add_string(ret, "atom",copy);
 /*
  * v points on the first function argument
  */
 while(v && v[0])
 {
  char * w;
  e = v;
  /*
   * We look for the arguments separator, taking care
   * of quoted text.
   */
  while(e && e[0] && e[0]!=FUNCTION_ARGS_SEP){
  	if(e[0]==OPEN_QUOTE)e = strchr(e+1, CLOSE_QUOTE);
	else if(e[0]==START_FUNCTION)e=strchr(e+1, END_FUNCTION);
	if(e && e[0])e++;
	}
  if(e && e[0])e[0]='\0';
  /*
   * v now points on xxxxxxx:xxxxxx or xxxxxx
   */
   w = quoted_strchr(v, FUNCTION_ARGS);
   
   if(w&&!is_function(v))
   {
    /* Nominated arguments */
    w[0] = '\0';
#ifdef DEBUG
    printf("add : %s:%s\n", v, w+1);
#endif    
    arg_add_value(fargs, v, ARG_STRING, strlen(w+1), nasl_strdup(globals,w+1));
   }
   else
   {
   arg_add_value(fargs, "no_name", ARG_STRING, strlen(v), nasl_strdup(globals,v));
#ifdef DEBUG   
   printf("add : %s\n", v);
#endif   
   }
 if(e)v = e+1;  
 else v = NULL;
 if(v >= end)v = NULL;
 }
 if(end[0])
 {
  if(!strncmp(end, FUNCTION_REPEAT, STRLEN_FUNCTION_REPEAT))
  {
   char * rep = end + STRLEN_FUNCTION_REPEAT;
   char * ed  = my_strchr(end, START_FUNCTION, END_FUNCTION);
   if(ed)ed[0] = '\0';
   harg_add_string(ret, "repeat",rep);
  }
  else if(!strncmp(end, FUNCTION_PROVIDED, STRLEN_FUNCTION_PROVIDED))
  {
   char * rep = end + STRLEN_FUNCTION_PROVIDED;
   char * ed  = my_strchr(end, START_FUNCTION, END_FUNCTION);
   if(ed)ed[0] = '\0';
   harg_add_string(ret, "provided",rep);
  }
 }
 harg_add_ptr(ret, "args", fargs); 
 nasl_free(globals,copy);
 return(ret);
}
   
    
struct arglist
function_call(globals, args)
 harglst * globals;
 char * args;
{
 harglst * fdata 		= split_function_args(globals, args);
 harglst * functions 		= harg_get_harg(globals, "functions");
 callback_func_t func;
 struct arglist * arguments;
 int repeat = 1;
 char * provided;
 struct arglist rt;
 struct arglist * a;

 if(!fdata){
   rt.type = PKT_ERROR(ERR_FUNC);
   return(rt);
   }
 func 	= harg_get_ptr(functions, harg_get_string(fdata, "atom"));
 arguments = harg_get_ptr(fdata, "args");
 provided = harg_get_string(fdata, "provided");

 bzero(&rt, sizeof(struct arglist));
 if(!func)
 {
  printf("Error ! Function \"%s\" does not exist\n", (char*)
  					harg_get_string(fdata, "atom"));
  rt.type = PKT_ERROR(ERR_FUNC|ERR_EXIST);
  return(rt);
 }

if(harg_get_type(fdata, "repeat")>0)
 {
  char * rp = harg_get_string(fdata, "repeat");
  int len = strlen(rp);
  if(rp[len-1]==';')rp[len-1]='\0';
  rt = sanitize_variable(globals, rp);
  if(rt.type & VAR_STR)repeat = atoi(rt.value);
  else {
   printf("Error : %s is not a good repeat variable\n", rp);
   rt.type = PKT_ERROR(ERR_VAR|ERR_TYPE);
   return(rt);
   }
  if(rt.type & VAR_DELETE)nasl_free(globals,rt.value);
 }else repeat = 1;
 
 /*
  * sanitize the arguments
  */
 a = arguments;
 while(a && a->next)
 { 
 if(strcmp(a->name, "no_name"))
  {
  rt = sanitize_variable(globals, a->value);
  if(rt.type){
    	if(a->value != rt.value)nasl_free(globals, a->value);
	/*if(rt.type & VAR_STR)*/
	a->value =  rt.value;
	a->length = rt.length;
	/*if(rt.type & VAR_DELETE)nasl_free(globals, rt.value);*/
	}
  }
  a = a->next;
 }

 while(repeat--)
 {
  int err;
  err = evaluate_boolean(globals, provided);
  if(err < 0){
  	rt.type = err;
	return(rt);
	}
  if(err)rt = (*func)(globals, arguments);
 }

 
 /*nasl_arg_free(arguments);*/
 /*nasl_arg_free(fdata);*/
  while(arguments && arguments->next)
  {
   struct arglist * next;
   next = arguments->next;
   free(arguments->name);
   /*nasl_free(globals, arguments->value);*/
   free(arguments);
   arguments = next;
  }
  free(arguments);
  
  harg_remove(fdata, "args");
  harg_close_all(fdata);
 if(!rt.type) 
 {
  char * zero = "0"; 
  rt.type = VAR_STR|STR_ALL_DIGIT;
  rt.value = nasl_strdup(globals,zero);
  rt.length = 1;
 }
 return(rt);
}
 
 
