/* Nessus
 * Copyright (C) 1998, 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <includes.h>
#include "report_utils.h"
 
 
int arglist_length(struct arglist * arg)
{
 if(!arg)return 0;
 return arg->next ? 1 + arglist_length(arg->next):0;
} 




/*
 * Auxilliary functions
 */
int number_of_warnings_by_port(struct arglist * arg)
{ 
 if(!arg || !arg->next)return 0;
 else {
  struct arglist * warnings = arg_get_value(arg->value, "INFO");
  return arglist_length(warnings) + number_of_warnings_by_port(arg->next);
  }
}

int number_of_warnings_by_host(struct arglist * arg)
{
 if(!arg || !arg->next)return 0;
 else return number_of_warnings_by_port(arg->value) +
  	     number_of_warnings_by_host(arg->next);	     
}
 

int number_of_holes_by_port(struct arglist * arg)
{ 
 if(!arg || !arg->next)return 0;
 else {
  struct arglist * holes = arg_get_value(arg->value, "REPORT");
  return arglist_length(holes) + number_of_holes_by_port(arg->next);
  }
}

int number_of_holes_by_host(struct arglist * arg)
{
 if(!arg || !arg->next)return 0;
 else return number_of_holes_by_port(arg->value) +
  	     number_of_holes_by_host(arg->next);	     
}


int number_of_warnings(struct arglist *  arg)
{
 if(!arg || !arg->next)return 0;
 else return number_of_warnings_by_host(arg->value) + 
 	     number_of_warnings(arg->next);
}

int number_of_holes(struct arglist * arg)
{
if(!arg ||!arg->next)return 0;
 else return number_of_holes_by_host(arg->value) + 
 	     number_of_holes(arg->next);
}

/*
 * The most dangerous host
 */
static struct arglist* sub_most_dangerous_host_holes(host, current, number)
	struct arglist * host;
	struct arglist * current;
	int number;
{
 if(!host || !host->next)return current;
 else 
 {
  int holes = number_of_holes_by_host(host->value);
  if(holes > number) return sub_most_dangerous_host_holes(host->next, host,
  							   holes);
	else return sub_most_dangerous_host_holes(host->next, current, number);
 }
}

static struct arglist* sub_most_dangerous_host_warnings(host, current, number)
	struct arglist * host;
	struct arglist * current;
	int number;
{
 if(!host || !host->next)return current;
 else 
 {
  int holes = number_of_warnings_by_host(host->value);
  if(holes > number) return sub_most_dangerous_host_warnings(host->next, host,
  							   holes);
	else return sub_most_dangerous_host_warnings(host->next, current, number);
 }
}

	
struct arglist *most_dangerous_host(hosts)
 struct arglist * hosts;
{
 struct arglist * most = sub_most_dangerous_host_holes(hosts, NULL, 0);
 if(most)return most;
 else return sub_most_dangerous_host_warnings(hosts, NULL, 0);
}

/************************************************************************
 * 
 * 			 	Insertion sort
 *
 ************************************************************************/


struct arglist * arglist_insert(struct arglist*e, struct arglist** l)
{
 int greater = 0;
 int danger_h_e = number_of_holes_by_host(e->value);
 int danger_h_l = number_of_holes_by_host((*l)->value);
 if(danger_h_e > danger_h_l)greater++;
 if(!(e && l))
 {
  int danger_w_e = number_of_warnings_by_host(e->value);
  int danger_w_l = number_of_warnings_by_host((*l)->value);
  if(danger_w_e > danger_w_l)greater++;
 }
 
 
 if(!((*l)->next) ||  greater)
 {
  e->next = *l;
  *l = e; 
  return *l;
 }
 else
 {
  arglist_insert(e, &((*l)->next));
  return *l;
 }
}
 
struct arglist * arglist_insert_sort(struct arglist * l)
{
 if(!l->next)
  return l;
 else 
  {
   struct arglist * result_insert;
   
   result_insert = arglist_insert_sort(l->next);
   return arglist_insert(l, &result_insert);
  }
}
 
 


struct arglist * sort_dangerous_hosts(struct arglist * hosts)
{
 return arglist_insert_sort(hosts);
}
