/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include	"LabelP.h"
#include	"Init.h"

static XtResource resources [] = {
	{
	 XtNbox_type ,
	 XtCBox_type ,
	 XtRInt ,
	 sizeof(int) ,
	 XtOffsetOf(LabelRec,base.box_type) ,
	 XtRImmediate ,
	 (XtPointer) XtCframeout_box
	},
};

static void ClassInitialize();

LabelClassRec labelClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &buttonClassRec,
    /* class_name            */ "Label",
    /* widget_size           */ sizeof(LabelRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ NULL,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ TRUE,
    /* compress_exposure     */ TRUE,
    /* compress_enterleave   */ TRUE,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ NULL,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ NULL,
    /* unhighlight	       */ NULL,
    /* highlightBorder	       */ NULL,
    /* unhighlightBorder       */ NULL,
   },
/* sButton */
   {
    /* empty                 */ 0
   },
/* button */
   {
    /* empty 		     */ 0
   },
/* label */
   {
   /* empty		     */ 0
   },
};

WidgetClass labelWidgetClass = (WidgetClass) &labelClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

void LabelSetLabel(w,label)
Widget w;
char *label;
{
	LabelWidget cw = (LabelWidget) w;

	XtFree(cw->button.label);
	cw->button.label = XtNewString(label);

	if (XtIsRealized(w))
	{
		XClearWindow(XtDisplay(w),XtWindow(w));
		buttonClassRec.core_class.expose(w,NULL,NULL);
	}
}
