/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _MenuP_H_
#define _MenuP_H_

#include	<X11/ShellP.h>
#include	<Nws/Menu.h>
#include	<Nws/dimdefP.h>

#if NeedFunctionPrototypes
typedef void (*popdown_submenu_Proc) (Widget);
typedef void (*popdown_all_Proc) (Widget);
typedef void (*insert_submenu_Proc) (Widget);
#else
typedef void (*popdown_submenu_Proc) ();
typedef void (*popdown_all_Proc) ();
typedef void (*insert_submenu_Proc) ();
#endif

#define  XtInheritGetInternalDimension ((get_internal_dimension_Proc) _XtInherit)
#define  XtInheritSetInternalDimension ((set_internal_dimension_Proc) _XtInherit)
#define  XtInheritPopdownSubmenu ((popdown_submenu_Proc) _XtInherit)
#define  XtInheritPopdownAll ((popdown_all_Proc) _XtInherit)

#define HIDE_PROTO 1
#include	"BaseMEP.h"
#undef HIDE_PROTO

typedef struct {
	get_internal_dimension_Proc	get_internal_dimension;
	set_internal_dimension_Proc	set_internal_dimension;
	int				num_submenu;
	WidgetList			submenu;
	insert_submenu_Proc		insert_submenu;
	popdown_submenu_Proc		popdown_submenu;
	popdown_all_Proc		popdown_all;
} MenuClassPart;

typedef struct _MenuClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ShellClassPart		shell_class;
	OverrideShellClassPart	override_shell_class;
	MenuClassPart		menu_class;
} MenuClassRec;

extern MenuClassRec menuClassRec;

typedef struct _MenuPart {
	/* public resources */
	Cursor		cursor;
	int		box_type;
	int		box_width;
	int		box_intensity;
	Pixel		box_color;
	int		backing_store;
	/* private */
	int		menu_sub_position;	/* kolkate je to submenu */
	Pixel		dark,light;
	Boolean		down_after_br;
	XtIntervalId    timer;
	BaseMEObject	*last_selected;
} MenuPart;

typedef struct _MenuRec {
	CorePart		core;
	CompositePart		composite;
	ShellPart		shell;
  	OverrideShellPart	override;
	MenuPart		menu;
} MenuRec;

#endif
