/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _ScrollbarP_H_
#define _ScrollbarP_H_

#include	<Nws/BaseP.h>
#include	<Nws/Scrollbar.h>


typedef struct {
	char	empty;
} ScrollbarClassPart;

typedef struct _ScrollbarClassRec {
	CoreClassPart		core_class;
	BaseClassPart		base_class;
	ScrollbarClassPart	scrollbar_class;
} ScrollbarClassRec;

extern ScrollbarClassRec scrollbarClassRec;

typedef struct {
	/* resources */
	Boolean		active_arrows;
	int		length;
	int		thickness;
	int		orientation;
	int		repeat_delay;
	int		init_delay;
	int		slider_min_length;
	float		slider_size;
	float		slider_position;
	float		slider_inc;
	XtCallbackList	scroll_cb;
	int		spacing;
	Boolean		auto_scrolling;
	/* private */
	float		old_position;
	int		drag_position;
	int		slider_area_length;
	int		slider_length;
	int		slider_start;
	Pixel		dark,light;
	XtIntervalId	timer;
	int		where;
} ScrollbarPart;

typedef struct _ScrollbarRec {
	CorePart	core;
	BasePart	base;
	ScrollbarPart	scrollbar;
} ScrollbarRec;
#endif

