/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include	<errno.h>
#include 	<stdlib.h>

#include	"TreeListP.h"
#include	"ScrollTreeList.h"
#include	"Init.h"
#include	"misc.h"
#include	"utils.h"

static char stiple_bitmap[] = {0x01, 0x02};

#define offset(field) XtOffsetOf(TreeListRec , treeList.field)

static XtResource resources[] = { 
	{
	 XtNfont,
	 XtCFont,
	 XtRFontStruct ,
	 sizeof(XFontStruct *) ,
	 offset(font) ,
	 XtRString ,
	 (XtPointer) XtDefaultFont 
	},
	{
	 XtNtree_line_color,
	 XtCTree_line_color ,
	 XtRPixel ,
	 sizeof(Pixel) ,
	 offset(tree_line_color) ,
	 XtRString ,
	 (XtPointer) XtDefaultForeground 
	},
        {
         XtNspacing ,
         XtCSpacing ,
         XtRInt ,
         sizeof(int) ,
         offset(spacing) ,
         XtRImmediate ,
         (XtPointer) 5
        },
        {
         XtNselect_cb ,
         XtCSelect_cb ,
         XtRCallback ,
         sizeof(XtCallbackList) ,
         offset(select_cb) ,
         XtRImmediate ,
         (XtPointer) NULL
        },
        {
         XtNselect_changed_cb ,
         XtCSelect_changed_cb ,
         XtRCallback ,
         sizeof(XtCallbackList) ,
         offset(select_changed_cb) ,
         XtRImmediate ,
         (XtPointer) NULL
        },
        {
         XtNselected_fg ,
         XtCSelected_fg ,
         XtRPixel ,
         sizeof(Pixel) ,
         offset(selected_fg) ,
         XtRString ,
         (XtPointer) XtDefaultBackground
        },
        {
         XtNselected_bg ,
         XtCSelected_bg ,
         XtRPixel ,
         sizeof(Pixel) ,
         offset(selected_bg) ,
         XtRString ,
         (XtPointer) XtDefaultForeground
        },
        {
         XtNsection_distance ,
         XtCSection_distance ,
         XtRInt ,
         sizeof(int) ,
         offset(section_distance) ,
         XtRImmediate ,
         (XtPointer) 15
        },
	{
	 XtNdo_layout ,
	 XtCDo_layout ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(do_layout) ,
	 XtRImmediate ,
	 (XtPointer) True
	},
	{
	 XtNdelete_subtree_on_close ,
	 XtCDelete_subtree_on_close ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(delete_subtree_on_close) ,
	 XtRImmediate ,
	 (XtPointer) False
	},
	{
	 XtNrestore_state_on_open ,
	 XtCRestore_state_on_open ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(restore_state_on_open) ,
	 XtRImmediate ,
	 (XtPointer) False
	},
	{
	 XtNdirect_draw ,
	 XtCDirect_draw ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(direct_draw) ,
	 XtRImmediate ,
	 (XtPointer) True
	},
};

static void ClassInitialize();
static void Initialize ();
static Boolean SetValues ();
static void Redisplay ();
static void Realize();
static void Resize ();
static void Destroy ();
static XtGeometryResult QueryGeometry();

static void Layout ();

static void Selecting ();
static void ActivateDouble ();
static void Activate ();
static void ActivateKB ();
static void Select();

static void FreeTree();
static void FreeNode();
static Boolean FindTreeObject();
static void GetPositionEntry();
static void GetYPositionEntry();
static void CloseSubTree();
static void OpenSubTree();

static void TreeListEntryInitialize();
static void TreeListEntryRedisplay();

static void Wscrl();

/********  podmienkove funkcie a struktury  pri vyhladavani v strome *********/

typedef struct {
	int x;
	int y;
} PositionStruct;

static Boolean PositionCondition();
static Boolean YPositionCondition();
static Boolean IDCondition();


/*****************************************************************************/


static XtActionsRec action [] = {
	{"start_selecting" , Activate},
	{"selecting" , Selecting },
	{"activate" , ActivateKB},
	{"select" , Select},
	};

static char trans_tab [] =
	"<Btn1Down>: start_selecting() focusCurrent() \n\
	 <Btn1Motion>: selecting() \n\
	 <Key>Return: activate() \n\
	 <Key>Up: select(previous) \n\
	 <Key>Down: select(next) \n\
	 <Key>Home: select(first) \n\
	 <Key>End: select(last) \n\
	 <Key>Prior: select(previous_page) \n\
	 <Key>Next: select(next_page) \n\
	 ~Shift<Key>Tab: traverseForward()\n\
	 Shift<Key>Tab: traverseBackward()\n\
	 <FocusIn>: focusIn()\n\
	 <FocusOut>: focusOut()\n\
	 <BtnDown>: focusCurrent()\n\
	 ";

TreeListClassRec treeListClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseClassRec,
    /* class_name            */ "TreeList",
    /* widget_size           */ sizeof(TreeListRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ Realize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ True,
    /* compress_exposure     */ True,
    /* compress_enterleave   */ True,
    /* visible_interest      */ True,
    /* destroy               */ Destroy,
    /* resize                */ Resize,
    /* expose                */ Redisplay,
    /* set_values            */ SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },	
   {
    /* empty		       */ 0
   },
};
	
WidgetClass treeListWidgetClass = (WidgetClass) &treeListClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	TreeListWidget cw = (TreeListWidget) new_widget;
        Display *dpy=XtDisplay(new_widget);
        XGCValues gc_res;
        XtGCMask  gc_mask;
	Pixmap p;

        gc_res.foreground = cw->treeList.tree_line_color;
        gc_res.font = cw->treeList.font->fid;
	
        gc_mask = GCForeground | GCFont;

        cw->treeList.lineGC = XCreateGC(dpy,DefaultRootWindow(dpy),
                        gc_mask, &gc_res);

	p = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy) ,stiple_bitmap,2,2);

	gc_res.stipple = p;
	gc_res.foreground = cw->core.background_pixel;

	gc_mask = GCForeground | GCStipple;

        cw->treeList.gc = XCreateGC(dpy,DefaultRootWindow(dpy),
                        gc_mask, &gc_res);

	cw->treeList.root = NULL;
	cw->treeList.last_selected = NULL;
	cw->treeList.internal_mode = False;
	cw->treeList.pos = 1;
	cw->treeList.topx = 0;
	cw->treeList.topy = 0;

	cw->treeList.scrolled = (XtClass(XtParent(new_widget))) == 
				scrollTreeListWidgetClass;

	if (cw->treeList.scrolled)
	{
		XtAddCallback(XtParent(new_widget) , XtNscroll_cb , Wscrl , new_widget);
	}

	cw->treeList.double_click_timer = (XtIntervalId)0;
}

static void Destroy(w)
Widget w;
{
	TreeListWidget cw = (TreeListWidget) w;

	if (cw->treeList.root != NULL)
	{
		FreeTree(cw->treeList.root);
	}
	XFreeGC(XtDisplay(w) , cw->treeList.lineGC);
	XFreeGC(XtDisplay(w) , cw->treeList.gc);
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	TreeListWidget cw = (TreeListWidget) w;
        TreeList *entry,*p;
	TreeList *p1,*p2,*pom;
        Window root , parent , *childs ;
        unsigned int nchilds;
	Display *dpy = XtDisplay(w);
	Drawable pmap;
	unsigned int pw,ph,bw,dpt,ww,wh;
	int wx,wy,px,py;
	int maxy , miny;

	if (!XtIsRealized(w) || !cw->core.visible) return;

	if (cw->treeList.root == NULL) return;

	XQueryTree(dpy , XtWindow(w) , &root , &parent , &childs , &nchilds);
	XFree(childs);
	XGetGeometry(dpy , parent , &root , &px , &py , &pw , &ph , &bw , &dpt); 
	XGetGeometry(dpy , XtWindow(w) , &root , &wx , &wy , &ww , &wh , &bw , &dpt); 
	miny = (wy < 0) ? -wy : 0;
	maxy = (wy + wh > ph) ? ph - wy : wh;

	if (ww < 2 || wh < 2) return;

	if (cw->treeList.direct_draw)
	{
		pmap = XtWindow(w);
	}
	else
	{
		pmap = XCreatePixmap(dpy , XtWindow(w) , ww , wh , 
			DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy)));

		XSetForeground(dpy , cw->treeList.gc , cw->core.background_pixel);
		XFillRectangle(dpy , pmap , cw->treeList.gc , 0 , 0 , ww ,wh);
	}

	p1 = cw->treeList.root;

	while (p1 != NULL)
	{
		if (p1->first_child != NULL && p1->expand_children)
		{
			p2 = p1->first_child;
		}
		else if (p1->neighbour == NULL)
		{
			if ((pom = p1->parent) != NULL)
			{
				while(pom->neighbour == NULL && pom->level != 0)
				{
					pom = pom->parent;
				}
				if (pom->level != 0) p2 = pom->neighbour;
				else p2 = NULL;
			}
			else p2 = NULL;
			
		}
		else
		{
			p2 = p1->neighbour;
		}

		entry = p1;

		p1 = p2;

                if (!entry->managed) continue;

		if (entry->y + cw->treeList.topy  > maxy + entry->height) break;

                if (entry->y + cw->treeList.topy < miny - entry->height) continue;

		XDrawLine(XtDisplay((Widget)w) , pmap ,
			cw->treeList.lineGC ,
			cw->treeList.topx + 
			entry->level * cw->treeList.section_distance ,
			cw->treeList.topy + 
			entry->y + entry->height / 2 ,
			cw->treeList.topx + 
			entry->level * cw->treeList.section_distance +
			cw->treeList.spacing ,
			cw->treeList.topy + 
			entry->y + entry->height / 2);

		if (entry->neighbour)
			XDrawLine(XtDisplay((Widget)w) , pmap ,
				cw->treeList.lineGC ,
				cw->treeList.topx + 
				entry->level  * cw->treeList.section_distance ,
				cw->treeList.topy + entry->y ,
				cw->treeList.topx + 
				entry->level  * cw->treeList.section_distance ,
				cw->treeList.topy + entry->y + entry->height);
		else
			XDrawLine(XtDisplay((Widget)w) , pmap ,
				cw->treeList.lineGC ,
				cw->treeList.topx + 
				entry->level  * cw->treeList.section_distance ,
				cw->treeList.topy + entry->y ,
				cw->treeList.topx + 
				entry->level  * cw->treeList.section_distance ,
				cw->treeList.topy + entry->y + entry->height / 2);

		p = entry->parent;

		while(p && (p != cw->treeList.root))
		{
			if (p->neighbour)
			{
				XDrawLine(XtDisplay((Widget)w) , pmap ,
					cw->treeList.lineGC ,
					cw->treeList.topx + 
					p->level * cw->treeList.section_distance ,
					cw->treeList.topy + entry->y ,
					cw->treeList.topx + 
					p->level * cw->treeList.section_distance ,
					cw->treeList.topy + entry->y + entry->height);
			}
			p = p->parent;
		}

		TreeListEntryRedisplay(w , entry , False , pmap);
        }
	if (!cw->treeList.direct_draw)
	{
		XCopyArea(dpy , pmap , XtWindow(w) , cw->treeList.gc ,
			0 , 0 , ww , wh , 0 , 0);
	        XFreePixmap(dpy , pmap);
	}
}

static void Realize(w, valueMask, attributes)
Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	TreeListWidget cw = (TreeListWidget) w;

	baseClassRec.core_class.realize(w, valueMask, attributes);

	Layout(w,cw->treeList.root);
}

static void Resize(w)
Widget w;
{
	if (!XtIsRealized(w)) return;

	baseClassRec.core_class.resize(w);
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> treeList.component != \
                                             w2 -> treeList.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	TreeListWidget cw = (TreeListWidget) current;
	TreeListWidget nw = (TreeListWidget) new_widget;
	Boolean redraw = False;

	if (WidgetValuesDiffer(cw , nw , tree_line_color))
	{
		XSetForeground(XtDisplay(current) , nw->treeList.lineGC ,
				nw->treeList.tree_line_color);
		redraw = True;
	}

	return redraw;
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	TreeListWidget cw = (TreeListWidget) w;
        unsigned int width = 0, height = 0;
	Dimension pwidth,pheight;
	Position x,y;
        TreeList *p;
	TreeList *p1,*p2,*pom;

        treeListClassRec.base_class.get_internal_dimension
        		(w , &x , &y , &pwidth , &pheight);

        preferred->width = cw->core.width - pwidth ;
        preferred->height = cw->core.height - pheight;
        preferred->request_mode = CWWidth | CWHeight;

	p1 = cw->treeList.root;

	while (p1 != NULL)
	{
		if (p1->first_child != NULL && p1->expand_children)
		{
			p2 = p1->first_child;
		}
		else if (p1->neighbour == NULL)
		{
			if ((pom = p1->parent) != NULL)
			{
				while( pom->neighbour == NULL && pom->level != 0)
				{
					pom = pom->parent;
				}
				if (pom->level != 0) p2 = pom->neighbour;
				else p2 = NULL;
			}
			else p2 = NULL;
			
		}
		else
		{
			p2 = p1->neighbour;
		}

		p = p1;

		p1 = p2;

                if (!p->managed) continue;

		width = MAX(width , p->x + p->width);
		height += p->height;
        }

        preferred->width = MAX(preferred->width , width);
        preferred->height = MAX( preferred->height , height);

	if (((intended->request_mode & (CWWidth | CWHeight))
                == (CWWidth | CWHeight)) &&
                intended->width == preferred->width &&
                intended->height == preferred->height)
                return XtGeometryYes;

        else if (preferred->width == cw->core.width &&
                preferred->height == cw->core.height)

        return XtGeometryNo;

        else return XtGeometryAlmost;
}


static void Wscrl(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
        ScrollWinInfo *p= (ScrollWinInfo *) call_data;
	TreeListWidget cw = (TreeListWidget) client_data;

	cw->treeList.topx = p->x;
	cw->treeList.topy = p->y;
	
	Redisplay((Widget)cw , NULL , NULL);	
}

/******************************************/

static void ActivateSingle(client_data , timer)
XtPointer  client_data;
XtIntervalId * timer;
{
	TreeListWidget cw = (TreeListWidget) client_data;

	cw->treeList.double_click_timer = (XtIntervalId) 0;

	if (cw->treeList.last_selected)
	{
		XtCallCallbackList((Widget) cw , cw->treeList.select_changed_cb ,
			(XtPointer) cw->treeList.last_selected);
	}	
}

static void ActivateDouble(w)
TreeListWidget w;
{
	TreeListWidget cw = (TreeListWidget) w;

	cw->treeList.double_click_timer = (XtIntervalId) 0;

	if (cw->treeList.last_selected)
	{
		if (cw->treeList.last_selected->expand_children)
		{
			CloseSubTree(w , cw->treeList.last_selected);
		}
		else
		{
			OpenSubTree(w , cw->treeList.last_selected);
		}

		XtCallCallbackList((Widget) cw , cw->treeList.select_changed_cb ,
			(XtPointer) cw->treeList.last_selected);

		XtCallCallbackList((Widget) cw , cw->treeList.select_cb ,
			(XtPointer) cw->treeList.last_selected);
	}

}

static void Activate(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	TreeListWidget cw = (TreeListWidget) w;
	TreeList *p;

	GetPositionEntry(w , event->xbutton.x - cw->treeList.topx , 
		event->xbutton.y - cw->treeList.topy , event , &p);

	if (p != cw->treeList.last_selected && cw->treeList.last_selected)
	{
                cw->treeList.last_selected->activated = False;
		TreeListEntryRedisplay(w , cw->treeList.last_selected , True , XtWindow(w));
	}

	cw->treeList.last_selected = p;

	if (!cw->treeList.last_selected)
	{
		if (cw->treeList.double_click_timer)
		{
			XtRemoveTimeOut(cw->treeList.double_click_timer);
			cw->treeList.double_click_timer = (XtIntervalId) 0;
		}
	}
	else
	{
                cw->treeList.last_selected->activated = True;
		TreeListEntryRedisplay(w , cw->treeList.last_selected , True , XtWindow(w));

		if (cw->treeList.double_click_timer)
		{
			XtRemoveTimeOut(cw->treeList.double_click_timer);
			cw->treeList.double_click_timer = (XtIntervalId) 0;
			ActivateDouble(w);
		}
		else
		{
			cw->treeList.double_click_timer = XtAppAddTimeOut(
				XtWidgetToApplicationContext(w), 
				(unsigned long) _DCtimeout ,
				ActivateSingle, (XtPointer) w);
		}
	}
}

static void ActivateKB(w)
TreeListWidget w;
{
	TreeListWidget cw = (TreeListWidget) w;

	if (cw->treeList.last_selected)
	{
		if (cw->treeList.last_selected->expand_children)
		{
			CloseSubTree(w , cw->treeList.last_selected);
		}
		else
		{
			OpenSubTree(w , cw->treeList.last_selected);
		}

		XtCallCallbackList((Widget) cw , cw->treeList.select_cb ,
			(XtPointer) cw->treeList.last_selected);
	}
}

static void Selecting (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	TreeListWidget cw = (TreeListWidget) w;
	TreeList *entry = NULL;

	GetYPositionEntry(w , event->xmotion.y - cw->treeList.topy , event , &entry);

	if (entry != cw->treeList.last_selected && cw->treeList.last_selected)
	{
		cw->treeList.last_selected->activated = False;

		TreeListEntryRedisplay(w , cw->treeList.last_selected ,
			True , XtWindow(w));
	}

	if (entry && entry != cw->treeList.last_selected)
	{
		cw->treeList.last_selected = entry;
		cw->treeList.last_selected->activated = True;

		TreeListEntryRedisplay(w , cw->treeList.last_selected ,
			True , XtWindow(w));

		XtCallCallbackList(w , cw->treeList.select_changed_cb ,
				(XtPointer) cw->treeList.last_selected);
	}

	cw->treeList.last_selected = entry;
}

static TreeList *getientry(w , entry , num)
Widget w;
TreeList *entry;
int num;
{
	TreeListWidget cw = (TreeListWidget) w;
        TreeList *p , *res;
	TreeList *p1,*p2,*pom;
	int i = 0;

	if (!entry) return cw->treeList.root;

	if (num >= 0)
	{
		p1 = p = entry;

		while (p1 != NULL && i < num)
		{
			if (p1->first_child != NULL && p1->expand_children)
			{
				p2 = p1->first_child;
			}
			else if (p1->neighbour == NULL)
			{
				if ((pom = p1->parent) != NULL)
				{
					while( pom->neighbour == NULL && pom->level != 0)
					{
						pom = pom->parent;
					}
					if (pom->level != 0) p2 = pom->neighbour;
					else p2 = NULL;
				}
				else p2 = NULL;
			
			}
			else
			{
				p2 = p1->neighbour;
			}
			p = p1;
			p1 = p2;
			i++;
		}
		if (!p1) p1 = p;
	}
	else
	{
		p1 = res = cw->treeList.root;

		while (p1 != NULL && entry != p1)
		{
			if (p1->first_child != NULL && p1->expand_children)
			{
				p2 = p1->first_child;
			}
			else if (p1->neighbour == NULL)
			{
				if ((pom = p1->parent) != NULL)
				{
					while( pom->neighbour == NULL && pom->level != 0)
					{
						pom = pom->parent;
					}
					if (pom->level != 0) p2 = pom->neighbour;
					else p2 = NULL;
				}
				else p2 = NULL;
			
			}
			else
			{
				p2 = p1->neighbour;
			}
			if (i == -num)
			{
				res = getientry(w , res , 1);
			}
			else
			{
				i++;
			}

			p = p1;
			p1 = p2;
		}

		p1 = res;
	}

	return p1;
}

static void Select (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	TreeListWidget cw = (TreeListWidget) w;
	TreeList *entry = NULL;
	int num;

	if (*num_params != 1)
	{
		XtWarning("Action 'select' called with wrong parameters count");
		return;
	}
	if (!cw->treeList.root) return;

	else
	{
		if ((! strcmp(params[0] , "next_page")) ||
		    (! strcmp(params[0] , "previous_page")))
		{
			if (cw->treeList.scrolled)
				XtCallActionProc(XtParent(w) , "select" , 
					event , params , 1);	
			return;
		}
		else if (! strcmp(params[0] , "next"))
		{
			entry = getientry(w , cw->treeList.last_selected , 1);
		}
		else if (! strcmp(params[0] , "previous"))
		{
			entry = getientry(w , cw->treeList.last_selected , -1);
		}
		else if (! strcmp(params[0] , "first"))
		{
			entry = cw->treeList.root;
		}
		else if (! strcmp(params[0] , "last"))
		{
			entry = getientry(w , cw->treeList.last_selected , 2000000);
		}
		else 
		{
			num = atoi(params[0]);
			if (errno == ERANGE)
			{
				XtWarning("Action 'select' called with wrong parameter");
				return;
			}
			entry = getientry(w , cw->treeList.last_selected , num);
		}
	}

	if (entry != cw->treeList.last_selected && cw->treeList.last_selected)
	{
		cw->treeList.last_selected->activated = False;

		TreeListEntryRedisplay(w , cw->treeList.last_selected ,
			True , XtWindow(w));
	}

	if (entry && entry != cw->treeList.last_selected)
	{
		cw->treeList.last_selected = entry;
		cw->treeList.last_selected->activated = True;

		TreeListEntryRedisplay(w , cw->treeList.last_selected ,
			True , XtWindow(w));

		XtCallCallbackList(w , cw->treeList.select_changed_cb ,
				(XtPointer) cw->treeList.last_selected);
	}

	cw->treeList.last_selected = entry;
}

/***********************************/

TreeList * TreeListInsertItem(w , parent , item)
Widget w;
TreeList *parent;
TreeListItem *item;
{

	if (item != NULL)
	{
		TreeListWidget cw = (TreeListWidget)w;
		TreeList *newp = (TreeList *) XtMalloc(sizeof(TreeList));
		TreeListItem *newi = (TreeListItem *) XtMalloc(sizeof(TreeList));
		TreeList *p;

		cw->treeList.internal_mode = True;

		*newi =  *item;
 		newi->label = XtNewString(item->label);

		newp->parent = parent;
		newp->first_child = NULL;
		newp->expand_children = True;
		newp->neighbour = NULL;
		newp->item = newi;
		newp->level = parent->level + 1;

		newp->x = cw->treeList.spacing + 
				newp->level * cw->treeList.section_distance;
		newp->y = -30;

		TreeListEntryInitialize(w , newp);
		
		if (parent->first_child)
		{
			for(p = parent->first_child ; p->neighbour != NULL ; 
				p = p->neighbour);
			p->neighbour = newp;
		}
		else
		{
			parent->first_child = newp;
		}

		if (cw->treeList.do_layout)
		{
			Layout(w,cw->treeList.root);
		}
		return newp;
	}
	else
	{
		return NULL;
	}
}

TreeList * TreeListSetNewRoot(w , item)
Widget w;
TreeListItem *item;
{

	if (item != NULL)
	{
		TreeListWidget cw = (TreeListWidget)w;
		TreeList *newp = (TreeList *) XtMalloc(sizeof(TreeList));
		TreeListItem *newi = (TreeListItem *) XtMalloc(sizeof(TreeList));

		*newi =  *item;
		newi->label = XtNewString(item->label);

		newp->parent = NULL;
		newp->first_child = NULL;
		newp->expand_children = True;
		newp->neighbour = NULL;
		newp->item = newi;
		newp->level = 0;

		newp->x = cw->treeList.spacing;
		newp->y = cw->treeList.spacing;

		TreeListEntryInitialize(w , newp);

		cw->treeList.root = newp;

		if (cw->treeList.do_layout)
		{
			cw->treeList.pos = 0;

			cw->treeList.node_height = cw->treeList.root->height;

			Layout(w,cw->treeList.root);
		}

		return newp;
		
	}
	return NULL;
}

void TreeListFreeSubTree(uzol)
TreeList *uzol;
{
	TreeList *p,*q;

	if (uzol != NULL)
	{
		for (p = uzol->first_child ; p != NULL ; p = q)
		{
			TreeListFreeSubTree(p);
			q = p->neighbour;
			FreeNode(p);
			
		}
		uzol->first_child = NULL;
	}
}

static void FreeTree(uzol)
TreeList *uzol;
{
	TreeList *p;

	if (uzol != NULL)
	{
		for (p = uzol->first_child ; p != NULL ; p = p->neighbour)
		{
			TreeListFreeSubTree(p);
		}
		FreeNode(uzol);
	}
}

static void FreeNode(uzol)
TreeList *uzol;
{
	XtFree((char *)uzol->item->label);
	XtFree((char *)uzol->item);
	XtFree((char *)uzol);
}

static void _Layout(w, node)
TreeListWidget w;
TreeList * node;
{
	TreeList *p;

	node->y = w->treeList.pos * w->treeList.node_height;

	w->treeList.width = MAX(w->treeList.width , node->x + node->width);

	w->treeList.pos ++;

	if (node->expand_children)
	{
		for ( p = node->first_child ; p != NULL ; p = p->neighbour)
		{
			_Layout(w , p);
		}
	}

}

static void Layout(w, node)
TreeListWidget w;
TreeList * node;
{
	int height , width;

	w->treeList.width = 0;
	w->treeList.pos = 0;
	w->treeList.node_height = w->treeList.root ? w->treeList.root->height : 0;

	if (w->treeList.root) _Layout(w, node);

	if (w->treeList.scrolled && XtIsRealized((Widget)w))
	{
		height = w->treeList.pos * w->treeList.node_height;
		width = w->treeList.width;

		SetScrollWin(XtParent(w) , XtCchild_height , height , 
		                           XtCchild_width , width , 0);
	}
}

static void GetPositionEntry(w , x , y , event , item)
Widget w;
int x;
int y;
XEvent *event;
TreeList **item;
{
        TreeListWidget cw = (TreeListWidget) w;
        Position _pomx , _pomy;
        Dimension _width , _height;
        int width,height;
        int pomx , pomy;
	PositionStruct pos;

	*item = NULL;

        if (XtWindow(w) != event->xany.window) return;

	treeListClassRec.base_class.get_internal_dimension(w , &_pomx , &_pomy , 
        	&_width , &_height);

	pomx = _pomx;
	pomy = _pomy;

	if (cw->treeList.scrolled)
	{
		width = cw->treeList.width;
		height = cw->treeList.pos * cw->treeList.node_height;
	}
	else
	{
		width = _width;
		height = _height;
        }


        if ((x < pomx) || (x > pomx + width) ||
        	(y < pomy) || (y > pomy + height)) return;

	pos.x = x;
	pos.y = y;

	cw->treeList.condition_struct = (void *)&pos;

	cw->treeList.found = NULL;

	FindTreeObject(cw , PositionCondition , cw->treeList.root);

	*item = cw->treeList.found;
}

static Boolean PositionCondition(w,item)
TreeListWidget w;
TreeList *item;
{
	if (!item->managed) return False;
	
	return (
	 BETWEEN(((PositionStruct *)(w->treeList.condition_struct))->x , 
	 	item->x , item->x + item->width) && 
	 BETWEEN(((PositionStruct *)(w->treeList.condition_struct))->y ,
	 	item->y , item->y + item->height));
	
}

static void GetYPositionEntry(w , y , event , item)
Widget w;
int y;
XEvent *event;
TreeList **item;
{
        TreeListWidget cw = (TreeListWidget) w;
        Position _pomx , _pomy;
        Dimension _width , _height;
        int width,height;
        int pomx , pomy;

	*item = NULL;

        if (XtWindow(w) != event->xany.window) return;

	treeListClassRec.base_class.get_internal_dimension(w , &_pomx , &_pomy , 
       		&_width , &_height);

	pomx = _pomx;
	pomy = _pomy;

	if (cw->treeList.scrolled)
	{
		width = cw->treeList.width;
		height = cw->treeList.pos * cw->treeList.node_height;
	}
	else
	{
		width = _width;
		height = _height;
        }
	
        if ((y < pomy) || (y > pomy + height)) return;

	cw->treeList.condition_struct = (void *)&y;

	FindTreeObject(cw , YPositionCondition , cw->treeList.root);

	*item = cw->treeList.found;
}

static Boolean YPositionCondition(w,item)
TreeListWidget w;
TreeList *item;
{
	if (!item->managed) return False;
	
	return (BETWEEN(*((int *)w->treeList.condition_struct) ,
	item->y , item->y + item->height));
}

static Boolean FindTreeObject(w , condition , item)
TreeListWidget w;
Boolean (* condition) ();
TreeList *item;
{
	TreeList *p;

	if (!item) return False;

	if (condition(w,item))
	{
		w->treeList.found = item;
		return True;
	}

	if (item->first_child ==  NULL)
	{
		w->treeList.found = NULL;
		return False;
	}
	
	for(p = item->first_child ; p != NULL ; p = p->neighbour)
	{
		if (FindTreeObject(w , condition , p))
		{
			return True;			
		}
	}

	return False;
}

static void UnmanageSubTree(w , item)
TreeListWidget w;
TreeList *item;
{
	TreeList *p;

	for(p = item->first_child ; p != NULL ; p = p->neighbour)
	{
		p->managed = False;
		if (!w->treeList.restore_state_on_open)
			p->expand_children = False;
		UnmanageSubTree(w , p);
	}
}

static void ManageSubTree(w , item)
TreeListWidget w;
TreeList *item;
{
	TreeList *p;

	for(p = item->first_child ; p != NULL ; p = p->neighbour)
	{
		p->managed = True;
		if (p->expand_children)
			ManageSubTree(w , p);
	}
}

void CloseSubTree(w , item)
TreeListWidget w;
TreeList *item;
{

	w->treeList.last_selected->expand_children = False;

	if (!item->first_child) return;

	XtUnmanageChild((Widget)w);

	if (w->treeList.delete_subtree_on_close)
	{
		w->treeList.internal_mode = True;
		TreeListFreeSubTree(item);
		w->treeList.internal_mode = False;
	}
	else
		UnmanageSubTree(w , item);

	XtManageChild((Widget)w);

	Layout(w,w->treeList.root);
}

void OpenSubTree(w , item)
TreeListWidget w;
TreeList *item;
{

	w->treeList.last_selected->expand_children = True;

	if (!item->first_child) return;

	XtUnmanageChild((Widget)w);

	ManageSubTree(w , item);

	XtManageChild((Widget)w);

	Layout(w,w->treeList.root);
}

TreeList *TreeListGetItemParent(w , item)
Widget w;
TreeList *item;
{
	return item->parent;
}

TreeList *TreeListGetSelectedItem(w)
Widget w;
{
	
	return ((TreeListWidget)w)->treeList.last_selected;
}

void TreeListDeleteItem(w , item)
Widget w;
TreeList *item;
{
	TreeListWidget cw = (TreeListWidget) w;
	TreeList *p , *prev;

	XtUnmanageChild((Widget)w);

	if(item->first_child)
		TreeListFreeSubTree(item);

	if (item->parent)
	{
		if (item->parent->first_child == item)
		{
			item->parent->first_child = item->neighbour;
			FreeNode(item);
		}
		else
		{
			prev = NULL;
			for (p = item->parent->first_child ; p != NULL ; p = p->neighbour)
			{
				if (p == item)
				{
					prev->neighbour = p->neighbour;
					FreeNode(p);
				}
				prev = p;
			}
		}
	}
	else
	{
		cw->treeList.root = NULL;
		FreeNode(item);
	}

	XtManageChild((Widget)w);

	if (cw->treeList.root)
	{
		Layout(w,cw->treeList.root);
	}
}

static Boolean IDCondition(w,item)
TreeListWidget w;
TreeList *item;
{

	return (item->item->id == 
		*((long*) (((TreeListWidget) w)->treeList.condition_struct)));

}

TreeList * TreeListGetItemByID(w , id)
Widget w;
long id;
{
	TreeListWidget cw = (TreeListWidget) w;

	cw->treeList.condition_struct = (void *)&id;
	cw->treeList.found = NULL;
	FindTreeObject(cw , IDCondition , cw->treeList.root);

	return cw->treeList.found;
}

void TreeListDontDoLayout(w)
Widget w;
{
	TreeListWidget cw = (TreeListWidget) w;

	cw->treeList.do_layout = False;
}

void TreeListDoLayout(w)
Widget w;
{
	TreeListWidget cw = (TreeListWidget) w;
	XtWidgetGeometry request,reply;

	cw->treeList.do_layout = True;

	cw->treeList.pos = 0;
	
	if (cw->treeList.root)
	{
		cw->treeList.pos = 0;

		cw->treeList.node_height = cw->treeList.root->height;

		Layout(w,cw->treeList.root);
	}
	
	QueryGeometry(w , &reply , &request);
	XtMakeGeometryRequest(w , &request , &reply);
}

static void TreeListEntryRedisplay(w , entry , chback , win)
Widget w;
TreeList *entry;
Boolean chback;
Drawable win;
{
	TreeListWidget cw = (TreeListWidget) w;
	int x,y,width,height,textx;
	Display *dpy = XtDisplay(w);

	x = cw->base.box_width;
	y = cw->base.box_width;
	height = entry->height - y;
	width = entry->width - y;

	if (entry->activated)
		XSetForeground(dpy , cw->treeList.gc , cw->treeList.selected_bg);
	else
		XSetForeground(dpy , cw->treeList.gc , cw->core.background_pixel);
		
	if (chback || entry->activated)
		XFillRectangle(dpy , win , cw->treeList.gc ,
			entry->x + cw->treeList.topx , entry->y + cw->treeList.topy, 
			entry->width , entry->height );

	if (entry->activated)
		X_DrawSimple3DFrame(dpy , win , entry->x + cw->treeList.topx , 
				entry->y + cw->treeList.topy , entry->width , 
				entry->height , cw->base.box_width ,
				cw->base.light , cw->base.dark);

	if (entry->item->icon)
		X_DrawIcon(dpy , win , entry->item->icon , x + entry->x + 
			cw->treeList.topx + cw->treeList.spacing ,
			y + entry->y + cw->treeList.topy +
			(height - entry->item->icon->height) / 2);

	if (!entry->item->label) return;

	textx = x + entry->x + cw->treeList.spacing; 
	
	if (entry->item->icon) 
		textx += cw->treeList.spacing + entry->item->icon->width;

	if (entry->activated)
		XSetForeground(dpy , cw->treeList.gc , cw->treeList.selected_fg);
	else
		XSetForeground(dpy , cw->treeList.gc , cw->base.foreground);
		
	XDrawString(dpy , win , cw->treeList.gc ,
		textx + cw->treeList.topx , y + entry->y + cw->treeList.topy +
		(height - (cw->treeList.font->max_bounds.ascent +
		cw->treeList.font->max_bounds.descent)) / 2 +
		cw->treeList.font->max_bounds.ascent ,
		entry->item->label , strlen(entry->item->label));

	if (!entry->sensitive)
	{
		XSetFillStyle(dpy , cw->treeList.gc , FillStippled);
		XSetForeground(dpy , cw->treeList.gc , cw->core.background_pixel);

		XFillRectangle(dpy , win , cw->treeList.gc ,
			entry->x + cw->treeList.topx , entry->y + cw->treeList.topy, 
			entry->width , entry->height );

		XSetFillStyle(dpy , cw->treeList.gc , FillSolid);
	}
}

static void TreeListEntryInitialize(w , entry)
Widget w;
TreeList *entry;
{
	TreeListWidget cw = (TreeListWidget) w;

	entry->width = 0;
	entry->height = 0;
	entry->activated = False;
	entry->managed = True;
	entry->sensitive = True;

	if (entry->item->label)
	{
		entry->width = XTextWidth(cw->treeList.font , entry->item->label , 
			strlen(entry->item->label)) + 2 * cw->treeList.spacing;

		entry->height = cw->treeList.font->max_bounds.ascent +
                        cw->treeList.font->max_bounds.descent + 2 *
			cw->treeList.spacing;

	}
	if (entry->item->icon)
	{

		entry->width += entry->item->icon->width + cw->treeList.spacing +
				cw->treeList.spacing * (entry->item->label == NULL);

		entry->height = MAX(entry->height ,
			2*cw->treeList.spacing + entry->item->icon->height);
	}
}

void TreeListItemSetIcon(w , entry , icon)
Widget w;
TreeList *entry;
Icon *icon;
{
	Boolean r = True;
	TreeList *p;
	TreeListWidget cw = (TreeListWidget) w;

	entry->item->icon = icon;

	entry->width = 0;

	if (entry->item->label)
	{
		entry->width = XTextWidth(cw->treeList.font , entry->item->label , 
			strlen(entry->item->label)) + 2 * cw->treeList.spacing;

		entry->height = cw->treeList.font->max_bounds.ascent +
                        cw->treeList.font->max_bounds.descent + 2 *
			cw->treeList.spacing;

	}

	if (entry->item->icon)
	{

		entry->width += entry->item->icon->width + cw->treeList.spacing +
				cw->treeList.spacing * (entry->item->label == NULL);

		entry->height = MAX(entry->height ,
			2*cw->treeList.spacing + entry->item->icon->height);
	}


	if (!XtIsRealized(w)) return;

	p = entry->parent;
	while(p && r)
	{
		r = r && p->expand_children && p->managed;
		p = p->parent;
	}

	if (r)
		TreeListEntryRedisplay(w , entry , True , XtWindow(w));

}

void TreeListItemSetSensitive(w , entry , sensitive)
Widget w;
TreeList *entry;
Boolean sensitive;
{
	if (entry->sensitive == sensitive) return;

	entry->sensitive = sensitive;
	TreeListEntryRedisplay(w , entry , True , XtWindow(w));
	
}
