/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <time.h>
#include <limits.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "config.h"

#ifdef HAVE_DBOPEN

#if HAVE_DB1_H
#include <db1/db.h>
#else
#include <db.h>
#endif

typedef int int32;
typedef unsigned int uint32;

#ifdef WORDS_BIGENDIAN
#define COPY_INT32(i1,i2) \
    ((char *)(i1))[0] = ((char *)(i2))[3];\
    ((char *)(i1))[1] = ((char *)(i2))[2];\
    ((char *)(i1))[2] = ((char *)(i2))[1];\
    ((char *)(i1))[3] = ((char *)(i2))[0]; 
#else
#define COPY_INT32(i1,i2)  i1 = i2;
#endif

static char *ns_cache_filename = NULL;
static DB *ns_cache_db = NULL;

void ns_cache_open_db(dirname)
char *dirname;
{
	bool reopen = FALSE;
	HASHINFO hash_info = {
		4*1024,  /* bucket size */
		0,        /* fill factor */
		0,        /* number of elements */
		96*1024,  /* bytes to cache */
		0,        /* hash function */
		0};       /* byte order */
	char pom[PATH_MAX];


	if (dirname)
	{
		sprintf(pom , "%s/index.db" , dirname);

		if (!ns_cache_filename || strcmp(pom , ns_cache_filename)) 
			reopen = TRUE;
	}
	else
	{
		_free(ns_cache_filename);
		if (ns_cache_db)
			ns_cache_db->close(ns_cache_db);
		ns_cache_db = NULL;
	}


	if (reopen)
	{
		ns_cache_db = dbopen(pom , O_RDONLY, 0600 , DB_HASH , &hash_info);

		if (!ns_cache_db)
		{
			xprintf(0 , gettext("Unable to open Netscape cache index - %s\n") , pom);
		}
		_free(ns_cache_filename);
		ns_cache_filename = new_string(pom);
	}
}

static void ns_cache_gen_key(key , urlstr)
DBT *key;
char *urlstr;
{
	int size;
	char *tmp;

	size = sizeof(int32); 		/* check sum */
	size += sizeof(int32);		/* size of urlstr */
	size += strlen(urlstr)+1;	/* urlstr */
	size += sizeof(int32);		/* post data */

	key->size = size;
	key->data = (void *)malloc(size);

	tmp = key->data;

	COPY_INT32(*(int32 *)tmp,size);
	tmp += sizeof(int32);

	COPY_INT32(*(int32 *)tmp,strlen(urlstr)+1);
	tmp += sizeof(int32);

	strcpy(tmp , urlstr);
	tmp += strlen(urlstr)+1;

	COPY_INT32(*(int32 *)tmp,0);
	tmp += sizeof(int32);
}

static char *ns_cache_get_filename(data)
DBT *data;
{
	char *tmp = data->data;

	tmp += sizeof(int32) 		/* size */
		+ sizeof(int32) 	/* version */
		+ sizeof(time_t)	/* last_modified */
		+ sizeof(time_t)	/* last_accessed */
		+ sizeof(time_t)	/* expires */
		+ sizeof(uint32)	/* content_length */
		+ sizeof(bool)		/* is_netsite */
		+ sizeof(time_t)	/* lock_date */
		+ sizeof(int32)		/* size of filename */
		;

	return tmp;
}

char * ns_cache_find_localname(urlstr)
char *urlstr;
{
	DBT key,data;
	char *retv = NULL;

	if (!ns_cache_db) return NULL;

	ns_cache_gen_key(&key , urlstr);

	if (!ns_cache_db->get(ns_cache_db, &key , &data , 0))
	{
		retv = new_string(ns_cache_get_filename(&data));
	}

	_free(key.data);

	return retv;
}

#endif

