/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _re_h_
#define _re_h_

#ifdef HAVE_REGEX
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif
#ifdef HAVE_POSIX_REGEX

typedef struct {
	regex_t	preg;
	char	*pattern;
} re_entry;

#endif
#ifdef HAVE_V8_REGEX
#ifndef NSUBEXP
#include <regexp.h>
#endif

typedef struct {
	regexp	*preg;
	char	*pattern;
} re_entry;

#endif
#ifdef HAVE_BSD_REGEX
typedef struct {
	char	*pattern;
} re_entry;
#endif
#ifdef HAVE_GNU_REGEX
typedef struct {
	struct re_pattern_buffer preg;
	char	*pattern;
} re_entry;
#endif

extern void re_free(re_entry *);
extern re_entry *re_make(char *);
extern int re_pmatch(re_entry *, char *);

#endif
#endif

