/************ start of %M% **************************************/

/******* description ***********************************************
*
*		Posix Timer functions
*
*******************************************************************/

#ifndef __X_TIMERS
#define __X_TIMERS __X_TIMERS

#ifdef	_AIX
#ifndef	HAVE_TIMER_CREATE

#include <signal.h>
#ifdef	HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#ifdef	HAVE_TIME_H
#ifdef	TIME_WITH_SYS_TIME
#include <time.h>
#endif
#endif
#ifdef	HAVE_SYS_TIMERS_H
#include <sys/timers.h>
#endif

#define	TIMER_ABSTIME		1
#define	TIMER_ADDREL		(TIMER_ABSTIME << 1)
#define	_TIMER_PRESERVE_EXEC	(TIMER_ABSTIME << 2)

#define	sigev_signo	sevt_signo

#define	clock_getres(id, res)	restimer((id), (res), &_local_timer_ptr_)

#ifndef	CLOCK_REALTIME
#define	CLOCK_REALTIME	0
#endif

#ifndef	HAVE_STRUCT_SIGEVENT
struct sigevent {
  signal_t	sigev_signo;
};
#endif

static struct timespec	_local_timer_ptr_;

typedef	int	clockid_t;

#ifdef	__cplusplus
extern	"C"	{
#endif

extern	timer_t	timer_create(clockid_t, struct sigevent *);
extern	int	timer_delete(timer_t);
extern	int	timer_gettime(timer_t, struct itimerspec *);
extern	int	timer_settime(timer_t, int, struct itimerspec *,
						struct itimerspec *);
extern	int	clock_gettime(clockid_t, struct timespec *);

#ifdef	__cplusplus
}
#endif

#endif	/* !defined(HAVE_TIMER_CREATE) */
#endif

#endif	/* __X_TIMERS */

/************ end of %M% **************************************/
