/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"maildirfilter.h"
#include	"maildirfilterconfig.h"
#include	"maildircreate.h"
#include	<stdlib.h>
#include	<string.h>
#include	<stdio.h>
#include	<ctype.h>
#include	<errno.h>
#if	HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: maildirfilter2.c,v 1.3 2000/12/02 05:38:53 mrsam Exp $";

static const char *mf_config(const char *maildir,
	const char *varname)
{
char *p=malloc(strlen(maildir)+sizeof("/maildirfilterconfig"));
FILE	*f;
static char configbuf[256];

	if (!p)	return (0);

	strcat(strcpy(p, maildir), "/maildirfilterconfig");
	f=fopen(p, "r");
	free(p);

	if (!f)	f=fopen(MAILDIRFILTERCONFIG, "r");
	if (!f)	return (0);

	while ((p=fgets(configbuf, sizeof(configbuf), f)) != 0)
	{
		if ((p=strchr(configbuf, '\n')) != 0)	*p=0;
		p=strchr(configbuf, '=');
		if (!p)	continue;
		*p++=0;
		if (strcmp(configbuf, varname) == 0)
		{
			fclose(f);
			return (p);
		}
	}
	fclose(f);
	return ("");
}

static char *mf_config_maildirfilter(const char *maildir)
{
const char *p=mf_config(maildir, "MAILDIRFILTER");
char *q;

	if (!p)	return (0);
	if (*p == 0)
	{
		errno=ENOENT;
		return (0);
	}

	q=malloc(strlen(maildir)+strlen(p)+2);
	*q=0;
	if (*p != '/')
		strcat(strcpy(q, maildir), "/");
	strcat(q, p);
	return (q);
}

int mf_importmaildirfilter(const char *maildir)
{
const char *p=mf_config(maildir, "MAILDIRFILTER");
char *maildirfilter;
char *tmpname, *newname;
FILE *i, *o;
int rc;

	if (!p)	return (-1);

	if (!*p)
	{
		errno=ENOENT;
		return (-1);
	}

	maildirfilter=mf_config_maildirfilter(maildir);
	if (!maildirfilter)	return (-1);

	for (;;)
	{
		rc=maildir_try_create(maildir, "maildirfilter-tmp", 0,
			&tmpname, &newname);
                if (rc < 0)
                {
			free(maildirfilter);
                        return (-1);
                }

		if (rc == 0)	break;
		sleep(3);
	}

	strcat(strcpy(newname, maildir), "/maildirfilter.tmp");

	if ((i=fopen(maildirfilter, "r")) == 0)
	{
	struct	maildirfilter mf;

		if (errno != ENOENT)
		{
			free(tmpname);
			free(newname);
			free(maildirfilter);
			return (-1);
		}
		unlink(newname);

		memset(&mf, 0, sizeof(mf));
		mf_savemaildirfilter(&mf, maildir, "");
		/* write out a blank one */
	}
	else
	{
	char	buf[BUFSIZ];
	int	n;

		if ((o=fopen(tmpname, "w")) == 0)
		{
			fclose(i);
			free(tmpname);
			free(newname);
			free(maildirfilter);
			return (-1);
		}

		while ((n=fread(buf, 1, sizeof(buf), i)) > 0)
			if (fwrite(buf, 1, n, o) != n)
			{
				fclose(o);
				fclose(i);
				free(tmpname);
				free(newname);
				free(maildirfilter);
				return (-1);
			}
		if (fflush(o))
		{
			fclose(o);
			fclose(i);
			free(tmpname);
			free(newname);
			free(maildirfilter);
			return (-1);
		}
		fclose(o);
		fclose(i);
		if (chmod(tmpname, 0600) || rename(tmpname, newname))
		{
			free(tmpname);
			free(newname);
			free(maildirfilter);
			return (-1);
		}
	}

	free(tmpname);
	free(newname);
	free(maildirfilter);
	return (0);
}

int mf_loadmaildirfilter(struct maildirfilter *mf, const char *maildir)
{
char *newname=malloc(strlen(maildir)+sizeof("/maildirfilter.tmp"));
int	rc;

	if (!newname)	return (-1);
	strcat(strcpy(newname, maildir), "/maildirfilter.tmp");

	rc=mf_loadrules(mf, newname);
	free(newname);
	if (rc && rc != MF_LOADNOTFOUND)
		rc= -1;
	else
		rc=0;
	return (rc);
}


int mf_savemaildirfilter(struct maildirfilter *mf, const char *maildir,
			 const char *from)
{
const char *maildirpath=mf_config(maildir, "MAILDIR");
char *tmpname, *newname;
int	rc;

	if (!maildirpath || !*maildirpath)
	{
		errno=EINVAL;
		return (-1);
	}

	for (;;)
	{
		rc=maildir_try_create(maildir, "maildirfilter-tmp", 0,
			&tmpname, &newname);
                if (rc < 0)
                {
                        return (-1);
                }

		if (rc == 0)	break;
		sleep(3);
	}

	strcat(strcpy(newname, maildir), "/maildirfilter.tmp");

	rc=mf_saverules(mf, tmpname, maildir, maildirpath, from);
	if (rc == 0 && rename(tmpname, newname))
		rc= -1;
	free(tmpname);
	free(newname);
	return (rc);
}

int mf_exportmaildirfilter(const char *maildir)
{
char *maildirfilter=mf_config_maildirfilter(maildir);
char *newname;
int	rc;

	if (!maildirfilter)	return (-1);

	newname=malloc(strlen(maildir)+sizeof("/maildirfilter.tmp"));
	if (!newname)
	{
		free(maildirfilter);
		return (-1);
	}

	strcat(strcpy(newname, maildir), "/maildirfilter.tmp");
	rc=rename(newname, maildirfilter);
	free(maildirfilter);
	free(newname);
	return (rc);
}

int mf_hasmaildirfilter(const char *maildir)
{
const char *p=mf_config(maildir, "MAILDIR");

	if (!p || !*p)	return (-1);

	p=mf_config(maildir, "MAILDIRFILTER");
	if (!p || !*p)	return (-1);
	return (0);
}

void mf_endmaildirfilter(const char *maildir)
{
char *maildirfilter=mf_config_maildirfilter(maildir);
char *newname;

	if (!maildirfilter)	return;

	newname=malloc(strlen(maildir)+sizeof("/maildirfilter.tmp"));
	if (!newname)
	{
		free(maildirfilter);
		return;
	}

	strcat(strcpy(newname, maildir), "/maildirfilter.tmp");
	unlink(newname);
	free(maildirfilter);
	free(newname);
}
