#include <string>
#include <iostream>
#include <ace/Log_Msg.h>
#include <ace/Synch.h>

class DBHostConfig;
class DBBalancerConfig;

class DBPostgresBackend {

public:

  DBPostgresBackend(DBBalancerConfig *config, DBHostConfig* host);
  ~DBPostgresBackend();

  // Private members reading

  inline int getSocket() { return _be_socket; }
  inline string getUser() { return _user; }
  inline string getPassword() { return _password; }
  inline string getDb() { return _db; }
  inline string getHost() { return _host; }
  inline int getPort() { return _port; }

  inline char *getKeyPointer() { return _secret_key_response; }
  inline char *getBufferPointer() { return _buffer; }
  inline int getKeySize() { return sizeof(_secret_key_response); }
  inline int getBufferSize() { return sizeof(_buffer); }

  inline bool getState() { return _state; }
  inline int getBufferFilling() { return _buffer_filling; }
  inline string getId() { return _id; }
 
  // Private members writing
 
  inline void setBufferFilling(int filling) { _buffer_filling = filling; }
  inline void setSocket(int socket) { _be_socket = socket; }
  inline void setKey(char *key, int size) { memcpy(_secret_key_response,key,size); }
  inline bool setState(int state) { return (_state = state); }
  inline void setId(string id) { _id = id; }

  // Do things

  // Inits a backend, doing auth with him.
  bool startUp();
  // Unconditionally read response from BE, appending to buffer.
  unsigned int read();
  // "select" and then read response from BE, in the beggining of the buffer
  unsigned int syncRead();
  // Writes command to a BE waiting for response.
  unsigned int writeSyncCommand(string command);
  // Writes command to a BE without waiting for response.
  unsigned int writeAsyncCommand(string command);
  // Sends data to a FE socket (when BE has data and is told to write)
  unsigned int writeForward(int fe_socket, int size);  
  // Sends data to a FE socket (when BE has data and is told to write)
  inline void resetBuffer() { _buffer_filling = 0;} ;
  // Tests the connection to see if the other side is ok();
  bool testConnection();
  // Recover connection in case it's needed.
  bool recoverConnection();
  // Dump textual info about the internal state.
  void dump();

  // R/W results

  const static unsigned int BUFF_DATA = 0;
  const static unsigned int BUFF_MORE = 1;
  const static unsigned int READ_EXCEPTION = 2;
  const static unsigned int WRITE_EXCEPTION = 3;
  const static unsigned int READ_OK = 4;

 // Auth Modes 

  const static unsigned int TRUSTED_AUTH_MODE = 0;
  const static unsigned int PLAINTEXT_PASSWORD_AUTH_MODE = 3;

private:

  int getSocketConnection(string host, int port);
  int getInetSocketConnection(string host, int port);
  int getUnixSocketConnection(string unixSocketBasePath, int port);

  const static unsigned int BUFFER_SIZE = 2048;
  const static unsigned int SEND_FLAGS = 0;
  const static unsigned int RECV_FLAGS = 0;

  // These values will have to be matched to what the OS
  // returns...
  const static int NO_DATA_IN_SOCKET = -1;         // ... after making an O_NONBLOCK recv with no data.
  const static int BROKEN_SOCKET_CONNECTION = 40;  // ... after making an O_NONBLOCK recv with no connection.

  // Private attributes.
  string _id;

  // BE connection data.
  int _be_socket;
  string _user;
  string _password;
  string _db;
  string _host;
  int _port;
  string _unixSocketBasePath;

  // Connection state
  char _buffer[BUFFER_SIZE];
  char _secret_key_response[10];

  int _buffer_filling;
  bool _state;



};

