// Copyright (c) 2000 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#include "mq3d.h"

#include <qapplication.h>

#include <signal.h>


void sighandler(int s)
{
    switch (s) {
    case SIGINT:
    case SIGTERM:
	qWarning("MQ3d: got signal %d, shutting down.", s);
	qApp->quit();
	break;

    case SIGSEGV:
	qWarning("MQ3d: crashing on signal %d.", s);
	abort();
	break;
    }
}


int main(int argc, char **argv)
{
    signal(SIGINT, sighandler);
    signal(SIGTERM, sighandler);
    signal(SIGSEGV, sighandler);

    QApplication mq3dapp(argc, argv, FALSE); // not a gui application
    // TODO: check for -regenerate commandline
    MQ3d mq3d(TRUE);

    if (mq3d.error())
	return 1;

    return mq3dapp.exec();
}

