// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#include "dragobjects.h"
#include "group.h"
#include "song.h"

#include <qbuffer.h>
#include <qdom.h>


GroupDrag::GroupDrag(Group *group, QWidget *source, const char *name)
    : QStoredDrag("application/x-mq3-group", source, name)
{
    QBuffer buffer;

    if (buffer.open(IO_WriteOnly)) {
	QTextStream ts(&buffer);
	ts.setEncoding(QTextStream::UnicodeUTF8);

	ts << "<!DOCTYPE MQ3-GroupDrag>" << endl << "<groupdrag>" << endl;
	group->xmlDescription(ts);
	ts << "</groupdrag>" << endl;

	buffer.close();
    }

    setEncodedData(buffer.buffer());
}

bool GroupDrag::canDecode(QMimeSource *e)
{
    return e->provides("application/x-mq3-group");
}

bool GroupDrag::decode(QMimeSource *source, Group *parent)
{
    QBuffer buffer(source->encodedData("application/x-mq3-group"));
    if (! buffer.open(IO_ReadOnly))
	return false;

    QDomDocument doc;
    if (! doc.setContent(&buffer))
	return false;

    if (doc.firstChild().toElement().tagName() != "groupdrag")
	return false;

    QDomElement e = doc.firstChild().toElement().firstChild().toElement();

    while (! e.isNull()) {
	(void) Group::create(parent, e);

	e = e.nextSibling().toElement();
    }

    buffer.close();

    return true;
}

SongDrag::SongDrag(Song *song, QWidget *source, const char *name)
    : QStoredDrag("application/x-mq3-song", source, name)
{
    QBuffer buffer;

    if (buffer.open(IO_WriteOnly)) {
	QTextStream ts(&buffer);
	ts.setEncoding(QTextStream::UnicodeUTF8);

	ts << "<!DOCTYPE MQ3-SongDrag>" << endl << "<songdrag>" << endl;
	song->xmlDescription(ts);
	ts << "</songdrag>" << endl;

	buffer.close();
    }

    setEncodedData(buffer.buffer());
}

bool SongDrag::canDecode(QMimeSource *e)
{
    return e->provides("application/x-mq3-song");
}

bool SongDrag::decode(QMimeSource *source, Group *parent)
{
    QBuffer buffer(source->encodedData("application/x-mq3-song"));
    if (! buffer.open(IO_ReadOnly))
	return false;

    QDomDocument doc;
    if (! doc.setContent(&buffer))
	return false;

    if (doc.firstChild().toElement().tagName() != "songdrag")
	return false;

    QDomElement e = doc.firstChild().toElement().firstChild().toElement();

    if (! e.isNull())
	(void) Song::create(parent, e);

    buffer.close();

    return true;
}
