/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkSCalendar Copyright (C) 1998 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_SCALENDAR_H__
#define __GTK_SCALENDAR_H__


#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_SCALENDAR(obj)          GTK_CHECK_CAST (obj, gtk_scalendar_get_type (), GtkSCalendar)
#define GTK_SCALENDAR_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_scalendar_get_type (), GtkSCalendarClass)
#define GTK_IS_SCALENDAR(obj)       GTK_CHECK_TYPE (obj, gtk_scalendar_get_type ())


typedef struct _GtkSCalendar       GtkSCalendar;
typedef struct _GtkSCalendarClass  GtkSCalendarClass;

struct _GtkSCalendar
{
	GtkMisc		misc;

	guint		day;
	guint		month;
	guint		year;

	guint		spacing;

	gboolean	show_month_year;

	gchar		**day_names;
	gchar		**month_names;

	gint		base;
};

struct _GtkSCalendarClass
{
	GtkMiscClass parent_class;

	void (* changed) (GtkSCalendar *scalendar);
};

guint		gtk_scalendar_get_type		(void);
GtkWidget*	gtk_scalendar_new		(gchar **day_names , 
						 gchar **month_names);
gint		gtk_scalendar_set_date		(GtkSCalendar *scalendar , 
						 gint day , 
						 gint month , 
						 gint year);
gint 		gtk_scalendar_show_month_label	(GtkSCalendar *scalendar, 
						 gint show);



#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_SCALENDAR_H__ */
