/* $Id: suidgetfd.C,v 1.6 2001/02/07 07:48:01 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "sfsmisc.h"
#include "sfsagent.h"

static int
recvfd (int fd)
{
  int nfd = -1;
  char c;
  readfd (fd, &c, 1, &nfd);
  return nfd;
}

int
suidgetfd (str prog)
{
  int fds[2];
  if (socketpair (AF_UNIX, SOCK_STREAM, 0, fds) < 0)
    return -1;
  close_on_exec (fds[0]);

  str path = fix_exec_path ("suidconnect");
  char *av[] = { "suidconnect", const_cast<char *> (prog.cstr ()), NULL };
  if (spawn (path, av, fds[1]) == -1) {
    close (fds[0]);
    close (fds[1]);
    return -1;
  }
  close (fds[1]);
  
  int fd = recvfd (fds[0]);
  close (fds[0]);
  return fd;
}

int
suidgetfd_required (str prog)
{
  int fds[2];
  if (socketpair (AF_UNIX, SOCK_STREAM, 0, fds) < 0)
    fatal ("socketpair: %m\n");
  close_on_exec (fds[0]);

  str path = fix_exec_path ("suidconnect");
  char *av[] = { "suidconnect", const_cast<char *> (prog.cstr ()), NULL };
  if (spawn (path, av, fds[1]) == -1)
    fatal << path << ": " << strerror (errno) << "\n";
  close (fds[1]);
  
  int fd = recvfd (fds[0]);
  if (fd < 0) {
    warn << "are you sure " << path << " is setgid?\n";
    fatal ("could not suidconnect for %s\n", prog.cstr ());
  }
  close (fds[0]);
  return fd;
}
