// uncomment this for java <= 1.3
//import com.sun.net.ssl.*;

import thinlet.*;
import java.util.Date;
import java.awt.Font;
import java.net.*;

// jsse
import javax.net.ssl.*;
import java.security.Security;
import java.security.cert.*;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.util.Vector;
/** @file
 *  this is the main class of the thinletclient.
 *  information about the thinlet engine can be found at www.thinlet.com
 */

/** the main class.
 *  this class contains nearly all of the code at the moment
 */
public class fireflier extends Thinlet {
    Vector conns; ///< currently known connections (monitoring subsystem)
    /** possible states of a connection. Unknown is currently used by UDP as
     this is a connectionless protocol
     */
    public static final String STATES[]={ "Invalid", "Unknown", "Opening", "Active", "Closing", "Closed" }; 
    /** Strings for the known protocols.
     *  These strings are needed to have an useful value for the user
     */
    public static final String PROTOCOL[]={ "Unknown", "ICMP", "Unknown", "Unknown", "Unknown", "Unknown"
    , "TCP", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"
    , "Unknown", "Unknown", "Unknown", "UDP", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"
    , "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"
    , "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"
    , "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "GRE"};

    /** Strings for the known ICMP Types
     *  These strings are needed to have an useful value for the user
     */
    public static final String[] ICMP_TYPES={"ECHO_REPLY", "UNKNOWN", "UNKNOWN", "DEST_UNREACH", "SOURCE_QUENCH", "REDIRECT", "UNKNOWN", "UNKNOWN", "ECHO", "UNKNOWN", "UNKNOWN", "TIME_EXCEEDED", "PARAMETERPROB", "TIMESTAMP", "TIMESTAMP_REPLY", "INFO_REQUEST", "INFO_REPLY", "ADDRESS", "ADDRESS_REPLY"};

    /** for converting a number to hexadecimal format in an elegant way */
    public static final char[] HEX={'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /** is the client connected to the server */
    public boolean Connected;

    SSLSocket socket=null;

    // Connection to the server
    InputStream in=null; ///< for getting (encrypted) data from the server
    OutputStream out=null; ///< for sending (encrypted) data to the server

    lookupThread lookupThr; ///< this thread resolves the ip-addresses to hostnames

    int curMsglen=-1; ///< length of the message currently being parsed. maybe avoid having this global some time

    static String ServerIP="127.0.0.1"; ///< IP address of the server we want to connect to
    static String ServerPort="1133"; ///< Port where the server should be running on host ServerIP

    // used when working with iptables Dialog (needed for deletion of rules)
    int inputStart=-1; ///< where the input Chain starts in the rules array
    int forwardStart=-1; ///< where the forward Chain starts in the rules array
    int outputStart=-1; ///< where the output Chain starts in the rules array

    Object about_dialog=null;
    Object login_dialog=null;

    boolean viewmonitoring; ///< is viewmonitoring activated?
    boolean monitoring; ///< is monitoring activated
    boolean show_inactive; ///< show inactive connections in connection window?

    // for accepting connections ignoring unknown certificate
    // I do use the SSL libraries only for encrypting, not for validating
    // the identity
    class MyX509TrustManager implements X509TrustManager
    {
        // for java < java14
        public boolean isClientTrusted(java.security.cert.X509Certificate[] chain){ return true;}
        public boolean isServerTrusted(java.security.cert.X509Certificate[] chain){ return true; }

        // for java14+
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain,java.lang.String client) {  }
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain,java.lang.String client) { }
        public X509Certificate[] getAcceptedIssuers() { return null; }
    }

    /** this thread does domain name lookups (IP->domain name)
     */
    class lookupThread implements Runnable {
        // ips which should be resolved
        private String srcip="dontrun";
        private String dstip="dontrun";
        private int mode;

        public lookupThread()
        {
        }

        /** set IPs to resolve. call this function if you want to resolve an
         *  address. The result is written to the correct field automatically
         *  This is not too beautiful, but it works asynchronously.
         *  We could maybe pass the Object where the result should be stored to
         *  @param amode where the result is written to. (0=label_ip_src, 1=conn_label_ip_src)
         */
        public void lookup(String asrcip, String adstip, int amode)
        {
            srcip=asrcip;
            dstip=adstip;
            mode=amode;
        }

        /** main loop which resolves ips whenever a new one is found
         */
        public void run() // Connection to server
        {
            String lsrcip="";
            String ldstip="";
            int lmode;
            String result;

            while (srcip.equals("dontrun"))
            {
                try {
                    Thread.sleep(1000);
                }
                catch (InterruptedException ie)
                {
                }
            }

            while (true)
            {
                // lookup source ip
                try {
                    lsrcip=srcip;
                    lmode=mode;
//                    System.out.println("Looking up "+lsrcip);
                    InetAddress i=InetAddress.getByName(lsrcip);
                    result=i.getHostName();
                    // if deny or allow wasnt pressed meanwhile
                    if (srcip.equals(lsrcip))
                    {
                        if (mode==0)
                            setString(find("label_ip_src"), "text", result);
                        else
                            setString(find("conn_label_ip_src"), "text", result);
                        //			label_ip_src.setText(result);
                        srcip="";
                    }
                }
                catch (UnknownHostException uh)
                {
//                    System.out.println("Lookup error");
                }

                // lookup destination ip
                try {
                    ldstip=dstip;
//                    System.out.println("Looking up "+ldstip);
                    InetAddress i=InetAddress.getByName(ldstip);
                    result=i.getHostName();
                    // if deny or allow wasnt pressed meanwhile
                    if (ldstip.equals(dstip))
                    {
                        if (mode==0)
                            setString(find("label_ip_dst"), "text", result);
                        else
                            setString(find("conn_label_ip_dst"), "text", result);
                        //			label_ip_dst.setText(result);
                        dstip="";
                    }
                }
                catch (UnknownHostException uh)
                {
//                    System.out.println("Lookup error");
                }
                try {
                    while (srcip.equals(""))
                        Thread.sleep(1000);
                }
                catch (InterruptedException ie)
                {
                }

            }
        }
    }

    /** send a request to the server (mostly this one is used).
     *  should only be called on allow/deny.
     *  this function gets most of its information from the states of the
     *  various interface checkboxes directly.
     *  @param id 0=allow, 1=deny.
     */
    void sendmsg(int id)
    {
        byte[] msg=new byte[17];

//        System.out.println("Sending command "+id);

        // states of checkboxes are sent too.
        msg[0]=(byte)id;
        msg[1]=0;
        if (getBoolean(find("cb_this_packet"), "selected"))
            msg[2]=1;
        else if (getBoolean(find("cb_queued_packets"), "selected"))
            msg[2]=2;
        else
            msg[2]=3;

        msg[3]=(getBoolean(find("cb_ip_src"), "selected"))?(byte)1:(byte)0;
        msg[4]=(getBoolean(find("cb_ip_dst"), "selected"))?(byte)1:(byte)0;
        msg[5]=(getBoolean(find("cb_port_src"), "selected"))?(byte)1:(byte)0;
        msg[6]=(getBoolean(find("cb_port_dst"), "selected"))?(byte)1:(byte)0;
        msg[7]=(getBoolean(find("cb_interface_in"), "selected"))?(byte)1:(byte)0;
        msg[8]=(getBoolean(find("cb_interface_out"), "selected"))?(byte)1:(byte)0;
        msg[9]=(getBoolean(find("cb_mac_addr"), "selected"))?(byte)1:(byte)0;
        msg[10]=(getBoolean(find("cb_protocol"), "selected"))?(byte)1:(byte)0;
        msg[11]=(getBoolean(find("cb_conntrack"), "selected"))?(byte)1:(byte)0;
        msg[12]=(getBoolean(find("cb_programname"), "selected"))?(byte)1:(byte)0;
//        msg[13]=(getBoolean(find("cb_tcp_flags"), "selected"))?(byte)1:(byte)0;
//        msg[14]=(getBoolean(find("cb_icmp_type"), "selected"))?(byte)1:(byte)0;

        // the timeout values of the interface are translated to seconds
//        if (find("ch_timeout")!=null)
//            System.out.println("Found ch_timeout");
//        if (getSelectedItem(find("ch_timeout"))!=null)
//            System.out.println("Found ch_timeout selected item");
        if ((getInteger(find("ch_timeout"), "selected"))==0)
        {
            msg[13]=0; // reserved for timeout
            msg[14]=0;
            msg[15]=0;
            msg[16]=0;
        }
        else if ((getInteger(find("ch_timeout"), "selected"))==1)
        {
            msg[13]=0; // reserved for timeout
            msg[14]=0;
            msg[15]=1;
            msg[16]=(byte)224;
        }
        else if ((getInteger(find("ch_timeout"), "selected"))==2)
        {
            msg[13]=0; // reserved for timeout
            msg[14]=0;
            msg[15]=14;
            msg[16]=16;
        }
        else if ((getInteger(find("ch_timeout"), "selected"))==3)
        {
            msg[13]=0; // reserved for timeout
            msg[14]=1;
            msg[15]=81;
            msg[16]=(byte)128;
        }

        try
        {
            if (out!=null)
                out.write(msg);
        } catch (IOException io)
        {
            System.out.println("Could not send message");
        }
        // if a rule is inserted by the client and the iptables dialog is opened,
        // request the new iptables rules
        //        if ((iptables_dia!=null) && (id!=2) && (id!=6))
        //        {
        //            sendcmd(2);
        //        }
        // if a rule is inserted by the client and the userspace dialog is opened,
        // request the new userspace rules
        //        if ((userspace_dia!=null) && (id!=6) && (id!=2))
        //        {
        //            sendcmd(6);
        //        }
    }

    /** only send a short command. (for requesting rules and source)
     */
    void sendcmd(int id)
    {
        byte[] msg=new byte[2];

        msg[0]=(byte)id;
        msg[1]=0;
        try
        {
            if (out!=null)
                out.write(msg);
        } catch (IOException io)
        {
            System.out.println("Could not send message");
        }
    }

    /** send command (deleting iptables/userspace rules)
     */
    void sendmsg(int id, int chain, int rulenum)
    {
        byte[] msg=new byte[5];

        msg[0]=(byte)id;
        msg[1]=0;
        msg[2]=(byte)chain;
        msg[3]=(byte)(rulenum&255);
        msg[4]=(byte)(rulenum>>8);
        try
        {
            if (out!=null)
                out.write(msg);
        } catch (IOException io)
        {
            System.out.println("Could not send message");
        }
    }

    /** initialize the interface, parse the xml files, start the login
     */
    public fireflier() {
        show_inactive=true;
        lookupThr=new lookupThread();
        try {
            add(parse("fireflier.xml"));
        } catch (Exception exc) { exc.printStackTrace(); }
        try {
            if (login_dialog == null) {
                login_dialog = parse("login_dialog.xml");
            }
            add(login_dialog);
            setBoolean(find("login_dialog"), "enabled", true);
            //requestFocus(find(dialog, "b_find"));
        } catch (Exception exc) { exc.printStackTrace(); }

    }

    /** callback function, which is called whenever the users clicks a different tab.
     *  this function automatically requests connection data, activates the monitoring,
     *  gets iptables or userspace rules, ...
     *  the results to the request will be processed as they arrive by the receiving thread
     */
    public void tab_changed() {
        Object tab=find("mypane");
        if (tab==null)
        {
            System.out.println("Tab not found");
            return;
        }
        switch (getInteger(tab, "selected"))
        {
        case 0:
//            System.out.println("packet window");
            if (viewmonitoring)
            {
                sendcmd(13);
                viewmonitoring=false;
            }
            break;
/*        case 1:
            System.out.println("connection window");
            sendcmd(12);
            viewmonitoring=true;
            monitoring=true;
            setBoolean(find("conn_monitor"), "selected", true);
            break;*/
        case 1:
//            System.out.println("source window");
            setString(find("source_text"), "text", "");
            if (viewmonitoring)
            {
                sendcmd(13);
                viewmonitoring=false;
            }
            sendcmd(1);
            break;
        case 2:
            removeAll(find("iptables_list"));
//            System.out.println("iptables window");
            if (viewmonitoring)
            {
                sendcmd(13);
                viewmonitoring=false;
            }
            sendcmd(2);
            break;
        case 3:
            removeAll(find("userspace_list"));
//            System.out.println("userspace window");
            if (viewmonitoring)
            {
                sendcmd(13);
                viewmonitoring=false;
            }
            sendcmd(6);
            break;
        default:
            break;
        }
    }

    /** creates the login message and sends it to the server
     */
    public boolean send_login()
    {
        int len;
        byte msg[];
        String username=getString(find("login_username"), "text");
        String password=getString(find("login_password"), "text");

        // Send header
        len=username.length();
        len+=password.length();
        len+=6;
        msg=new byte[len];
        msg[0]=(byte)8; // auth message type
        msg[1]=0;

        // send username
        len=username.length();
        msg[2]=(byte)(len&255);
        msg[3]=(byte)(len>>8);
        byte[] tempmsg=username.getBytes();
        for (int i=0;i<tempmsg.length;i++)
            msg[i+4]=tempmsg[i];

        // send password
        int pos=username.length()+4;
        len=password.length();
        msg[pos]=(byte)(len&255);
        msg[pos+1]=(byte)(len>>8);
        tempmsg=password.getBytes();
        for (int i=0;i<tempmsg.length;i++)
            msg[pos+2+i]=tempmsg[i];

        // send message
        try {
            statusbar("Trying to log in - not yet connected to server");
            while (out==null)
            {
                try {
                    Thread.sleep(1000);
                }
                catch (InterruptedException ie)
                {
                }
            }
            statusbar("Trying to log in");
            out.write(msg);
        }
        catch (IOException io)
        {
            return false;
        }
        return true;
    }

    /** when a user clicks a connection this function is called to set the
     *  detail labels to the correct values
     */
    public void setConnLabels(String state, String birthday, String lastPacket, String protocol,
                              String ip_hostA, String ip_hostA_str, String port_hostA, String packetCount_hostA,
                              String amount_hostA, String lostAmount_hostA,  String rate_hostA,
                              String maxrate_hostA, String maxtime_hostA, String programname_hostA,
                              String ip_hostB, String ip_hostB_str, String port_hostB, String packetCount_hostB,
                              String amount_hostB, String lostAmount_hostB,  String rate_hostB,
                              String maxrate_hostB, String maxtime_hostB, String programname_hostB)
    {
        try {
            setString(find("conn_rate_src"), "text", "Rate="+rate_hostA);
            setString(find("conn_rate_dst"), "text", "Rate="+rate_hostB);
            setString(find("conn_birthday"), "text", ""+(new Date(Long.parseLong(birthday)*1000)).toString());
            setString(find("conn_transferred_src"), "text", "Bytes Transferred="+(Integer.parseInt(amount_hostA)));
            setString(find("conn_transferred_dst"), "text", "Bytes Transferred="+(Integer.parseInt(amount_hostB)));
            setString(find("conn_last_packet"), "text", "Last Packet: "+(new Date(Long.parseLong(lastPacket)*1000)).toString());
            setString(find("conn_label_lost_amount_src"), "text", "not analyzed="+lostAmount_hostA);
            setString(find("conn_label_lost_amount_dst"), "text", "not analyzed="+lostAmount_hostB);
            setString(find("conn_label_packets_src"), "text", "packets="+packetCount_hostA);
            setString(find("conn_label_packets_dst"), "text", "packets="+packetCount_hostB);
            setString(find("conn_cb_programname"), "text", "programname="+programname_hostA+" "+programname_hostB);
            setString(find("conn_cb_protocol"), "text", "Protocol="+protocol);
            // dont resolve if only a refresh of the connection is done.
            if (!getString(find("conn_cb_ip_src"), "text").equals("IP="+ip_hostA) ||
                !getString(find("conn_cb_ip_dst"), "text").equals("IP="+ip_hostB))
            {
                setString(find("conn_label_ip_src"), "text", "resolving...");
                setString(find("conn_label_ip_dst"), "text", "resolving...");
                lookupThr.lookup(ip_hostA_str, ip_hostB_str, 1);
            }
            setString(find("conn_cb_ip_src"), "text", "IP="+ip_hostA);
            setString(find("conn_cb_ip_dst"), "text", "IP="+ip_hostB);
            setString(find("conn_cb_port_src"), "text", "PORT="+port_hostA);
            setString(find("conn_cb_port_dst"), "text", "PORT="+port_hostB);
            setString(find("conn_label_maxrate_src"), "text", "Maximum rate="+maxrate_hostA);
            setString(find("conn_label_maxtime_src"), "text", "  happened at "+(new Date(Long.parseLong(maxtime_hostA)*1000)).toString());
            setString(find("conn_label_maxrate_dst"), "text", "Maximum rate="+maxrate_hostB);
            setString(find("conn_label_maxtime_dst"), "text", "  happened at "+(new Date(Long.parseLong(maxtime_hostB)*1000)).toString());
//            setString(find("conn_cb_conntrack"), "text", "NA");
        }
        catch (IllegalArgumentException ie)
        {
            ie.printStackTrace();
        }
    }

    /** callback function, that is called when the user selects a connection.
     *  calls setConnLabels.
     */
    public void connection_clicked()
    {
        int index=getSelectedIndex(find("connection_list"));
        Connection a;
        boolean found=false;
        for (int i=0;i<conns.size();i++)
        {
            a=(Connection)conns.elementAt(i);
            if (a.listpos==index)
            {

                setConnLabels(""+a.state,
                              ""+a.birthday,
                              ""+a.lastPacket,
                              ""+PROTOCOL[a.protocol],

                              ""+unsigned((byte)(a.ip_hostA>>24))+"."+unsigned((byte)((a.ip_hostA>>16)&255))+"."+unsigned((byte)((a.ip_hostA>>8)&255))+"."+unsigned((byte)((a.ip_hostA)&255)),
                              ""+a.ip_hostA_str,
                              ""+a.port_hostA,
                              ""+a.packetCount_hostA,
                              ""+a.amount_hostA,
                              ""+a.lostAmount_hostA,
                              ""+a.rate_hostA,
                              ""+a.maxrate_hostA,
                              ""+a.maxtime_hostA,
                              ""+a.programname_hostA,

                              ""+unsigned((byte)(a.ip_hostB>>24))+"."+unsigned((byte)((a.ip_hostB>>16)&255))+"."+unsigned((byte)((a.ip_hostB>>8)&255))+"."+unsigned((byte)((a.ip_hostB)&255)),
                              ""+a.ip_hostB_str,
                              ""+a.port_hostB,
                              ""+a.packetCount_hostB,
                              ""+a.amount_hostB,
                              ""+a.lostAmount_hostB,
                              ""+a.rate_hostB,
                              ""+a.maxrate_hostB,
                              ""+a.maxtime_hostB,
                              ""+a.programname_hostB
                             );

            }
        }

    }

    /** callback function, that is called when the user changes one of the
     *  connection window combo boxes
     */
    public void combo_option_changed()
    {
        int show_conns_index=getInteger(find("ch_show_conns"), "selected");
        if (show_conns_index==0)
            show_inactive=true;
        else
            show_inactive=false;
        resort_connections();

//        System.out.println("Will "+((show_inactive)?"":"NOT ")+"show inactive connections");
    }

    /** callback function, that is called when a user clicks a button
     */
    public void button_clicked(Object src)
    {
        String action="";
        String src_name=getString(src, "name");

        if (src_name.equals("button_allow"))
            action="allow";
        else if (src_name.equals("button_deny"))
            action="deny";
        else if (src_name.equals("about_close"))
        {
            remove(about_dialog);
        }
        else if (src_name.equals("login_cancel"))
        {
            System.exit(0);
        }
        else if (src_name.equals("login_send"))
        {
            if (send_login())
                remove(login_dialog);
        }
        else if (src_name.equals("iptables_delete"))
        {
            Object items[]=getSelectedItems(find("iptables_list"));
            for (int i=items.length-1;i>=0;i--)
            {
                int chain=1;
                int rulenum=0;
                int selected=((Integer)getProperty(items[i], "index")).intValue();

//                System.out.println(""+inputStart+" "+forwardStart+" "+outputStart);
//                System.out.println("Selected: "+selected);
                if ((inputStart<selected) && (selected<forwardStart)) // which chain was this rule in
                {
                    chain=1;
                    rulenum=selected-inputStart-1;
                } else if ((forwardStart<selected) && (selected<outputStart))
                {
                    chain=2;
                    rulenum=selected-forwardStart-1;
                } else
                {
                    chain=3;
                    rulenum=selected-outputStart-1;
                }
                if ((rulenum>0) && (selected!=forwardStart-1) && (selected!=outputStart-1))
                {
                    sendmsg(5, chain, rulenum);
//                    System.out.println("Deleting rule "+rulenum+" of chain "+chain);
                }
            }
        }
        else if (src_name.equals("iptables_movedown"))
        {
            Object items[]=getSelectedItems(find("iptables_list"));
            for (int i=items.length-1;i>=0;i--)
            {
                int chain=1;
                int rulenum=0;
                int selected=((Integer)getProperty(items[i], "index")).intValue();

//                System.out.println(""+inputStart+" "+forwardStart+" "+outputStart);
//                System.out.println("Selected: "+selected);
                if ((inputStart<selected) && (selected<forwardStart)) // which chain was this rule in
                {
                    chain=1;
                    rulenum=selected-inputStart-1;
                } else if ((forwardStart<selected) && (selected<outputStart))
                {
                    chain=2;
                    rulenum=selected-forwardStart-1;
                } else
                {
                    chain=3;
                    rulenum=selected-outputStart-1;
                }
                if ((rulenum>0) && (selected!=forwardStart-1) && (selected!=outputStart-1))
                {
                    sendmsg(17, chain, rulenum);
//                    System.out.println("Moving rule "+rulenum+" of chain "+chain+" down");
                }
//                putProperty(getItem(find("iptables_list"), i+1), "selected", true);
                Object o=getItem(find("iptables_list"), selected+1);
                if (o!=null)
                    setBoolean(o, "selected", true);
                o=getItem(find("iptables_list"), selected);
                if (o!=null)
                    setBoolean(o, "selected", false);

            }
        }
        else if (src_name.equals("iptables_moveup"))
        {
            Object items[]=getSelectedItems(find("iptables_list"));
            for (int i=0; i<=items.length-1;i++)
            {
                int chain=1;
                int rulenum=0;
                int selected=((Integer)getProperty(items[i], "index")).intValue();

//                System.out.println(""+inputStart+" "+forwardStart+" "+outputStart);
//                System.out.println("Selected: "+selected);
                if ((inputStart<selected) && (selected<forwardStart)) // which chain was this rule in
                {
                    chain=1;
                    rulenum=selected-inputStart-1;
                } else if ((forwardStart<selected) && (selected<outputStart))
                {
                    chain=2;
                    rulenum=selected-forwardStart-1;
                } else
                {
                    chain=3;
                    rulenum=selected-outputStart-1;
                }
                if ((rulenum>0) && (selected!=forwardStart-1) && (selected!=outputStart-1))
                {
                    sendmsg(16, chain, rulenum);
//                    System.out.println("Moving rule "+rulenum+" of chain "+chain+" UP");
                }
                Object o=getItem(find("iptables_list"), selected-1);
                if (o!=null)
                    setBoolean(o, "selected", true);
                o=getItem(find("iptables_list"), selected);
                if (o!=null)
                    setBoolean(o, "selected", false);
            }
        }
        else if (src_name.equals("iptables_refresh"))
        {
            removeAll(find("iptables_list"));
//            System.out.println("iptables window refresh");
            sendcmd(2);
        }
        else if (src_name.equals("userspace_delete"))
        {
            Object items[]=getSelectedItems(find("userspace_list"));
            for (int i=items.length-1;i>=0;i--)
            {
                Integer index=(Integer)getProperty(items[i], "index");
//                System.out.println("deleting "+index);
                sendmsg(7, 0, index.intValue()); // 0 ... not important in this context
            }
        }
        else if (src_name.equals("userspace_refresh"))
        {
            removeAll(find("userspace_list"));
//            System.out.println("userspace window refresh");
            sendcmd(6);
        }

        if (src_name.equals("button_allow") || src_name.equals("button_deny"))
        {

            if (getBoolean(find("cb_this_packet"), "selected"))
            {
                // accept/deny current packet
                setLabels("", "", "", "", "", "", "", "", "", "", "", "", "", "");
                if (action.equals("allow"))
                    sendmsg(3);
                else
                    sendmsg(4);
                curMsglen=-1;
                return;
            }
            else if (getBoolean(find("cb_queued_packets"), "selected"))
            {
                // accept/deny queued packets
                setLabels("", "", "", "", "", "", "", "", "", "", "", "", "", "");
                if (action.equals("allow"))
                    sendmsg(3);
                else
                    sendmsg(4);
                curMsglen=-1;
                return;
            }
            else if (getBoolean(find("cb_create_rule"), "selected"))
            {
                // do the sophisticated stuff
                setLabels("", "", "", "", "", "", "", "", "", "", "", "", "", "");
                if (action.equals("allow"))
                    sendmsg(3);
                else
                    sendmsg(4);
                curMsglen=-1;
                return;
            }
        }
    }

    /** callback function, that is called when the user selects a menu entry
     */
    public void menu_clicked(Object src) {
        if (getString(src, "name").equals("help_about"))
        {
            try {
                if (about_dialog == null) {
                    about_dialog = parse("about_dialog.xml");
                }
                add(about_dialog);
                setBoolean(find("about_dialog"), "enabled", true);
                //requestFocus(find(dialog, "b_find"));
            } catch (Exception exc) { exc.printStackTrace(); }
        }
        else if (getString(src, "name").equals("exit"))
            System.exit(0);
        else if (getString(src, "name").equals("conn_monitor"))
        {
//            System.out.println(""+(getBoolean(src, "selected")?"activating":"disabling")+" connection monitoring");
            if (getBoolean(src, "selected"))
                sendcmd(10);
            else
                sendcmd(11);
        }
//        else if (getString(src, "name").equals("ignore_incoming"))
//            System.out.println(""+(getBoolean(src, "selected")?"starting to":" stopping to")+" ignore incoming messages");
//        else if (getString(src, "name").equals("ignore_forwarded"))
//            System.out.println(""+(getBoolean(src, "selected")?"starting to":" stopping to")+" ignore forwarded messages");
//        else if (getString(src, "name").equals("ignore_outgoing"))
//            System.out.println(""+(getBoolean(src, "selected")?"starting to":" stopping to")+" ignore outgoing messages");
    }

    /** return a byte(-128 - 127) as an integer(0-255)
     */
    public int unsigned(byte b)
    {
        return(b+256)%256;
    }

    /** when we accepted or denied a packet we reset the interface to
     *  a not active state.
     *  when a new packet arrives the interface is made active again
     */
    public void resetInterface(int mode)
    {
        if (mode==0)
        {
            setBoolean(find("cb_this_packet"), "enabled", false);
            setBoolean(find("cb_queued_packets"), "enabled", false);
            setBoolean(find("cb_create_rule"), "enabled", false);
            setBoolean(find("hdr1label"), "enabled", false);
            setBoolean(find("label_hook"), "enabled", false);
            setBoolean(find("label_arrived"), "enabled", false);
            setBoolean(find("label_len"), "enabled", false);
            setBoolean(find("label_tcp_flags"), "enabled", false);
            setBoolean(find("cb_mac_addr"), "enabled", false);
            setBoolean(find("label_icmp_type"), "enabled", false);
            setBoolean(find("cb_programname"), "enabled", false);
            setBoolean(find("cb_protocol"), "enabled", false);
            setBoolean(find("hdr2label"), "enabled", false);
            setBoolean(find("hdr3label"), "enabled", false);
            setBoolean(find("cb_ip_src"), "enabled", false);
            setBoolean(find("cb_ip_dst"), "enabled", false);
            setBoolean(find("label_ip_src"), "enabled", false);
            setBoolean(find("label_ip_dst"), "enabled", false);
            setBoolean(find("cb_port_src"), "enabled", false);
            setBoolean(find("cb_port_dst"), "enabled", false);
            setBoolean(find("cb_interface_in"), "enabled", false);
            setBoolean(find("cb_interface_out"), "enabled", false);
            setBoolean(find("hdr4label"), "enabled", false);
            setBoolean(find("cb_conntrack"), "enabled", false);
            setBoolean(find("ch_timeout"), "enabled", false);
            setBoolean(find("button_allow"), "enabled", false);
            setBoolean(find("button_deny"), "enabled", false);
        }
        else
        {
            setBoolean(find("cb_this_packet"), "enabled", true);
            setBoolean(find("cb_queued_packets"), "enabled", true);
            setBoolean(find("cb_create_rule"), "enabled", true);
            setBoolean(find("hdr1label"), "enabled", true);
            setBoolean(find("label_hook"), "enabled", true);
            setBoolean(find("label_arrived"), "enabled", true);
            setBoolean(find("label_len"), "enabled", true);
            setBoolean(find("label_tcp_flags"), "enabled", true);
            setBoolean(find("cb_mac_addr"), "enabled", true);
            setBoolean(find("label_icmp_type"), "enabled", true);
            setBoolean(find("cb_programname"), "enabled", true);
            setBoolean(find("cb_protocol"), "enabled", true);
            setBoolean(find("hdr2label"), "enabled", true);
            setBoolean(find("hdr3label"), "enabled", true);
            setBoolean(find("cb_ip_src"), "enabled", true);
            setBoolean(find("cb_ip_dst"), "enabled", true);
            setBoolean(find("label_ip_src"), "enabled", true);
            setBoolean(find("label_ip_dst"), "enabled", true);
            setBoolean(find("cb_port_src"), "enabled", true);
            setBoolean(find("cb_port_dst"), "enabled", true);
            setBoolean(find("cb_interface_in"), "enabled", true);
            setBoolean(find("cb_interface_out"), "enabled", true);
            setBoolean(find("hdr4label"), "enabled", true);
            setBoolean(find("cb_conntrack"), "enabled", true);
            setBoolean(find("ch_timeout"), "enabled", true);
            setBoolean(find("button_allow"), "enabled", true);
            setBoolean(find("button_deny"), "enabled", true);
        }
    }

    /** sets the labels in the packet window to the detailed values
     */
    public void setLabels(String ip_src, String ip_dst, String mac_addr, String port_src,
                          String port_dst, String protocol, String interface_in,
                          String interface_out, String len, String tcp_flags,
                          String icmp_type, String arrived, String hook, String programname)
    {
        if (!ip_src.equals(""))
        {
            resetInterface(1);
            setString(find("cb_ip_src"), "text", ip_src);
            setString(find("cb_ip_dst"), "text", ip_dst);
            setString(find("cb_port_src"), "text", port_src);
            setString(find("cb_port_dst"), "text", port_dst);
            setString(find("cb_mac_addr"), "text", mac_addr);
            setString(find("cb_protocol"), "text", protocol);
            setString(find("cb_interface_in"), "text", interface_in);
            setString(find("cb_interface_out"), "text", interface_out);
            setString(find("label_len"), "text", len);
            setString(find("label_tcp_flags"), "text", tcp_flags);
            setString(find("label_icmp_type"), "text", icmp_type);
            setString(find("label_arrived"), "text", arrived);
            setString(find("label_hook"), "text", hook);
            setString(find("cb_programname"), "text", programname);
            setString(find("label_ip_src"), "text", "resolving...");
            setString(find("label_ip_dst"), "text", "resolving...");
            lookupThr.lookup(ip_src.substring(6), ip_dst.substring(6), 0);
        }
        else
        {
            resetInterface(0);
            setString(find("cb_ip_src"), "text", "not available");
            setString(find("cb_ip_dst"), "text", "not available");
            setString(find("cb_port_src"), "text", "not available");
            setString(find("cb_port_dst"), "text", "not available");
            setString(find("cb_mac_addr"), "text", "not available");
            setString(find("cb_protocol"), "text", "not available");
            setString(find("cb_interface_in"), "text", "not available");
            setString(find("cb_interface_out"), "text", "not available");
            setString(find("label_len"), "text", "not available");
            setString(find("label_tcp_flags"), "text", "not available");
            setString(find("label_icmp_type"), "text", "not available");
            setString(find("label_arrived"), "text", "not available");
            setString(find("label_hook"), "text", "not available");
            setString(find("cb_programname"), "text", "not available");
            setString(find("label_ip_src"), "text", "not available");
            setString(find("label_ip_dst"), "text", "not available");
            statusbar("no packets available");
        }
    }

    /** scans a packet from the server.
     *  the information about a new packet is scanned here into system
     *  useable values
     */
    public void scanpacket(byte[] buffer)
    {
        String packet_id="";
        String ip_src="";
        String ip_dst="";
        String interface_in="";
        String interface_out="";
        String mac_addr="";
        String port_src="";
        String port_dst="";
        String protocol="";
        String tcp_flags="";
        String icmp_type="";
        String arrived="";
        String len="";
        String hook=""; // ==chain
        String programname;

        int temp=0;
        int pos;

        // read packet id - not used in the interface at the moment
        packet_id=""+((buffer[3])<<24+(buffer[2]<<16)+(buffer[1]<<8)+buffer[0]);

        // date when the packet arrived at the firewall
        temp=(unsigned(buffer[7])<<24)+(unsigned(buffer[6])<<16)+(unsigned(buffer[5])<<8)+(unsigned(buffer[4]));
        arrived=""+(new Date(temp)).toString();

        temp=(unsigned(buffer[8])<<8)+unsigned(buffer[9]);
        curMsglen=temp;
        len="LEN="+temp; // length of packet

        // ip addresses
        ip_src="SRCIP="+unsigned(buffer[13])+"."+unsigned(buffer[12])+"."+unsigned(buffer[11])+"."+unsigned(buffer[10]);
        ip_dst="DSTIP="+unsigned(buffer[17])+"."+unsigned(buffer[16])+"."+unsigned(buffer[15])+"."+unsigned(buffer[14]);

        switch (buffer[18]) // protocol
        {
        case 1:
            protocol="ICMP";
            break;
        case 6:
            protocol="TCP";
            break;
        case 17:
            protocol="UDP";
            break;
        case 47:
            protocol="GRE";
            break;
        default:
            protocol="Unknown: "+buffer[18];
            break;
        }

        // ports
        if ((protocol.equals("TCP")) || (protocol.equals("UDP")))
        {
            port_src="SPT="+(unsigned(buffer[19])*256+unsigned(buffer[20]));
            port_dst="DPT="+(unsigned(buffer[21])*256+unsigned(buffer[22]));
        } else
        {
            port_src="no SPT";
            port_dst="no DPT";
        }

        // TCP flags
        if (protocol.equals("TCP"))
        {
            // decode flags
            temp=unsigned(buffer[23])<<8;
            temp+=unsigned(buffer[24]);
            if ((temp&32)!=0) tcp_flags+="PSH ";
            if ((temp&16)!=0) tcp_flags+="URG ";
            if ((temp&8)!=0) tcp_flags+="RST ";
            if ((temp&4)!=0) tcp_flags+="ACK ";
            if ((temp&2)!=0) tcp_flags+="SYN ";
            if ((temp&1)!=0) tcp_flags+="FIN ";

            tcp_flags="FLAGS="+tcp_flags;
        }
        else
            tcp_flags="not TCP";

        // ICMP Type
        if (protocol.equals("ICMP"))
        {
            //decode type
            icmp_type="TYPE="+ICMP_TYPES[buffer[25]];
        }
        else
            icmp_type="not ICMP";

        // chains
        switch (buffer[26])
        {
        case 1:
            hook="CHAIN=INPUT";
            break;
        case 2:
            hook="CHAIN=FORWARD";
            break;
        case 3:
            hook="CHAIN=OUTPUT";
            break;
        default:
            hook="UNKNOWN: "+buffer[25];
            break;
        }

        String colon="";
        temp=buffer[26];
        pos=0;
        mac_addr="";
        while (pos<temp) // hardware address of network interface card
        {
            mac_addr+=colon+HEX[unsigned(buffer[27+pos])>>4]+HEX[unsigned(buffer[27+pos])&15];
            pos++;
            colon=":";
        }
        mac_addr="mac="+mac_addr;

        pos=0;
        // network interface names
        while ((pos<16) && (buffer[pos+36]>=32))
        {
            interface_in+=(char)buffer[pos+36];
            pos++;
        }
        if (interface_in.equals(""))
            interface_in="no incoming interface";

        pos=0;
        while ((pos<16) && (buffer[pos+52]>=32))
        {
            interface_out+=(char)buffer[pos+52];
            pos++;
        }
        if (interface_out.equals(""))
            interface_out="no outgoing interface";

        protocol="PROTOCOL="+protocol;

        // name of associated program (if any found)
        temp=buffer[68];
        pos=0;
        programname="";
        while ((pos<temp) && (buffer[pos+69]!=0)) {
            programname+=(char)buffer[pos+69];
            pos++;
        }
        programname="Program="+programname;

        // update labels / checkboxes
        setLabels(ip_src, ip_dst, mac_addr, port_src, port_dst, protocol, interface_in, interface_out, len, tcp_flags, icmp_type, arrived, hook, programname);

    }

    /** format the message source to a hex-viewer style output
     */
    public String getSourceFormatted(byte[] src)
    {
        String result="";
        int pos=0;

        if (src==null) return "";

        while (pos<src.length)
        {
            for (int i=0;i<16;i++)
            {
                if (i==8)
                    result+="  ";
                else if (i%4==0)
                    result+=" ";
                if (i+pos<src.length)
                    result+=""+(char)HEX[unsigned(src[i+pos])>>4]+""+(char)HEX[unsigned(src[i+pos])&15]+" ";
                else
                    result+="   ";
            }
            result+="   ";
            for (int i=0;i<16;i++)
            {
                if (i==8)
                    result+="  ";
                else if (i%4==0)
                    result+=" ";

                if ((i+pos<src.length) && (src[i+pos]>=32))
                    result+=(char)src[i+pos];
                else
                    result+=".";
            }
            pos+=16;
            result+="\n";
        }
        return result;
    }

    /** this function is used to catch receives which terminate too early
     * I dont know why this happens, but at least this fixes it.
     */
    public int myread(InputStream in, byte[] buffer)
    {
        int count=0;
        int result=0;

        try
        {
            while (count+result<buffer.length) // receive until complete packet received
            {
                result=in.read(buffer, count, buffer.length-count);
                if (result<=-1)
                {
                    return(-1);
                }
                count+=result;
            }
        } catch (IOException io)
        {
            return -1;
        }
        return count;
    }

    // TinySSL has some problem with the in.read() call
    // so I emultate this one using the in.read(byte[], offset, len)
    public int readbyte(InputStream in) throws IOException
    {
        byte result[]=new byte[1];
        if (in.read(result, 0, 1)==-1)
            return -1;
        return unsigned(result[0]);
    }

    /** sets the statusbar of the main window to a certain text. Used for progress indication
     */
    public void statusbar(String text)
    {
        if (text==null)
            text="";
        setString(find("label_statusbar"), "text", text);
//        System.out.println("Statusbar:"+text);
    }

    boolean running=false;

    /** This thread connects to the server and
     *  from then on receives the packets. Actions are taken depending on
     *  the incoming packets.
     */
    public void run() // Connection to server
    {
        byte[] msg=null;
        int len;
        int msgtype;
        int temp;
        int ok=0;

        // work around double start of this thread - will have to find the reason
        // some time. May be a thinlet problem
        synchronized(this) { 
            if (running)
            {
                super.run();
                return;
            }
            running=true;
        }

        Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
        SSLSocketFactory ssl_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();

        conns=new Vector();
        setFont(new Font("Monospaced", Font.PLAIN, 12));
        resetInterface(0);

        viewmonitoring=false;
        monitoring=false;
        try
        {
//            System.out.println("Connecting..."+InetAddress.getByName(ServerIP)+" "+Integer.valueOf(ServerPort).intValue());
            statusbar("Connecting...");

            // initialize SSL connection to server
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
            X509TrustManager tm = new MyX509TrustManager();
            KeyManager []km = null;
            TrustManager []tma = {tm};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(km,tma,new java.security.SecureRandom());
            SSLSocketFactory sf = sslContext.getSocketFactory();
            socket=(SSLSocket)sf.createSocket(InetAddress.getByName(ServerIP), Integer.valueOf(ServerPort).intValue());
            socket.startHandshake();
            in=socket.getInputStream();
            out=socket.getOutputStream();
            statusbar("Connected.");
        }
        catch (Exception e)
        {
            statusbar("Connection error.");
            e.printStackTrace();
            System.exit(1);
        }

        try
        {
            while (true) // receive packets until server dies
            {
                int count;
                int msglen;
                if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                msgtype=temp;

                switch (msgtype)
                {
                case 0: // receive network packet
                    if (!Connected) break;
                    if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                    msglen=temp*256;
                    if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                    msglen+=temp;

//                    System.out.println("Msglen: "+msglen);

                    msg=new byte[msglen-3];
                    if ((count=myread(in,msg))==-1) throw new IOException("Server down");
//                    System.out.println("Received "+count+" bytes(2)");
                    break;
                case 1: // received packet source
                    if (!Connected) break;
                    msg=new byte[curMsglen];
                    if ((count=myread(in, msg))==-1) throw new IOException("Server down");
//                    System.out.println("Received "+count+" bytes");
                    break;
                case 8:
                    if (Connected)
                    {
                        System.out.println("Invalid message");
                    }
                    else
                    {
                        //read answer to login process
                        if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                        ok=temp;
                        if (ok==0)
                        {
                            statusbar("authentication error");
                            Connected=false;
                        }
                        else
                        {
                            statusbar("authenticated");
                            Connected=true;
                        }
                        if (Connected);
//                            System.out.println("Logged in successfully");
                        else
                        {
//                            System.out.println("Login error");
                            add(login_dialog);
                        }
                    }
                    break;
                case 6: // iptables / userspace rules
                case 2:
                    if (!Connected) break;
                    int rulelen;
                    if ((temp=(readbyte(in)))==-1) throw new IOException("Server down"+temp);
                    rulelen=temp<<8;
                    if ((temp=(readbyte(in)))==-1) throw new IOException("Server down"+temp);
                    rulelen+=temp;

//                    System.out.println("RULELEN:"+rulelen);
                    msg=new byte[rulelen];
                    if ((count=myread(in, msg))==-1) throw new IOException("Server down");
//                    System.out.println("Received "+count+" bytes(3)");
                    break;
                case 14:
                    if (!Connected) break;
                    if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                    msglen=temp;
                    if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                    msglen=msglen*256+temp;
                    if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                    msglen=msglen*256+temp;
                    if ((temp=readbyte(in))==-1) throw new IOException("Server down");
                    msglen=msglen*256+temp;
                    msg=new byte[msglen+2];
                    if ((count=myread(in,msg))==-1) throw new IOException("Server down");
//                    System.out.println("Received "+count+" connection bytes");
                    //                    msg=null; // drop msg for now
                    break;
                default:
                    System.out.println("UNKNOWN MESSAGE ("+msgtype+") !!!");
                    break;
                }
                if (msg!=null)
                {
//                    System.out.println("Received message - parsing");
                    //                    for (int i=0;i<msg.length;i++)
                    //                        System.out.print((msg[i]+256)%256+" ");
                    //                    System.out.println();

                    if (msgtype==0) // a new firewall packet
                    {
//                        System.out.println("scanning packet");
                        statusbar("packet awaiting decision");
                        scanpacket(msg);
                    } else if (msgtype==1)  // source of the current packet
                    {
                        setString(find("source_text"), "text", getSourceFormatted(msg));
//                        System.out.println("Message source:"+getSourceFormatted(msg));
                    } else if (msgtype==2) // iptables rules
                    {
                        Object items[]=getSelectedItems(find("iptables_list"));
                        int[] indeces=new int[items.length];
                        for (int i=0;i<items.length;i++)
                            indeces[i]=((Integer)getProperty(items[i], "index")).intValue();

                        inputStart=-1; // for searching the chain boundaries
                        outputStart=-1;
                        forwardStart=-1;
                        int pos=0;
                        String rules="";
                        rules=new String(msg);
                        removeAll(find("iptables_list"));

                        temp=0;
                        count=0;
                        // fill in rules data and get chain boundaries
                        while ((temp<rules.length()) && (pos!=-1))
                        {
                            pos=rules.indexOf("\n", temp);
                            if (pos>=temp)
                            {
                                String line=rules.substring(temp, pos);
                                if (line.startsWith("Chain INPUT"))
                                    inputStart=count;
                                if (line.startsWith("Chain OUTPUT"))
                                    outputStart=count;
                                if (line.startsWith("Chain FORWARD"))
                                    forwardStart=count;
                                Object elem=create("item");
                                if (line.equals(""))
                                    line="-----------------------------------------------------";
                                setString(elem, "text", line);
                                putProperty(elem, "index", new Integer(count));
                                add(find("iptables_list"), elem);
                                temp=pos+1;
                                count++;
                            }
                        }
                        for (int i=0;i<indeces.length;i++)
                        {
                            Object o=getItem(find("iptables_list"), indeces[i]);
                            if (o!=null)
                                setBoolean(o, "selected", true);
                        }

                    } else if (msgtype==6) // get userspace rules
                    {
                        int pos=0;
                        String rules="";
                        removeAll(find("userspace_list"));
                        rules=new String(msg);

                        temp=0;
                        count=0;
                        while ((temp<rules.length()) && (pos!=-1)) // fill in rules
                        {
                            pos=rules.indexOf("\n", temp);
                            if (pos>=temp)
                            {
                                String line=rules.substring(temp, pos);
                                Object elem=create("item");
                                setString(elem, "text", line);
                                putProperty(elem, "index", new Integer(count));
                                add(find("userspace_list"), elem);
                                temp=pos+1;
                                count++;
                            }
                        }
                    }
                    else if (msgtype==14) // connection update
                    {
                        parseConnectionMessage(msg);
                    }
                    msg=null;
                } /* if (msg) */
            } /* while */
        } catch (IOException io)
        {
            System.out.println("Error while communicating");
            statusbar("communication error");
            io.printStackTrace();
            in=null;
            out=null;
            System.exit(1);
        }
    }

    /** update the internal (not the displayed) connection list
     */
    void updateConns(Vector conns, Connection c)
    {
        Connection a;
        boolean found=false;
        for (int i=0;i<conns.size();i++) // search for connection
        {
            a=(Connection)conns.elementAt(i);
            if ((a.ip_hostA==c.ip_hostA) &&
                (a.ip_hostB==c.ip_hostB) &&
                (a.port_hostA==c.port_hostA) &&
                (a.port_hostB==c.port_hostB) &&
                (a.protocol==c.protocol))
            {
                found=true;
                c.listpos=a.listpos;
                c.wantrefresh=true;
                conns.setElementAt(c, i);
            }

        }
        if ((!found))
        {
            conns.addElement(c);
//            System.out.println("New connection found");
        }
    }

    /** pads a string with spaces. used to align certain outputs.
     * @param fromend 0=pad with leading spaces, 1=pad with trailing spaces
     */
    String pad(String src, int len, int fromend)
    {
        while (src.length()<len)
            if (fromend==1)
                src=src+" ";
            else
                src=" "+src;

        return src;
    }

    /** pads a string with trailing spaces
     */
    String pad(String src, int len)
    {
        return pad(src, len, 1);
    }

    /** removes a connection from the visible connection list.
     *  tries to hold consistency.
     *  this whole connection list should be rewritten
     */
    void remove_connection_from_list(int index)
    {
        if (index<=-1)
            return;
        try {
            remove(getItem(find("connection_list"), index));
            Connection temp;
            for (int i=0;i<conns.size();i++)
            {
                temp=(Connection)conns.elementAt(i);
                if (temp.listpos>index)
                {
                    temp.listpos--;
                }
            }
        }
        catch (IllegalArgumentException ie)
        {
//            System.out.println("Wanted to delete "+index+" listsize="+getCount(find("connection_list")));
            ie.printStackTrace();
        }
    }

    /** adds a connection to the visible connection list
     */
    void add_connection_to_list(Connection a, int index)
    {
        if (a.listpos!=-1)
        {
            System.out.println("ADDING AN ALREADY EXISTING ELEMENT TO THE LIST");
            return;
        }
        Object elem=create("item");
        setString(elem, "text",
                  ""+PROTOCOL[a.protocol]+" "+pad(STATES[a.state], 7)+" "+
                  pad(a.ip_hostA_str, 15, 0)+":"+pad(""+a.port_hostA, 5)+" <--> "+
                  pad(a.ip_hostB_str, 15, 0)+":"+pad(""+a.port_hostB, 5)+
                  " Amount="+pad(""+(a.amount_hostA+a.amount_hostB), 9)+
                  " rate="+pad(""+(a.rate_hostA+a.rate_hostB), 9)
                 );

        if (index==-1)
        {
            add(find("connection_list"), elem);
            a.listpos=getCount(find("connection_list"))-1;
            if (getItem(find("connection_list"), a.listpos)!=elem)
            {
                System.out.println("REREAD MISMATCH");
                if (getItem(find("connection_list"), a.listpos-1)==elem)
                    System.out.println("index -1 would be better");

            }
            index=a.listpos;
        }
        else
        {
            add(find("connection_list"), elem, index);
            if (getItem(find("connection_list"), index)!=elem)
            {
                System.out.println("REREAD MISMATCH2");
                if (getItem(find("connection_list"), index-1)==elem)
                    System.out.println("index -1 would be better");

            }
            a.listpos=index;
            Connection temp;
            for (int i=0;i<conns.size();i++)
            {
                temp=(Connection)conns.elementAt(i);
                if ((temp.listpos>=index) && (temp!=a))
                {
                    if (temp.listpos+1>getCount(find("connection_list")))
                        System.out.println("Attempting to increase listpos beyond listsize!!!!");
                    temp.listpos++;
                }
            }
        }

    }

    /** returns the absolute value
     */
    int abs(int val)
    {
        if (val>=0)
            return val;
        else
            return -val;
    }

    /** reorganizes and resorts the visible connection list.
     *  this function should be rewritten
     */
    void resort_connections()
    {
        try {
        Connection a;
        for (int i=0;i<conns.size();i++) // reset wantedlistpos in all connections
        {
            a=(Connection)conns.elementAt(i);
            a.wantedlistpos=-1;
            a.sorted=false;
            if (a.listpos>=getCount(find("connection_list")))
                System.out.println("SANITY CHECK FAILED ON ELEMENT "+i);
        }

        int MaxIndex = 0;
        int count=0;

        for (int OuterLoopCount = 0; OuterLoopCount < conns.size(); OuterLoopCount++)
        {
            MaxIndex = 0;
            while (((Connection)conns.elementAt(MaxIndex)).sorted)
                MaxIndex++;

            for (int InnerLoopCount = 0; InnerLoopCount <conns.size(); InnerLoopCount++)
            {
                try {
                    if (((Connection)conns.elementAt(InnerLoopCount)).compareTo((Connection)conns.elementAt(MaxIndex), getInteger(find("ch_order_conns"), "selected")) > 0)
                    {
                        if (!((Connection)conns.elementAt(InnerLoopCount)).sorted)
                        {
                            MaxIndex = InnerLoopCount;
                        }
                    }
                }
                catch (IllegalArgumentException ie)
                {
                    ie.printStackTrace();
                    return;
                }
            }
            a=((Connection)conns.elementAt(MaxIndex));
            a.sorted=true;

            if (show_inactive || ((a.state!=0)/* && (a.state!=1)*/ && (a.state!=5)))
            {
                a.wantedlistpos=count;
                count++;
            }
            else
                a.wantedlistpos=-1;
        }
        if (count>getCount(find("connection_list")))
            System.out.println("SANITY CHECK FAILED: TOO MANY ELEMENTS FOR THIS LIST");
        //	System.out.println("SORTED ORDER:");
        //	for (int i=0;i<conns.size();i++)
        //	{
        //	    for (int j=0;j<conns.size();j++)
        //	    {
        //		a=(Connection)conns.elementAt(j);
        //                if (a.wantedlistpos==i)
        //		    System.out.println("lp="+a.wantedlistpos+" amount="+(a.amount_hostA+a.amount_hostB));
        //	    }
        //       }
        //       System.out.println("--------------------------------------------------------");

        int Temp = 0;

        Connection max;
        // this is some code which might eventually provide a means to update
        // the list with as few modifications as possible
        for (int j=0;j<conns.size();j++)
        {
            MaxIndex=0;
            max=(Connection)conns.elementAt(MaxIndex);
            while ((!max.sorted) || (max.wantedlistpos>getCount(find("connection_list"))+((max.listpos==-1)?1:0))) // just to know which have already been moved - using sorted the other way round
            {
                MaxIndex++;
                try {
                    max=(Connection)conns.elementAt(MaxIndex);
                }
                catch (ArrayIndexOutOfBoundsException ae)
                {
                    ae.printStackTrace();
                    max=(Connection)conns.elementAt(0);
                }
            }

            for (int i=0;i<conns.size();i++)
            {
                a=(Connection)conns.elementAt(i);
                if ((a.sorted) && (abs(a.listpos-a.wantedlistpos)>abs(max.listpos-max.wantedlistpos)) &&
                    (a.wantedlistpos<=getCount(find("connection_list"))-((a.listpos==-1)?1:0) ))
                {
                    MaxIndex=i;
                    max=a;
                }
            }

            a=max;
            Temp=0;
            if ((a.listpos!=a.wantedlistpos))
            {
//                System.out.println("Moving "+a.listpos+" to "+a.wantedlistpos+" listsize="+getCount(find("connection_list")));
                if ((getSelectedIndex(find("connection_list"))==a.listpos) && (a.listpos!=-1))
                    Temp=1;
                if (a.listpos>=0)
                {
                    remove_connection_from_list(a.listpos);
                    a.listpos=-1;
                }
                if (a.wantedlistpos>=0)
                {
                    if (a.wantedlistpos>=getCount(find("connection_list")))
                    {
                        if (a.wantedlistpos>getCount(find("connection_list")))
                            System.out.println("index too big ------------------------------------------");

//                        System.out.println("Adding element to end of list");
                        add_connection_to_list(a, -1);
                    }
                    else
                    {
//                        System.out.println("inserting element to list "+a.wantedlistpos+" "+getCount(find("connection_list")));
                        add_connection_to_list(a, a.wantedlistpos);
                    }
                }
                if (Temp==1)
                {
                    if (a.wantedlistpos<getCount(find("connection_list")))
                    {
                        Object o=getItem(find("connection_list"), a.wantedlistpos);
                        if (o!=null)
                            setBoolean(o, "selected", true);
                    }
                }
                a.wantedlistpos=-1;
                a.sorted=false;
            }
            a.wantedlistpos=-1;
            a.sorted=false;
        }
        }
        catch (ArrayIndexOutOfBoundsException ae)
        {
            ae.printStackTrace();
        }
    }

    /** parse a connection update message from the server.
     *  the server tells us about new connections. this function
     *  needs to convert the message into an useable form.
     */
    void parseConnectionMessage(byte msg[])
    {
        monitormessage m=new monitormessage(msg);
        try {
            for (int i=0;i<m.numConns;i++)
            {
                updateConns(conns, (Connection)m.conns.elementAt(i));
            }
            int index=getSelectedIndex(find("connection_list"));
            for (int i=0;i<conns.size();i++)
            {
                Connection a;
                a=(Connection)conns.elementAt(i);
                if (a.wantrefresh)
                {
                    a.wantrefresh=false;
                    if ((a.listpos==-1))
                    {
                        if (show_inactive || ((a.state!=0)/* && (a.state!=1) */&& (a.state!=5)))
                            add_connection_to_list(a, -1);
                        //			Object elem=create("item");
                        //                        setString(elem, "text",
                        //				  ""+PROTOCOL[a.protocol]+" "+pad(STATES[a.state], 7)+" "+
                        //				  pad(a.ip_hostA_str, 15, 0)+":"+pad(""+a.port_hostA, 5)+" <--> "+
                        //				  pad(a.ip_hostB_str, 15, 0)+":"+pad(""+a.port_hostB, 5)+
                        //				  " Amount="+pad(""+(a.amount_hostA+a.amount_hostB), 9)+
                        //				  " rate="+pad(""+(a.rate_hostA+a.rate_hostB), 9)
                        //                                  );
                        //
                        //                        add(find("connection_list"), elem);
                        //			a.listpos=getCount(find("connection_list"))-1;
                    }
                    else
                    {
                        if (a.listpos>=getCount(find("connection_list")))
                            System.out.println("Invalid list position");
                        else
                        {
                            int temp;
                            if (a.listpos>=0)
                                remove_connection_from_list(a.listpos);
                            temp=a.listpos;
                            a.listpos=-1;
                            if (temp>=0)
                                add_connection_to_list(a, temp);
                            if ((index==a.listpos) && (index!=-1))
                            {
                                setBoolean(getItem(find("connection_list"), index), "selected", true);
                                connection_clicked(); // force update of connection
                            }
                        }
                    }
                }
                //		a.dump();
            }
            //	    System.out.println();
            //	    System.out.println();
        }
        catch (NullPointerException ne)
        {
            ne.printStackTrace();
        }
        resort_connections();
    }

    /** puts it all together. starts the threads, and launches the thinlet system
     */
    public static void main(String[] args) {
        fireflier f=new fireflier();
        f.Connected=false;

        Thread conn=new Thread(f); // thread for receiving packets from server
        conn.start();
        new Thread(f.lookupThr).start(); // start lookup thread

        new FrameLauncher("FireFlier - Thinlet", f, 800, 860);
    }
}
