/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- July 1998
 */

/*
 * RtagDlg.cpp : the cvs rtag dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "GetPrefs.h"
#endif /* WIN32 */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LCheckBox.h>
#	include <LEditText.h>
#	include <LPopupGroupBox.h>
#	include <LRadioButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#include "RtagDlg.h"
#include "CvsPrefs.h"
#include "UpdateDlg.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32
IMPLEMENT_DYNCREATE(CRtag_CREATE, CPropertyPage)

CRtag_CREATE::CRtag_CREATE(const char * sLastModule, const char * sLastTag,
	bool hasDate, bool hasRev,
	const char * sLastDate, const char * sLastRev,
	bool noRecurs, bool overwriteExist,
	bool useMostRecent, bool lookAttic) : CPropertyPage(CRtag_CREATE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_CREATE)
	m_attic = lookAttic;
	m_date = sLastDate;
	m_rev = sLastRev;
	m_hasdate = hasDate;
	m_hasrev = hasRev;
	m_norecurs = noRecurs;
	m_match = useMostRecent;
	m_modname = sLastModule;
	m_tagname = sLastTag;
	m_overwrite = overwriteExist;
	//}}AFX_DATA_INIT
}

CRtag_CREATE::CRtag_CREATE() : CPropertyPage(CRtag_CREATE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_CREATE)
	m_attic = FALSE;
	m_date = _T("");
	m_rev = _T("");
	m_hasdate = FALSE;
	m_hasrev = FALSE;
	m_norecurs = FALSE;
	m_match = FALSE;
	m_modname = _T("");
	m_tagname = _T("");
	m_overwrite = FALSE;
	//}}AFX_DATA_INIT
}

CRtag_CREATE::~CRtag_CREATE()
{
}

void CRtag_CREATE::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRtag_CREATE)
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_Check(pDX, IDC_ATTIC, m_attic);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_MATCH, m_match);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_TAGNAME, m_tagname);
	DDX_Check(pDX, IDC_OVERWRITE, m_overwrite);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_tagname, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}

BEGIN_MESSAGE_MAP(CRtag_CREATE, CPropertyPage)
	//{{AFX_MSG_MAP(CRtag_CREATE)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRtag_CREATE::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CRtag_CREATE::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}

IMPLEMENT_DYNCREATE(CRtag_DELETE, CPropertyPage)

CRtag_DELETE::CRtag_DELETE(const char * sLastModule,
	const char * sLastTag, bool noRecurs,
	bool lookAttic) : CPropertyPage(CRtag_DELETE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_DELETE)
	m_attic = lookAttic;
	m_norecurs = noRecurs;
	m_modname = sLastModule;
	m_tagname = sLastTag;
	//}}AFX_DATA_INIT
}

CRtag_DELETE::CRtag_DELETE() : CPropertyPage(CRtag_DELETE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_DELETE)
	m_attic = FALSE;
	m_norecurs = FALSE;
	m_modname = _T("");
	m_tagname = _T("");
	//}}AFX_DATA_INIT
}

CRtag_DELETE::~CRtag_DELETE()
{
}

void CRtag_DELETE::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRtag_DELETE)
	DDX_Check(pDX, IDC_ATTIC, m_attic);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_TAGNAME, m_tagname);
	//}}AFX_DATA_MAP
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_tagname, 1);
}

BEGIN_MESSAGE_MAP(CRtag_DELETE, CPropertyPage)
	//{{AFX_MSG_MAP(CRtag_DELETE)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CRtag_BRANCH, CPropertyPage)

CRtag_BRANCH::CRtag_BRANCH(const char * sLastModule, const char * sLastBranch,
	bool hasDate, bool hasRev,
	const char * sLastDate, const char * sLastRev,
	bool noRecurs, bool useMostRecent, bool lookAttic) :
		CPropertyPage(CRtag_BRANCH::IDD)
{
	//{{AFX_DATA_INIT(CRtag_BRANCH)
	m_attic = lookAttic;
	m_date = sLastDate;
	m_rev = sLastRev;
	m_hasdate = hasDate;
	m_hasrev = hasRev;
	m_norecurs = noRecurs;
	m_match = useMostRecent;
	m_modname = sLastModule;
	m_branchname = sLastBranch;
	//}}AFX_DATA_INIT
}

CRtag_BRANCH::CRtag_BRANCH() : CPropertyPage(CRtag_BRANCH::IDD)
{
	//{{AFX_DATA_INIT(CRtag_BRANCH)
	m_attic = FALSE;
	m_date = _T("");
	m_rev = _T("");
	m_hasdate = FALSE;
	m_hasrev = FALSE;
	m_norecurs = FALSE;
	m_match = FALSE;
	m_modname = _T("");
	m_branchname = _T("");
	//}}AFX_DATA_INIT
}

CRtag_BRANCH::~CRtag_BRANCH()
{
}

void CRtag_BRANCH::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRtag_BRANCH)
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_Check(pDX, IDC_ATTIC, m_attic);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_MATCH, m_match);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_TAGNAME, m_branchname);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_branchname, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}

BEGIN_MESSAGE_MAP(CRtag_BRANCH, CPropertyPage)
	//{{AFX_MSG_MAP(CRtag_BRANCH)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRtag_BRANCH::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CRtag_BRANCH::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_RtagCreateMain(LWindow *theDialog,
	CPStr & sLastModule, CPStr & sLastTag,
	bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev,
	bool & useMostRecent, bool & lookAttic, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LCheckBox *chkLookAttic = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_InAttic));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillRev = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillRev->DoDataExchange(gRevNames, putValue);
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)sLastModule, sLastModule.length());
		tname->SetText((Ptr)(const char *)sLastTag, sLastTag.length());
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		chkLookAttic->SetValue(lookAttic ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;
		lookAttic = chkLookAttic->GetValue() == Button_On;

		char str[255];
		Size len;
		
		mname->GetText(str, 254, &len);
		sLastModule.set(str, len);
		tname->GetText(str, 254, &len);
		sLastTag.set(str, len);
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}

static void DoDataExchange_RtagCreateOptions(LWindow *theDialog,
	bool & noRecurs, bool & overwriteExist, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkOverwrite = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_OverwriteRev));
	
	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
		chkOverwrite->SetValue(overwriteExist ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
		overwriteExist = chkOverwrite->GetValue() == Button_On;
	}
}

static void DoDataExchange_RtagDeleteMain(LWindow *theDialog,
	CPStr & sLastModule, CPStr & sLastTag,
	bool & noRecurs, bool & lookAttic, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkLookAttic = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_InAttic));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	
	fillTag->DoDataExchange(gRevNames, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)sLastModule, sLastModule.length());
		tname->SetText((Ptr)(const char *)sLastTag, sLastTag.length());
		chkLookAttic->SetValue(lookAttic ? Button_On : Button_Off);
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
	}
	else
	{
		lookAttic = chkLookAttic->GetValue() == Button_On;
		noRecurs = chkNoRecurs->GetValue() == Button_On;

		char str[255];
		Size len;
		
		mname->GetText(str, 254, &len);
		sLastModule.set(str, len);
		tname->GetText(str, 254, &len);
		sLastTag.set(str, len);
	}
}

static void DoDataExchange_RtagBranchMain(LWindow *theDialog,
	CPStr & sLastModule, CPStr & sLastBranch,
	bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev,
	bool & useMostRecent, bool & lookAttic, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LCheckBox *chkLookAttic = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_InAttic));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillRev = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillRev->DoDataExchange(gRevNames, putValue);
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)sLastModule, sLastModule.length());
		tname->SetText((Ptr)(const char *)sLastBranch, sLastBranch.length());
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		chkLookAttic->SetValue(lookAttic ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;
		lookAttic = chkLookAttic->GetValue() == Button_On;

		char str[255];
		Size len;
		
		mname->GetText(str, 254, &len);
		sLastModule.set(str, len);
		tname->GetText(str, 254, &len);
		sLastBranch.set(str, len);
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}

static void DoDataExchange_RtagBranchOptions(LWindow *theDialog,
	bool & noRecurs, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	
	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
	}
}
#endif /* qMacCvsPP */

#if qUnix
class UCvsRtagCreate : public UWidget
{
	UDECLARE_DYNAMIC(UCvsRtagCreate)
public:
	UCvsRtagCreate() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsRtagCreate() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsRtagCreate, UWidget)

UBEGIN_MESSAGE_MAP(UCvsRtagCreate, UWidget)
	ON_UCOMMAND(UCvsRtagCreate::kOK, UCvsRtagCreate::OnOK)
	ON_UCOMMAND(UCvsRtagCreate::kCancel, UCvsRtagCreate::OnCancel)
UEND_MESSAGE_MAP()

int UCvsRtagCreate::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsRtagCreate::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsRtagCreate::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsRtagCreate_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsRtagCreate_MAIN)
public:
	UCvsRtagCreate_MAIN(const char * sLastModule, const char * sLastTag,
						bool hasDate, bool hasRev,
						const char * sLastDate, const char * sLastRev,
						bool noRecurs, bool overwriteExist,
						bool useMostRecent, bool lookAttic);
	virtual ~UCvsRtagCreate_MAIN() {}

	enum
	{
		kEditTag = EV_COMMAND_START,	// 0
		kEditMod,			// 1
		kCheckRev,			// 2
		kCheckDate,			// 3
		kComboRev,			// 4
		kComboDate,			// 5
		kCheckRecurs,		// 6
		kCheckAttic,		// 7
		kCheckOverwrite,	// 8
		kCheckMatch			// 9
	};

	virtual void DoDataExchange(bool fill);

	bool m_attic;
	UStr m_date;
	UStr m_rev;
	bool m_hasdate;
	bool m_hasrev;
	bool m_norecurs;
	bool m_match;
	UStr m_modname;
	UStr m_tagname;
	bool m_overwrite;
protected:
	ev_msg int OnChecks(int cmd);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsRtagCreate_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsRtagCreate_MAIN, UWidget)
	ON_UCOMMAND_RANGE(UCvsRtagCreate_MAIN::kCheckRev, UCvsRtagCreate_MAIN::kCheckDate, UCvsRtagCreate_MAIN::OnChecks)
UEND_MESSAGE_MAP()

UCvsRtagCreate_MAIN::UCvsRtagCreate_MAIN(const char * sLastModule, const char * sLastTag,
										 bool hasDate, bool hasRev,
										 const char * sLastDate, const char * sLastRev,
										 bool noRecurs, bool overwriteExist,
										 bool useMostRecent, bool lookAttic) : UWidget(::UEventGetWidID())
{
	m_attic = lookAttic;
	m_date = sLastDate;
	m_rev = sLastRev;
	m_hasdate = hasDate;
	m_hasrev = hasRev;
	m_norecurs = noRecurs;
	m_match = useMostRecent;
	m_modname = sLastModule;
	m_tagname = sLastTag;
	m_overwrite = overwriteExist;
}

int UCvsRtagCreate_MAIN::OnChecks(int cmd)
{
	int state = UEventSendMessage(GetWidID(), EV_QUERYSTATE, cmd, 0L);
	UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(cmd + 2, state), 0L);
	return 0;
}

void UCvsRtagCreate_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kComboRev, gRevNames);
	::DoDataExchange(fill, GetWidID(), kComboDate, gDateNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditTag, (void *)(const char *)m_tagname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditMod, (void *)(const char *)m_modname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboRev, (void *)(const char *)m_rev);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboDate, (void *)(const char *)m_date);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckDate, m_hasdate), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRev, m_hasrev), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckAttic, m_attic), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckOverwrite, m_overwrite), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckMatch, m_match), 0L);

		OnChecks(kCheckRev);
		OnChecks(kCheckDate);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditTag, &m_tagname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditMod, &m_modname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboRev, &m_rev);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboDate, &m_date);

		m_hasdate = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDate, 0L);
		m_hasrev = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRev, 0L);
		m_attic = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckAttic, 0L);
		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
		m_overwrite = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckOverwrite, 0L);
		m_match = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckMatch, 0L);
	}
}

class UCvsRtagDel : public UWidget
{
	UDECLARE_DYNAMIC(UCvsRtagDel)
public:
	UCvsRtagDel() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsRtagDel() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsRtagDel, UWidget)

UBEGIN_MESSAGE_MAP(UCvsRtagDel, UWidget)
	ON_UCOMMAND(UCvsRtagDel::kOK, UCvsRtagDel::OnOK)
	ON_UCOMMAND(UCvsRtagDel::kCancel, UCvsRtagDel::OnCancel)
UEND_MESSAGE_MAP()

int UCvsRtagDel::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsRtagDel::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsRtagDel::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsRtagDel_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsRtagDel_MAIN)
public:
	UCvsRtagDel_MAIN(const char * sLastModule,
					 const char * sLastTag, bool noRecurs,
					 bool lookAttic);
	virtual ~UCvsRtagDel_MAIN() {}

	enum
	{
		kEditTag = EV_COMMAND_START,	// 0
		kEditMod,			// 1
		kCheckRecurs,		// 2
		kCheckAttic			// 3
	};

	virtual void DoDataExchange(bool fill);

	bool m_attic;
	bool m_norecurs;
	UStr m_modname;
	UStr m_tagname;
protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsRtagDel_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsRtagDel_MAIN, UWidget)
UEND_MESSAGE_MAP()

UCvsRtagDel_MAIN::UCvsRtagDel_MAIN(const char * sLastModule,
								   const char * sLastTag, bool noRecurs,
								   bool lookAttic) : UWidget(::UEventGetWidID())
{
	m_attic = lookAttic;
	m_norecurs = noRecurs;
	m_modname = sLastModule;
	m_tagname = sLastTag;
}

void UCvsRtagDel_MAIN::DoDataExchange(bool fill)
{
	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditTag, (void *)(const char *)m_tagname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditMod, (void *)(const char *)m_modname);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckAttic, m_attic), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditTag, &m_tagname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditMod, &m_modname);

		m_attic = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckAttic, 0L);
		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
	}
}

class UCvsRtagBranch : public UWidget
{
	UDECLARE_DYNAMIC(UCvsRtagBranch)
public:
	UCvsRtagBranch() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsRtagBranch() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsRtagBranch, UWidget)

UBEGIN_MESSAGE_MAP(UCvsRtagBranch, UWidget)
	ON_UCOMMAND(UCvsRtagBranch::kOK, UCvsRtagBranch::OnOK)
	ON_UCOMMAND(UCvsRtagBranch::kCancel, UCvsRtagBranch::OnCancel)
UEND_MESSAGE_MAP()

int UCvsRtagBranch::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsRtagBranch::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsRtagBranch::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsRtagBranch_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsRtagBranch_MAIN)
public:
	UCvsRtagBranch_MAIN(const char * sLastModule, const char * sLastTag,
						bool hasDate, bool hasRev,
						const char * sLastDate, const char * sLastRev,
						bool noRecurs, bool useMostRecent, bool lookAttic);
	virtual ~UCvsRtagBranch_MAIN() {}

	enum
	{
		kEditTag = EV_COMMAND_START,	// 0
		kEditMod,			// 1
		kCheckRev,			// 2
		kCheckDate,			// 3
		kComboRev,			// 4
		kComboDate,			// 5
		kCheckRecurs,		// 6
		kCheckAttic,		// 7
		kCheckMatch			// 9
	};

	virtual void DoDataExchange(bool fill);

	bool m_attic;
	UStr m_date;
	UStr m_rev;
	bool m_hasdate;
	bool m_hasrev;
	bool m_norecurs;
	bool m_match;
	UStr m_modname;
	UStr m_tagname;
protected:
	ev_msg int OnChecks(int cmd);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsRtagBranch_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsRtagBranch_MAIN, UWidget)
	ON_UCOMMAND_RANGE(UCvsRtagBranch_MAIN::kCheckRev, UCvsRtagBranch_MAIN::kCheckDate, UCvsRtagBranch_MAIN::OnChecks)
UEND_MESSAGE_MAP()

UCvsRtagBranch_MAIN::UCvsRtagBranch_MAIN(const char * sLastModule, const char * sLastTag,
											 bool hasDate, bool hasRev, const char * sLastDate,
											 const char * sLastRev, bool noRecurs, bool useMostRecent,
											 bool lookAttic) : UWidget(::UEventGetWidID())
{
	m_attic = lookAttic;
	m_date = sLastDate;
	m_rev = sLastRev;
	m_hasdate = hasDate;
	m_hasrev = hasRev;
	m_norecurs = noRecurs;
	m_match = useMostRecent;
	m_modname = sLastModule;
	m_tagname = sLastTag;
}

int UCvsRtagBranch_MAIN::OnChecks(int cmd)
{
	int state = UEventSendMessage(GetWidID(), EV_QUERYSTATE, cmd, 0L);
	UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(cmd + 2, state), 0L);
	return 0;
}

void UCvsRtagBranch_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kComboRev, gRevNames);
	::DoDataExchange(fill, GetWidID(), kComboDate, gDateNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditTag, (void *)(const char *)m_tagname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditMod, (void *)(const char *)m_modname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboRev, (void *)(const char *)m_rev);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboDate, (void *)(const char *)m_date);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckDate, m_hasdate), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRev, m_hasrev), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckAttic, m_attic), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckMatch, m_match), 0L);

		OnChecks(kCheckRev);
		OnChecks(kCheckDate);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditTag, &m_tagname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditMod, &m_modname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboRev, &m_rev);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboDate, &m_date);

		m_hasdate = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDate, 0L);
		m_hasrev = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRev, 0L);
		m_attic = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckAttic, 0L);
		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
		m_match = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckMatch, 0L);
	}
}

#endif // qUnix

bool CompatRtagCreate(bool & noRecurs, bool & overwriteExisting, CPStr & tagName,
					 CPStr & modName, CPStr & date, CPStr & rev,
					 bool & useMostRecent, bool & lookAttic)
{
	bool userHitOK = false;

	static CPStr sLastModule;
	static CPStr sLastTag;
	static CPStr sLastDate;
	static CPStr sLastRev;

	bool hasDate = false;
	bool hasRev = false;

	date = "";
	rev = "";
	tagName = "";
	modName = "";
	noRecurs = false;
	overwriteExisting = false;
	useMostRecent = false;
	lookAttic = false;

#ifdef WIN32
	CPropertySheet pages("Create tag settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CRtag_CREATE page1(sLastModule, sLastTag, hasDate, hasRev,
		sLastDate, sLastRev, noRecurs, overwriteExisting,
		useMostRecent, lookAttic);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		lookAttic = page1.m_attic == TRUE;
		sLastDate = page1.m_date;
		sLastRev = page1.m_rev;
		hasDate = page1.m_hasdate == TRUE;
		hasRev = page1.m_hasrev == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		useMostRecent = page1.m_match == TRUE;
		sLastModule = page1.m_modname;
		sLastTag = page1.m_tagname;
		overwriteExisting = page1.m_overwrite == TRUE;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#if qUnix
	void *wid = UCreate_TagModDlg();

	UCvsRtagCreate *dlg = new UCvsRtagCreate();
	UCvsRtagCreate_MAIN *tab1 =
		new UCvsRtagCreate_MAIN(sLastModule, sLastTag, hasDate, hasRev,
								sLastDate, sLastRev, noRecurs, overwriteExisting,
								useMostRecent, lookAttic);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsRtagCreate::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		lookAttic = tab1->m_attic;
		sLastDate = tab1->m_date;
		sLastRev = tab1->m_rev;
		hasDate = tab1->m_hasdate;
		hasRev = tab1->m_hasrev;
		noRecurs = tab1->m_norecurs;
		useMostRecent = tab1->m_match;
		sLastModule = tab1->m_modname;
		sLastTag = tab1->m_tagname;
		overwriteExisting = tab1->m_overwrite;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_RtagCreate, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_RtagCreateOptions(theDialog, noRecurs, overwriteExisting, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_RtagCreateMain(theDialog, sLastModule, sLastTag,
		hasDate, hasRev, sLastDate, sLastRev,
		useMostRecent, lookAttic, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_RtagCreateMain(theDialog, sLastModule, sLastTag,
			hasDate, hasRev, sLastDate, sLastRev,
			useMostRecent, lookAttic, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_RtagCreateOptions(theDialog, noRecurs, overwriteExisting, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;
	
		tagName = sLastTag;
		modName = sLastModule;

		gCvsPrefs.save();
	}

	return userHitOK;
}

bool CompatRtagDelete(bool & noRecurs, bool & lookAttic,
					 CPStr & tagName, CPStr & modName)
{

	bool userHitOK = false;

	static CPStr sLastModule;
	static CPStr sLastTag;

	tagName = "";
	modName = "";
	noRecurs = false;
	lookAttic = false;

#ifdef WIN32
	CPropertySheet pages("Delete tag settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CRtag_DELETE page1(sLastModule, sLastTag, noRecurs, lookAttic);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		lookAttic = page1.m_attic == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		sLastModule = page1.m_modname;
		sLastTag = page1.m_tagname;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#if qUnix
	void *wid = UCreate_UntagModDlg();

	UCvsRtagDel *dlg = new UCvsRtagDel();
	UCvsRtagDel_MAIN *tab1 = new UCvsRtagDel_MAIN(sLastModule, sLastTag,
												  noRecurs, lookAttic);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsRtagDel::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		lookAttic = tab1->m_attic;
		noRecurs = tab1->m_norecurs;
		sLastModule = tab1->m_modname;
		sLastTag = tab1->m_tagname;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_RtagDelete, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_RtagDeleteMain(theDialog, sLastModule, sLastTag,
		noRecurs, lookAttic, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_RtagDeleteMain(theDialog, sLastModule, sLastTag,
			noRecurs, lookAttic, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		tagName = sLastTag;
		modName = sLastModule;

		gCvsPrefs.save();
	}

	return userHitOK;
}

bool CompatRtagBranch(bool & noRecurs, CPStr & branchName,
					 CPStr & modName, CPStr & date, CPStr & rev,
					 bool & useMostRecent, bool & lookAttic)
{
	bool userHitOK = false;

	static CPStr sLastModule;
	static CPStr sLastBranch;
	static CPStr sLastDate;
	static CPStr sLastRev;

	bool hasDate = false;
	bool hasRev = false;

	date = "";
	rev = "";
	branchName = "";
	modName = "";
	noRecurs = false;
	useMostRecent = false;
	lookAttic = false;

#ifdef WIN32
	CPropertySheet pages("Create branch settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CRtag_BRANCH page1(sLastModule, sLastBranch, hasDate, hasRev,
		sLastDate, sLastRev, noRecurs, useMostRecent, lookAttic);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		lookAttic = page1.m_attic == TRUE;
		sLastDate = page1.m_date;
		sLastRev = page1.m_rev;
		hasDate = page1.m_hasdate == TRUE;
		hasRev = page1.m_hasrev == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		useMostRecent = page1.m_match == TRUE;
		sLastModule = page1.m_modname;
		sLastBranch = page1.m_branchname;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#if qUnix
	void *wid = UCreate_BranchModDlg();

	UCvsRtagBranch *dlg = new UCvsRtagBranch();
	UCvsRtagBranch_MAIN *tab1 = 
		new UCvsRtagBranch_MAIN(sLastModule, sLastBranch, hasDate, hasRev,
								  sLastDate, sLastRev, noRecurs, useMostRecent,
								  lookAttic);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsRtagBranch::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		lookAttic = tab1->m_attic;
		sLastDate = tab1->m_date;
		sLastRev = tab1->m_rev;
		hasDate = tab1->m_hasdate;
		hasRev = tab1->m_hasrev;
		noRecurs = tab1->m_norecurs;
		useMostRecent = tab1->m_match;
		sLastModule = tab1->m_modname;
		sLastBranch = tab1->m_tagname;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_RtagBranch, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_RtagBranchOptions(theDialog, noRecurs, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_RtagBranchMain(theDialog, sLastModule, sLastBranch,
		hasDate, hasRev, sLastDate, sLastRev,
		useMostRecent, lookAttic, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_RtagBranchMain(theDialog, sLastModule, sLastBranch,
			hasDate, hasRev, sLastDate, sLastRev,
			useMostRecent, lookAttic, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_RtagBranchOptions(theDialog, noRecurs, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;
	
		branchName = sLastBranch;
		modName = sLastModule;

		gCvsPrefs.save();
	}

	return userHitOK;
}
