/********************************************************************
 * $Author: jgoerzen $
 * $Revision: 1.3 $
 * $Date: 2002/02/12 20:50:21 $
 * $Source: /var/cvs/gopher/object/Regex.c,v $
 * $Status: $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: Regex.c
 * Portable method of doing regular expressions
 *********************************************************************
 * Revision History:
 * $Log: Regex.c,v $
 * Revision 1.3  2002/02/12 20:50:21  jgoerzen
 * Beginning of MacOS X (Darwin) support.
 * Many modifications to Regex.[ch], see debian/changelog for details.
 *
 * Revision 1.2  2002/02/12 19:54:18  jgoerzen
 * Updated with regex fixes
 *
 * Revision 1.1.1.1  2000/08/19 00:28:56  jgoerzen
 * Import from UMN Gopher 2.3.1 after GPLization
 *
 * Revision 3.2  1994/07/25  13:56:53  lindner
 * First crack at POSIX regular expressions
 *
 * Revision 3.1  1993/10/19  20:48:23  lindner
 * Portable versions of Regular expression routines for System V and BSD..
 *
 *
 *********************************************************************/

#define __GOPHER_REGEX_C__

/*
 * If you're using gcc on Solaris you might need to copy /usr/include/regexp.h
 * to /opt/whatever/regexp.h
 */

#define  REGEX_CODEIT    /* only include sysv regex code once.. */
#include "Regex.h"

#ifdef REGEX_POSIX
char *REGEX_param = NULL;
#endif

#ifdef __APPLE__
regexp *REGEX_param = NULL;
#endif

#ifdef REGEX_SYSV

#define ESIZE 512
static char expbuf[ESIZE];

char *
re_comp(expr)
  char *expr;
{
     char *result;

     result = compile(expr, expbuf, &expbuf[ESIZE], '\0');

     return(NULL);
}

int
re_exec(string)
  char *string;
{
     return(step(string, expbuf));
}

#endif
