/*
 * Copyright 2003-2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.groovy.tools.stubgenerator

/**
 * Test stub generation for an annotation 
 *
 * @author Roshan Dawrani
 */
class StubGenerationForAnAnnotationStubsTest extends StringSourcesStubTestCase {

    Map<String, String> provideSources() {
        [
            'Foo4451.groovy': '''
                import java.lang.annotation.ElementType;
                import java.lang.annotation.Retention;
                import java.lang.annotation.RetentionPolicy;
                import java.lang.annotation.Target;
                
                @Retention(RetentionPolicy.RUNTIME)
                @Target( [ ElementType.TYPE ])
                public @interface Foo4451 {}
            ''',
            'Bar.java': '''
                class Bar {}
            '''
        ]
    }

    void verifyStubs() {
        String annotationClassSource = stubJavaSourceFor('Foo4451')
        assert annotationClassSource.contains('public @interface Foo4451')
        assert !annotationClassSource.contains('java.lang.annotation.Annotation')

        println 'StubGenerationForAnAnnotationStubsTest - verified'
    }
}
