/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "add_share.h"
#include "reread_conf.h"
#include "commented.h"
#include "functions.h"
#include "get_option_pos.h"
#include "show_info.h"
#include "populate_shares.h"
#include "populate_share_settings.h"
#include "populate_conf_tab.h"



void add_share(struct w *widgets)
{
    /* Lists the values in the server tab */
    FILE *fp;
    long conf_size;
    char *line, *new_conf;
    gchar *dir, *cmd, *opt, *info;
    gint active_index;

    /* Entries, get all share settings */
    G_CONST_RETURN gchar *share_name = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[0]));
    G_CONST_RETURN gchar *directory = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[1]));
    G_CONST_RETURN gchar *comment = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[2]));
    G_CONST_RETURN gchar *valid_users = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[3]));
    G_CONST_RETURN gchar *write_list = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[4]));
    G_CONST_RETURN gchar *admin_users = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[5]));
    G_CONST_RETURN gchar *dir_mask = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[6]));
    G_CONST_RETURN gchar *create_mode = gtk_entry_get_text(GTK_ENTRY(widgets->share_set_entry[7]));


    if( share_name == NULL || strlen(share_name) < 1 )
    {
	info = g_strdup_printf(_("The share name is missing, the share was not added.\n"));
	show_info(info);
	g_free(info);
	return;    
    }

    if( directory == NULL || strlen(directory) < 1 )
    {
	info = g_strdup_printf(_("The directory to share is missing, the share was not added.\n"));
	show_info(info);
	g_free(info);
	return;    
    }


    if((fp=fopen(SAMBA_CONF, "r"))==NULL)
    {
	info = g_strdup_printf(_("Cant open smb.conf here:\n%s\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    new_conf = allocate(conf_size+200000); /* + for the added share */
    
    /* First collect the entire conf, if the share exists then return */
    gchar *sharedef = g_strdup_printf("[%s]", share_name);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strstr(line, sharedef) )
	{
	    free(line);
	    free(new_conf);
	    fclose(fp);
	    info = g_strdup_printf(_("The share already exists.\n"));
	    show_info(info);
	    g_free(info);
	    return;
	}
	
        strcat(new_conf, line);
    }
    fclose(fp);
    free(line);


    /* Entries... */

    /* Add the new share definition */
    opt = g_strdup_printf("\n[%s]\n", share_name);
    strcat(new_conf, opt);
    
    opt = g_strdup_printf("path = %s\n", directory);
    strcat(new_conf, opt);

    if( comment !=NULL && strlen(comment) > 1 )
    {
	opt = g_strdup_printf("comment = %s\n", comment);
	strcat(new_conf, opt);
    }
    else
      {
	  opt = g_strdup_printf("comment = no comment\n");
	  strcat(new_conf, opt);
      }

    if( valid_users !=NULL && strlen(valid_users) > 1 )
    {
	opt = g_strdup_printf("valid users = %s\n", valid_users);
	strcat(new_conf, opt);
    }
    else
      {
	  opt = g_strdup_printf("valid users =\n");
	  strcat(new_conf, opt);
      }

    if( write_list !=NULL && strlen(write_list) > 1 )
    {
	opt = g_strdup_printf("write list = %s\n", write_list);
	strcat(new_conf, opt);
    }
    else
      {
	opt = g_strdup_printf("write list =\n");
	strcat(new_conf, opt);
      }

    if( admin_users !=NULL && strlen(admin_users) > 1 )
    {
	opt = g_strdup_printf("admin users = %s\n", admin_users);
	strcat(new_conf, opt);
    }
    else
      {
	  opt = g_strdup_printf("admin users =\n");
	  strcat(new_conf, opt);
      }

    /* If these 2 arent specified at share creation then dont use it */
    if( dir_mask !=NULL && strlen(dir_mask) > 1 )
    {
        opt = g_strdup_printf("directory mask = %s\n", dir_mask);
        strcat(new_conf, opt);
    }

    if( create_mode !=NULL && strlen(create_mode) > 1 )
    {
	opt = g_strdup_printf("create mode = %s\n", create_mode);
	strcat(new_conf, opt);
    }



    /* Combos... */

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[0]));
    if( active_index == 0 )
      opt = g_strdup_printf("read only = yes\n");
    else
      opt = g_strdup_printf("read only = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[1]));
    if( active_index == 0 )
      opt = g_strdup_printf("available = yes\n");
    else
      opt = g_strdup_printf("available = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[2]));
    if( active_index == 0 )
      opt = g_strdup_printf("browseable = yes\n");
    else
      opt = g_strdup_printf("browseable = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[3]));
    if( active_index == 0 )
      opt = g_strdup_printf("writable = yes\n");
    else
      opt = g_strdup_printf("writable = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[4]));
    if( active_index == 0 )
      opt = g_strdup_printf("guest ok = yes\n");
    else
      opt = g_strdup_printf("guest ok = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[5]));
    if( active_index == 0 )
      opt = g_strdup_printf("public = yes\n");
    else
      opt = g_strdup_printf("public = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[6]));
    if( active_index == 0 )
      opt = g_strdup_printf("printable = yes\n");
    else
      opt = g_strdup_printf("printable = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[7]));
    if( active_index == 0 )
      opt = g_strdup_printf("share modes = yes\n");
    else
      opt = g_strdup_printf("share modes = no\n");
    strcat(new_conf, opt);

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->share_set_combo[8]));
    if( active_index == 0 )
      opt = g_strdup_printf("locking = yes\n");
    else
      opt = g_strdup_printf("locking = no\n");
    strcat(new_conf, opt);


    g_free(opt);


    /* Make the directory if it doesnt exist */
    dir = g_strdup_printf("%s", directory);
    if( ! file_exists(dir) )
    {
        cmd = g_strdup_printf("%s '%s'", "mkdir -p", dir);
        if((fp=popen(cmd, "w"))==NULL)
    	  perror("popen");

        pclose(fp);
        g_free(cmd);
    }
    g_free(dir);                                                                                    

    /* Write the new conf */
    if((fp=fopen(SAMBA_CONF, "w+"))==NULL)
    {
	info = g_strdup_printf(_("Cant open smb.conf here:\n%s\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fputs(new_conf, fp);
    fclose(fp);
    free(new_conf);

    populate_shares(widgets);
    populate_share_settings(widgets);
    populate_conf_tab(widgets);

    reread_conf(widgets);
}
