/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "allocate.h"
#include "functions.h"
#include "import_functions.h"
#include "make_settings_checkbuttons.h"
#include "create_import_question.h"
#include "create_import_selection.h"

extern int global_import_local;
extern int global_import_remote;

extern int global_import_users;
extern int global_import_groups;

extern int global_import_valid;
extern int global_import_write;
extern int global_import_admin;



/* Local checkbutton callback */
void import_local_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The local checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_local)) )
    {
        global_import_local  = 1;
	global_import_remote = 0;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_remote), FALSE);
    }
}

/* Remote checkbutton callback */
void import_remote_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The remote checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_remote)) )
    {    
        global_import_local  = 0;
        global_import_remote = 1;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_local), FALSE);
    }
}

/* Users checkbutton callback */
void import_users_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The users checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_users)) )
    {    
        global_import_users  = 1;
        global_import_groups = 0;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_groups), FALSE);
    }
}

/* Groups checkbutton callback */
void import_groups_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The groups checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_groups)) )
    {    
        global_import_users  = 0;
        global_import_groups = 1;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_users), FALSE);
    }
}



/* Valid checkbutton callback */
void import_valid_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The valid checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_valid)) )
    {    
        global_import_valid  = 1;
    }
    else
        global_import_valid  = 0;
}

/* Write checkbutton callback */
void import_write_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The write checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_write)) )
	global_import_write  = 1;
    else
        global_import_write  = 0;
}

/* Admin checkbutton callback */
void import_admin_checkbutton_toggled(GtkButton *button, struct w *widgets)
{
    /* The admin checkbutton is active */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_admin)) )
	global_import_admin  = 1;
    else
	global_import_admin  = 0;
}


/* A question for how to import users or groups */
void create_import_question(struct w *widgets)
{
    GtkWidget *frame1, *frame2, *frame3;
    GtkWidget *table1, *table2, *table3;
    GtkWidget *question_vbox;
    GtkTooltips *tooltips;
    gchar *utf8=NULL;
    gchar *info;
    int a=0, b=1;

    widgets->import_question_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_position(GTK_WINDOW (widgets->import_question_window), GTK_WIN_POS_CENTER);
    gtk_widget_set_size_request(widgets->import_question_window, 450, -1);

    /* Set window information */
    info = g_strdup_printf(_("GSAMBAD %s import question"), VERSION);
    gtk_window_set_title(GTK_WINDOW(widgets->import_question_window), info);
    g_free(info);

    g_signal_connect(GTK_WINDOW(widgets->import_question_window), "delete_event",
                     G_CALLBACK(gtk_widget_destroy), NULL);

    question_vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(widgets->import_question_window), question_vbox);

    tooltips = gtk_tooltips_new();

    /* 3 tables with some settings and 2 columns */
    table1 = gtk_table_new(2, 2, FALSE);
    table2 = gtk_table_new(2, 2, FALSE);
    table3 = gtk_table_new(3, 2, FALSE);

    frame1 = gtk_frame_new("Import users or groups from:");
    gtk_box_pack_start(GTK_BOX(question_vbox), frame1, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame1), table1);

    frame2 = gtk_frame_new("Import users or groups:");
    gtk_box_pack_start(GTK_BOX(question_vbox), frame2, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame2), table2);

    frame3 = gtk_frame_new("Import privileges:");
    gtk_box_pack_start(GTK_BOX(question_vbox), frame3, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame3), table3);


    /* Settings */

    /* Import from */
    widgets->import_chkbtn_local = make_checkbutton_with_label(GTK_TABLE(table1), _("Local computer:"), 0,1,a,b);
    a++; b++;

    widgets->import_chkbtn_remote = make_checkbutton_with_label(GTK_TABLE(table1), _("Remote master domain:"), 0,1,a,b);

    a=0; b=1;


    /* Import users or groups */
    widgets->import_chkbtn_users = make_checkbutton_with_label(GTK_TABLE(table2), _("Users:"), 0,1,a,b);
    a++; b++;

    widgets->import_chkbtn_groups = make_checkbutton_with_label(GTK_TABLE(table2), _("Groups:"), 0,1,a,b);


    a=0; b=1;

    /* Import permissions (valid users, write list and/or admin users) */
    widgets->import_chkbtn_valid = make_checkbutton_with_label(GTK_TABLE(table3), _("Valid users:"), 0,1,a,b);
    a++; b++;
    widgets->import_chkbtn_write = make_checkbutton_with_label(GTK_TABLE(table3), _("Write list:"), 0,1,a,b);
    a++; b++;
    widgets->import_chkbtn_admin = make_checkbutton_with_label(GTK_TABLE(table3), _("Admin users:"), 0,1,a,b);
	      

    /* Buttons, "Abort", "Next"*/
    GtkWidget *hbutton_box = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbutton_box), GTK_BUTTONBOX_SPREAD);

    GtkWidget *cancel_button, *forward_button;

    cancel_button = gtk_button_new_from_stock(GTK_STOCK_QUIT);
    forward_button = gtk_button_new_from_stock(GTK_STOCK_GO_FORWARD);

    gtk_box_pack_start(GTK_BOX(hbutton_box), cancel_button, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbutton_box), forward_button, FALSE, FALSE, 0);

    gtk_container_add(GTK_CONTAINER(question_vbox), hbutton_box);


    /* Set default import states.. same as in gsambad.c (globals origin) */
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_local), TRUE);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_users), TRUE);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widgets->import_chkbtn_valid), TRUE);



    /* Signal hookups for the checkbuttons, all uses the same function to set globals */
    g_signal_connect((gpointer)widgets->import_chkbtn_local, "toggled",
                	    G_CALLBACK(import_local_checkbutton_toggled), widgets);

    g_signal_connect((gpointer)widgets->import_chkbtn_remote, "toggled",
                	    G_CALLBACK(import_remote_checkbutton_toggled), widgets);

    g_signal_connect((gpointer)widgets->import_chkbtn_users, "toggled",
                	    G_CALLBACK(import_users_checkbutton_toggled), widgets);

    g_signal_connect((gpointer)widgets->import_chkbtn_groups, "toggled",
                	    G_CALLBACK(import_groups_checkbutton_toggled), widgets);

    g_signal_connect((gpointer)widgets->import_chkbtn_valid, "toggled",
                	    G_CALLBACK(import_valid_checkbutton_toggled), widgets);

    g_signal_connect((gpointer)widgets->import_chkbtn_write, "toggled",
                	    G_CALLBACK(import_write_checkbutton_toggled), widgets);

    g_signal_connect((gpointer)widgets->import_chkbtn_admin, "toggled",
                	    G_CALLBACK(import_admin_checkbutton_toggled), widgets);


    /* Quit button */
    g_signal_connect_swapped((gpointer)cancel_button, "clicked",
                    	    G_CALLBACK(gtk_widget_destroy),
                            GTK_OBJECT(widgets->import_question_window));

    /* Forward button */
    g_signal_connect_swapped((gpointer)forward_button, "clicked",
                    	    G_CALLBACK(create_import_selection), widgets);


    gtk_widget_show_all(widgets->import_question_window);

    if( utf8 != NULL )
      g_free(utf8);
}
