/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "support.h"
#include "widgets.h"
/* For getuid */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>

#include "create_main_window.h"
#include "gsambad.h"
#include "commands.h"
#include "set_version.h"
#include "standard_conf.h"
#include "add_standard_users.h"
#include "create_server_tab.h"
#include "create_server_settings.h"
#include "create_user_tab.h"
#include "create_user_settings.h"
#include "create_share_tab.h"
#include "create_share_settings.h"
#include "create_macct_tab.h"
#include "create_macct_settings.h"
#include "create_conn_tab.h"
#include "create_disc_tab.h"
#include "create_security_tab.h"
#include "create_conf_tab.h"
#include "populate_gsambad.h"
#include "show_info.h"
#include "status_update.h"

int MAX_READ_POPEN = 16384;
int activated = 0;

int info_window_exit_main = 0;

char global_user_name[1024]="";
char global_share_name[16384]="";

char global_macct_name[1024]="";


/* Default values for the importer */
int global_import_local  = 1;
int global_import_remote = 0;

int global_import_users  = 1;
int global_import_groups = 0;

int global_import_valid  = 1;
int global_import_write  = 0;
int global_import_admin  = 0;



int main(int argc, char *argv[])
{
    gchar *gsambad_settings, *conf_path, *info;
    int i=0;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);

    wid* widgets = g_malloc(sizeof(wid));

    /* Non root usage */
    if( ! getuid() == 0 )
    {
	/* For setting a different exit method in the info window */
	info_window_exit_main = 1;

        info = g_strdup_printf("You must be root to run: %s\nThis window will close in 10 seconds.\n", PACKAGE);
        show_info(info);
        g_free(info);

	/* Users can close the info window earlier then the timeout */
	for(i=0; i<10; i++)
	{
    	    while(gtk_events_pending())
                  gtk_main_iteration();

	    /* Set when close info window is clicked */
	    if( info_window_exit_main == 2 )
	      break;

    	    usleep(100000*10);
    	}

	g_free(widgets);
	return 0;
    }


    /* Create the main window */
    create_main_window(widgets);
    
    /* Set SAMBA Version */
    set_version(widgets);

    /* Create the server tab */
    create_server_tab(widgets);

    /* Create the server settings */
    create_server_settings(widgets);

    /* Create the user tab */
    create_user_tab(widgets);

    /* Create the user settings */
    create_user_settings(widgets);


    /* Create the share tab */
    create_share_tab(widgets);
    create_share_settings(widgets);


    /* Create the machine account tab */
    create_macct_tab(widgets);
    create_macct_settings(widgets);

    /* Create the connection tab */
    create_conn_tab(widgets);
// FIXME   create_conn_settings(widgets);



    /* Create the disc tab */
    create_disc_tab(widgets);

    /* Create the security tab */
    create_security_tab(widgets);

    /* Create the conf tab */
    create_conf_tab(widgets);


    /* Add standard users (nobody etc) */
    add_standard_users(widgets);



//FIXME    conf_path = g_strdup_printf("%s/smb.conf", SAMBA_CONF_BUF);
    conf_path = g_strdup_printf("%s", SAMBA_CONF);
    gsambad_settings = g_strdup_printf("%s", SETTINGS_FILE);

    /* If theres no smb.conf, add one and populate the entire gui */
    if( ! file_exists(conf_path) )
      add_standard_conf(widgets);
    else      
    /* If we havnt asked to add an smb.conf file, then ask (show_conf_question: in gsambad's settings) */
    if( ! conf_ok(gsambad_settings) )
      create_standard_conf_question(widgets);
    else
      /* The conf is ok, populate the entire gui */
      populate_gsambad(widgets);

    g_free(conf_path);
    g_free(gsambad_settings);

    /* Window close button (x) */   
    g_signal_connect(GTK_OBJECT(widgets->main_window), "destroy",
	             GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    /* Activated/Deactivated status */
    gtk_timeout_add(1000, (GtkFunction) status_update, widgets);

    gtk_main();

    g_free(widgets);

    return 0;    
}
