/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: stage1app.cpp,v 1.1.4.4 2004/07/12 23:55:55 nhart Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#define INITGUID
#include "hxtypes.h"
#include "hxcom.h"
#include "hxbuffer.h"
#include "archive_info.h"
#include "stage1.h"
#include "safestring.h"

#ifndef _PASSWORD
#define _PASSWORD NULL
#endif

// so we can do some simple library dependency checking...
#include <dlfcn.h>
#include "ctype.h"
#include "stdio.h"



struct Dep
{
    const char* lib;
    const char* name;
    BOOL required;
    BOOL found;
};

BOOL CheckDeps()
{
    // XXXNH: this is really hacky, but we want to have some simple package
    // dependency checking for now
    BOOL bOk = TRUE;

    Dep deps[] = 
    {
#if !defined(_LINUX)	
        { "libiconv.so",       "libiconv",     TRUE,  FALSE },
#endif
	{ "libgtk-x11-2.0.so", "GTK+ 2.0",     TRUE,  FALSE },
	{ "libatk-1.0.so",     "ATK 1.0",      TRUE,  FALSE },
	{ "libpango-1.0.so",   "Pango 1.0",    TRUE,  FALSE },
	{ "libpangox-1.0.so",  "PangoX 1.0",   TRUE,  FALSE },
#if 0 // XXXNH: we don't use gnome or glade yet
	{ "libglade-2.0.so",   "Glade 2.0",    FALSE, FALSE },
	{ "libgmodule-2.0.so", "GModule 2.0",  FALSE, FALSE },
	{ "libgnome-2.so",     "Gnome 2.0",    FALSE, FALSE },
	{ "libgnomeui-2.so",   "Gnome UI 2.0", FALSE, FALSE },
#endif
	{ NULL, NULL, FALSE, FALSE } // terminator
    };

    BOOL bMissingRequired = FALSE;
    BOOL bMissingOptional = FALSE;
    for (Dep* dep = deps; dep->lib != NULL; dep++)
    {
	void* temp = dlopen(dep->lib, RTLD_LAZY);
	if (!temp)
	{
	    const int kAlternateSize = 256; // big enough for now
	    char pAlternate[kAlternateSize];
	    SafeStrCpy(pAlternate, dep->lib, kAlternateSize-3);
	    SafeStrCat(pAlternate, ".0", kAlternateSize);
	    temp = dlopen(pAlternate, RTLD_LAZY);
	}

	if (temp)
	{
	    dep->found = TRUE;
	    dlclose(temp);
	}
	else
	{
	    if (dep->required)
	    {
		bMissingRequired = TRUE;
	    }
	    else
	    {
		bMissingOptional = TRUE;
	    }
	}
    }

    if (bMissingRequired)
    {
	fprintf(stderr,
		"Some required libraries seem to be missing from your system.  Installation\n"
		"can continue without them, but you will be unable to run the HelixPlayer\n"
		"without them.  You will need to install them (or if they are already present\n"
		"you may simply need to update your system's library paths or LD_LIBRARY_PATH\n"
		"environment variable.\n");
	
    }
    else if (bMissingOptional)
    {
	fprintf(stderr,
		"Some optional libraries seem to be missing from your system.  Installation\n"
		"will continue, but there may be some HelixPlayer features unavailable.\n");
    }

    if (bMissingRequired || bMissingOptional)
    {
	for (Dep* dep = deps; dep->lib != NULL; dep++)
	{
	    if (!dep->found)
	    {
		fprintf(stderr, "\t%s (%s%s", dep->name, dep->lib,
			dep->required ? ")\n" : ", optional)\n");
	    }
	}

	if (bMissingRequired)
	{
	    fprintf(stderr, "continue with installation? [y/n]: ");
	    int ch = tolower(getchar());
	    bOk = (ch == 'y');
	}
	else
	{
	    fprintf(stderr, "installation will continue shortly");
	    for (int i = 0; i < 3; ++i)
	    {
		sleep(1);
		fprintf(stderr, ".");
	    }
	    fprintf(stderr, "\n");
	}
    }
    
    return bOk;
}


int
main(int argc, char* argv[])
{
    if (CheckDeps())
    {
	Stage1* pStage1 = new Stage1();
	return pStage1->Main(ARCHIVE_SIZE, ARCHIVE_PROG_SIZE, ARCHIVE_TYPE,
			     argc, argv, _PASSWORD);
    }
    return 0;
}
