/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: macrgbblt.cpp,v 1.1.1.1.42.1 2004/07/09 01:59:02 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxcom.h"
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxvsurf.h"
#include "colormap.h"

#include "macrgbblt.h"

CMacRGBBlt::CMacRGBBlt()
 :  CMacBlt()
 , m_GWorld(NULL)
 , m_Window(NULL)
{
}

CMacRGBBlt::~CMacRGBBlt()
{
    DestroySurface(0);
}

HX_RESULT CMacRGBBlt::CreateSurface(int cidIn, int& cidOut,
                                 int nWidth, int nHeight,
                                 int nFlags, HWND hWnd,
                                 int nCountIn, int& nCountOut)
{
#if defined (HELIX_FEATURE_CC_RGB32out)
    m_nCID = CID_RGB32;
#elif defined (HELIX_FEATURE_CC_RGB565out)
    m_nCID = CID_RGB565;
    nSize += 3 * sizeof(ULONG32);
#endif
    
    cidOut = m_nCID;
    
    m_Window = (WindowPtr)hWnd;

    // build a gworld and return OK!
    
    short depth = 32; // if CID_RGB32
    Rect r;
    r.left = 0;
    r.top = 0;
    r.right = nWidth;
    r.bottom = nHeight;
    
    ::NewGWorld( &m_GWorld, depth, &r, nil, nil, 0 );
    
    if (!m_GWorld) return HXR_FAIL;
    
    return HXR_OK;
}

HX_RESULT CMacRGBBlt::LockSurface(UCHAR** ppDestPtr,
                              LONG32* pnDestPitch,
                              int& cid,
                              REF(HXxSize) srcSize,
                              int nIndex)
{
    PixMapHandle theGWorldPixMap = ::GetPortPixMap( m_GWorld );
    ::LockPixels( theGWorldPixMap );
    
    *ppDestPtr = (UCHAR*) ::GetPixBaseAddr( theGWorldPixMap );
    *pnDestPitch = (**theGWorldPixMap).rowBytes & 0x3fff; // xxxbobclark lose the top two bits.

    cid = CID_RGB32;

    return HXR_OK;
}

HX_RESULT CMacRGBBlt::FillSurface(int cidIn,
                               UCHAR* pSrcBuffer,
                               HXxSize* pSrcSize,
                               HXxRect* prSrcRect,
                               UCHAR* pDstBuffer,
                               LONG32 nDstPitch,
                               HXxRect* prDestRect)
{
    
    return HXR_NOTIMPL;
}

HX_RESULT CMacRGBBlt::UnlockSurface(UCHAR* pSurfPtr, int nIndex)
{
    PixMapHandle theGWorldPixMap = ::GetPortPixMap( m_GWorld );
    ::UnlockPixels( theGWorldPixMap );
    return HXR_OK;
}

HX_RESULT CMacRGBBlt::RenderSurface(HXxSize* pSrcSize,
                                 HXxRect* prSrcRect,
                                 HXxRect* prDestRect,
                                 int nIndex)
{
    // xxxbobclark so is the src rect gonna be based on 0,0 like we assumed
    // when we created the gworld???
    
    GrafPtr savePort;
    ::GetPort( &savePort );
    GrafPtr theWindowPort = ::GetWindowPort( m_Window );
    ::SetPort( theWindowPort );
    
    PixMapHandle theGWorldPixMap = ::GetPortPixMap( m_GWorld );
    
    // convert HXxRect to OS specific Rect. (HXxRect's fields are long, Rect's fields are short)
    
    Rect srcR, dstR;
    
    srcR.left = prSrcRect->left;
    srcR.top = prSrcRect->top;
    srcR.right = prSrcRect->right;
    srcR.bottom = prSrcRect->bottom;
    
    dstR.left = prDestRect->left;
    dstR.top = prDestRect->top;
    dstR.right = prDestRect->right;
    dstR.bottom = prDestRect->bottom;
    
    ::CopyBits( (BitMap*)*theGWorldPixMap, ::GetPortBitMapForCopyBits( theWindowPort ),
		&srcR, &dstR, srcCopy, NULL );
    
    ::QDFlushPortBuffer( theWindowPort, NULL );
    
    ::SetPort( savePort );
    
    return HXR_OK;
}

HX_RESULT CMacRGBBlt::DestroySurface(int cid)
{
    ::DisposeGWorld( m_GWorld );
    // destroy gworld
    
    return HXR_OK;
}
