<?php
/**
 * This file lists the locations of cities around the world. The
 * format is:
 *
 *   $coordinates['countryname']['lat:long'] = 'cityname';
 *
 * Latitude and longitude are decimals (south and west are negative).
 *
 * $Horde: framework/NLS/NLS/coordinates.php,v 1.2 2003/11/06 21:03:10 chuck Exp $
 *
 * @package Horde_NLS
 */

$coordinates['Afghanistan']['31.000:61.850'] = "Zaranj";
$coordinates['Afghanistan']['32.367:62.183'] = "Farah";
$coordinates['Afghanistan']['33.400:62.283'] = "Shindand";
$coordinates['Afghanistan']['34.217:62.217'] = "Herat";
$coordinates['Afghanistan']['34.433:70.467'] = "Jalalabad";
$coordinates['Afghanistan']['34.633:69.200'] = "Kabul Airport";
$coordinates['Afghanistan']['35.133:69.250'] = "Jabul-Saraj";
$coordinates['Afghanistan']['36.500:71.250'] = "Zebak";
$coordinates['Afghanistan']['36.667:65.717'] = "Shebirghan";
$coordinates['Afghanistan']['36.700:67.200'] = "Mazar-I-Sharif";
$coordinates['Afghanistan']['37.117:70.517'] = "Faizabad";
$coordinates['Albania']['41.333:19.783'] = "Tirana";
$coordinates['Algeria']['24.550:9.467'] = "Djanet";
$coordinates['Algeria']['26.500:8.417'] = "Illizi";
$coordinates['Algeria']['27.667:-8.133'] = "Tindouf";
$coordinates['Algeria']['27.883:-0.283'] = "Adrar";
$coordinates['Algeria']['28.050:9.633'] = "In Amenas";
$coordinates['Algeria']['29.250:0.283'] = "Timimoun";
$coordinates['Algeria']['30.567:2.867'] = "El Golea";
$coordinates['Algeria']['31.617:-2.233'] = "Bechar";
$coordinates['Algeria']['31.667:6.150'] = "Hassi-Messaoud";
$coordinates['Algeria']['31.917:5.400'] = "Ouargla";
$coordinates['Algeria']['32.383:3.817'] = "Ghardaia";
$coordinates['Algeria']['33.117:6.133'] = "Touggourt";
$coordinates['Algeria']['33.500:6.117'] = "El Oued";
$coordinates['Algeria']['33.767:2.933'] = "Laghouat";
$coordinates['Algeria']['34.683:3.250'] = "Djelfa";
$coordinates['Algeria']['34.800:5.733'] = "Biskra";
$coordinates['Algeria']['34.933:-0.433'] = "Mecheria";
$coordinates['Algeria']['35.017:-1.467'] = "Tlemcen Zenata";
$coordinates['Algeria']['35.200:-0.133'] = "Mascara-Ghriss";
$coordinates['Algeria']['35.250:1.433'] = "Tiaret";
$coordinates['Algeria']['35.333:4.200'] = "Bou-Saada";
$coordinates['Algeria']['35.483:8.133'] = "Tebessa";
$coordinates['Algeria']['35.550:6.183'] = "Batna";
$coordinates['Algeria']['35.633:-0.600'] = "Oran / Es Senia";
$coordinates['Algeria']['36.183:5.417'] = "Setif";
$coordinates['Algeria']['36.217:1.333'] = "Chlef";
$coordinates['Algeria']['36.283:6.617'] = "Constantine";
$coordinates['Algeria']['36.717:3.250'] = "Dar-El-Beida";
$coordinates['Algeria']['36.717:5.067'] = "Bejaia";
$coordinates['Algeria']['36.833:7.817'] = "Annaba";
$coordinates['Algeria']['36.883:5.817'] = "Jijel Achouat";
$coordinates['Algeria']['36.933:6.950'] = "Skikda";
$coordinates['Angola']['-12.383:16.950'] = "Bie Silva Porto";
$coordinates['Angola']['-12.583:13.417'] = "Monbaca Benguela";
$coordinates['Angola']['-12.800:15.750'] = "Huambo Nova Lisboa";
$coordinates['Angola']['-5.550:12.183'] = "Cabinda";
$coordinates['Angola']['-8.850:13.233'] = "Luanda";
$coordinates['Antarctica']['-77.867:166.967'] = "Williams Field";
$coordinates['Antarctica']['-90.000:0.000'] = "Amundsen-Scott South Pole Station";
$coordinates['Antigua and Barbuda']['17.117:-61.783'] = "Vc Bird International Airport Antigua";
$coordinates['Antigua and Barbuda']['17.200:-62.583'] = "Charlestown / Newcast";
$coordinates['Argentina']['-22.100:-65.600'] = "La Quiaca Observatorio";
$coordinates['Argentina']['-22.650:-63.817'] = "Tartagal Aerodrome";
$coordinates['Argentina']['-23.150:-64.317'] = "Oran Aerodrome";
$coordinates['Argentina']['-24.167:-62.900'] = "Rivadavia";
$coordinates['Argentina']['-24.383:-65.083'] = "Jujuy Aerodrome";
$coordinates['Argentina']['-24.700:-60.583'] = "Las Lomitas";
$coordinates['Argentina']['-24.850:-65.483'] = "Salta Aerodrome";
$coordinates['Argentina']['-25.733:-54.467'] = "Iguazu Aerodrome";
$coordinates['Argentina']['-26.200:-58.233'] = "Formosa Aerodrome";
$coordinates['Argentina']['-26.817:-60.450'] = "Presidencia Roque Saenz Pena Aerodrome";
$coordinates['Argentina']['-26.850:-65.100'] = "Tucuman Aerodrome";
$coordinates['Argentina']['-27.367:-55.967'] = "Posadas Aero.";
$coordinates['Argentina']['-27.450:-58.767'] = "Corrientes Aero.";
$coordinates['Argentina']['-27.450:-59.050'] = "Resistencia Aero.";
$coordinates['Argentina']['-27.767:-64.300'] = "Santiago Del Estero Aero.";
$coordinates['Argentina']['-28.067:-67.567'] = "Tinogasta";
$coordinates['Argentina']['-28.600:-65.767'] = "Catamarca Aero.";
$coordinates['Argentina']['-29.217:-67.433'] = "Chilecito";
$coordinates['Argentina']['-29.383:-66.817'] = "La Rioja Aero.";
$coordinates['Argentina']['-29.683:-57.150'] = "Paso De Los Libres Aerodrome";
$coordinates['Argentina']['-29.783:-57.983'] = "Curuzu Cuatia Aerodrome";
$coordinates['Argentina']['-29.883:-61.950'] = "Ceres Aerodrome";
$coordinates['Argentina']['-29.900:-63.683'] = "Villa De Maria Del Rio Seco";
$coordinates['Argentina']['-30.250:-68.750'] = "Jachal";
$coordinates['Argentina']['-30.267:-57.650'] = "Monte Caseros Aerodrome";
$coordinates['Argentina']['-31.300:-58.017'] = "Concordia Aerodrome";
$coordinates['Argentina']['-31.317:-64.217'] = "Cordoba Aerodrome";
$coordinates['Argentina']['-31.333:-66.600'] = "Chepes";
$coordinates['Argentina']['-31.567:-68.867'] = "San Juan Aerodrome";
$coordinates['Argentina']['-31.667:-63.883'] = "Pilar Observatorio";
$coordinates['Argentina']['-31.700:-60.817'] = "Sauce Viejo Aerodrome";
$coordinates['Argentina']['-31.783:-60.483'] = "Parana Aerodrome";
$coordinates['Argentina']['-31.850:-59.083'] = "Villaguay Aerodrome";
$coordinates['Argentina']['-31.950:-65.133'] = "Villa Dolores Aerodrome";
$coordinates['Argentina']['-32.600:-69.333'] = "Uspallata";
$coordinates['Argentina']['-32.700:-62.150'] = "Marcos Juarez Aerodrome";
$coordinates['Argentina']['-32.833:-68.783'] = "Mendoza Aerodrome";
$coordinates['Argentina']['-32.917:-60.783'] = "Rosario Aerodrome";
$coordinates['Argentina']['-33.000:-58.617'] = "Gualeguaychu Aerodrome";
$coordinates['Argentina']['-33.083:-68.417'] = "San Martin";
$coordinates['Argentina']['-33.117:-64.233'] = "Rio Cuarto Aerodrome";
$coordinates['Argentina']['-33.267:-66.350'] = "San Luis Aerodrome";
$coordinates['Argentina']['-33.733:-65.383'] = "Villa Reynolds Aerodrome";
$coordinates['Argentina']['-33.767:-69.033'] = "San Carlos";
$coordinates['Argentina']['-34.133:-63.367'] = "Laboulaye";
$coordinates['Argentina']['-34.483:-58.617'] = "Don Torcuato Aerodrome";
$coordinates['Argentina']['-34.550:-60.917'] = "Junin Aerodrome";
$coordinates['Argentina']['-34.567:-58.417'] = "Aeroparque Bs. As. Aerodrome";
$coordinates['Argentina']['-34.583:-58.483'] = "Buenos Aires Observatorio";
$coordinates['Argentina']['-34.583:-68.400'] = "San Rafael Aerodrome";
$coordinates['Argentina']['-34.600:-58.600'] = "El Palomar Aerodrome";
$coordinates['Argentina']['-34.817:-58.533'] = "Ezeiza Aerodrome";
$coordinates['Argentina']['-34.967:-57.900'] = "La Plata Aerodrome";
$coordinates['Argentina']['-35.500:-69.583'] = "Malargue Aerodrome";
$coordinates['Argentina']['-35.700:-63.750'] = "General Pico Aerodrome";
$coordinates['Argentina']['-35.867:-61.900'] = "Pehuajo Aerodrome";
$coordinates['Argentina']['-36.350:-57.733'] = "Dolores Aerodrome";
$coordinates['Argentina']['-36.567:-64.267'] = "Santa Rosa Aerodrome";
$coordinates['Argentina']['-36.750:-59.833'] = "Azul Airport";
$coordinates['Argentina']['-37.233:-57.033'] = "Villa Gesell";
$coordinates['Argentina']['-37.233:-59.250'] = "Tandil Aerodrome";
$coordinates['Argentina']['-37.600:-62.383'] = "Pigue Aerodrome";
$coordinates['Argentina']['-37.933:-57.583'] = "Mar Del Plata Aerodrome";
$coordinates['Argentina']['-38.333:-60.250'] = "Tres Arroyos";
$coordinates['Argentina']['-38.733:-62.167'] = "Bahia Blanca Aerodrome";
$coordinates['Argentina']['-38.950:-68.133'] = "Neuquen Aerodrome";
$coordinates['Argentina']['-39.017:-64.083'] = "Rio Colorado";
$coordinates['Argentina']['-40.083:-71.133'] = "Chapelco";
$coordinates['Argentina']['-40.783:-65.100'] = "San Antonio Oeste Aerodrome";
$coordinates['Argentina']['-40.850:-63.017'] = "Viedma Aerodrome";
$coordinates['Argentina']['-41.150:-71.167'] = "Bariloche Aerodrome";
$coordinates['Argentina']['-41.967:-71.517'] = "El Bolson Aerodrome";
$coordinates['Argentina']['-42.933:-71.150'] = "Esquel Aerodrome";
$coordinates['Argentina']['-43.200:-65.267'] = "Trelew Aerodrome";
$coordinates['Argentina']['-43.817:-68.883'] = "Paso De Indios";
$coordinates['Argentina']['-45.783:-67.500'] = "Comodoro Rivadavia Aerodrome";
$coordinates['Argentina']['-46.517:-71.017'] = "Perito Moreno Aerodrome";
$coordinates['Argentina']['-47.733:-65.917'] = "Puerto Deseado Aerodrome";
$coordinates['Argentina']['-48.783:-70.167'] = "Gobernador Gregores Aerodrome";
$coordinates['Argentina']['-49.317:-67.750'] = "San Julian Aerodrome";
$coordinates['Argentina']['-50.017:-68.567'] = "Santa Cruz Aerodrome";
$coordinates['Argentina']['-50.333:-72.300'] = "Lago Argentino Aerodrome";
$coordinates['Argentina']['-51.617:-69.283'] = "Rio Gallegos Aerodrome";
$coordinates['Argentina']['-53.800:-67.750'] = "Rio Grande B. A.";
$coordinates['Argentina']['-54.800:-68.317'] = "Ushuaia Aerodrome";
$coordinates['Armenia']['40.133:44.467'] = "Yerevan";
$coordinates['Aruba']['12.500:-70.017'] = "Queen Beatrix Airport";
$coordinates['Australia']['-12.267:136.817'] = "Gove Airport";
$coordinates['Australia']['-12.400:130.867'] = "Darwin Airport";
$coordinates['Australia']['-12.633:141.883'] = "Weipa City";
$coordinates['Australia']['-15.767:128.700'] = "Kununurra Kununurra Aws";
$coordinates['Australia']['-16.883:145.750'] = "Cairns Airport";
$coordinates['Australia']['-17.300:123.617'] = "Derby";
$coordinates['Australia']['-17.950:122.217'] = "Broome Airport";
$coordinates['Australia']['-19.250:146.750'] = "Townsville Amo";
$coordinates['Australia']['-19.633:134.167'] = "Tennant Creek Airport";
$coordinates['Australia']['-20.100:119.567'] = "Port Hedland Pardoo";
$coordinates['Australia']['-20.483:148.533'] = "Proserpine Airport";
$coordinates['Australia']['-20.667:139.467'] = "Mount Isa Amo";
$coordinates['Australia']['-21.117:149.200'] = "Mackay Mo";
$coordinates['Australia']['-22.233:114.083'] = "Learmonth Airport";
$coordinates['Australia']['-23.383:150.467'] = "Rockhampton Airport";
$coordinates['Australia']['-23.433:144.267'] = "Longreach Airport";
$coordinates['Australia']['-23.800:133.883'] = "Alice Springs Aerodrome";
$coordinates['Australia']['-23.850:151.250'] = "Gladstone";
$coordinates['Australia']['-25.183:130.967'] = "Yulara Aws";
$coordinates['Australia']['-26.400:146.267'] = "Charleville Airport";
$coordinates['Australia']['-26.600:118.533'] = "Meekatharra Airport";
$coordinates['Australia']['-27.383:153.100'] = "Brisbane Airport M. O";
$coordinates['Australia']['-27.417:151.733'] = "Oakey Aerodrome";
$coordinates['Australia']['-27.567:153.000'] = "Archerfield Aerodrome";
$coordinates['Australia']['-27.633:152.717'] = "Amberley Aerodrome";
$coordinates['Australia']['-28.167:153.500'] = "Coolangatta Airport Aws";
$coordinates['Australia']['-28.783:114.700'] = "Geraldton Airport";
$coordinates['Australia']['-29.033:167.933'] = "Norfolk Island Airport";
$coordinates['Australia']['-30.317:153.117'] = "Coffs Harbour Mo";
$coordinates['Australia']['-30.583:138.417'] = "Leigh Creek Airport";
$coordinates['Australia']['-30.783:121.450'] = "Kalgoorlie Boulder Amo";
$coordinates['Australia']['-30.833:128.100'] = "Forrest Airport";
$coordinates['Australia']['-31.083:150.833'] = "Tamworth Airport";
$coordinates['Australia']['-31.133:136.817'] = "Woomera Aerodrome";
$coordinates['Australia']['-31.667:116.017'] = "Bullsbrook Pearce Amo";
$coordinates['Australia']['-31.933:115.950'] = "Belmont Perth Airport";
$coordinates['Australia']['-31.967:141.467'] = "Broken Hill Patton Street";
$coordinates['Australia']['-32.117:133.700'] = "Ceduna Airport";
$coordinates['Australia']['-32.200:148.567'] = "Dubbo";
$coordinates['Australia']['-32.783:151.817'] = "Williamtown Aerodrome";
$coordinates['Australia']['-33.600:150.783'] = "Richmond Aus-Afb";
$coordinates['Australia']['-33.917:150.983'] = "Bankstown Airport Aws";
$coordinates['Australia']['-33.950:151.183'] = "Sydney Airport";
$coordinates['Australia']['-34.033:150.683'] = "Camden Airport";
$coordinates['Australia']['-34.217:142.083'] = "Mildura Airport";
$coordinates['Australia']['-34.700:138.617'] = "Edinburgh M. O.";
$coordinates['Australia']['-34.783:138.633'] = "Parafield Airport";
$coordinates['Australia']['-34.933:117.800'] = "Albany Airport";
$coordinates['Australia']['-34.933:138.517'] = "Adelaide Airport";
$coordinates['Australia']['-34.950:150.533'] = "Nowra Ran Air Station";
$coordinates['Australia']['-35.150:147.450'] = "Wagga Airport";
$coordinates['Australia']['-35.300:149.183'] = "Canberra";
$coordinates['Australia']['-36.067:146.950'] = "Albury Airport";
$coordinates['Australia']['-36.233:149.083'] = "Cooma";
$coordinates['Australia']['-37.667:144.833'] = "Melbourne Airport";
$coordinates['Australia']['-37.733:140.783'] = "Mount Gambier Aerodrome";
$coordinates['Australia']['-37.733:145.400'] = "Goldstream Aws";
$coordinates['Australia']['-37.850:144.733'] = "Laverton Aerodrome";
$coordinates['Australia']['-37.967:145.100'] = "Moorabbin Airport Aws";
$coordinates['Australia']['-38.100:147.133'] = "East Sale Aerodrome";
$coordinates['Australia']['-40.983:145.717'] = "Wynyard West";
$coordinates['Australia']['-41.167:146.367'] = "Devonport East";
$coordinates['Australia']['-41.533:147.200'] = "Launceston Airport";
$coordinates['Australia']['-42.833:147.483'] = "Hobart Airport";
$coordinates['Australia']['-54.483:158.950'] = "Macquarie Island";
$coordinates['Austria']['46.650:14.333'] = "Klagenfurt-Flughafen";
$coordinates['Austria']['47.000:15.433'] = "Graz-Thalerhof-Flughafen";
$coordinates['Austria']['47.200:14.750'] = "Zeltweg";
$coordinates['Austria']['47.267:11.350'] = "Innsbruck-Flughafen";
$coordinates['Austria']['47.333:11.700'] = "Schwaz Heliport";
$coordinates['Austria']['47.533:14.133'] = "Aigen Im Ennstal";
$coordinates['Austria']['47.800:13.000'] = "Salzburg-Flughafen";
$coordinates['Austria']['47.964:16.259'] = "Niederosterreich / Lugplatz  Voslau";
$coordinates['Austria']['48.117:16.567'] = "Wien / Schwechat-Flughafen";
$coordinates['Austria']['48.233:14.183'] = "Horsching Aus-Afb";
$coordinates['Austria']['48.233:14.183'] = "Linz / Hoersching-Flughafen";
$coordinates['Austria']['48.317:16.117'] = "Tulln";
$coordinates['Azerbaijan']['40.450:50.067'] = "Baku / Bine Airport";
$coordinates['Bahamas']['20.950:-73.683'] = "Matthew Town, Inagua";
$coordinates['Bahamas']['23.475:-75.767'] = "Georgetown, Exuma";
$coordinates['Bahamas']['24.050:-74.533'] = "Cockburn Town, San Salvador";
$coordinates['Bahamas']['25.050:-77.467'] = "Nassau Airport";
$coordinates['Bahamas']['25.733:-79.300'] = "Alice Town, Bimini";
$coordinates['Bahamas']['26.550:-78.700'] = "Freeport, Grand Bahama";
$coordinates['Bahamas']['26.700:-78.967'] = "West End, Grand Bahama";
$coordinates['Bahrain']['26.267:50.650'] = "Bahrain International Airport";
$coordinates['Bangladesh']['21.433:91.967'] = "Cox's Bazar";
$coordinates['Bangladesh']['22.267:91.817'] = "Chittagong Patenga";
$coordinates['Bangladesh']['23.183:89.167'] = "Jessore";
$coordinates['Bangladesh']['23.767:90.383'] = "Dhaka";
$coordinates['Bangladesh']['23.850:90.400'] = "Kurmitola, Dia";
$coordinates['Bangladesh']['24.133:89.050'] = "Ishurdi";
$coordinates['Bangladesh']['24.367:88.700'] = "Rajshahi";
$coordinates['Bangladesh']['24.900:91.883'] = "Sylhet";
$coordinates['Barbados']['13.067:-59.483'] = "Grantley Adams";
$coordinates['Belarus']['53.933:27.633'] = "Minsk";
$coordinates['Belarus']['55.167:30.217'] = "Vitebsk";
$coordinates['Belgium']['49.900:5.217'] = "Bertrix Bel-Afb";
$coordinates['Belgium']['50.033:5.400'] = "St-Hubert";
$coordinates['Belgium']['50.233:4.650'] = "Florennes";
$coordinates['Belgium']['50.467:4.450'] = "Charleroi / Gosselies";
$coordinates['Belgium']['50.467:6.183'] = "Elsenborn";
$coordinates['Belgium']['50.483:5.917'] = "Spa / La Sauveniere";
$coordinates['Belgium']['50.567:3.833'] = "Chievres";
$coordinates['Belgium']['50.650:5.450'] = "Bierset";
$coordinates['Belgium']['50.750:4.767'] = "Beauvechain";
$coordinates['Belgium']['50.783:4.950'] = "Goetsenhoven";
$coordinates['Belgium']['50.800:5.200'] = "Sint-Truiden";
$coordinates['Belgium']['50.900:4.500'] = "Melsbroek Bel-Afb";
$coordinates['Belgium']['50.900:4.533'] = "Bruxelles National";
$coordinates['Belgium']['50.933:3.733'] = "Munte";
$coordinates['Belgium']['50.933:5.500'] = "Genk";
$coordinates['Belgium']['51.000:5.067'] = "Schaffen";
$coordinates['Belgium']['51.083:2.650'] = "Koksijde";
$coordinates['Belgium']['51.167:5.467'] = "Kleine Brogel";
$coordinates['Belgium']['51.183:3.817'] = "Gent / Industrie-Zone";
$coordinates['Belgium']['51.200:2.867'] = "Oostende Airport";
$coordinates['Belgium']['51.200:4.467'] = "Antwerpen / Deurne";
$coordinates['Belgium']['51.333:4.500'] = "Brasschaat";
$coordinates['Belgium']['51.417:5.000'] = "Weelde Military";
$coordinates['Belize']['17.533:-88.300'] = "Belize / Phillip Goldston Intl. Airport";
$coordinates['Benin']['10.317:1.383'] = "Natitingou";
$coordinates['Benin']['11.133:2.933'] = "Kandi";
$coordinates['Benin']['6.350:2.383'] = "Cotonou";
$coordinates['Benin']['7.167:2.067'] = "Bohicon";
$coordinates['Benin']['8.033:2.467'] = "Save";
$coordinates['Benin']['9.350:2.617'] = "Parakou";
$coordinates['Bermuda']['32.367:-64.683'] = "Bermuda";
$coordinates['Bolivia']['-10.817:-65.350'] = "Guayaramerin";
$coordinates['Bolivia']['-11.000:-66.117'] = "Riberalta";
$coordinates['Bolivia']['-11.033:-68.783'] = "Cobija";
$coordinates['Bolivia']['-13.067:-64.817'] = "San Joaquin";
$coordinates['Bolivia']['-13.333:-64.117'] = "Magdalena";
$coordinates['Bolivia']['-13.767:-65.433'] = "Santa Ana";
$coordinates['Bolivia']['-14.317:-67.383'] = "Reyes";
$coordinates['Bolivia']['-14.467:-67.567'] = "Rurrenabaque";
$coordinates['Bolivia']['-14.733:-68.500'] = "Apolo";
$coordinates['Bolivia']['-14.817:-64.917'] = "Trinidad";
$coordinates['Bolivia']['-14.867:-66.867'] = "San Borja";
$coordinates['Bolivia']['-14.917:-65.600'] = "San Ignacio De Moxos";
$coordinates['Bolivia']['-15.717:-63.100'] = "Ascencion De Guarayos";
$coordinates['Bolivia']['-16.150:-62.017'] = "Concepcion";
$coordinates['Bolivia']['-16.267:-62.467'] = "San Javier";
$coordinates['Bolivia']['-16.383:-60.967'] = "San Ignacio De Velasco";
$coordinates['Bolivia']['-16.517:-68.183'] = "La Paz / Alto";
$coordinates['Bolivia']['-17.417:-66.183'] = "Cochabamba";
$coordinates['Bolivia']['-17.583:-69.600'] = "Charana";
$coordinates['Bolivia']['-17.633:-63.133'] = "Viru-Viru";
$coordinates['Bolivia']['-17.800:-60.733'] = "San Jose De Chiquitos";
$coordinates['Bolivia']['-17.800:-63.183'] = "Santa Cruz / El Trompillo";
$coordinates['Bolivia']['-17.967:-67.067'] = "Oruro";
$coordinates['Bolivia']['-18.317:-59.767'] = "Robore";
$coordinates['Bolivia']['-18.983:-57.817'] = "Puerto Suarez";
$coordinates['Bolivia']['-19.017:-65.300'] = "Sucre";
$coordinates['Bolivia']['-19.550:-65.733'] = "Potosi";
$coordinates['Bolivia']['-20.000:-63.533'] = "Camiri";
$coordinates['Bolivia']['-21.250:-63.450'] = "Villamontes";
$coordinates['Bolivia']['-21.550:-64.700'] = "Tarija";
$coordinates['Bolivia']['-21.950:-63.650'] = "Yacuiba";
$coordinates['Bosnia and Herzegovina']['43.833:17.017'] = "Livno";
$coordinates['Botswana']['-17.817:25.150'] = "Kasane";
$coordinates['Botswana']['-18.367:21.850'] = "Shakawe";
$coordinates['Botswana']['-19.983:23.417'] = "Maun";
$coordinates['Botswana']['-20.467:25.983'] = "Sua-Pan";
$coordinates['Botswana']['-21.217:27.500'] = "Francistown";
$coordinates['Botswana']['-21.417:25.600'] = "Letlhakane";
$coordinates['Botswana']['-21.700:21.650'] = "Ghanzi";
$coordinates['Botswana']['-24.017:21.883'] = "Tshane";
$coordinates['Botswana']['-24.217:25.917'] = "Seretse Khama International Airport";
$coordinates['Botswana']['-24.600:24.667'] = "Jwaneng";
$coordinates['Botswana']['-26.050:22.450'] = "Tsabong";
$coordinates['Brazil']['0.033:-50.050'] = "Macapa";
$coordinates['Brazil']['-0.133:-67.083'] = "Sao Gabriel Da Cachoeira";
$coordinates['Brazil']['0.617:-69.200'] = "Iauarete";
$coordinates['Brazil']['-0.983:-62.583'] = "Barcelos";
$coordinates['Brazil']['-1.383:-48.483'] = "Belem Aeroporto";
$coordinates['Brazil']['-10.000:-67.800'] = "Rio Branco";
$coordinates['Brazil']['-10.700:-48.400'] = "Porto Nacional Aeroporto";
$coordinates['Brazil']['-10.983:-37.067'] = "Aracaju Aeroporto";
$coordinates['Brazil']['-12.700:-60.100'] = "Vilhena Aeroporto";
$coordinates['Brazil']['-12.900:-38.333'] = "Salvador Aeroporto";
$coordinates['Brazil']['-13.267:-43.417'] = "Bom Jesus Da Lapa";
$coordinates['Brazil']['-14.700:-52.350'] = "Xavantina";
$coordinates['Brazil']['-14.817:-39.033'] = "Ilheus Aeroporto";
$coordinates['Brazil']['-14.950:-40.883'] = "Vitoria Da Conquista";
$coordinates['Brazil']['-15.650:-56.100'] = "Cuiaba Aeroporto";
$coordinates['Brazil']['-15.867:-47.933'] = "Brasilia Aeroporto";
$coordinates['Brazil']['-15.867:-52.383'] = "Barra Do Garcas";
$coordinates['Brazil']['-16.050:-48.050'] = "Gama";
$coordinates['Brazil']['-16.233:-48.967'] = "Anapolis Braz-Afb";
$coordinates['Brazil']['-16.633:-49.217'] = "Goiania Aeroporto";
$coordinates['Brazil']['-16.717:-43.867'] = "Montes Claros";
$coordinates['Brazil']['-17.633:-39.250'] = "Caravelas Aeropor-To";
$coordinates['Brazil']['-19.083:-57.500'] = "Corumba";
$coordinates['Brazil']['-19.783:-47.967'] = "Uberaba";
$coordinates['Brazil']['-19.850:-43.950'] = "Belo Horizonte Aeroporto";
$coordinates['Brazil']['-19.933:-43.933'] = "Belo Horizonte";
$coordinates['Brazil']['-2.433:-54.717'] = "Santarem-Aeroporto";
$coordinates['Brazil']['-2.600:-44.233'] = "Sao Luiz Aeroporto";
$coordinates['Brazil']['2.833:-60.700'] = "Boa Vista Aeropor-To";
$coordinates['Brazil']['-2.917:-41.750'] = "Parnaiba Aeroporto";
$coordinates['Brazil']['-20.267:-40.283'] = "Vitoria Aeroporto";
$coordinates['Brazil']['-20.467:-54.667'] = "Campo Grande Aeroporto";
$coordinates['Brazil']['-21.250:-43.767'] = "Barbacena";
$coordinates['Brazil']['-21.750:-41.333'] = "Campos";
$coordinates['Brazil']['-21.767:-43.350'] = "Juiz De Fora";
$coordinates['Brazil']['-21.850:-46.567'] = "Pocos De Caldas";
$coordinates['Brazil']['-21.983:-47.333'] = "Pirassununga";
$coordinates['Brazil']['-22.017:-47.883'] = "Sao Carlos";
$coordinates['Brazil']['-22.117:-51.383'] = "Presidente Prudente";
$coordinates['Brazil']['-22.317:-49.067'] = "Bauru";
$coordinates['Brazil']['-22.483:-44.467'] = "Resende";
$coordinates['Brazil']['-22.550:-55.700'] = "Ponta Pora Aeropor-To";
$coordinates['Brazil']['-22.783:-45.200'] = "Guaratingueta";
$coordinates['Brazil']['-22.817:-42.100'] = "S. P. Aldeia Aerodrome";
$coordinates['Brazil']['-22.817:-43.250'] = "Galeao";
$coordinates['Brazil']['-22.867:-43.367'] = "Afonsos Aeroporto";
$coordinates['Brazil']['-22.900:-43.167'] = "Rio De Janeiro Aeroporto";
$coordinates['Brazil']['-22.933:-43.717'] = "Santa Cruz Aeropor-To";
$coordinates['Brazil']['-22.983:-43.367'] = "Rio / Jacarepagua";
$coordinates['Brazil']['-23.000:-47.133'] = "Campinas Aeroporto";
$coordinates['Brazil']['-23.333:-51.133'] = "Londrina Aeroporto";
$coordinates['Brazil']['-23.417:-51.950'] = "Maringa";
$coordinates['Brazil']['-23.517:-46.633'] = "Marte Civ / Mil";
$coordinates['Brazil']['-23.617:-46.650'] = "Sao Paulo Aeropor-To";
$coordinates['Brazil']['-23.933:-46.300'] = "Santos Aeroporto";
$coordinates['Brazil']['-25.433:-49.267'] = "Curitiba";
$coordinates['Brazil']['-25.517:-48.517'] = "Paranagua";
$coordinates['Brazil']['-25.517:-49.167'] = "Curitiba Aeroporto";
$coordinates['Brazil']['-25.517:-54.583'] = "Foz Do Iguacu Aeroporto";
$coordinates['Brazil']['-27.667:-48.550'] = "Florianopolis Aeroporto";
$coordinates['Brazil']['-28.250:-52.400'] = "Passo Fundo";
$coordinates['Brazil']['-29.717:-53.700'] = "Santa Maria Aero-Porto";
$coordinates['Brazil']['-29.783:-57.033'] = "Uruguaiana Aeroporto";
$coordinates['Brazil']['-3.033:-60.050'] = "Eduardo Gomes International";
$coordinates['Brazil']['-3.150:-59.983'] = "Manaus Aeroporto";
$coordinates['Brazil']['-3.200:-52.200'] = "Altamira";
$coordinates['Brazil']['-3.367:-64.683'] = "Tefe";
$coordinates['Brazil']['-3.667:-69.667'] = "Tabatinga";
$coordinates['Brazil']['-3.717:-49.717'] = "Tucurui";
$coordinates['Brazil']['-3.783:-38.533'] = "Fortaleza Aeropor-To";
$coordinates['Brazil']['3.833:-51.833'] = "Oiapoque";
$coordinates['Brazil']['-3.850:-32.417'] = "Fernando De Noronha";
$coordinates['Brazil']['-30.000:-51.183'] = "Porto Alegre Aero-Porto";
$coordinates['Brazil']['-30.017:-51.217'] = "Porto Alegre";
$coordinates['Brazil']['-31.350:-54.117'] = "Bage Aeroporto";
$coordinates['Brazil']['-31.867:-52.350'] = "Pelotas";
$coordinates['Brazil']['-4.250:-56.000'] = "Itaituba";
$coordinates['Brazil']['-4.383:-70.033'] = "Benjamin Constant";
$coordinates['Brazil']['-5.050:-42.817'] = "Teresina Aeroporto";
$coordinates['Brazil']['-5.200:-37.367'] = "Mocoro / 17 Rosado";
$coordinates['Brazil']['-5.350:-49.150'] = "Maraba";
$coordinates['Brazil']['-5.533:-47.500'] = "Imperatriz";
$coordinates['Brazil']['-5.817:-61.300'] = "Manicore";
$coordinates['Brazil']['-5.917:-35.250'] = "Natal Aeroporto";
$coordinates['Brazil']['-6.267:-57.733'] = "Jacareacanga";
$coordinates['Brazil']['-7.100:-34.867'] = "Joao Pessoa";
$coordinates['Brazil']['-7.217:-35.883'] = "Campina Grande";
$coordinates['Brazil']['-7.317:-47.467'] = "Maranhao / Carolina Airport";
$coordinates['Brazil']['-7.633:-72.667'] = "Cruzeiro Do Sul";
$coordinates['Brazil']['-8.067:-34.850'] = "Recife Aeroporto";
$coordinates['Brazil']['-8.167:-70.767'] = "Tarauaca";
$coordinates['Brazil']['-8.250:-49.283'] = "Conceicao Do Araguaia";
$coordinates['Brazil']['-8.767:-63.917'] = "Porto Velho Aeroporto";
$coordinates['Brazil']['-9.350:-40.550'] = "Petrolina Aeropor-To";
$coordinates['Brazil']['-9.400:-38.217'] = "Paulo Afonso";
$coordinates['Brazil']['-9.517:-35.783'] = "Maceio Aeroporto";
$coordinates['Brazil']['-9.867:-56.100'] = "Alta Floresta Aeroporto";
$coordinates['British Indian Ocean Territory']['-7.300:72.400'] = "Diego Garcia";
$coordinates['Brunei Darussalam']['4.933:114.933'] = "Brunei Airport";
$coordinates['Bulgaria']['42.133:24.750'] = "Plovdiv";
$coordinates['Bulgaria']['42.483:27.483'] = "Burgas";
$coordinates['Bulgaria']['42.650:23.383'] = "Sofia Observ.";
$coordinates['Bulgaria']['43.200:27.917'] = "Varna";
$coordinates['Bulgaria']['43.850:25.950'] = "Rousse";
$coordinates['Burkina Faso']['10.333:-3.183'] = "Gaoua";
$coordinates['Burkina Faso']['11.150:-1.150'] = "Po";
$coordinates['Burkina Faso']['11.167:-4.317'] = "Bobo-Dioulasso";
$coordinates['Burkina Faso']['11.750:-2.933'] = "Boromo";
$coordinates['Burkina Faso']['12.033:0.367'] = "Fada N'Gourma";
$coordinates['Burkina Faso']['12.350:-1.517'] = "Ouagadougou";
$coordinates['Burkina Faso']['12.467:-3.483'] = "Dedougou";
$coordinates['Burkina Faso']['13.567:-2.417'] = "Ouahigouya";
$coordinates['Burkina Faso']['14.033:-0.033'] = "Dori";
$coordinates['Burundi']['-3.317:29.317'] = "Bujumbura";
$coordinates['Cambodia']['11.550:104.850'] = "Phnom-Penh / Pochentong";
$coordinates['Cambodia']['12.000:105.450'] = "Kompong-Cham";
$coordinates['Cambodia']['13.367:103.850'] = "Siemreap";
$coordinates['Cameroon']['10.450:14.250'] = "Maroua-Salak";
$coordinates['Cameroon']['2.950:9.900'] = "Kribi";
$coordinates['Cameroon']['3.150:13.617'] = "Lomie";
$coordinates['Cameroon']['3.833:11.517'] = "Yaounde";
$coordinates['Cameroon']['3.967:13.200'] = "Abong-Mbang";
$coordinates['Cameroon']['4.000:9.733'] = "Douala Obs.";
$coordinates['Cameroon']['4.083:9.367'] = "Tiko";
$coordinates['Cameroon']['4.467:14.367'] = "Batouri";
$coordinates['Cameroon']['4.733:11.250'] = "Bafia";
$coordinates['Cameroon']['4.950:9.933'] = "Nkongsamba";
$coordinates['Cameroon']['5.550:12.367'] = "Yoko";
$coordinates['Cameroon']['5.600:14.067'] = "Betare-Oya";
$coordinates['Cameroon']['5.650:10.750'] = "Koundja";
$coordinates['Cameroon']['5.717:9.283'] = "Mamfe";
$coordinates['Cameroon']['6.050:10.117'] = "Bamenda";
$coordinates['Cameroon']['6.533:14.367'] = "Meiganga";
$coordinates['Cameroon']['6.783:11.817'] = "Banyo";
$coordinates['Cameroon']['7.350:13.567'] = "Ngaoundere";
$coordinates['Cameroon']['9.333:13.383'] = "Garoua";
$coordinates['Canada']['41.833:-82.467'] = "S. E. Shoal Meteorological Aeronautical Presentation System";
$coordinates['Canada']['42.250:-81.900'] = "Erieau Meteorological Aeronautical Presentation System";
$coordinates['Canada']['42.267:-82.967'] = "Windsor, Ont.";
$coordinates['Canada']['42.300:-82.700'] = "Belle River";
$coordinates['Canada']['42.567:-80.050'] = "Long Point Meteorological Aeronautical Presentation System";
$coordinates['Canada']['42.850:-80.267'] = "Simcoe, Ont.";
$coordinates['Canada']['42.867:-79.250'] = "Port Colborne Automated Reporting Station";
$coordinates['Canada']['42.867:-80.550'] = "Delhi CS, Ont.";
$coordinates['Canada']['43.000:-82.317'] = "Sarnia Airport";
$coordinates['Canada']['43.033:-81.150'] = "London, Ont.";
$coordinates['Canada']['43.167:-79.933'] = "Hamilton Airport";
$coordinates['Canada']['43.250:-79.217'] = "Port Weller, Ont.";
$coordinates['Canada']['43.300:-79.800'] = "Burlington Piers";
$coordinates['Canada']['43.467:-80.383'] = "Waterloo Well";
$coordinates['Canada']['43.617:-79.350'] = "Toronto Headland";
$coordinates['Canada']['43.633:-79.400'] = "Toronto Island Airport Automated Reporting Station";
$coordinates['Canada']['43.667:-79.633'] = "Toronto Pearson Int'L. Ont.";
$coordinates['Canada']['43.767:-81.717'] = "Goderich Automatic Weather Reporting System";
$coordinates['Canada']['43.783:-79.467'] = "Toronto Aes Hq";
$coordinates['Canada']['43.833:-66.083'] = "Yarmouth, N. S.";
$coordinates['Canada']['43.833:-77.150'] = "Point Petre , Ont.";
$coordinates['Canada']['43.933:-60.017'] = "Sable Island, N. S.";
$coordinates['Canada']['43.950:-78.167'] = "Cobourg, Ont.";
$coordinates['Canada']['43.983:-64.667'] = "Western Head, N. S.";
$coordinates['Canada']['43.983:-80.750'] = "Mount Forest, Ont.";
$coordinates['Canada']['44.117:-77.533'] = "Trenton, Ont.";
$coordinates['Canada']['44.217:-76.600'] = "Kingston, Ont.";
$coordinates['Canada']['44.233:-78.367'] = "Peterborough Airport";
$coordinates['Canada']['44.286:-66.347'] = "Brier Island, N. S.";
$coordinates['Canada']['44.383:-79.783'] = "Barrie, Ont.";
$coordinates['Canada']['44.417:-75.850'] = "Grenadier Island";
$coordinates['Canada']['44.433:-65.200'] = "Kejimkujik 1, N. S.";
$coordinates['Canada']['44.500:-80.217'] = "Collingwood Automatic Weather Reporting System";
$coordinates['Canada']['44.533:-79.217'] = "Lagoon City";
$coordinates['Canada']['44.633:-63.500'] = "Shearwater, N. S.";
$coordinates['Canada']['44.700:-76.300'] = "Upper Rideau Lake";
$coordinates['Canada']['44.733:-81.283'] = "Oliphant \ Ont";
$coordinates['Canada']['44.750:-81.100'] = "Wiarton, Ont.";
$coordinates['Canada']['44.817:-62.333'] = "Beaven Island, N. S.";
$coordinates['Canada']['44.850:-79.867'] = "Beausoleil Island Automated Reporting Station";
$coordinates['Canada']['44.883:-63.500'] = "Halifax International Airport";
$coordinates['Canada']['44.967:-79.300'] = "Muskoka, Ont.";
$coordinates['Canada']['44.983:-64.917'] = "Greenwood, N. S.";
$coordinates['Canada']['45.033:-80.367'] = "Western Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['45.050:-72.833'] = "Frelighsburg";
$coordinates['Canada']['45.067:-64.483'] = "Kentville , N. S.";
$coordinates['Canada']['45.117:-74.283'] = "St Anicet";
$coordinates['Canada']['45.167:-73.683'] = "Saint Clothilde Automated Reporting Station";
$coordinates['Canada']['45.217:-67.250'] = "St. Stephen, N. B.";
$coordinates['Canada']['45.300:-73.350'] = "L'Acadie";
$coordinates['Canada']['45.317:-72.250'] = "Mont-Orford";
$coordinates['Canada']['45.317:-75.667'] = "Ottawa Int'L. Ont.";
$coordinates['Canada']['45.333:-65.883'] = "Saint John, N. B.";
$coordinates['Canada']['45.333:-81.733'] = "Cove Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['45.350:-60.983'] = "Hart Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['45.367:-63.267'] = "Truro, N. S.";
$coordinates['Canada']['45.367:-71.817'] = "Lennoxville";
$coordinates['Canada']['45.400:-71.883'] = "Sherbrooke, Que.";
$coordinates['Canada']['45.417:-73.933'] = "Mcgill Radar Site";
$coordinates['Canada']['45.433:-73.933'] = "Ste Anne De Bell 1";
$coordinates['Canada']['45.467:-73.750'] = "Montreal / Dorval International, Que";
$coordinates['Canada']['45.500:-73.583'] = "Mc Tavish Automated Reporting Station";
$coordinates['Canada']['45.517:-73.417'] = "Saint Hubert Airport";
$coordinates['Canada']['45.633:-70.550'] = "Montreal-Est";
$coordinates['Canada']['45.633:-82.967'] = "Great Duck Island";
$coordinates['Canada']['45.717:-60.233'] = "Fourchu Head Meteorological Aeronautical Presentation System";
$coordinates['Canada']['45.717:-73.383'] = "Varennes";
$coordinates['Canada']['45.767:-62.683'] = "Caribou Point Meteorological Aeronautical Presentation System";
$coordinates['Canada']['45.800:-80.533'] = "Britt, Ont.";
$coordinates['Canada']['45.817:-73.433'] = "L'Assomption";
$coordinates['Canada']['45.833:-66.433'] = "Gagetown Can-Mil";
$coordinates['Canada']['45.833:-75.650'] = "High Falls , Que.";
$coordinates['Canada']['45.850:-64.267'] = "Amherst, N. S.";
$coordinates['Canada']['45.867:-66.533'] = "Fredericton, N. B.";
$coordinates['Canada']['45.883:-82.567'] = "Gore Bay, Ont.";
$coordinates['Canada']['45.950:-77.317'] = "Petawawa, Ont.";
$coordinates['Canada']['45.967:-81.483'] = "Killarney Meteorological Aeronautical Presentation System";
$coordinates['Canada']['46.050:-74.283'] = "Ste Agathe Des Mont";
$coordinates['Canada']['46.067:-74.533'] = "St Jovite Automatic Weather Reporting System";
$coordinates['Canada']['46.117:-64.683'] = "Moncton, N. B.";
$coordinates['Canada']['46.167:-60.050'] = "Sydney, N. S.";
$coordinates['Canada']['46.200:-70.783'] = "Beauceville";
$coordinates['Canada']['46.217:-72.650'] = "Nicolet Automatic Weather Reporting System";
$coordinates['Canada']['46.283:-63.133'] = "Charlottetown, P. E. I.";
$coordinates['Canada']['46.283:-76.000'] = "Maniwaki";
$coordinates['Canada']['46.317:-79.467'] = "Nipissing";
$coordinates['Canada']['46.350:-72.517'] = "Trois Rivieres";
$coordinates['Canada']['46.350:-79.433'] = "North Bay, Ont.";
$coordinates['Canada']['46.383:-75.967'] = "Maniwaki, Que.";
$coordinates['Canada']['46.433:-63.833'] = "Summerside Can-Mil";
$coordinates['Canada']['46.433:-71.933'] = "Villeroy Radar Site";
$coordinates['Canada']['46.450:-61.967'] = "East Point, P. E. I";
$coordinates['Canada']['46.483:-84.500'] = "Sault Ste Marie, Ont.";
$coordinates['Canada']['46.550:-61.050'] = "Grand Etang, N. S.";
$coordinates['Canada']['46.583:-72.583'] = "Shawinigan CS , Que.";
$coordinates['Canada']['46.617:-80.800'] = "Sudbury, Ont.";
$coordinates['Canada']['46.650:-53.067'] = "Cape Race, Nfld";
$coordinates['Canada']['46.683:-71.950'] = "Deschambaults , Que.";
$coordinates['Canada']['46.800:-71.383'] = "Quebec, Que";
$coordinates['Canada']['46.817:-60.667'] = "North Mountain , N. S.";
$coordinates['Canada']['46.833:-71.200'] = "Beauport CS, Que.";
$coordinates['Canada']['46.900:-71.500'] = "Valcartier Airport";
$coordinates['Canada']['46.900:-71.500'] = "Valcartier";
$coordinates['Canada']['46.917:-55.383'] = "St. Lawrence, Nfld.";
$coordinates['Canada']['47.000:-65.450'] = "Chatham Can-Mil";
$coordinates['Canada']['47.000:-70.817'] = "Ile D'Orleans Automated Reporting Station";
$coordinates['Canada']['47.067:-64.800'] = "Point Escuminac Meteorological Aeronautical Presentation System";
$coordinates['Canada']['47.067:-70.800'] = "Cap Tourmente";
$coordinates['Canada']['47.150:-67.833'] = "Saint Leonard Airport";
$coordinates['Canada']['47.233:-60.133'] = "Saint Paul Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['47.283:-70.633'] = "Charlevoix CS , Que.";
$coordinates['Canada']['47.300:-54.000'] = "Argentia, Nfld";
$coordinates['Canada']['47.300:-71.267'] = "Ste Foy CS , Que.";
$coordinates['Canada']['47.333:-85.833'] = "Caribou Island, Ont.";
$coordinates['Canada']['47.350:-70.033'] = "La Pocatiere";
$coordinates['Canada']['47.367:-55.800'] = "Sagona Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['47.417:-61.783'] = "Iles De La Madeleineque.";
$coordinates['Canada']['47.417:-61.800'] = "Iles-De-La-Madelein";
$coordinates['Canada']['47.417:-72.800'] = "La Tuque";
$coordinates['Canada']['47.516:-52.785'] = "St. John's West CDA CS, Nfld.";
$coordinates['Canada']['47.567:-59.167'] = "Port-Aux-Basques, Nfld.";
$coordinates['Canada']['47.567:-71.233'] = "Parc Des Laurentid";
$coordinates['Canada']['47.617:-52.733'] = "St. John's, Nfld";
$coordinates['Canada']['47.700:-79.850'] = "Earlton, Ont.";
$coordinates['Canada']['47.800:-69.550'] = "Riviere Du Loup, Que.";
$coordinates['Canada']['47.917:-74.617'] = "Parent, Que.";
$coordinates['Canada']['47.967:-84.783'] = "Wawa, Ont.";
$coordinates['Canada']['47.983:-66.333'] = "Charlo, N. B.";
$coordinates['Canada']['48.017:-64.500'] = "Miscou Island, N. B.";
$coordinates['Canada']['48.017:-65.333'] = "New Carlisle1";
$coordinates['Canada']['48.067:-77.783'] = "Val D'Or, Que.";
$coordinates['Canada']['48.083:-69.550'] = "Ile Rouge Meteorological Aeronautical Presentation System";
$coordinates['Canada']['48.250:-79.033'] = "Rouyn";
$coordinates['Canada']['48.267:-70.117'] = "Puinte Claveau";
$coordinates['Canada']['48.300:-123.533'] = "Race Rocks Automatic Weather Reporting System";
$coordinates['Canada']['48.300:-70.933'] = "La Baie , Que.";
$coordinates['Canada']['48.333:-71.000'] = "Bagotville, Que.";
$coordinates['Canada']['48.367:-89.117'] = "Welcome Island";
$coordinates['Canada']['48.367:-89.317'] = "Thunder Bay, Ont.";
$coordinates['Canada']['48.383:-123.917'] = "Sheringham Automatic Weather Reporting System";
$coordinates['Canada']['48.383:-70.533'] = "Cap Rouge";
$coordinates['Canada']['48.416:-68.893'] = "Ile Bicquette, Que.";
$coordinates['Canada']['48.417:-123.317'] = "Victoria Automatic Weather Reporting System";
$coordinates['Canada']['48.417:-64.317'] = "Cap D'Espoir , Que.";
$coordinates['Canada']['48.417:-71.217'] = "Jonquiere Automated Reporting Station";
$coordinates['Canada']['48.433:-123.433'] = "Esquimalt Harbour, B. C.";
$coordinates['Canada']['48.450:-123.300'] = "Victoria University";
$coordinates['Canada']['48.467:-67.433'] = "Amqui , Que.";
$coordinates['Canada']['48.517:-72.267'] = "Roberval, Que.";
$coordinates['Canada']['48.533:-58.550'] = "Stephenville, Nfld.";
$coordinates['Canada']['48.557:-53.974'] = "Terra Nova National Park CS, Nfld.";
$coordinates['Canada']['48.567:-81.367'] = "Timmins, Ont.";
$coordinates['Canada']['48.583:-123.583'] = "Malahat Automatic Weather Reporting System";
$coordinates['Canada']['48.600:-68.217'] = "Mont Joli, Que.";
$coordinates['Canada']['48.600:-86.300'] = "Pukaskwa";
$coordinates['Canada']['48.633:-79.450'] = "Roquemaure";
$coordinates['Canada']['48.650:-123.433'] = "Victoria Int. Airport, B. C.";
$coordinates['Canada']['48.667:-124.833'] = "Nitinat Lake Meteorological Aeronautical Presentation System";
$coordinates['Canada']['48.667:-53.117'] = "Bonavista, Nfld.";
$coordinates['Canada']['48.750:-91.617'] = "Atikokan Automated Reporting Station";
$coordinates['Canada']['48.767:-64.483'] = "Gaspe, Que.";
$coordinates['Canada']['48.767:-71.717'] = "Mistook Automated Reporting Station";
$coordinates['Canada']['48.783:-123.050'] = "Saturna Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['48.833:-72.550'] = "Normandin";
$coordinates['Canada']['48.883:-71.033'] = "Onatchiway, Que.";
$coordinates['Canada']['48.917:-125.550'] = "Amphitrite Point";
$coordinates['Canada']['48.950:-54.567'] = "Gander Int. Airport, Nfld.";
$coordinates['Canada']['48.967:-56.067'] = "Badger, Nfld";
$coordinates['Canada']['49.017:-122.783'] = "White Rock Automatic Weather Reporting System";
$coordinates['Canada']['49.033:-119.433'] = "Osoyoos Automatic Weather Reporting System";
$coordinates['Canada']['49.033:-122.367'] = "Abbotsford, B. C.";
$coordinates['Canada']['49.033:-90.467'] = "Upsala, Ont.";
$coordinates['Canada']['49.033:-97.567'] = "Gretna, Man.";
$coordinates['Canada']['49.050:-105.483'] = "Coronach Spc";
$coordinates['Canada']['49.050:-123.867'] = "Nanaimo Airport";
$coordinates['Canada']['49.067:-107.583'] = "Val Marie Southeast, Sask";
$coordinates['Canada']['49.083:-116.500'] = "Creston Automatic Weather Reporting System";
$coordinates['Canada']['49.083:-125.767'] = "Tofino Airport";
$coordinates['Canada']['49.083:-61.700'] = "Heath Point Meteorological Aeronautical Presentation System";
$coordinates['Canada']['49.117:-110.467'] = "Onefour Automatic Weather Reporting System";
$coordinates['Canada']['49.117:-66.650'] = "Cap Chat CS, Que.";
$coordinates['Canada']['49.133:-112.050'] = "Milk River";
$coordinates['Canada']['49.133:-68.200'] = "Baie Comeau, Que.";
$coordinates['Canada']['49.167:-105.983'] = "Rockglen, Sask.";
$coordinates['Canada']['49.183:-123.167'] = "Vancouver International Air-Port, B. C.";
$coordinates['Canada']['49.183:-98.083'] = "Morden CDA CS , Man.";
$coordinates['Canada']['49.200:-113.283'] = "Cardston Automated Reporting Station";
$coordinates['Canada']['49.200:-122.683'] = "P. Meadows Coastal Station Automatic Weather Reporting System";
$coordinates['Canada']['49.200:-98.900'] = "Pilot Mound, Man.";
$coordinates['Canada']['49.217:-102.967'] = "Estevan, Sask.";
$coordinates['Canada']['49.217:-123.800'] = "Entrance Island Automatic Weather Reporting System";
$coordinates['Canada']['49.217:-57.400'] = "Deer Lake, Nfld.";
$coordinates['Canada']['49.250:-121.767'] = "Agassiz Automated Reporting Station";
$coordinates['Canada']['49.250:-124.833'] = "Port Alberni, B. C.";
$coordinates['Canada']['49.250:-65.333'] = "Cap Madeleine Meteorological Aeronautical Presentation System";
$coordinates['Canada']['49.267:-54.883'] = "Comfort Cove, Nfld.";
$coordinates['Canada']['49.267:-68.150'] = "Baie Comeau";
$coordinates['Canada']['49.283:-100.983'] = "Melita, Man";
$coordinates['Canada']['49.283:-73.350'] = "Chamouchouane Automatic Weather Reporting System";
$coordinates['Canada']['49.300:-117.633'] = "Castlegar Airport";
$coordinates['Canada']['49.300:-123.117'] = "Vancouver Automatic Weather Reporting System";
$coordinates['Canada']['49.317:-67.383'] = "Pointe-Des-Monts , Que.";
$coordinates['Canada']['49.350:-123.183'] = "W Vancouver Automatic Weather Reporting System";
$coordinates['Canada']['49.350:-124.167'] = "Ballenas Island Automatic Weather Reporting System";
$coordinates['Canada']['49.367:-121.483'] = "Hope, B. C.";
$coordinates['Canada']['49.383:-126.550'] = "Estevan Point, B. C.";
$coordinates['Canada']['49.400:-98.317'] = "Deerwood RCS , Man.";
$coordinates['Canada']['49.417:-82.467'] = "Kapuskasing, Ont.";
$coordinates['Canada']['49.433:-108.983'] = "Eastend Cypress, Sask";
$coordinates['Canada']['49.467:-119.600'] = "Penticton, B. C.";
$coordinates['Canada']['49.467:-120.517'] = "Princeton Airport";
$coordinates['Canada']['49.483:-123.300'] = "Pam Rocks";
$coordinates['Canada']['49.483:-124.433'] = "Sisters Island Automatic Weather Reporting System";
$coordinates['Canada']['49.500:-117.300'] = "Nelson Automatic Weather Reporting System";
$coordinates['Canada']['49.500:-98.033'] = "Carman U Of M";
$coordinates['Canada']['49.567:-119.650'] = "Summerland Automatic Weather Reporting System";
$coordinates['Canada']['49.567:-57.883'] = "Rocky Harbour CS, Nfld.";
$coordinates['Canada']['49.583:-114.417'] = "Turtle Mountain";
$coordinates['Canada']['49.617:-115.783'] = "Cranbrook, B. C.";
$coordinates['Canada']['49.633:-111.450'] = "Bow Island";
$coordinates['Canada']['49.633:-112.800'] = "Lethbridge, Alta.";
$coordinates['Canada']['49.633:-114.483'] = "Crowsnest";
$coordinates['Canada']['49.650:-109.517'] = "Cypress Hills Park";
$coordinates['Canada']['49.683:-54.800'] = "Twillingate Meteorological Aeronautical Presentation System";
$coordinates['Canada']['49.700:-103.800'] = "Weyburn Automatic Weather Reporting System";
$coordinates['Canada']['49.700:-112.783'] = "Lethbridge Automated Reporting Station";
$coordinates['Canada']['49.717:-124.900'] = "Comox, B. C.";
$coordinates['Canada']['49.717:-88.333'] = "Katatota Island";
$coordinates['Canada']['49.733:-105.933'] = "Assiniboia Airport Automated Reporting Station";
$coordinates['Canada']['49.750:-114.900'] = "Sparwood Automatic Weather Reporting System";
$coordinates['Canada']['49.750:-84.167'] = "Nagagami, Ont.";
$coordinates['Canada']['49.767:-74.533'] = "Chibougamau-Chapais, Que";
$coordinates['Canada']['49.767:-77.817'] = "Matagami, Que.";
$coordinates['Canada']['49.783:-123.167'] = "Squamish Airport, B. C";
$coordinates['Canada']['49.783:-86.933'] = "Geraldton, Ont.";
$coordinates['Canada']['49.783:-94.367'] = "Kenora, Ont.";
$coordinates['Canada']['49.783:-99.633'] = "Shilo";
$coordinates['Canada']['49.833:-124.500'] = "Powell River Airport";
$coordinates['Canada']['49.833:-64.300'] = "Port Menier, Que.";
$coordinates['Canada']['49.883:-97.133'] = "Winnipeg The Forks, Man.";
$coordinates['Canada']['49.900:-109.467'] = "Maplecreek Automatic Weather Reporting System";
$coordinates['Canada']['49.900:-71.250'] = "Chute Des Passes";
$coordinates['Canada']['49.900:-97.233'] = "Winnipeg Int. Airportman.";
$coordinates['Canada']['49.900:-98.267'] = "Portage Southport A";
$coordinates['Canada']['49.900:-99.350'] = "Carberry Mcdc";
$coordinates['Canada']['49.917:-55.667'] = "La Scie, Nfld.";
$coordinates['Canada']['49.917:-99.950'] = "Brandon, Man.";
$coordinates['Canada']['49.967:-119.383'] = "Kelowna Airport";
$coordinates['Canada']['50.017:-110.717'] = "Medicine Hat, Alta.";
$coordinates['Canada']['50.017:-113.633'] = "Claresholm Automatic Weather Reporting System";
$coordinates['Canada']['50.050:-112.133'] = "Vauxhall Cda";
$coordinates['Canada']['50.117:-127.933'] = "Solander Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['50.117:-91.900'] = "Sioux Lookout, Ont.";
$coordinates['Canada']['50.167:-60.067'] = "Cape Whittle";
$coordinates['Canada']['50.167:-66.433'] = "Pointe Noire , Que.";
$coordinates['Canada']['50.183:-61.817'] = "Natashquan, Que.";
$coordinates['Canada']['50.183:-96.067'] = "Pinawa Automatic Weather Reporting System";
$coordinates['Canada']['50.200:-104.700'] = "Bratts Lake, Sask.";
$coordinates['Canada']['50.217:-66.267'] = "Sept-Iles, Que.";
$coordinates['Canada']['50.224:-64.208'] = "Ile Aux Perroquets, Que.";
$coordinates['Canada']['50.233:-119.283'] = "Vernon, B. C.";
$coordinates['Canada']['50.233:-121.583'] = "Lytton, B. C.";
$coordinates['Canada']['50.233:-57.583'] = "Daniel's Harbour, Nfld";
$coordinates['Canada']['50.267:-107.733'] = "Swift Current Automatic Weather Reporting System";
$coordinates['Canada']['50.267:-111.183'] = "Suffield Airport";
$coordinates['Canada']['50.267:-117.817'] = "Nakusp Automatic Weather Reporting System";
$coordinates['Canada']['50.267:-64.233'] = "Longue Point De Mingan, Que.";
$coordinates['Canada']['50.283:-107.683'] = "Swift Current, Sask.";
$coordinates['Canada']['50.283:-63.617'] = "Havre St Pierre";
$coordinates['Canada']['50.300:-122.733'] = "Pemberton Automatic Weather Reporting System";
$coordinates['Canada']['50.300:-89.033'] = "Armstrong, Ont.";
$coordinates['Canada']['50.333:-105.550'] = "Moose Jaw, Sask.";
$coordinates['Canada']['50.383:-102.683'] = "Broadview, Sask.";
$coordinates['Canada']['50.400:-104.583'] = "Regina University";
$coordinates['Canada']['50.400:-125.867'] = "Helmcken Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['50.433:-104.667'] = "Regina, Sask.";
$coordinates['Canada']['50.450:-100.600'] = "Shoal Lake Airport Automated Reporting Station";
$coordinates['Canada']['50.467:-59.633'] = "Chevery, Que.";
$coordinates['Canada']['50.550:-111.850'] = "Brooks Automatic Weather Reporting System";
$coordinates['Canada']['50.600:-120.517'] = "Princeton Automatic Weather Reporting System";
$coordinates['Canada']['50.617:-97.033'] = "Gimli Industrial, Man";
$coordinates['Canada']['50.631:-96.982'] = "Gimli Harbour CS, Man.";
$coordinates['Canada']['50.633:-128.117'] = "Holberg, B. C.";
$coordinates['Canada']['50.650:-99.933'] = "Wasagaming, Man.";
$coordinates['Canada']['50.667:-70.533'] = "Manouane-Est Automated Reporting Station";
$coordinates['Canada']['50.683:-127.367'] = "Port Hardy, B. C.";
$coordinates['Canada']['50.700:-119.283'] = "Salmon Arm Automatic Weather Reporting System";
$coordinates['Canada']['50.700:-120.450'] = "Kamloops, B. C.";
$coordinates['Canada']['50.700:-96.567'] = "Victoria Beach";
$coordinates['Canada']['50.717:-56.117'] = "Englee Meteorological Aeronautical Presentation System";
$coordinates['Canada']['50.733:-71.017'] = "Bonnard 1, Que.";
$coordinates['Canada']['50.783:-128.433'] = "Cape Scott Light";
$coordinates['Canada']['50.817:-128.900'] = "Sartine Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['50.900:-109.500'] = "Leader Airport Automatic Weather Reporting System";
$coordinates['Canada']['50.933:-127.633'] = "Herbert Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['50.950:-107.150'] = "Lucky Lake Automatic Weather Reporting System";
$coordinates['Canada']['50.950:-115.183'] = "Nakiska Ridgetop";
$coordinates['Canada']['50.967:-118.183'] = "Revelstoke, B. C.";
$coordinates['Canada']['50.983:-127.733'] = "Pine Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['51.067:-93.800'] = "Red Lake, Ont.";
$coordinates['Canada']['51.083:-114.217'] = "Cop Upper";
$coordinates['Canada']['51.083:-115.067'] = "Bow Valley";
$coordinates['Canada']['51.083:-97.550'] = "Fisher Branch Marine Aviation Reporting Station";
$coordinates['Canada']['51.100:-100.050'] = "Dauphin Coastal Station";
$coordinates['Canada']['51.100:-100.050'] = "Dauphin, Man.";
$coordinates['Canada']['51.117:-114.017'] = "Calgary International, Alta.";
$coordinates['Canada']['51.133:-106.583'] = "Elbow Marine Aviation Reporting Station";
$coordinates['Canada']['51.150:-121.500'] = "Clinton, B. C.";
$coordinates['Canada']['51.183:-115.567'] = "Banff, Alta.";
$coordinates['Canada']['51.250:-123.083'] = "Big Creek";
$coordinates['Canada']['51.267:-102.467'] = "Yorkton, Sask.";
$coordinates['Canada']['51.267:-80.650'] = "Moosonee, Ont.";
$coordinates['Canada']['51.367:-55.633'] = "St. Anthony, Nfld.";
$coordinates['Canada']['51.450:-116.333'] = "Yoho Park Automatic Weather Reporting System";
$coordinates['Canada']['51.450:-57.183'] = "Blanc Sablon, Que.";
$coordinates['Canada']['51.450:-90.200'] = "Pickle Lake, Ont.";
$coordinates['Canada']['51.483:-107.050'] = "Outlook Pfra";
$coordinates['Canada']['51.517:-109.167'] = "Kindersley, Sask.";
$coordinates['Canada']['51.550:-71.117'] = "Lac Benoit";
$coordinates['Canada']['51.567:-107.917'] = "Rosetown East, Sask";
$coordinates['Canada']['51.667:-105.400'] = "Watrous East Automated Reporting Station";
$coordinates['Canada']['51.667:-110.200'] = "Esther 1";
$coordinates['Canada']['51.667:-98.750'] = "Gypsumville";
$coordinates['Canada']['51.700:-113.217'] = "Three Hills";
$coordinates['Canada']['51.750:-99.900'] = "Bachelors Island Automated Reporting Station";
$coordinates['Canada']['51.767:-104.200'] = "Wynyard, Sask.";
$coordinates['Canada']['51.767:-114.683'] = "Sundre";
$coordinates['Canada']['51.867:-63.283'] = "Lac Eon, Que";
$coordinates['Canada']['52.067:-111.450'] = "Coronation Marine Aviation Reporting Station";
$coordinates['Canada']['52.117:-101.233'] = "Swan River, Man.";
$coordinates['Canada']['52.117:-124.133'] = "Puntzi Mountain, B. C.";
$coordinates['Canada']['52.133:-119.300'] = "Blue River, B. C.";
$coordinates['Canada']['52.150:-106.550'] = "Saskatoon Kernen";
$coordinates['Canada']['52.167:-106.683'] = "Saskatoon, Sask.";
$coordinates['Canada']['52.183:-113.900'] = "Red Deer, Alta.";
$coordinates['Canada']['52.183:-122.050'] = "Williams Lake, B. C.";
$coordinates['Canada']['52.183:-127.467'] = "Cathedral Point Meteorological Aeronautical Presentation System";
$coordinates['Canada']['52.233:-87.883'] = "Lansdowne House";
$coordinates['Canada']['52.267:-128.717'] = "Mcinnes Island, B. C.";
$coordinates['Canada']['52.300:-55.833'] = "Mary's Harbour, Nfld.";
$coordinates['Canada']['52.350:-97.033'] = "Berens River Airport";
$coordinates['Canada']['52.350:-97.033'] = "Berens River CS , Man.";
$coordinates['Canada']['52.383:-126.583'] = "Bella Coola Airport";
$coordinates['Canada']['52.433:-114.917'] = "Rocky Mountain House, Alta";
$coordinates['Canada']['52.450:-113.750'] = "Lacombe Cda";
$coordinates['Canada']['52.650:-56.867'] = "Alexis River Meteorological Aeronautical Presentation System";
$coordinates['Canada']['52.767:-108.250'] = "North Battleford, Sask.";
$coordinates['Canada']['52.800:-97.617'] = "George Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['52.817:-102.317'] = "Hudson Bay, Sask.";
$coordinates['Canada']['52.817:-104.600'] = "Melfort Automatic Weather Reporting System";
$coordinates['Canada']['52.883:-118.067'] = "Jasper, Alta.";
$coordinates['Canada']['52.933:-118.317'] = "Jasper Warden Automated Reporting Station";
$coordinates['Canada']['52.933:-66.867'] = "Wabush Lake, Nfld.";
$coordinates['Canada']['53.033:-100.933'] = "Hunters Point Mar";
$coordinates['Canada']['53.033:-112.817'] = "Camrose";
$coordinates['Canada']['53.033:-122.517'] = "Quesnel Airport";
$coordinates['Canada']['53.050:-129.683'] = "Ethelda Bay";
$coordinates['Canada']['53.183:-99.267'] = "Grand Rapids, Man.";
$coordinates['Canada']['53.217:-105.683'] = "Prince Albert, Sask.";
$coordinates['Canada']['53.250:-131.817'] = "Sandspit, B. C.";
$coordinates['Canada']['53.300:-113.583'] = "Edmonton International, Alta.";
$coordinates['Canada']['53.300:-113.600'] = "Edmonton International CS , Alta.";
$coordinates['Canada']['53.317:-110.067'] = "Lloydminister, Alta.";
$coordinates['Canada']['53.317:-132.750'] = "Kindakun Rocks, B. C.";
$coordinates['Canada']['53.317:-60.417'] = "Goose, Nfld.";
$coordinates['Canada']['53.333:-104.000'] = "Nipawin, Sask.";
$coordinates['Canada']['53.367:-107.550'] = "Spiritwood West, Sask";
$coordinates['Canada']['53.383:-118.333'] = "Willow Creek";
$coordinates['Canada']['53.417:-113.200'] = "Ellerslie";
$coordinates['Canada']['53.450:-114.467'] = "Highvale";
$coordinates['Canada']['53.500:-130.633'] = "Bonilla Island Meteorological Aeronautical Presentation System";
$coordinates['Canada']['53.533:-114.100'] = "Edmonton Stony Plain Alta.";
$coordinates['Canada']['53.550:-64.100'] = "Churchill Falls, Nfld.";
$coordinates['Canada']['53.567:-113.517'] = "Edmonton Municipal Alta.";
$coordinates['Canada']['53.567:-113.517'] = "Edmonton Municipal CR10 , Alta.";
$coordinates['Canada']['53.567:-64.100'] = "Churchill Falls";
$coordinates['Canada']['53.583:-116.467'] = "Edson, Alta.";
$coordinates['Canada']['53.617:-112.033'] = "Vegreville Automatic Weather Reporting System";
$coordinates['Canada']['53.633:-77.700'] = "La Grande Riviere, Que";
$coordinates['Canada']['53.667:-113.467'] = "Edmonton Namao Alta.";
$coordinates['Canada']['53.683:-112.867'] = "Elk Island National Park";
$coordinates['Canada']['53.683:-124.833'] = "Nechako River";
$coordinates['Canada']['53.700:-57.033'] = "Cartwright, Nfld.";
$coordinates['Canada']['53.733:-105.267'] = "Candle Lake";
$coordinates['Canada']['53.750:-73.667'] = "La Grande Iv, Que.";
$coordinates['Canada']['53.783:-118.433'] = "Henderickson Automatic Weather Reporting System";
$coordinates['Canada']['53.833:-89.867'] = "Big Trout Lake";
$coordinates['Canada']['53.850:-94.650'] = "Island Lake, Man.";
$coordinates['Canada']['53.883:-122.683'] = "Prince George, B. C.";
$coordinates['Canada']['53.917:-106.067'] = "Waskesiu Lake Automated Reporting Station";
$coordinates['Canada']['53.967:-101.100'] = "The Pas, Man.";
$coordinates['Canada']['53.967:-97.833'] = "Norway House, Man.";
$coordinates['Canada']['54.133:-108.517'] = "Meadow Lake, Sask.";
$coordinates['Canada']['54.150:-115.783'] = "Whitecourt , Alta.";
$coordinates['Canada']['54.150:-115.783'] = "Whitecourt, Alta.";
$coordinates['Canada']['54.167:-130.367'] = "Holland Rock Automatic Weather Reporting System";
$coordinates['Canada']['54.167:-131.667'] = "Rose Spit Meteorological Aeronautical Presentation System";
$coordinates['Canada']['54.250:-133.133'] = "Langara, B. C.";
$coordinates['Canada']['54.300:-130.433'] = "Prince Rupert, B. C.";
$coordinates['Canada']['54.383:-125.950'] = "Burns Lake";
$coordinates['Canada']['54.417:-110.283'] = "Cold Lake, Alta.";
$coordinates['Canada']['54.467:-128.583'] = "Terrace, B. C.";
$coordinates['Canada']['54.583:-130.700'] = "Grey Islet Meteorological Aeronautical Presentation System";
$coordinates['Canada']['54.750:-110.050'] = "Primrose Lake";
$coordinates['Canada']['54.767:-112.017'] = "Lac La Biche, Alta.";
$coordinates['Canada']['54.783:-110.067'] = "Primrose Lake 2";
$coordinates['Canada']['54.800:-66.800'] = "Schefferville, Que.";
$coordinates['Canada']['54.817:-127.183'] = "Smithers, B. C.";
$coordinates['Canada']['54.983:-85.433'] = "Peawanuck Meteorological Aeronautical Presentation System";
$coordinates['Canada']['55.150:-105.267'] = "La Ronge , Sask.";
$coordinates['Canada']['55.150:-105.267'] = "La Ronge, Sask";
$coordinates['Canada']['55.183:-118.883'] = "Grande Prairie, Alta.";
$coordinates['Canada']['55.200:-119.400'] = "Beaverlodge";
$coordinates['Canada']['55.283:-77.767'] = "Kuujjuarapik, Que.";
$coordinates['Canada']['55.300:-114.783'] = "Slave Lake, Alta";
$coordinates['Canada']['55.300:-123.133'] = "Mackenzie, B. C.";
$coordinates['Canada']['55.333:-63.217'] = "Border, Que.";
$coordinates['Canada']['55.450:-60.233'] = "Hopedale Meteorological Aeronautical Presentation System";
$coordinates['Canada']['55.695:-119.234'] = "Spirit River Auto Station, Alta";
$coordinates['Canada']['55.800:-97.850'] = "Thompson Weather Office, Man";
$coordinates['Canada']['55.833:-108.433'] = "Buffalo Narrows, Sask.";
$coordinates['Canada']['55.933:-129.983'] = "Stewart Airport";
$coordinates['Canada']['56.233:-117.433'] = "Peace River, Alta.";
$coordinates['Canada']['56.233:-120.733'] = "Fort St John, B. C.";
$coordinates['Canada']['56.333:-103.283'] = "Southend Automatic Weather Reporting System";
$coordinates['Canada']['56.350:-94.700'] = "Gillam, Man.";
$coordinates['Canada']['56.533:-115.267'] = "Red Earth";
$coordinates['Canada']['56.550:-61.683'] = "Nain, Nfld";
$coordinates['Canada']['56.650:-111.217'] = "Fort McMurray CS, Alta.";
$coordinates['Canada']['56.650:-111.217'] = "Fort Mcmurray, Alta.";
$coordinates['Canada']['56.733:-131.667'] = "Iskut River";
$coordinates['Canada']['56.867:-101.083'] = "Lynn Lake, Man.";
$coordinates['Canada']['57.133:-61.483'] = "Cape Kiglapait, Nfld.";
$coordinates['Canada']['57.250:-105.617'] = "Key Lake";
$coordinates['Canada']['57.350:-107.133'] = "Cree Lake Meteorological Aeronautical Presentation System";
$coordinates['Canada']['57.533:-111.567'] = "Mildred Lake";
$coordinates['Canada']['58.100:-68.417'] = "Kuujjuaq, Que.";
$coordinates['Canada']['58.183:-103.700'] = "Collins Bay Automatic Weather Reporting System";
$coordinates['Canada']['58.333:-62.583'] = "Saglek Bay";
$coordinates['Canada']['58.383:-109.500'] = "Cluff Lake , Sask.";
$coordinates['Canada']['58.417:-130.000'] = "Dease Lake B. C.";
$coordinates['Canada']['58.417:-130.000'] = "Dease Lake Coastal Station";
$coordinates['Canada']['58.450:-78.117'] = "Inukjuak, Que";
$coordinates['Canada']['58.583:-118.500'] = "Sousa Crk Avt";
$coordinates['Canada']['58.617:-117.167'] = "High Level, Alta";
$coordinates['Canada']['58.622:-111.672'] = "Prairie River, Alta";
$coordinates['Canada']['58.683:-113.883'] = "Garden River Automatic Weather Reporting System";
$coordinates['Canada']['58.733:-94.067'] = "Churchill, Man.";
$coordinates['Canada']['58.767:-111.117'] = "Fort Chipewyan, Alta.";
$coordinates['Canada']['58.833:-122.583'] = "Fort Nelson, B. C.";
$coordinates['Canada']['59.133:-113.800'] = "Waterton Park Gate";
$coordinates['Canada']['59.217:-109.700'] = "Beartooth Island";
$coordinates['Canada']['59.250:-105.833'] = "Stony Rapids Airport";
$coordinates['Canada']['59.567:-108.483'] = "Uranium City, Sask.";
$coordinates['Canada']['59.983:-64.167'] = "Cape Kakkiviak";
$coordinates['Canada']['60.017:-111.950'] = "Fort Smith, N. W. T.";
$coordinates['Canada']['60.117:-128.817'] = "Watson Lake, Y. T.";
$coordinates['Canada']['60.167:-132.733'] = "Teslin, Y. T.";
$coordinates['Canada']['60.417:-64.850'] = "Killinek Meteorological Aeronautical Presentation System";
$coordinates['Canada']['60.433:-121.233'] = "Trout Lake";
$coordinates['Canada']['60.717:-135.067'] = "Whitehorse, Y. T.";
$coordinates['Canada']['60.767:-137.583'] = "Haines Junction";
$coordinates['Canada']['60.833:-115.783'] = "Hay River, N. W. T.";
$coordinates['Canada']['61.050:-109.333'] = "Powder Lake";
$coordinates['Canada']['61.050:-69.633'] = "Quaqtaq Airport";
$coordinates['Canada']['61.117:-122.850'] = "Lindberg Landing , N. W. T.";
$coordinates['Canada']['61.133:-100.900'] = "Ennadai Lake Meteorological Aeronautical Presentation System";
$coordinates['Canada']['61.317:-117.600'] = "Fort Providence";
$coordinates['Canada']['61.367:-139.050'] = "Burwash Automatic Weather Reporting System";
$coordinates['Canada']['61.583:-64.650'] = "Resolution Island, N. W. T.";
$coordinates['Canada']['61.633:-125.800'] = "Virginia Falls";
$coordinates['Canada']['61.667:-108.417'] = "Porter Lake";
$coordinates['Canada']['61.750:-121.233'] = "Fort Simpson, N. W. T.";
$coordinates['Canada']['61.917:-113.733'] = "Inner Whalebacks";
$coordinates['Canada']['61.967:-127.217'] = "Rabbit Kettle Automated Reporting Station";
$coordinates['Canada']['62.117:-136.183'] = "Carmacks CS, Y. T.";
$coordinates['Canada']['62.233:-133.350'] = "Faro, Y. T.";
$coordinates['Canada']['62.467:-114.450'] = "Yellowknife, N. W. T.";
$coordinates['Canada']['62.700:-98.300'] = "Yathkyed Lake Meteorological Aeronautical Presentation System";
$coordinates['Canada']['62.717:-109.183'] = "Fort Reliance, N. W. T.";
$coordinates['Canada']['62.817:-92.117'] = "Rankin Inlet, N. W. T.";
$coordinates['Canada']['63.150:-117.267'] = "Lac La Martre";
$coordinates['Canada']['63.233:-101.767'] = "Dubawnt Lake Meteorological Aeronautical Presentation System";
$coordinates['Canada']['63.333:-64.150'] = "Brevoort Island";
$coordinates['Canada']['63.583:-105.150'] = "Hanbury River Automated Reporting Station";
$coordinates['Canada']['63.600:-113.867'] = "Lower Carp Lake , N. W. T.";
$coordinates['Canada']['63.617:-135.867'] = "Mayo Airport";
$coordinates['Canada']['63.750:-68.550'] = "Iqaluit, N. W. T.";
$coordinates['Canada']['64.050:-139.133'] = "Dawson, Y. T.";
$coordinates['Canada']['64.117:-117.367'] = "Rae Lakes";
$coordinates['Canada']['64.200:-83.367'] = "Coral Harbour, N. W. T.";
$coordinates['Canada']['64.217:-76.533'] = "Cape Dorset, N. W. T.";
$coordinates['Canada']['64.300:-96.083'] = "Baker Lake, N. W. T.";
$coordinates['Canada']['64.383:-115.017'] = "Indian River";
$coordinates['Canada']['64.750:-124.217'] = "St Charles Creek";
$coordinates['Canada']['64.950:-63.583'] = "Cape Mercy";
$coordinates['Canada']['65.100:-102.433'] = "Robertson Lake Automated Reporting Station";
$coordinates['Canada']['65.217:-123.433'] = "Deline , N. W. T.";
$coordinates['Canada']['65.283:-126.800'] = "Norman Wells, N. W. T.";
$coordinates['Canada']['65.617:-118.117'] = "Camsell River, N. W. T.";
$coordinates['Canada']['65.767:-111.233'] = "Lupin, N. W. T.";
$coordinates['Canada']['65.950:-130.467'] = "Rampart River Automatic Weather Reporting System";
$coordinates['Canada']['66.000:-117.767'] = "Clut Lake Automated Reporting Station";
$coordinates['Canada']['66.033:-91.833'] = "B, R";
$coordinates['Canada']['66.083:-96.500'] = "Back River Meteorological Aeronautical Presentation System";
$coordinates['Canada']['66.150:-65.733'] = "Pangnirtung";
$coordinates['Canada']['66.583:-61.617'] = "Cape Dyer, N. W. T.";
$coordinates['Canada']['66.867:-134.200'] = "Satah River Automatic Weather Reporting System";
$coordinates['Canada']['67.033:-126.083'] = "Colville Lake";
$coordinates['Canada']['67.067:-121.100'] = "Haldane River Automatic Weather Reporting System";
$coordinates['Canada']['67.200:-130.217'] = "Little Chicago";
$coordinates['Canada']['67.533:-63.783'] = "Broughton Island";
$coordinates['Canada']['67.567:-139.833'] = "Old Crow Automatic Weather Reporting System";
$coordinates['Canada']['67.700:-104.467'] = "Ellice River Automated Reporting Station";
$coordinates['Canada']['67.817:-115.133'] = "Coppermine, N. W. T.";
$coordinates['Canada']['68.258:-122.104'] = "Qavvik Lake, N. W. T.";
$coordinates['Canada']['68.300:-133.483'] = "Inuvik, N. W. T.";
$coordinates['Canada']['68.300:-85.667'] = "Mackar Inlet";
$coordinates['Canada']['68.317:-100.083'] = "Hat Island, N. W. T.";
$coordinates['Canada']['68.433:-89.717'] = "Pelly Bay";
$coordinates['Canada']['68.467:-66.800'] = "Cape Hooper, N. W. T.";
$coordinates['Canada']['68.500:-113.217'] = "Lady Franklin Point, N. W. T.";
$coordinates['Canada']['68.650:-101.733'] = "Jenny Lind Island Airport";
$coordinates['Canada']['68.650:-71.167'] = "Dewar Lakes, N. W. T.";
$coordinates['Canada']['68.750:-109.067'] = "Byron Bay Airport";
$coordinates['Canada']['68.750:-133.500'] = "Trail Valley , N. W. T.";
$coordinates['Canada']['68.783:-114.833'] = "Bernard Harbour";
$coordinates['Canada']['68.783:-81.250'] = "Hall Beach, N. W. T.";
$coordinates['Canada']['68.817:-93.433'] = "Shepherd Bay, N. W. T.";
$coordinates['Canada']['68.883:-75.133'] = "Longstaff Bluff, N. W. T.";
$coordinates['Canada']['68.900:-133.933'] = "Storm Hills , N. W. T.";
$coordinates['Canada']['68.933:-116.917'] = "Cape Young Airport";
$coordinates['Canada']['68.950:-137.217'] = "Shingle Point, Y. T.";
$coordinates['Canada']['69.100:-105.117'] = "Cambridge Bay, N. W. T.";
$coordinates['Canada']['69.150:-140.150'] = "Ivvavik Park Automatic Weather Reporting System";
$coordinates['Canada']['69.183:-122.350'] = "Tuktut Nogait , N. W. T.";
$coordinates['Canada']['69.350:-124.050'] = "Paulatuk Automated Reporting Station";
$coordinates['Canada']['69.433:-133.033'] = "Tuktoyaktuk Automated Reporting Station";
$coordinates['Canada']['69.433:-89.733'] = "Pelly Bay 1";
$coordinates['Canada']['69.450:-133.017'] = "Tuktoyaktuk";
$coordinates['Canada']['69.567:-138.917'] = "Herschel Island Automatic Weather Reporting System";
$coordinates['Canada']['69.583:-140.183'] = "Komakuk Beach Airport";
$coordinates['Canada']['69.600:-130.900'] = "Liverpool Bay";
$coordinates['Canada']['69.617:-140.200'] = "Komakuk Beach, Y. T.";
$coordinates['Canada']['69.633:-135.433'] = "Pelly Island Automatic Weather Reporting System";
$coordinates['Canada']['69.933:-128.967'] = "Nicholson Peninsul";
$coordinates['Canada']['70.167:-124.700'] = "Cape Parry, N. W. T.";
$coordinates['Canada']['70.483:-68.517'] = "Clyde, N. W. T.";
$coordinates['Canada']['72.000:-125.267'] = "Sachs Harbour, N. W. T.";
$coordinates['Canada']['72.700:-77.967'] = "Pond Inlet, N. W. T.";
$coordinates['Canada']['74.133:-119.983'] = "Aulvik National Park";
$coordinates['Canada']['74.717:-94.983'] = "Resolute, N. W. T.";
$coordinates['Canada']['76.233:-119.333'] = "Mould Bay, N. W. T.";
$coordinates['Canada']['78.783:-103.550'] = "Isachsen Meteorological Aeronautical Presentation System";
$coordinates['Canada']['79.983:-85.933'] = "Eureka, N. W. T.";
$coordinates['Canada']['82.500:-62.333'] = "Alert, N. W. T.";
$coordinates['Cape Verde']['16.733:-22.950'] = "Sal";
$coordinates['Cayman Islands']['19.283:-81.350'] = "Owen Roberts Airportgrand Cayman";
$coordinates['Central African Republic']['10.283:22.783'] = "Birao";
$coordinates['Central African Republic']['4.250:15.800'] = "Berberati";
$coordinates['Central African Republic']['4.400:18.517'] = "Bangui";
$coordinates['Central African Republic']['4.733:22.833'] = "Bangassou";
$coordinates['Central African Republic']['5.050:21.200'] = "Alindao";
$coordinates['Central African Republic']['5.267:17.633'] = "Bossembele";
$coordinates['Central African Republic']['5.400:26.500'] = "Obo";
$coordinates['Central African Republic']['5.850:20.650'] = "Bambari";
$coordinates['Central African Republic']['5.967:15.633'] = "Bouar";
$coordinates['Central African Republic']['6.483:17.433'] = "Bossangoa";
$coordinates['Central African Republic']['6.500:23.267'] = "Yalinga";
$coordinates['Central African Republic']['6.533:21.983'] = "Bria";
$coordinates['Central African Republic']['8.400:20.650'] = "N'Dele";
$coordinates['Chad']['11.033:20.283'] = "Am-Timan";
$coordinates['Chad']['12.133:15.033'] = "Ndjamena";
$coordinates['Chad']['12.383:17.050'] = "Bokoro";
$coordinates['Chad']['13.433:14.733'] = "Bol-Berim";
$coordinates['Chad']['13.850:20.850'] = "Abeche";
$coordinates['Chad']['18.000:19.167'] = "Faya";
$coordinates['Chad']['8.617:16.067'] = "Moundou";
$coordinates['Chad']['9.150:18.383'] = "Sarh";
$coordinates['Chad']['9.367:14.917'] = "Pala";
$coordinates['Chile']['-18.333:-70.333'] = "Arica";
$coordinates['Chile']['-20.533:-70.183'] = "Iquique / Diego Arac";
$coordinates['Chile']['-23.433:-70.433'] = "Antofagasta";
$coordinates['Chile']['-26.317:-70.617'] = "Chanaral";
$coordinates['Chile']['-27.150:-109.417'] = "Isla De Pascua";
$coordinates['Chile']['-27.300:-70.417'] = "Copiapo";
$coordinates['Chile']['-28.600:-70.767'] = "Vallenar";
$coordinates['Chile']['-29.900:-71.200'] = "La Serena";
$coordinates['Chile']['-32.783:-71.517'] = "Quintero Santiago";
$coordinates['Chile']['-33.383:-70.783'] = "Pudahuel";
$coordinates['Chile']['-34.967:-71.233'] = "Curico";
$coordinates['Chile']['-36.567:-72.033'] = "Chillan";
$coordinates['Chile']['-36.767:-73.050'] = "Concepcion";
$coordinates['Chile']['-38.750:-72.633'] = "Temuco";
$coordinates['Chile']['-39.617:-73.083'] = "Valdivia";
$coordinates['Chile']['-41.417:-73.083'] = "Puerto Montt";
$coordinates['Chile']['-45.583:-72.117'] = "Coyhaique";
$coordinates['Chile']['-45.917:-71.683'] = "Balmaceda";
$coordinates['Chile']['-46.550:-71.700'] = "Chile Chico";
$coordinates['Chile']['-47.233:-72.550'] = "Cochrane";
$coordinates['Chile']['-53.000:-70.850'] = "Punta Arenas";
$coordinates['China']['20.033:110.350'] = "Haikou";
$coordinates['China']['21.217:110.400'] = "Zhanjiang";
$coordinates['China']['22.550:114.100'] = "Shenzhen";
$coordinates['China']['22.817:108.350'] = "Nanning";
$coordinates['China']['23.167:113.333'] = "Guangzhou";
$coordinates['China']['23.400:116.683'] = "Shantou";
$coordinates['China']['24.483:118.083'] = "Xiamen";
$coordinates['China']['25.017:102.683'] = "Kunming";
$coordinates['China']['25.333:110.300'] = "Guilin";
$coordinates['China']['25.850:114.950'] = "Ganzhou";
$coordinates['China']['26.083:119.283'] = "Fuzhou";
$coordinates['China']['26.583:106.717'] = "Guiyang";
$coordinates['China']['28.200:113.083'] = "Changsha";
$coordinates['China']['28.600:115.917'] = "Nanchang";
$coordinates['China']['29.517:106.483'] = "Chongqing";
$coordinates['China']['29.667:91.133'] = "Lhasa";
$coordinates['China']['30.233:120.167'] = "Hangzhou";
$coordinates['China']['30.617:114.133'] = "Wuhan";
$coordinates['China']['30.667:104.017'] = "Chengdu";
$coordinates['China']['31.167:121.433'] = "Shanghai / Hongqiao";
$coordinates['China']['31.867:117.233'] = "Hefei";
$coordinates['China']['32.000:118.800'] = "Nanjing";
$coordinates['China']['34.300:108.933'] = "Xi'An";
$coordinates['China']['34.717:113.650'] = "Zhengzhou";
$coordinates['China']['36.067:120.333'] = "Qingdao";
$coordinates['China']['36.600:109.500'] = "Yan An";
$coordinates['China']['36.617:101.767'] = "Xining";
$coordinates['China']['36.683:116.983'] = "Jinan";
$coordinates['China']['37.133:79.933'] = "Hotan";
$coordinates['China']['37.783:112.550'] = "Taiyuan";
$coordinates['China']['38.483:106.217'] = "Yinchuan";
$coordinates['China']['38.900:121.633'] = "Dalian";
$coordinates['China']['39.467:75.983'] = "Kashi";
$coordinates['China']['39.767:98.483'] = "Jiuquan";
$coordinates['China']['39.933:116.283'] = "Beijing";
$coordinates['China']['40.817:111.683'] = "Hohhot";
$coordinates['China']['42.817:93.517'] = "Hami";
$coordinates['China']['43.900:125.217'] = "Changchun";
$coordinates['China']['43.950:81.333'] = "Yining";
$coordinates['China']['47.383:123.917'] = "Qiqihar";
$coordinates['Christmas Island']['-10.433:105.683'] = "Christmas Island Aerodrome";
$coordinates['Christmas Island']['-12.183:96.817'] = "Cocos Island Airport";
$coordinates['Colombia']['0.500:-76.500'] = "Puerto Asis";
$coordinates['Colombia']['0.817:-77.633'] = "Ipiales / San Luis";
$coordinates['Colombia']['1.133:-70.050'] = "Mitu";
$coordinates['Colombia']['1.417:-77.267'] = "Pasto / Antonio Narin";
$coordinates['Colombia']['10.433:-73.250'] = "Valledupar / Alfonso Lopez";
$coordinates['Colombia']['10.450:-75.517'] = "Cartagena / Rafael Nunez";
$coordinates['Colombia']['10.883:-74.783'] = "Barranquilla / Ernestocortissoz";
$coordinates['Colombia']['11.133:-74.233'] = "Santa Marta / Simon Bolivar";
$coordinates['Colombia']['11.533:-72.933'] = "Riohacha / Almirante Padilla";
$coordinates['Colombia']['12.583:-81.717'] = "San Andres Isla / Sesquicentenario";
$coordinates['Colombia']['13.367:-81.350'] = "Providencia Isla / El Embrujo";
$coordinates['Colombia']['2.467:-76.600'] = "Popayan / Guillermo";
$coordinates['Colombia']['2.567:-72.633'] = "San Jose Del Guaviare";
$coordinates['Colombia']['2.967:-75.300'] = "Neiva / Benito Salas";
$coordinates['Colombia']['3.550:-76.383'] = "Cali / Alfonso Bonillaaragon";
$coordinates['Colombia']['3.850:-76.967'] = "Buenaventura";
$coordinates['Colombia']['-4.167:-69.950'] = "Leticia / Vasquez Cobo";
$coordinates['Colombia']['4.167:-73.617'] = "Villavicencio / Vanguardia";
$coordinates['Colombia']['4.433:-75.150'] = "Ibague / Perales";
$coordinates['Colombia']['4.500:-75.717'] = "Armenia / El Eden";
$coordinates['Colombia']['4.717:-74.150'] = "Bogota / Eldorado";
$coordinates['Colombia']['4.817:-75.733'] = "Pereira / Matecana";
$coordinates['Colombia']['5.717:-76.617'] = "Quibdo / El Carano";
$coordinates['Colombia']['6.133:-75.433'] = "Rionegro / J. M. Cordova";
$coordinates['Colombia']['6.167:-67.500'] = "Puerto Carreno / A. Guauquea";
$coordinates['Colombia']['6.217:-75.600'] = "Medellin / Olaya Herrera";
$coordinates['Colombia']['7.017:-73.800'] = "Barrancabermeja / Yariguies";
$coordinates['Colombia']['7.067:-70.733'] = "Arauca / Santiago Perez";
$coordinates['Colombia']['7.100:-73.200'] = "Bucaramanga / Palonegro";
$coordinates['Colombia']['7.817:-76.700'] = "Apartado / Los Cedros";
$coordinates['Colombia']['7.933:-72.517'] = "Cucuta / Camilo Daza";
$coordinates['Colombia']['8.817:-75.850'] = "Monteria / Los Garzones";
$coordinates['Comoros']['-11.533:43.267'] = "Hahaya International Airport";
$coordinates['Comoros']['-12.117:44.433'] = "Ouani Anjouan";
$coordinates['Comoros']['-12.800:45.283'] = "Dzaoudzi / Pamanzi Mayotte";
$coordinates['Congo']['-0.017:15.583'] = "Makoua";
$coordinates['Congo']['1.617:16.050'] = "Ouesso";
$coordinates['Congo']['1.617:18.067'] = "Impfondo";
$coordinates['Congo']['-1.867:15.867'] = "Gamboma";
$coordinates['Congo']['2.067:14.133'] = "Souanke";
$coordinates['Congo']['-2.533:14.767'] = "Djambala";
$coordinates['Congo']['-2.617:16.217'] = "M'Pouya";
$coordinates['Congo']['-3.483:12.617'] = "Makabana";
$coordinates['Congo']['-3.683:13.350'] = "Sibiti";
$coordinates['Congo']['-3.983:13.917'] = "Mouyondzi";
$coordinates['Congo']['-4.200:12.700'] = "Loubomo";
$coordinates['Congo']['-4.250:15.250'] = "Brazzaville / Maya-Maya";
$coordinates['Congo']['-4.817:11.900'] = "Pointe-Noire";
$coordinates['Cook Islands']['-19.067:-169.917'] = "Alofi / Niue";
$coordinates['Cook Islands']['-21.200:-159.817'] = "Rarotonga";
$coordinates['Costa Rica']['10.000:-83.050'] = "Puerto Limon";
$coordinates['Costa Rica']['10.000:-84.217'] = "Juan Santamaria";
$coordinates['Costa Rica']['10.150:-85.450'] = "Nicoya";
$coordinates['Costa Rica']['10.617:-85.433'] = "Liberia";
$coordinates['Costa Rica']['8.950:-83.467'] = "Palmar Sur";
$coordinates['Cote D\'Ivoire']['4.417:-7.367'] = "Tabou";
$coordinates['Cote D\'Ivoire']['4.750:-6.650'] = "San Pedro";
$coordinates['Cote D\'Ivoire']['4.950:-6.083'] = "Sassandra";
$coordinates['Cote D\'Ivoire']['5.250:-3.933'] = "Abidjan";
$coordinates['Cote D\'Ivoire']['5.300:-3.300'] = "Adiake";
$coordinates['Cote D\'Ivoire']['6.133:-5.950'] = "Gagnoa";
$coordinates['Cote D\'Ivoire']['6.650:-4.700'] = "Dimbokro";
$coordinates['Cote D\'Ivoire']['6.867:-6.467'] = "Daloa";
$coordinates['Cote D\'Ivoire']['6.900:-5.350'] = "Yamoussoukro";
$coordinates['Cote D\'Ivoire']['7.383:-7.517'] = "Man";
$coordinates['Cote D\'Ivoire']['7.733:-5.067'] = "Bouake";
$coordinates['Cote D\'Ivoire']['8.050:-2.783'] = "Bondoukou";
$coordinates['Cote D\'Ivoire']['9.417:-5.617'] = "Korhogo";
$coordinates['Cote D\'Ivoire']['9.500:-7.567'] = "Odienne";
$coordinates['Croatia']['42.567:18.267'] = "Dubrovnik / Cilipi";
$coordinates['Croatia']['43.167:16.450'] = "Hvar";
$coordinates['Croatia']['43.533:16.300'] = "Split / Resnik";
$coordinates['Croatia']['44.100:15.350'] = "Zadar / Zemunik";
$coordinates['Croatia']['45.033:18.800'] = "Osijek / Cepin";
$coordinates['Croatia']['45.167:18.000'] = "Slavonski Brod";
$coordinates['Croatia']['45.217:14.583'] = "Rijeka / Omisalj";
$coordinates['Croatia']['45.733:16.067'] = "Zagreb / Pleso";
$coordinates['Croatia']['45.817:16.033'] = "Zagreb / Maksimir";
$coordinates['Croatia']['45.900:13.917'] = "Pula Aerodrome";
$coordinates['Croatia']['46.300:16.383'] = "Varazdin";
$coordinates['Cuba']['19.900:-75.133'] = "Guantanamo, Oriente";
$coordinates['Cuba']['19.967:-75.850'] = "Santiago De Cuba, Oriente";
$coordinates['Cuba']['20.083:-75.150'] = "Guantanamo, Oriente";
$coordinates['Cuba']['20.333:-77.117'] = "Manzanillo, Oriente";
$coordinates['Cuba']['20.350:-74.500'] = "Baracoa, Oriente";
$coordinates['Cuba']['20.950:-76.950'] = "Las Tunas, Las Tunas";
$coordinates['Cuba']['21.417:-77.850'] = "Camaguey Aeropuerto";
$coordinates['Cuba']['21.783:-78.783'] = "Venezuela, Ciego De Avila";
$coordinates['Cuba']['21.833:-82.783'] = "Nueva Gerona, Isla De Pinos";
$coordinates['Cuba']['22.150:-80.400'] = "Cienfuegos, Las Villas";
$coordinates['Cuba']['22.417:-83.683'] = "Pinar Del Rio, Pinar Del Rio";
$coordinates['Cuba']['22.983:-82.400'] = "Aeropuerto Jose Marti, Rancho-Boyeros, Habana";
$coordinates['Cuba']['23.133:-81.283'] = "Varadero, Matanzas";
$coordinates['Cyprus']['34.583:32.983'] = "Akrotiri";
$coordinates['Cyprus']['34.717:32.483'] = "Paphos Airport";
$coordinates['Cyprus']['34.883:33.633'] = "Larnaca Airport";
$coordinates['Cyprus']['35.150:33.400'] = "Athalassa";
$coordinates['Czech Republic']['49.150:16.700'] = "Brno / Turany";
$coordinates['Czech Republic']['49.317:17.567'] = "Holesov";
$coordinates['Czech Republic']['49.683:18.117'] = "Ostrava / Mosnov";
$coordinates['Czech Republic']['50.100:14.250'] = "Praha / Ruzyne";
$coordinates['Czech Republic']['50.200:12.917'] = "Karlovy Vary";
$coordinates['Denmark']['54.700:11.450'] = "Maribo Lufthavn";
$coordinates['Denmark']['54.967:9.783'] = "Soenderborg Lufthavn";
$coordinates['Denmark']['55.017:10.567'] = "Sydfyns Flyveplads";
$coordinates['Denmark']['55.067:14.750'] = "Roenne";
$coordinates['Denmark']['55.083:11.783'] = "Avno Danish Air Force Base";
$coordinates['Denmark']['55.233:9.267'] = "Skrydstrup";
$coordinates['Denmark']['55.433:9.333'] = "Vamdrup";
$coordinates['Denmark']['55.483:10.333'] = "Odense / Beldringe";
$coordinates['Denmark']['55.533:8.567'] = "Esbjerg";
$coordinates['Denmark']['55.583:12.133'] = "Koebenhavn / Roskilde";
$coordinates['Denmark']['55.617:12.650'] = "Koebenhavn / Kastrup";
$coordinates['Denmark']['55.700:9.200'] = "Vandel";
$coordinates['Denmark']['55.733:9.167'] = "Billund Lufthavn";
$coordinates['Denmark']['55.767:12.333'] = "Vaerloese";
$coordinates['Denmark']['56.000:8.350'] = "Stauning Lufthavn";
$coordinates['Denmark']['56.300:10.617'] = "Tirstrup";
$coordinates['Denmark']['56.300:9.117'] = "Karup";
$coordinates['Denmark']['56.400:8.450'] = "Lindtorp Airport";
$coordinates['Denmark']['56.550:9.167'] = "Skive Lufthavn";
$coordinates['Denmark']['56.700:11.550'] = "Anholt Island Automated Reporting Station";
$coordinates['Denmark']['56.717:10.117'] = "Hadsund";
$coordinates['Denmark']['57.067:8.717'] = "Thisted Lufthavn";
$coordinates['Denmark']['57.100:9.850'] = "Aalborg";
$coordinates['Denmark']['57.500:10.217'] = "Sindal Flyveplads";
$coordinates['Denmark']['62.067:-7.283'] = "Soervaag / Vagar";
$coordinates['Djibouti']['11.550:43.150'] = "Djibouti";
$coordinates['Dominica']['15.300:-61.400'] = "Roseau";
$coordinates['Dominica']['15.533:-61.300'] = "Melville Hall Airport";
$coordinates['Dominica']['15.533:-61.400'] = "Canefield Airport";
$coordinates['Dominican Republic']['18.200:-71.100'] = "Barahona";
$coordinates['Dominican Republic']['18.433:-69.667'] = "Las Americas";
$coordinates['Dominican Republic']['18.467:-69.967'] = "Herrera";
$coordinates['Dominican Republic']['18.567:-68.367'] = "Punta Cana";
$coordinates['Dominican Republic']['19.450:-70.700'] = "Santiago";
$coordinates['Dominican Republic']['19.750:-70.550'] = "Puerto Plata International";
$coordinates['East Timor']['-8.500:126.400'] = "Baucau";
$coordinates['East Timor']['-8.567:125.567'] = "Dilli / Dilli Airport";
$coordinates['East Timor']['-9.200:124.367'] = "Oe-Cusse / Oe Cusse";
$coordinates['Ecuador']['-0.150:-78.483'] = "Quito / Mariscal Sucre";
$coordinates['Ecuador']['0.350:-78.133'] = "Ibarra / Atahualpa";
$coordinates['Ecuador']['-0.583:-80.400'] = "Bahia De Caraquez";
$coordinates['Ecuador']['-0.783:-75.517'] = "Tiputini";
$coordinates['Ecuador']['0.817:-77.700'] = "Tulcan / El Rosal";
$coordinates['Ecuador']['-0.900:-89.600'] = "San Cristobal Galapagos";
$coordinates['Ecuador']['-0.917:-78.617'] = "Latacunga";
$coordinates['Ecuador']['-0.950:-80.683'] = "Manta";
$coordinates['Ecuador']['0.967:-79.633'] = "Esmeraldas-Tachina";
$coordinates['Ecuador']['-1.200:-78.567'] = "Ambato / Chachoan";
$coordinates['Ecuador']['-1.500:-78.050'] = "Pastaza / Rio Amazonas";
$coordinates['Ecuador']['-2.150:-79.883'] = "Guayaquil / Simon Bolivar";
$coordinates['Ecuador']['-2.200:-80.983'] = "Salinas / General Ulpiano Paez";
$coordinates['Ecuador']['-2.883:-78.983'] = "Cuenca / Mariscal Lamar";
$coordinates['Ecuador']['-3.250:-79.967'] = "Machala / General M. Serrano";
$coordinates['Ecuador']['-4.000:-79.367'] = "Catamayo / Camilo Ponce Enriquez";
$coordinates['Ecuador']['-4.367:-79.933'] = "Macara / J. M. Velasco I.";
$coordinates['Egypt']['23.967:32.783'] = "Asswan";
$coordinates['Egypt']['25.667:32.700'] = "Luxor";
$coordinates['Egypt']['27.050:31.017'] = "Asyut";
$coordinates['Egypt']['27.150:33.717'] = "Hurguada";
$coordinates['Egypt']['28.233:32.617'] = "El Tor";
$coordinates['Egypt']['30.133:31.400'] = "Cairo Airport";
$coordinates['Egypt']['31.083:33.817'] = "El Arish";
$coordinates['Egypt']['31.200:29.950'] = "Alexandria / Nouzha";
$coordinates['Egypt']['31.267:32.300'] = "Port Said";
$coordinates['Egypt']['31.333:27.217'] = "Mersa Matruh";
$coordinates['El Salvador']['13.433:-89.050'] = "El Salvador Intl. Airport / Comalapa";
$coordinates['El Salvador']['13.450:-88.117'] = "San Miguel / El Papalon";
$coordinates['El Salvador']['13.567:-89.833'] = "Acajutla";
$coordinates['El Salvador']['13.700:-89.117'] = "San Salvador / Ilopango";
$coordinates['El Salvador']['13.983:-89.567'] = "Santa Ana / El Palmar";
$coordinates['Equatorial Guinea']['3.750:8.767'] = "Malabo/Fernando Poo";
$coordinates['Estonia']['58.983:22.817'] = "Kardla";
$coordinates['Estonia']['59.383:24.583'] = "Tallinn";
$coordinates['Ethiopia']['10.350:37.717'] = "Debremarcos";
$coordinates['Ethiopia']['11.083:39.717'] = "Combolcha";
$coordinates['Ethiopia']['11.600:37.400'] = "Bahar Dar";
$coordinates['Ethiopia']['12.533:37.433'] = "Gondar";
$coordinates['Ethiopia']['13.067:42.717'] = "Assab";
$coordinates['Ethiopia']['13.500:39.483'] = "Makale";
$coordinates['Ethiopia']['15.283:38.917'] = "Asmara";
$coordinates['Ethiopia']['15.617:39.450'] = "Massawa";
$coordinates['Ethiopia']['5.100:44.583'] = "Gode";
$coordinates['Ethiopia']['5.283:39.750'] = "Neghelli";
$coordinates['Ethiopia']['6.067:37.667'] = "Arba Minch";
$coordinates['Ethiopia']['7.067:38.500'] = "Awassa";
$coordinates['Ethiopia']['7.667:36.833'] = "Jimma";
$coordinates['Ethiopia']['8.167:35.550'] = "Gore";
$coordinates['Ethiopia']['8.733:39.000'] = "Harar Meda";
$coordinates['Ethiopia']['8.983:38.800'] = "Addis Ababa";
$coordinates['Ethiopia']['9.333:42.717'] = "Jiggiga";
$coordinates['Ethiopia']['9.600:41.867'] = "Dire Dawa";
$coordinates['Falkland Islands (Malvinas)']['-51.683:-57.767'] = "Stanley Airport";
$coordinates['Fiji']['-12.500:177.050'] = "Rotuma";
$coordinates['Fiji']['-17.750:177.450'] = "Nandi";
$coordinates['Fiji']['-18.050:178.567'] = "Nausori";
$coordinates['Fiji']['-18.233:-178.800'] = "Lakemba";
$coordinates['Finland']['60.117:19.900'] = "Mariehamn / Aland Island";
$coordinates['Finland']['60.250:25.050'] = "Helsinki-Malmi";
$coordinates['Finland']['60.317:24.967'] = "Helsinki-Vantaa";
$coordinates['Finland']['60.517:22.267'] = "Turku";
$coordinates['Finland']['60.900:26.933'] = "Utti";
$coordinates['Finland']['61.046:28.149'] = "Lappeenranta";
$coordinates['Finland']['61.417:23.583'] = "Tampere / Pirkkala";
$coordinates['Finland']['61.467:21.800'] = "Pori";
$coordinates['Finland']['61.733:27.300'] = "Mikkeli";
$coordinates['Finland']['61.850:24.800'] = "Halli";
$coordinates['Finland']['61.950:28.950'] = "Savonlinna";
$coordinates['Finland']['62.400:25.683'] = "Jyvaskyla";
$coordinates['Finland']['62.533:24.217'] = "Ahtari";
$coordinates['Finland']['62.667:29.633'] = "Joensuu";
$coordinates['Finland']['63.017:27.800'] = "Kuopio";
$coordinates['Finland']['63.050:21.767'] = "Vaasa";
$coordinates['Finland']['63.083:25.867'] = "Viitasaari";
$coordinates['Finland']['63.100:23.033'] = "Kauhava";
$coordinates['Finland']['63.717:23.150'] = "Kruunupyy";
$coordinates['Finland']['64.283:27.683'] = "Kajaani";
$coordinates['Finland']['64.900:29.017'] = "Suomussalmi";
$coordinates['Finland']['64.933:25.367'] = "Oulu";
$coordinates['Finland']['65.033:24.800'] = "Hailuoto";
$coordinates['Finland']['65.367:27.017'] = "Pudasjarvi";
$coordinates['Finland']['65.783:24.583'] = "Kemi";
$coordinates['Finland']['65.967:29.183'] = "Kuusamo";
$coordinates['Finland']['66.567:25.833'] = "Rovaniemi";
$coordinates['Finland']['66.800:24.000'] = "Pello";
$coordinates['Finland']['67.367:26.650'] = "Sodankyla";
$coordinates['Finland']['68.617:27.417'] = "Ivalo";
$coordinates['France']['-13.233:-176.167'] = "Hihifo Ile Wallis";
$coordinates['France']['-14.317:-178.117'] = "Maopoopo Ile Futuna";
$coordinates['France']['41.500:9.100'] = "Figari";
$coordinates['France']['41.917:8.800'] = "Ajaccio";
$coordinates['France']['41.917:9.400'] = "Solenzara";
$coordinates['France']['42.533:8.800'] = "Calvi";
$coordinates['France']['42.550:9.483'] = "Bastia";
$coordinates['France']['42.733:2.867'] = "Perpignan";
$coordinates['France']['43.000:1.100'] = "St-Girons";
$coordinates['France']['43.100:6.150'] = "Hyeres";
$coordinates['France']['43.183:0.000'] = "Tarbes / Ossun";
$coordinates['France']['43.217:2.317'] = "Carcassonne";
$coordinates['France']['43.383:-0.417'] = "Pau";
$coordinates['France']['43.383:6.383'] = "Le Luc";
$coordinates['France']['43.417:6.750'] = "St-Raphael";
$coordinates['France']['43.450:5.233'] = "Marseille / Marignane";
$coordinates['France']['43.467:-1.533'] = "Biarritz";
$coordinates['France']['43.500:5.367'] = "Aix Les Milles";
$coordinates['France']['43.517:4.933'] = "Istres";
$coordinates['France']['43.533:1.367'] = "Toulouse / Francazal";
$coordinates['France']['43.550:6.950'] = "Cannes";
$coordinates['France']['43.583:3.967'] = "Montpellier";
$coordinates['France']['43.600:5.100'] = "Salon";
$coordinates['France']['43.633:1.367'] = "Toulouse / Blagnac";
$coordinates['France']['43.650:7.200'] = "Nice";
$coordinates['France']['43.683:0.600'] = "Auch";
$coordinates['France']['43.683:-1.067'] = "Dax";
$coordinates['France']['43.750:4.417'] = "Nimes / Garons";
$coordinates['France']['43.867:4.400'] = "Nimes / Courbessac";
$coordinates['France']['43.917:-0.500'] = "Mont-De-Marsan";
$coordinates['France']['43.917:2.117'] = "Albi";
$coordinates['France']['44.067:6.000'] = "St-Auban-Sur-Durance";
$coordinates['France']['44.133:4.833'] = "Orange";
$coordinates['France']['44.183:0.600'] = "Agen";
$coordinates['France']['44.183:2.517'] = "Cassagnes-Begonhes";
$coordinates['France']['44.400:2.483'] = "Rodez";
$coordinates['France']['44.433:-1.250'] = "Biscarosse";
$coordinates['France']['44.533:-1.133'] = "Cazaux";
$coordinates['France']['44.583:4.733'] = "Montelimar";
$coordinates['France']['44.817:0.517'] = "Bergerac";
$coordinates['France']['44.833:-0.700'] = "Bordeaux / Merignac";
$coordinates['France']['44.900:2.417'] = "Aurillac";
$coordinates['France']['45.083:3.767'] = "Le Puy";
$coordinates['France']['45.150:1.467'] = "Brive";
$coordinates['France']['45.200:0.817'] = "Perigueux";
$coordinates['France']['45.367:5.333'] = "Grenoble / St. Geoirs";
$coordinates['France']['45.533:4.300'] = "St-Etienne Boutheon";
$coordinates['France']['45.650:5.883'] = "Chambery / Aix-Les-Bains";
$coordinates['France']['45.667:-0.317'] = "Cognac";
$coordinates['France']['45.717:4.950'] = "Lyon / Bron";
$coordinates['France']['45.733:5.083'] = "Lyon / Satolas";
$coordinates['France']['45.783:3.167'] = "Clermont-Ferrand";
$coordinates['France']['45.867:1.183'] = "Limoges";
$coordinates['France']['45.983:5.333'] = "Amberieu";
$coordinates['France']['46.150:-1.150'] = "La Rochelle";
$coordinates['France']['46.167:3.400'] = "Vichy";
$coordinates['France']['46.300:4.800'] = "Macon";
$coordinates['France']['46.317:-0.400'] = "Niort";
$coordinates['France']['46.417:4.017'] = "Saint-Yan";
$coordinates['France']['46.583:0.317'] = "Poitiers";
$coordinates['France']['46.700:-1.383'] = "La Roche-Sur-Yon";
$coordinates['France']['46.850:1.717'] = "Chateauroux";
$coordinates['France']['47.000:3.100'] = "Nevers";
$coordinates['France']['47.067:2.367'] = "Bourges";
$coordinates['France']['47.167:-1.600'] = "Nantes";
$coordinates['France']['47.250:5.983'] = "Besancon";
$coordinates['France']['47.267:5.083'] = "Dijon";
$coordinates['France']['47.317:1.683'] = "Romorantin";
$coordinates['France']['47.317:-2.167'] = "St-Nazaire";
$coordinates['France']['47.450:0.717'] = "Tours";
$coordinates['France']['47.500:-0.567'] = "Angers";
$coordinates['France']['47.600:7.517'] = "Bale-Mulhouse";
$coordinates['France']['47.633:6.867'] = "Belfort";
$coordinates['France']['47.767:-3.450'] = "Lann Bihoue";
$coordinates['France']['47.783:6.350'] = "Luxeuil";
$coordinates['France']['47.800:3.550'] = "Auxerre";
$coordinates['France']['47.850:4.550'] = "Chatillon-Sur-Seine";
$coordinates['France']['47.917:7.400'] = "Colmar";
$coordinates['France']['47.933:0.200'] = "Le Mans";
$coordinates['France']['47.967:-4.167'] = "Quimper";
$coordinates['France']['47.983:1.750'] = "Orleans";
$coordinates['France']['48.050:1.383'] = "Chateaudun";
$coordinates['France']['48.067:-1.733'] = "Rennes";
$coordinates['France']['48.283:-4.433'] = "Lanveoc Poulmic";
$coordinates['France']['48.333:4.017'] = "Troyes";
$coordinates['France']['48.450:0.117'] = "Alencon";
$coordinates['France']['48.450:-4.417'] = "Brest";
$coordinates['France']['48.467:1.517'] = "Chartres";
$coordinates['France']['48.517:-4.150'] = "Landivisiau";
$coordinates['France']['48.533:-2.850'] = "Saint-Brieuc";
$coordinates['France']['48.550:7.633'] = "Strasbourg";
$coordinates['France']['48.583:-2.067'] = "Dinard";
$coordinates['France']['48.583:5.967'] = "Nancy / Ochey";
$coordinates['France']['48.617:2.683'] = "Melun";
$coordinates['France']['48.633:4.900'] = "St-Dizier";
$coordinates['France']['48.683:6.217'] = "Nancy / Essey";
$coordinates['France']['48.733:2.400'] = "Paris-Orly";
$coordinates['France']['48.767:1.100'] = "Toussus Le Noble";
$coordinates['France']['48.767:2.200'] = "Villacoublay";
$coordinates['France']['48.783:5.483'] = "Toul / Rosieres";
$coordinates['France']['48.967:2.450'] = "Paris / Le Bourget";
$coordinates['France']['48.983:6.250'] = "Metz-Nancy-Lorraine";
$coordinates['France']['49.017:1.217'] = "Evreux";
$coordinates['France']['49.017:2.533'] = "Paris-Aeroport Charles De Gaulle";
$coordinates['France']['49.083:6.133'] = "Metz / Frescaty";
$coordinates['France']['49.183:-0.450'] = "Caen";
$coordinates['France']['49.250:2.517'] = "Creil Fafb";
$coordinates['France']['49.300:4.033'] = "Reims";
$coordinates['France']['49.383:1.183'] = "Rouen";
$coordinates['France']['49.467:2.117'] = "Beauvais";
$coordinates['France']['49.517:0.067'] = "La Heve";
$coordinates['France']['49.650:-1.467'] = "Cherbourg / Maupertus";
$coordinates['France']['49.783:4.633'] = "Charleville";
$coordinates['France']['49.817:3.200'] = "Saint-Quentin";
$coordinates['France']['49.833:0.650'] = "Vittefleur / St. Vale";
$coordinates['France']['50.133:1.833'] = "Abbeville";
$coordinates['France']['50.217:3.150'] = "Cambrai";
$coordinates['France']['50.517:1.617'] = "Le Touquet";
$coordinates['France']['50.567:3.100'] = "Lille";
$coordinates['French Guiana']['4.833:-52.367'] = "Cayenne / Rochambeau";
$coordinates['French Guiana']['5.500:-54.033'] = "Saint-Laurent-Du-Maroni";
$coordinates['French Polynesia']['-14.967:-147.667'] = "Rangiroa / Tuamoto Island";
$coordinates['French Polynesia']['-16.450:-151.750'] = "Bora-Bora";
$coordinates['French Polynesia']['-17.550:-149.617'] = "Tahiti-Faaa";
$coordinates['French Polynesia']['-18.067:-140.950'] = "Hao";
$coordinates['French Polynesia']['-21.817:-138.800'] = "Mururoa";
$coordinates['French Polynesia']['-23.350:-149.483'] = "Tubuai";
$coordinates['Gabon']['0.450:9.417'] = "Libreville";
$coordinates['Gabon']['0.567:12.867'] = "Makokou";
$coordinates['Gabon']['-0.700:8.750'] = "Port-Gentil";
$coordinates['Gabon']['-0.717:10.233'] = "Lambarene";
$coordinates['Gabon']['0.783:11.533'] = "Mitzic";
$coordinates['Gabon']['-0.833:12.717'] = "Lastoursville";
$coordinates['Gabon']['1.000:9.600'] = "Cocobeach";
$coordinates['Gabon']['1.017:13.933'] = "Mekambo";
$coordinates['Gabon']['-1.533:13.267'] = "Moanda";
$coordinates['Gabon']['-1.867:11.017'] = "Mouila";
$coordinates['Gabon']['2.083:11.483'] = "Bitam";
$coordinates['Gabon']['-2.850:11.017'] = "Tchibanga";
$coordinates['Gabon']['-3.417:10.650'] = "Mayumba";
$coordinates['Gambia']['13.350:-16.800'] = "Banjul / Yundum";
$coordinates['Georgia']['41.683:44.950'] = "Tbilisi";
$coordinates['Georgia']['41.933:44.583'] = "Muhrani";
$coordinates['Germany']['47.667:9.517'] = "Friedrichshafen";
$coordinates['Germany']['47.683:9.183'] = "Konstanz";
$coordinates['Germany']['47.833:10.867'] = "Altenstadt";
$coordinates['Germany']['47.967:8.517'] = "Donaueschingen / Villingen";
$coordinates['Germany']['47.983:10.233'] = "Memmingen";
$coordinates['Germany']['48.067:10.900'] = "Landsberg";
$coordinates['Germany']['48.133:11.700'] = "Munich / Riem";
$coordinates['Germany']['48.183:10.867'] = "Lechfeld";
$coordinates['Germany']['48.183:9.000'] = "Messstetten";
$coordinates['Germany']['48.200:11.267'] = "Fuerstenfeldbruck";
$coordinates['Germany']['48.217:9.917'] = "Laupheim";
$coordinates['Germany']['48.317:11.950'] = "Erding";
$coordinates['Germany']['48.433:10.933'] = "Augsburg";
$coordinates['Germany']['48.683:9.217'] = "Stuttgart-Echterdingen";
$coordinates['Germany']['48.717:11.217'] = "Neuburg / Donau";
$coordinates['Germany']['48.717:11.533'] = "Ingolstadt";
$coordinates['Germany']['49.217:11.100'] = "Roth";
$coordinates['Germany']['49.217:11.833'] = "Hohenfels";
$coordinates['Germany']['49.217:7.117'] = "Saarbruecken / Ensheim";
$coordinates['Germany']['49.317:10.633'] = "Ansbach / Katterbach";
$coordinates['Germany']['49.400:8.650'] = "Heidelberg";
$coordinates['Germany']['49.400:9.967'] = "Niederstetten";
$coordinates['Germany']['49.433:11.900'] = "Kuemmersruck";
$coordinates['Germany']['49.433:7.600'] = "Ramstein";
$coordinates['Germany']['49.467:10.383'] = "Illesheim";
$coordinates['Germany']['49.473:8.516'] = "Baden Wurttemberg, Neuostheim";
$coordinates['Germany']['49.500:11.050'] = "Nuernberg";
$coordinates['Germany']['49.500:7.867'] = "Sembach United States Air Force Operated Base In Foreign Country";
$coordinates['Germany']['49.567:8.467'] = "Coleman Mannheim";
$coordinates['Germany']['49.650:9.967'] = "Giebelstadt";
$coordinates['Germany']['49.700:11.950'] = "Grafenwoehr";
$coordinates['Germany']['49.700:7.333'] = "Idar-Oberstein";
$coordinates['Germany']['49.750:10.200'] = "Kitzingen Usa \ Af";
$coordinates['Germany']['49.850:7.600'] = "Pferdsfeld";
$coordinates['Germany']['49.850:7.883'] = "Bad Kreuznach";
$coordinates['Germany']['49.950:7.267'] = "Hahn";
$coordinates['Germany']['49.983:11.633'] = "Bayreuth";
$coordinates['Germany']['49.983:6.700'] = "Spangdahlem";
$coordinates['Germany']['50.050:8.333'] = "Wiesbaden";
$coordinates['Germany']['50.050:8.600'] = "Frankfurt / M-Flughafen";
$coordinates['Germany']['50.167:7.067'] = "Buechel";
$coordinates['Germany']['50.167:8.967'] = "Hanau";
$coordinates['Germany']['50.317:11.883'] = "Hof";
$coordinates['Germany']['50.367:7.317'] = "Mendig";
$coordinates['Germany']['50.817:6.183'] = "Aachen / Merzbruck";
$coordinates['Germany']['50.833:6.667'] = "Noervenich";
$coordinates['Germany']['50.867:7.167'] = "Koeln / Bonn";
$coordinates['Germany']['50.967:6.050'] = "Geilenkirchen";
$coordinates['Germany']['50.983:10.967'] = "Erfurt-Bindersleben";
$coordinates['Germany']['51.117:9.283'] = "Fritzlar";
$coordinates['Germany']['51.133:13.750'] = "Dresden-Klotzsche";
$coordinates['Germany']['51.200:6.133'] = "Brueggen";
$coordinates['Germany']['51.300:6.767'] = "Duesseldorf";
$coordinates['Germany']['51.400:6.967'] = "Essen";
$coordinates['Germany']['51.400:9.383'] = "Kassel / Calden";
$coordinates['Germany']['51.417:12.233'] = "Leipzig-Schkeuditz";
$coordinates['Germany']['51.517:7.617'] = "Dortmund / Wickede";
$coordinates['Germany']['51.600:6.150'] = "Laarbruch";
$coordinates['Germany']['51.617:8.617'] = "Paderborn / Lippstadt";
$coordinates['Germany']['51.667:14.633'] = "Preschen";
$coordinates['Germany']['51.733:6.267'] = "Kalkar";
$coordinates['Germany']['51.767:13.183'] = "Holzdorf";
$coordinates['Germany']['51.767:14.300'] = "Cottbus Flugplatz";
$coordinates['Germany']['51.917:8.300'] = "Guetersloh";
$coordinates['Germany']['52.133:7.700'] = "Muenster / Osnabrueck";
$coordinates['Germany']['52.283:9.083'] = "Bueckeburg";
$coordinates['Germany']['52.300:10.450'] = "Braunschweig";
$coordinates['Germany']['52.300:7.383'] = "Rheine-Bentlage";
$coordinates['Germany']['52.333:7.533'] = "Hopsten";
$coordinates['Germany']['52.383:13.517'] = "Berlin-Schoenefeld";
$coordinates['Germany']['52.450:7.167'] = "Nordhorn";
$coordinates['Germany']['52.450:9.433'] = "Wunstorf";
$coordinates['Germany']['52.467:13.400'] = "Berlin-Tempelhof";
$coordinates['Germany']['52.467:9.683'] = "Hannover";
$coordinates['Germany']['52.567:13.317'] = "Berlin-Tegel";
$coordinates['Germany']['52.583:8.350'] = "Diepholz";
$coordinates['Germany']['52.600:10.017'] = "Celle";
$coordinates['Germany']['52.817:9.933'] = "Bergen";
$coordinates['Germany']['52.917:10.183'] = "Fassberg";
$coordinates['Germany']['53.050:8.800'] = "Bremen";
$coordinates['Germany']['53.200:12.517'] = "Wittstock";
$coordinates['Germany']['53.427:11.784'] = "Mecklenburg-Vorpommern, Parchim";
$coordinates['Germany']['53.533:7.883'] = "Jever";
$coordinates['Germany']['53.533:9.833'] = "Hamburg-Finkenwerder";
$coordinates['Germany']['53.550:7.667'] = "Wittmundhaven";
$coordinates['Germany']['53.600:13.317'] = "Trollenhagen";
$coordinates['Germany']['53.633:10.000'] = "Hamburg-Fuhlsbuettel";
$coordinates['Germany']['53.767:8.667'] = "Nordholz";
$coordinates['Germany']['53.817:10.700'] = "Luebeck-Blankensee";
$coordinates['Germany']['53.917:12.283'] = "Laage";
$coordinates['Germany']['54.000:9.583'] = "Itzehoe";
$coordinates['Germany']['54.317:9.533'] = "Hohn";
$coordinates['Germany']['54.383:10.150'] = "Kiel-Holtenau";
$coordinates['Germany']['54.467:9.517'] = "Schleswig-Jagel";
$coordinates['Germany']['54.633:9.350'] = "Eggebek";
$coordinates['Germany']['54.833:9.500'] = "Gluecksburg / Meierwik";
$coordinates['Germany']['54.917:8.350'] = "Westerland / Sylt";
$coordinates['Ghana']['10.050:-2.500'] = "Wa";
$coordinates['Ghana']['10.900:-1.100'] = "Navrongo";
$coordinates['Ghana']['4.867:-2.233'] = "Axim";
$coordinates['Ghana']['4.883:-1.767'] = "Takoradi";
$coordinates['Ghana']['5.200:-1.067'] = "Saltpond";
$coordinates['Ghana']['5.600:-0.167'] = "Accra";
$coordinates['Ghana']['5.617:0.000'] = "Tema";
$coordinates['Ghana']['5.783:0.633'] = "Ada";
$coordinates['Ghana']['5.933:-0.983'] = "Akim Oda";
$coordinates['Ghana']['6.083:-0.250'] = "Koforidua";
$coordinates['Ghana']['6.100:0.117'] = "Akuse";
$coordinates['Ghana']['6.200:-2.333'] = "Sefwi Bekwai";
$coordinates['Ghana']['6.600:0.467'] = "Ho";
$coordinates['Ghana']['6.717:-1.600'] = "Kumasi";
$coordinates['Ghana']['7.333:-2.333'] = "Sunyani";
$coordinates['Ghana']['7.750:-2.100'] = "Wenchi";
$coordinates['Ghana']['9.033:-2.483'] = "Bole";
$coordinates['Ghana']['9.450:-0.017'] = "Yendi";
$coordinates['Ghana']['9.500:-0.850'] = "Tamale";
$coordinates['Gibraltar']['36.150:-5.350'] = "Gibraltar";
$coordinates['Greece']['35.333:25.183'] = "Heraklion Airport";
$coordinates['Greece']['35.414:27.148'] = "Karpathos Airport";
$coordinates['Greece']['35.483:24.117'] = "Souda Airport";
$coordinates['Greece']['36.400:28.083'] = "Rhodes Airport";
$coordinates['Greece']['36.783:27.067'] = "Kos Airport";
$coordinates['Greece']['37.067:22.017'] = "Kalamata Airport";
$coordinates['Greece']['37.533:22.400'] = "Tripolis Airport";
$coordinates['Greece']['37.700:26.917'] = "Samos Airport";
$coordinates['Greece']['37.900:23.733'] = "Athinai Airport";
$coordinates['Greece']['37.917:21.283'] = "Andravida Airport";
$coordinates['Greece']['38.067:23.550'] = "Elefsis Airport";
$coordinates['Greece']['38.100:23.783'] = "Tatoi";
$coordinates['Greece']['38.117:20.500'] = "Kefalhnia Airport";
$coordinates['Greece']['38.150:21.417'] = "Araxos Airport";
$coordinates['Greece']['38.317:23.533'] = "Tanagra Airport";
$coordinates['Greece']['38.333:26.133'] = "Chios Airport";
$coordinates['Greece']['38.617:20.767'] = "Aktion Airport";
$coordinates['Greece']['39.067:26.600'] = "Mytilini Airport";
$coordinates['Greece']['39.217:22.800'] = "Anchialos Airport";
$coordinates['Greece']['39.617:19.917'] = "Kerkyra Airport";
$coordinates['Greece']['39.633:22.417'] = "Larissa Airport";
$coordinates['Greece']['39.917:25.233'] = "Limnos Airport";
$coordinates['Greece']['40.300:21.783'] = "Kozani Airport";
$coordinates['Greece']['40.450:21.283'] = "Kastoria Airport";
$coordinates['Greece']['40.517:22.967'] = "Thessaloniki Airport";
$coordinates['Greece']['40.850:25.917'] = "Alexandroupoli Airport";
$coordinates['Greece']['40.983:24.600'] = "Chrysoupoli Airport";
$coordinates['Greenland']['59.983:-45.200'] = "Angisoq";
$coordinates['Greenland']['60.050:-43.167'] = "Prins Christian Sund";
$coordinates['Greenland']['60.717:-46.050'] = "Julianehaab";
$coordinates['Greenland']['61.167:-45.417'] = "Narsarsuaq";
$coordinates['Greenland']['61.233:-48.100'] = "Groennedal";
$coordinates['Greenland']['62.000:-49.667'] = "Frederikshaab";
$coordinates['Greenland']['64.167:-51.750'] = "Godthaab / Nuuk";
$coordinates['Greenland']['65.583:-37.150'] = "Kulusuk Lufthavn";
$coordinates['Greenland']['65.600:-37.633'] = "Tasiilaq";
$coordinates['Greenland']['66.917:-53.667'] = "Holsteinsborg";
$coordinates['Greenland']['67.017:-50.700'] = "Sdr Stroemfjord";
$coordinates['Greenland']['67.783:-32.300'] = "Aputiteeq";
$coordinates['Greenland']['68.700:-52.750'] = "Egedesminde";
$coordinates['Greenland']['69.233:-51.067'] = "Jacobshavn Lufthavn";
$coordinates['Greenland']['70.417:-21.967'] = "Cape Tobin Automated Reporting Station";
$coordinates['Greenland']['70.483:-21.950'] = "Scoresbysund";
$coordinates['Greenland']['70.750:-22.650'] = "Constable Pynt";
$coordinates['Greenland']['74.300:-20.217'] = "Daneborg";
$coordinates['Greenland']['76.533:-68.750'] = "Thule A. B.";
$coordinates['Greenland']['76.767:-18.667'] = "Danmarkshavn";
$coordinates['Grenada']['12.000:-61.783'] = "Point Salines Airport";
$coordinates['Guadeloupe']['16.267:-61.517'] = "Le Raizet, Guadeloupe";
$coordinates['Guadeloupe']['17.900:-62.850'] = "Gustavia, Saint Barthelemy";
$coordinates['Guatemala']['13.917:-90.817'] = "San Jose";
$coordinates['Guatemala']['14.533:-91.667'] = "Retalhuleu";
$coordinates['Guatemala']['14.583:-90.517'] = "Guatemala Aeropuertola Aurora";
$coordinates['Guatemala']['15.317:-91.467'] = "Huehuetenango";
$coordinates['Guatemala']['15.467:-90.317'] = "Coban";
$coordinates['Guatemala']['15.717:-88.600'] = "Puerto Barrios";
$coordinates['Guatemala']['16.917:-89.883'] = "Flores";
$coordinates['Guinea']['10.033:-10.750'] = "Faranah / Badala";
$coordinates['Guinea']['10.050:-12.867'] = "Kindia";
$coordinates['Guinea']['10.383:-9.300'] = "Kankan";
$coordinates['Guinea']['10.933:-14.317'] = "Boke";
$coordinates['Guinea']['11.317:-12.300'] = "Labe";
$coordinates['Guinea']['11.433:-9.167'] = "Siguiri";
$coordinates['Guinea']['7.733:-8.833'] = "N'Zerekore";
$coordinates['Guinea']['8.533:-9.467'] = "Macenta";
$coordinates['Guinea']['9.183:-10.100'] = "Kissidougou";
$coordinates['Guinea']['9.567:-13.617'] = "Conakry / Gbessia";
$coordinates['Guinea-Bissau']['11.883:-15.650'] = "Bissau Aeroport";
$coordinates['Guinea-Bissau']['12.167:-14.667'] = "Bafata";
$coordinates['Guyana']['6.500:-58.250'] = "Timehri Airport";
$coordinates['Guyana']['6.800:-58.150'] = "Georgetown";
$coordinates['Haiti']['18.567:-72.300'] = "Port-Au-Prince / Aeroport International";
$coordinates['Haiti']['19.750:-72.183'] = "Cap-Haitien";
$coordinates['Honduras']['13.267:-87.650'] = "Amapala";
$coordinates['Honduras']['13.300:-87.183'] = "Choluteca";
$coordinates['Honduras']['14.050:-87.217'] = "Tegucigalpa";
$coordinates['Honduras']['14.317:-88.150'] = "La Esperanza";
$coordinates['Honduras']['14.383:-87.617'] = "Coronel Enrique Soto Cano Air Base";
$coordinates['Honduras']['14.783:-88.783'] = "Santa Rosa De Copan";
$coordinates['Honduras']['14.900:-85.933'] = "Catacamas";
$coordinates['Honduras']['15.167:-87.117'] = "Yoro";
$coordinates['Honduras']['15.217:-83.800'] = "Puerto Lempira";
$coordinates['Honduras']['15.450:-87.933'] = "La Mesa San Pedro Sula";
$coordinates['Honduras']['15.717:-87.483'] = "Tela";
$coordinates['Honduras']['15.733:-86.867'] = "La Ceiba Airport";
$coordinates['Honduras']['16.317:-86.517'] = "Roatan";
$coordinates['Honduras']['16.467:-86.067'] = "Guanaja";
$coordinates['Honduras']['17.400:-83.933'] = "Islas Del Cisne";
$coordinates['Hong Kong']['22.200:114.017'] = "Cheung Chau";
$coordinates['Hong Kong']['22.333:114.183'] = "Hong Kong Inter-National Airport";
$coordinates['Hungary']['46.100:18.233'] = "Pecs / Pogany";
$coordinates['Hungary']['46.250:20.100'] = "Szeged";
$coordinates['Hungary']['46.383:17.833'] = "Kaposvar";
$coordinates['Hungary']['46.683:21.167'] = "Bekescsaba";
$coordinates['Hungary']['46.917:18.050'] = "Siofok";
$coordinates['Hungary']['46.917:19.750'] = "Kecskemet";
$coordinates['Hungary']['47.117:20.233'] = "Szolnok";
$coordinates['Hungary']['47.200:17.500'] = "Papa";
$coordinates['Hungary']['47.267:16.633'] = "Szombathely";
$coordinates['Hungary']['47.433:19.267'] = "Budapest / Ferihegy";
$coordinates['Hungary']['47.450:18.967'] = "Budaors";
$coordinates['Hungary']['47.483:21.600'] = "Debrecen";
$coordinates['Hungary']['47.517:19.033'] = "Budapest Met Center";
$coordinates['Hungary']['47.967:21.983'] = "Nyiregyhaza / Napkor";
$coordinates['Hungary']['48.083:20.767'] = "Miskolc";
$coordinates['Iceland']['63.400:-20.283'] = "Vestmannaeyjar";
$coordinates['Iceland']['63.967:-22.600'] = "Keflavikurflugvollur";
$coordinates['Iceland']['64.133:-21.900'] = "Reykjavik";
$coordinates['Iceland']['64.300:-15.217'] = "Akurnes";
$coordinates['Iceland']['65.083:-22.733'] = "Stykkisholmur";
$coordinates['Iceland']['65.283:-14.400'] = "Egilsstadir";
$coordinates['Iceland']['65.683:-18.083'] = "Akureyri";
$coordinates['Iceland']['65.700:-14.817'] = "Skjaldthingsstadir";
$coordinates['Iceland']['66.450:-15.950'] = "Raufarhofn";
$coordinates['Iceland']['66.533:-18.017'] = "Grimsey";
$coordinates['India']['10.767:78.717'] = "Tiruchchirapalli";
$coordinates['India']['11.033:77.050'] = "Coimbatore / Peelamedu";
$coordinates['India']['11.667:92.717'] = "Port Blair";
$coordinates['India']['12.917:74.883'] = "Mangalore / Bajpe";
$coordinates['India']['12.917:79.150'] = "Vellore";
$coordinates['India']['13.000:80.183'] = "Madras / Minambakkam";
$coordinates['India']['14.483:78.833'] = "Cuddapah";
$coordinates['India']['15.150:76.850'] = "Bellary";
$coordinates['India']['15.383:73.817'] = "Goa / Dabolim Airport";
$coordinates['India']['15.850:74.617'] = "Belgaum / Sambra";
$coordinates['India']['16.533:80.800'] = "Vijayawada / Gannavaram";
$coordinates['India']['16.700:74.233'] = "Kolhapur";
$coordinates['India']['17.450:78.467'] = "Hyderabad Airport";
$coordinates['India']['17.667:75.900'] = "Sholapur";
$coordinates['India']['19.117:72.850'] = "Bombay / Santacruz";
$coordinates['India']['19.850:75.400'] = "Aurangabad Chikalthan Aerodrome";
$coordinates['India']['20.250:85.833'] = "Bhubaneswar";
$coordinates['India']['20.700:77.067'] = "Akola";
$coordinates['India']['21.100:79.050'] = "Nagpur Sonegaon";
$coordinates['India']['21.750:72.200'] = "Bhaunagar";
$coordinates['India']['21.833:76.367'] = "Khandwa";
$coordinates['India']['21.917:84.083'] = "Jharsuguda";
$coordinates['India']['22.300:70.783'] = "Rajkot";
$coordinates['India']['22.650:88.450'] = "Calcutta / Dum Dum";
$coordinates['India']['22.717:75.800'] = "Indore";
$coordinates['India']['22.817:86.183'] = "Jamshedpur";
$coordinates['India']['23.067:72.633'] = "Ahmadabad";
$coordinates['India']['23.200:79.950'] = "Jabalpur";
$coordinates['India']['23.250:69.667'] = "Bhuj-Rudramata";
$coordinates['India']['23.283:77.350'] = "Bhopal / Bairagarh";
$coordinates['India']['23.317:85.317'] = "M. O. Ranchi";
$coordinates['India']['23.883:91.250'] = "Agartala";
$coordinates['India']['24.567:80.833'] = "Satna";
$coordinates['India']['24.617:73.883'] = "Udaipur Dabok";
$coordinates['India']['24.750:84.950'] = "Gaya";
$coordinates['India']['24.767:93.900'] = "Imphal Tulihal";
$coordinates['India']['25.150:75.850'] = "Kota Aerodrome";
$coordinates['India']['25.450:78.583'] = "Jhansi";
$coordinates['India']['25.450:81.733'] = "Allahabad / Bamhrauli";
$coordinates['India']['25.450:82.867'] = "Varanasi / Babatpur";
$coordinates['India']['25.600:85.100'] = "Patna";
$coordinates['India']['26.100:91.583'] = "Gauhati";
$coordinates['India']['26.233:78.250'] = "Gwalior";
$coordinates['India']['26.300:73.017'] = "Jodhpur";
$coordinates['India']['26.400:80.400'] = "Kanpur / Chakeri";
$coordinates['India']['26.633:88.317'] = "Siliguri";
$coordinates['India']['26.750:80.883'] = "Lucknow / Amausi";
$coordinates['India']['26.750:83.367'] = "Gorakhpur";
$coordinates['India']['26.817:75.800'] = "Jaipur / Sanganer";
$coordinates['India']['27.150:77.967'] = "Agra";
$coordinates['India']['27.233:94.117'] = "North Lakhimpur";
$coordinates['India']['27.483:95.017'] = "Dibrugarh / Mohanbari";
$coordinates['India']['28.367:79.400'] = "Bareilly";
$coordinates['India']['28.567:77.117'] = "New Delhi / Palam";
$coordinates['India']['28.583:77.200'] = "New Delhi / Safdarjung";
$coordinates['India']['29.167:75.733'] = "Hissar";
$coordinates['India']['31.250:76.667'] = "Bilaspur";
$coordinates['India']['31.633:74.867'] = "Amritsar";
$coordinates['India']['8.467:76.950'] = "Thiruvananthapuram";
$coordinates['India']['9.150:92.817'] = "Car Nicobar";
$coordinates['India']['9.833:78.083'] = "Madurai";
$coordinates['India']['9.950:76.267'] = "Cochin / Willingdon";
$coordinates['Indonesia']['0.117:111.533'] = "Sintang";
$coordinates['Indonesia']['-0.150:109.400'] = "Pontianak / Supadio";
$coordinates['Indonesia']['0.467:101.450'] = "Pakanbaru / Simpangtiga";
$coordinates['Indonesia']['0.467:102.317'] = "Rengat / Japura";
$coordinates['Indonesia']['-0.483:104.583'] = "Singkep / Dabo";
$coordinates['Indonesia']['0.517:123.067'] = "Gorontalo / Jalaluddin";
$coordinates['Indonesia']['-0.617:117.150'] = "Samarinda / Temindung";
$coordinates['Indonesia']['-0.683:119.733'] = "Palu / Mutiara";
$coordinates['Indonesia']['0.783:127.383'] = "Ternate / Babullah";
$coordinates['Indonesia']['-0.883:100.350'] = "Padang / Tabing";
$coordinates['Indonesia']['-0.883:134.050'] = "Manokwari / Rendani";
$coordinates['Indonesia']['-0.900:122.783'] = "Luwuk / Bubung";
$coordinates['Indonesia']['0.917:104.533'] = "Tanjungpinang / Kijang";
$coordinates['Indonesia']['-0.933:131.117'] = "Sorong / Jefman";
$coordinates['Indonesia']['-0.950:114.900'] = "Muaratewe / Beringin";
$coordinates['Indonesia']['-1.000:114.000'] = "Palangkaraya / Panarung";
$coordinates['Indonesia']['1.017:120.800'] = "Toli-Toli / Lalos";
$coordinates['Indonesia']['1.083:109.667'] = "Singkawang Ii";
$coordinates['Indonesia']['1.117:104.117'] = "Batan (Sumatra)";
$coordinates['Indonesia']['-1.183:136.117'] = "Biak / Mokmer";
$coordinates['Indonesia']['-1.267:116.900'] = "Balikpapan / Sepinggan";
$coordinates['Indonesia']['-1.383:120.733'] = "Poso / Kasiguncu";
$coordinates['Indonesia']['1.500:97.633'] = "Gunung Sitoli / Binaka";
$coordinates['Indonesia']['1.533:124.917'] = "Menado / Dr. Sam Ratulangi";
$coordinates['Indonesia']['1.550:98.883'] = "Sibolga / Pinangsori";
$coordinates['Indonesia']['-1.617:124.550'] = "Labuha / Taliabu";
$coordinates['Indonesia']['-1.633:103.650'] = "Jambi / Sultan Taha";
$coordinates['Indonesia']['1.817:127.833'] = "Galela / Gamarmalamu";
$coordinates['Indonesia']['-1.833:138.717'] = "Sarmi";
$coordinates['Indonesia']['-1.850:109.967'] = "Ketapang / Rahadi Usmaman";
$coordinates['Indonesia']['-1.867:136.233'] = "Serui / Yendosa";
$coordinates['Indonesia']['-10.167:123.667'] = "Kupang / El Tari";
$coordinates['Indonesia']['-10.500:121.833'] = "Sabu / Tardamu";
$coordinates['Indonesia']['-10.733:123.067'] = "Rote / Baa";
$coordinates['Indonesia']['-2.083:126.000'] = "Sanana";
$coordinates['Indonesia']['2.117:117.450'] = "Tanjung Redep / Berau";
$coordinates['Indonesia']['-2.167:106.133'] = "Pangkalpinang / Pangkalpinang";
$coordinates['Indonesia']['-2.567:140.483'] = "Jayapura / Sentani";
$coordinates['Indonesia']['-2.700:110.700'] = "Pangkalan Bun / Iskandar";
$coordinates['Indonesia']['-2.750:107.750'] = "Tanjungpandan / Buluh Tumbang";
$coordinates['Indonesia']['-2.767:101.367'] = "Kerinci / Depati Parbo";
$coordinates['Indonesia']['2.850:117.333'] = "Tanjung Selor";
$coordinates['Indonesia']['-2.883:132.250'] = "Fak-Fak / Torea";
$coordinates['Indonesia']['-2.900:104.700'] = "Palembang / Talangbetutu";
$coordinates['Indonesia']['-3.250:127.083'] = "Namlea";
$coordinates['Indonesia']['3.333:117.567'] = "Tarakan / Juwata";
$coordinates['Indonesia']['-3.333:135.500'] = "Nabire";
$coordinates['Indonesia']['-3.350:128.883'] = "Amahai";
$coordinates['Indonesia']['-3.400:116.217'] = "Kotabaru";
$coordinates['Indonesia']['-3.433:114.750'] = "Banjarmasin / Syamsuddin Noor";
$coordinates['Indonesia']['3.567:98.683'] = "Medan / Polonia";
$coordinates['Indonesia']['3.583:125.467'] = "Tahuna";
$coordinates['Indonesia']['-3.667:133.750'] = "Kaimana / Utarom";
$coordinates['Indonesia']['-3.700:128.083'] = "Ambon / Pattimura";
$coordinates['Indonesia']['3.733:115.683'] = "Longbawan / Juvai Semaring";
$coordinates['Indonesia']['-3.883:102.333'] = "Bengkulu / Padangkemiling";
$coordinates['Indonesia']['-3.917:136.367'] = "Enarotali";
$coordinates['Indonesia']['3.950:108.383'] = "Ranai / Ranai";
$coordinates['Indonesia']['-4.067:138.950'] = "Wamena / Wamena";
$coordinates['Indonesia']['-4.100:122.433'] = "Kendari / Woltermon-Ginsidi";
$coordinates['Indonesia']['4.250:96.117'] = "Meulaboh / Cut Nyak Dhien";
$coordinates['Indonesia']['-4.450:105.183'] = "Menggala / Astra Ksetra";
$coordinates['Indonesia']['-4.717:136.433'] = "Kokonao / Timuka";
$coordinates['Indonesia']['-5.067:119.550'] = "Ujung Pandang / Hasanuddin";
$coordinates['Indonesia']['5.233:97.200'] = "Lhokseumawe / Malikussaleh";
$coordinates['Indonesia']['-5.267:105.183'] = "Telukbetung / Beranti";
$coordinates['Indonesia']['-5.467:122.617'] = "Bau-Bau / Beto Ambiri";
$coordinates['Indonesia']['5.517:95.417'] = "Banda Aceh / Blangbintang";
$coordinates['Indonesia']['5.867:95.317'] = "Sabang / Cut Bau";
$coordinates['Indonesia']['-6.100:140.300'] = "Tanah Merah / Tanah Merah";
$coordinates['Indonesia']['-6.117:106.650'] = "Jakarta / Soekarno-Hatta";
$coordinates['Indonesia']['-6.233:106.650'] = "Curug / Budiarto";
$coordinates['Indonesia']['-6.250:106.900'] = "Jakarta Halim Perdanakusuma";
$coordinates['Indonesia']['-6.550:107.667'] = "Kalijati";
$coordinates['Indonesia']['-6.900:107.583'] = "Bandung / Husein";
$coordinates['Indonesia']['-6.983:110.383'] = "Semarang / Ahmadyani";
$coordinates['Indonesia']['-7.217:112.717'] = "Surabaya / Perak";
$coordinates['Indonesia']['-7.217:113.717'] = "Surabaya";
$coordinates['Indonesia']['-7.333:108.250'] = "Tasikmalaya / Cibeureum";
$coordinates['Indonesia']['-7.367:112.767'] = "Surabaya / Juanda";
$coordinates['Indonesia']['-7.617:111.517'] = "Madiun / Iswahyudi";
$coordinates['Indonesia']['-7.733:109.017'] = "Cilacap";
$coordinates['Indonesia']['-7.783:110.433'] = "Jogyakarta / Adisucipto";
$coordinates['Indonesia']['-7.867:110.917'] = "Surakarta / Adisumarmo";
$coordinates['Indonesia']['-7.967:112.700'] = "Malang / Abdul Rahkmansaleh";
$coordinates['Indonesia']['-7.983:131.300'] = "Saumlaki";
$coordinates['Indonesia']['-8.217:124.567'] = "Alor / Mali";
$coordinates['Indonesia']['-8.267:122.967'] = "Larantuka";
$coordinates['Indonesia']['-8.433:117.417'] = "Sumbawa Besar / Sumbawa Besar";
$coordinates['Indonesia']['-8.467:140.383'] = "Merauke / Mopah";
$coordinates['Indonesia']['-8.533:116.067'] = "Ampenan / Selaparang";
$coordinates['Indonesia']['-8.550:118.700'] = "Bima";
$coordinates['Indonesia']['-8.633:122.250'] = "Maumere / Wai Oti";
$coordinates['Indonesia']['-8.750:115.167'] = "Denpasar / Ngurah-Rai";
$coordinates['Indonesia']['-9.667:120.333'] = "Waingapu / Mau Hau";
$coordinates['Iran, Islamic Republic of']['25.417:60.750'] = "Chahbahar";
$coordinates['Iran, Islamic Republic of']['26.583:54.833'] = "Bandar Lengeh";
$coordinates['Iran, Islamic Republic of']['26.633:57.767'] = "Jask";
$coordinates['Iran, Islamic Republic of']['27.200:60.700'] = "Iranshahr";
$coordinates['Iran, Islamic Republic of']['27.217:56.367'] = "Bandarabbass";
$coordinates['Iran, Islamic Republic of']['28.967:53.683'] = "Fasa";
$coordinates['Iran, Islamic Republic of']['28.983:50.833'] = "Bushehr Civ / Afb";
$coordinates['Iran, Islamic Republic of']['29.100:58.400'] = "Bam";
$coordinates['Iran, Islamic Republic of']['29.467:60.883'] = "Zahedan";
$coordinates['Iran, Islamic Republic of']['29.533:52.583'] = "Shiraz";
$coordinates['Iran, Islamic Republic of']['30.250:56.967'] = "Kerman";
$coordinates['Iran, Islamic Republic of']['30.367:48.250'] = "Abadan";
$coordinates['Iran, Islamic Republic of']['30.433:50.767'] = "Gach Saran Du Gunbadan";
$coordinates['Iran, Islamic Republic of']['30.767:49.667'] = "Omidieh";
$coordinates['Iran, Islamic Republic of']['31.183:52.667'] = "Abadeh";
$coordinates['Iran, Islamic Republic of']['31.333:48.667'] = "Ahwaz";
$coordinates['Iran, Islamic Republic of']['31.333:61.483'] = "Zabol";
$coordinates['Iran, Islamic Republic of']['31.900:54.400'] = "Yazd";
$coordinates['Iran, Islamic Republic of']['31.983:49.267'] = "Masjed-Soleyman";
$coordinates['Iran, Islamic Republic of']['32.333:50.850'] = "Shahre-Kord";
$coordinates['Iran, Islamic Republic of']['32.467:51.717'] = "Esfahan";
$coordinates['Iran, Islamic Republic of']['32.867:59.200'] = "Birjand";
$coordinates['Iran, Islamic Republic of']['33.600:56.917'] = "Tabas";
$coordinates['Iran, Islamic Republic of']['33.983:51.450'] = "Kashan";
$coordinates['Iran, Islamic Republic of']['34.100:49.400'] = "Arak";
$coordinates['Iran, Islamic Republic of']['34.267:47.117'] = "Kermanshah";
$coordinates['Iran, Islamic Republic of']['34.517:45.583'] = "Ghasre-Shirin";
$coordinates['Iran, Islamic Republic of']['35.267:59.217'] = "Torbat-Heydarieh";
$coordinates['Iran, Islamic Republic of']['35.333:47.000'] = "Sanandaj";
$coordinates['Iran, Islamic Republic of']['35.550:53.383'] = "Semnan";
$coordinates['Iran, Islamic Republic of']['35.683:51.350'] = "Tehran-Mehrabad";
$coordinates['Iran, Islamic Republic of']['36.217:57.667'] = "Sabzevar";
$coordinates['Iran, Islamic Republic of']['36.250:46.267'] = "Saghez";
$coordinates['Iran, Islamic Republic of']['36.250:50.000'] = "Ghazvin";
$coordinates['Iran, Islamic Republic of']['36.267:59.633'] = "Mashhad";
$coordinates['Iran, Islamic Republic of']['36.683:48.483'] = "Zanjan";
$coordinates['Iran, Islamic Republic of']['36.817:54.467'] = "Gorgan";
$coordinates['Iran, Islamic Republic of']['36.900:50.667'] = "Ramsar";
$coordinates['Iran, Islamic Republic of']['37.200:49.633'] = "Rasht";
$coordinates['Iran, Islamic Republic of']['37.467:57.333'] = "Bojnourd";
$coordinates['Iran, Islamic Republic of']['37.533:45.083'] = "Orumieh";
$coordinates['Iran, Islamic Republic of']['38.083:46.283'] = "Tabriz";
$coordinates['Iran, Islamic Republic of']['38.550:44.967'] = "Khoy";
$coordinates['Iraq']['30.417:47.650'] = "Shaibah / Basrah";
$coordinates['Iraq']['33.233:44.233'] = "Baghdad";
$coordinates['Iraq']['36.317:43.150'] = "Mosul";
$coordinates['Ireland']['51.850:-8.483'] = "Cork Airport";
$coordinates['Ireland']['52.700:-8.917'] = "Shannon Airport";
$coordinates['Ireland']['53.300:-6.433'] = "Casement Aerodrome";
$coordinates['Ireland']['53.433:-6.250'] = "Dublin Airport";
$coordinates['Israel']['29.550:34.950'] = "Eilat";
$coordinates['Israel']['30.000:34.833'] = "Ovda";
$coordinates['Israel']['31.233:34.783'] = "Beer-Sheva";
$coordinates['Israel']['31.867:35.217'] = "Jerusalem Airport";
$coordinates['Israel']['32.000:34.900'] = "Ben-Gurion International Airport";
$coordinates['Israel']['32.800:35.033'] = "Sde-Haifa Haifa";
$coordinates['Italy']['35.500:12.600'] = "Lampedusa";
$coordinates['Italy']['36.683:15.133'] = "Cozzo Spadaro";
$coordinates['Italy']['36.817:11.967'] = "Pantelleria";
$coordinates['Italy']['37.083:14.217'] = "Gela";
$coordinates['Italy']['37.400:14.917'] = "Catania / Sigonella";
$coordinates['Italy']['37.467:15.050'] = "Catania / Fontanarossa";
$coordinates['Italy']['37.567:14.283'] = "Enna";
$coordinates['Italy']['37.917:12.500'] = "Trapani / Birgi";
$coordinates['Italy']['38.067:15.650'] = "Reggio Calabria";
$coordinates['Italy']['38.100:13.300'] = "Palermo Boccadifalco";
$coordinates['Italy']['38.183:13.100'] = "Palermo / Punta Raisi";
$coordinates['Italy']['38.200:15.550'] = "Messina";
$coordinates['Italy']['38.700:13.183'] = "Ustica";
$coordinates['Italy']['38.900:16.250'] = "Lamezia Terme";
$coordinates['Italy']['39.000:17.067'] = "Crotone";
$coordinates['Italy']['39.100:9.517'] = "Capo Carbonara";
$coordinates['Italy']['39.250:9.067'] = "Cagliari / Elmas";
$coordinates['Italy']['39.333:16.400'] = "Monte Scuro";
$coordinates['Italy']['39.350:8.967'] = "Decimomannu";
$coordinates['Italy']['39.500:9.633'] = "Capo S. Lorenzo";
$coordinates['Italy']['39.583:15.883'] = "Bonifati";
$coordinates['Italy']['39.667:9.433'] = "Perdasdefogu";
$coordinates['Italy']['39.750:8.467'] = "Capo Frasca";
$coordinates['Italy']['39.817:18.350'] = "S. Maria Di Leuca";
$coordinates['Italy']['39.933:9.717'] = "Capo Bellavista";
$coordinates['Italy']['40.017:15.283'] = "Capo Palinuro";
$coordinates['Italy']['40.083:16.017'] = "Latronico";
$coordinates['Italy']['40.117:9.250'] = "Fonni";
$coordinates['Italy']['40.233:18.150'] = "Lecce";
$coordinates['Italy']['40.433:16.883'] = "Marina Di Ginosa";
$coordinates['Italy']['40.517:17.400'] = "Grottaglie";
$coordinates['Italy']['40.550:14.200'] = "Capri";
$coordinates['Italy']['40.567:8.167'] = "Capo Caccia";
$coordinates['Italy']['40.633:15.800'] = "Potenza";
$coordinates['Italy']['40.633:8.283'] = "Alghero";
$coordinates['Italy']['40.650:17.950'] = "Brindisi";
$coordinates['Italy']['40.767:16.933'] = "Gioia Del Colle";
$coordinates['Italy']['40.850:14.300'] = "Napoli / Capodichino";
$coordinates['Italy']['40.900:9.517'] = "Olbia / Costa Smeralda";
$coordinates['Italy']['40.917:12.950'] = "Ponza";
$coordinates['Italy']['41.050:14.067'] = "Grazzanise";
$coordinates['Italy']['41.050:15.233'] = "Trevico";
$coordinates['Italy']['41.133:16.783'] = "Bari / Palese Macchie";
$coordinates['Italy']['41.217:9.400'] = "Guardiavecchia";
$coordinates['Italy']['41.533:15.717'] = "Amendola";
$coordinates['Italy']['41.550:12.900'] = "Latina";
$coordinates['Italy']['41.567:14.650'] = "Campobasso";
$coordinates['Italy']['41.633:13.300'] = "Frosinone";
$coordinates['Italy']['41.650:12.450'] = "Pratica Di Mare";
$coordinates['Italy']['41.700:15.950'] = "Monte S. Angelo";
$coordinates['Italy']['41.783:12.583'] = "Roma / Ciampino";
$coordinates['Italy']['41.800:12.233'] = "Roma Fiumicino";
$coordinates['Italy']['41.950:12.500'] = "Roma / Urbe";
$coordinates['Italy']['42.000:12.733'] = "Guidonia";
$coordinates['Italy']['42.000:15.000'] = "Termoli";
$coordinates['Italy']['42.033:11.833'] = "Civitavecchia";
$coordinates['Italy']['42.083:12.217'] = "Vigna Di Valle";
$coordinates['Italy']['42.383:11.167'] = "Monte Argentario";
$coordinates['Italy']['42.417:12.850'] = "Rieti";
$coordinates['Italy']['42.433:12.050'] = "Viterbo";
$coordinates['Italy']['42.433:14.200'] = "Pescara";
$coordinates['Italy']['42.467:12.983'] = "Monte Terminillo";
$coordinates['Italy']['42.733:10.400'] = "M. Calamita";
$coordinates['Italy']['42.750:11.067'] = "Grosseto";
$coordinates['Italy']['42.900:11.767'] = "Radicofani";
$coordinates['Italy']['43.083:12.500'] = "Perugia";
$coordinates['Italy']['43.400:10.867'] = "Volterra";
$coordinates['Italy']['43.467:11.850'] = "Arezzo";
$coordinates['Italy']['43.517:12.733'] = "Frontone";
$coordinates['Italy']['43.617:13.367'] = "Falconara";
$coordinates['Italy']['43.683:10.383'] = "Pisa / S. Giusto";
$coordinates['Italy']['43.800:11.200'] = "Firenze / Peretola";
$coordinates['Italy']['43.950:8.167'] = "Capo Mele";
$coordinates['Italy']['44.033:12.617'] = "Rimini";
$coordinates['Italy']['44.033:9.833'] = "Isola Di Palmaria";
$coordinates['Italy']['44.050:8.117'] = "Albenga";
$coordinates['Italy']['44.083:9.983'] = "Sarzana / Luni";
$coordinates['Italy']['44.200:10.700'] = "Monte Cimone";
$coordinates['Italy']['44.200:12.067'] = "Forli";
$coordinates['Italy']['44.217:12.300'] = "Cervia";
$coordinates['Italy']['44.250:7.800'] = "Monte Malanotte";
$coordinates['Italy']['44.417:8.850'] = "Genova / Sestri";
$coordinates['Italy']['44.433:9.933'] = "Passo Della Cisa";
$coordinates['Italy']['44.450:12.300'] = "Punta Marina";
$coordinates['Italy']['44.533:11.300'] = "Bologna / Borgo Panigale";
$coordinates['Italy']['44.633:8.933'] = "Passo Dei Giovi";
$coordinates['Italy']['44.833:11.617'] = "Ferrara";
$coordinates['Italy']['44.917:9.733'] = "Piacenza";
$coordinates['Italy']['45.033:7.733'] = "Torino / Bric Della Croce";
$coordinates['Italy']['45.217:7.650'] = "Torino / Caselle";
$coordinates['Italy']['45.383:10.867'] = "Verona / Villafranca";
$coordinates['Italy']['45.417:10.283'] = "Brescia / Ghedi";
$coordinates['Italy']['45.433:9.283'] = "Milano / Linate";
$coordinates['Italy']['45.500:12.333'] = "Venezia / Tessera";
$coordinates['Italy']['45.517:8.667'] = "Novara / Cameri";
$coordinates['Italy']['45.567:11.517'] = "Vicenza";
$coordinates['Italy']['45.617:8.733'] = "Milano / Malpensa";
$coordinates['Italy']['45.650:12.183'] = "Treviso / S. Angelo";
$coordinates['Italy']['45.650:13.750'] = "Trieste";
$coordinates['Italy']['45.667:9.700'] = "Bergamo / Orio Al Serio";
$coordinates['Italy']['45.683:12.100'] = "Treviso / Istrana";
$coordinates['Italy']['45.817:13.483'] = "Ronchi Dei Legionari";
$coordinates['Italy']['45.867:9.067'] = "Monte Bisbino";
$coordinates['Italy']['45.933:7.700'] = "Pian Rosa";
$coordinates['Italy']['45.983:13.033'] = "Udine / Rivolto";
$coordinates['Italy']['46.033:12.600'] = "Aviano";
$coordinates['Italy']['46.033:12.617'] = "Aviano Usaf";
$coordinates['Italy']['46.033:13.183'] = "Udine / Campoformido";
$coordinates['Italy']['46.150:11.033'] = "Paganella";
$coordinates['Italy']['46.300:11.783'] = "Passo Rolle";
$coordinates['Italy']['46.467:11.333'] = "Bolzano";
$coordinates['Italy']['46.500:13.583'] = "Tarvisio";
$coordinates['Italy']['46.733:12.217'] = "Dobbiaco";
$coordinates['Jamaica']['17.933:-76.783'] = "Kingston / Norman Manley";
$coordinates['Jamaica']['18.500:-77.917'] = "Montego Bay / Sangster";
$coordinates['Japan']['24.300:153.967'] = "Minamitorishima";
$coordinates['Japan']['24.333:124.167'] = "Ishigakijima";
$coordinates['Japan']['24.467:122.983'] = "Yonaguni Airport";
$coordinates['Japan']['24.783:125.283'] = "Miyakojima";
$coordinates['Japan']['24.783:141.317'] = "Iwojima";
$coordinates['Japan']['25.833:131.233'] = "Minamidaitojima";
$coordinates['Japan']['26.183:127.650'] = "Naha Airport";
$coordinates['Japan']['26.267:127.750'] = "Futenma Marine Corps Air Facility";
$coordinates['Japan']['26.300:127.767'] = "Hamby U. S. Army Airfield";
$coordinates['Japan']['26.333:126.800'] = "Kumejima";
$coordinates['Japan']['26.350:127.767'] = "Kadena Ab";
$coordinates['Japan']['26.717:127.783'] = "Iejima Auxiliary Ab";
$coordinates['Japan']['27.083:142.183'] = "Chichijima";
$coordinates['Japan']['27.433:128.700'] = "Okinoerabu";
$coordinates['Japan']['27.833:128.883'] = "Tokunoshima Island";
$coordinates['Japan']['28.433:129.717'] = "Amami Airport";
$coordinates['Japan']['30.383:130.667'] = "Yakushima";
$coordinates['Japan']['30.550:130.950'] = "Tanegashima Airport";
$coordinates['Japan']['31.367:130.833'] = "Kanoya Ab";
$coordinates['Japan']['31.800:130.717'] = "Kagoshima Airport";
$coordinates['Japan']['31.867:131.450'] = "Miyazaki Airport";
$coordinates['Japan']['32.083:131.450'] = "Nyutabaru Ab";
$coordinates['Japan']['32.667:128.833'] = "Fukue Airport";
$coordinates['Japan']['32.833:130.850'] = "Kumamoto Airport";
$coordinates['Japan']['32.917:129.917'] = "Nagasaki Airport";
$coordinates['Japan']['33.117:139.783'] = "Hachijojima Airport";
$coordinates['Japan']['33.150:129.717'] = "Sasebo Usn";
$coordinates['Japan']['33.317:130.417'] = "Metabaru Ab";
$coordinates['Japan']['33.483:131.733'] = "Oita Airport";
$coordinates['Japan']['33.533:133.667'] = "Kochi Airport";
$coordinates['Japan']['33.583:130.450'] = "Fukuoka Airport";
$coordinates['Japan']['33.667:135.350'] = "Nankishirahama Airport";
$coordinates['Japan']['33.683:131.050'] = "Tsuiki Ab";
$coordinates['Japan']['33.750:129.783'] = "Iki Airport";
$coordinates['Japan']['33.817:132.700'] = "Matsuyama Airport";
$coordinates['Japan']['33.833:130.950'] = "Kitakyushu Airport";
$coordinates['Japan']['33.883:130.650'] = "Ashiya Ab";
$coordinates['Japan']['33.933:131.283'] = "Yamaguchi Ube Airport";
$coordinates['Japan']['34.000:134.633'] = "Komatsujima Ab";
$coordinates['Japan']['34.033:131.550'] = "Hofu Ab";
$coordinates['Japan']['34.050:131.050'] = "Ozuki Ab";
$coordinates['Japan']['34.067:139.567'] = "Miyakejima Airport";
$coordinates['Japan']['34.133:132.233'] = "Iwakuni Marine Corps Air Station";
$coordinates['Japan']['34.133:134.617'] = "Tokushima Ab";
$coordinates['Japan']['34.217:134.017'] = "Takamatsu Airport";
$coordinates['Japan']['34.283:129.333'] = "Tsushima Airport";
$coordinates['Japan']['34.417:135.250'] = "Kansai International Airport";
$coordinates['Japan']['34.433:132.917'] = "Hiroshima Airport";
$coordinates['Japan']['34.533:136.683'] = "Akeno Ab";
$coordinates['Japan']['34.600:135.600'] = "Yao Airport";
$coordinates['Japan']['34.667:131.800'] = "Iwami Airport";
$coordinates['Japan']['34.750:133.850'] = "Okayama Airport";
$coordinates['Japan']['34.750:137.700'] = "Hamamatsu Ab";
$coordinates['Japan']['34.783:135.450'] = "Osaka International Airport";
$coordinates['Japan']['34.783:139.367'] = "Oshima Airport";
$coordinates['Japan']['34.817:138.300'] = "Shizuhama Ab";
$coordinates['Japan']['34.983:139.833'] = "Tateyama Ab";
$coordinates['Japan']['35.250:136.933'] = "Nagoya Airport";
$coordinates['Japan']['35.283:139.667'] = "Yokosuka Fwf";
$coordinates['Japan']['35.317:138.867'] = "Fuji Ab";
$coordinates['Japan']['35.383:136.867'] = "Gifu Ab";
$coordinates['Japan']['35.400:139.917'] = "Kisarazu Ab";
$coordinates['Japan']['35.417:132.900'] = "Izumo Airport";
$coordinates['Japan']['35.450:139.450'] = "Atsugi United States Naval Air Station";
$coordinates['Japan']['35.483:133.250'] = "Miho Ab";
$coordinates['Japan']['35.517:139.400'] = "Zama Airfield";
$coordinates['Japan']['35.533:134.167'] = "Tottori Airport";
$coordinates['Japan']['35.550:139.783'] = "Tokyo International Airport";
$coordinates['Japan']['35.633:139.850'] = "Tokyo Heliport";
$coordinates['Japan']['35.667:139.533'] = "Chofu Airport";
$coordinates['Japan']['35.683:139.767'] = "Tokyo";
$coordinates['Japan']['35.700:139.400'] = "Tachikawa Ab";
$coordinates['Japan']['35.750:139.350'] = "Yokota Ab";
$coordinates['Japan']['35.767:140.383'] = "New Tokyo Inter-National Airport";
$coordinates['Japan']['35.800:140.017'] = "Shimofusa Ab";
$coordinates['Japan']['35.833:139.417'] = "Iruma Ab";
$coordinates['Japan']['36.033:140.200'] = "Kasumigaura Ab";
$coordinates['Japan']['36.133:136.233'] = "Fukui Airport";
$coordinates['Japan']['36.167:137.933'] = "Matsumoto Airport";
$coordinates['Japan']['36.183:133.333'] = "Oki Airport";
$coordinates['Japan']['36.183:140.417'] = "Hyakuri Ab";
$coordinates['Japan']['36.383:136.417'] = "Komatsu Ab";
$coordinates['Japan']['36.517:139.867'] = "Utsunomiya Ab";
$coordinates['Japan']['36.650:137.183'] = "Toyama Airport";
$coordinates['Japan']['37.233:140.433'] = "Fukushima Airport";
$coordinates['Japan']['37.950:139.117'] = "Niigata Airport";
$coordinates['Japan']['38.050:138.417'] = "Sado Airport";
$coordinates['Japan']['38.133:140.917'] = "Sendai Airport";
$coordinates['Japan']['38.233:140.917'] = "Kasuminome Ab";
$coordinates['Japan']['38.400:141.217'] = "Matsushima Ab";
$coordinates['Japan']['38.417:140.367'] = "Yamagata Airport";
$coordinates['Japan']['39.433:141.133'] = "Hanamaki Airport";
$coordinates['Japan']['39.617:140.217'] = "Akita Airport";
$coordinates['Japan']['40.550:141.467'] = "Hachinohe Ab";
$coordinates['Japan']['40.700:141.383'] = "Misawa Ab";
$coordinates['Japan']['40.733:140.700'] = "Aomori Airport";
$coordinates['Japan']['41.233:141.133'] = "Ominato Ab";
$coordinates['Japan']['41.767:140.817'] = "Hakodate Airport";
$coordinates['Japan']['42.317:140.983'] = "Muroran";
$coordinates['Japan']['42.733:143.217'] = "Obihiro Airport";
$coordinates['Japan']['42.800:141.667'] = "Chitose Ab";
$coordinates['Japan']['42.817:141.683'] = "Chitose Japanese Air Self Defense Force";
$coordinates['Japan']['42.983:144.400'] = "Kushiro";
$coordinates['Japan']['43.033:144.200'] = "Kushiro Airport";
$coordinates['Japan']['43.117:141.383'] = "Sapporo Ab";
$coordinates['Japan']['43.567:144.967'] = "Nakashibetsu Airport";
$coordinates['Japan']['43.667:142.450'] = "Asahikawa Airport";
$coordinates['Japan']['43.800:142.367'] = "Asahikawa Ab";
$coordinates['Japan']['43.883:144.167'] = "Memambetsu Airport";
$coordinates['Japan']['44.250:143.533'] = "Mombetsu Airport";
$coordinates['Japan']['45.400:141.800'] = "Wakkanai Airport";
$coordinates['Jordan']['29.633:35.017'] = "Aqaba Airport";
$coordinates['Jordan']['30.167:35.783'] = "Ma'An";
$coordinates['Jordan']['31.667:35.967'] = "Queen Alia Airport";
$coordinates['Jordan']['31.983:35.983'] = "Amman Airport";
$coordinates['Jordan']['32.200:37.133'] = "H-5'Safawi";
$coordinates['Jordan']['32.367:36.250'] = "Mafraq";
$coordinates['Jordan']['32.500:38.200'] = "H-4'Irwaished";
$coordinates['Jordan']['32.550:35.850'] = "Irbid";
$coordinates['Kazakhstan']['42.317:69.700'] = "Shymkent";
$coordinates['Kazakhstan']['43.233:76.933'] = "Almaty";
$coordinates['Kazakhstan']['44.850:65.500'] = "Kzyl-Orda";
$coordinates['Kazakhstan']['46.783:61.650'] = "Aralskoe More";
$coordinates['Kazakhstan']['50.283:57.150'] = "Aktjubinsk";
$coordinates['Kazakhstan']['51.250:51.283'] = "Uralsk";
$coordinates['Kazakstan']['49.800:73.150'] = "Karaganda";
$coordinates['Kenya']['0.083:37.650'] = "Meru";
$coordinates['Kenya']['-0.100:34.750'] = "Kisumu";
$coordinates['Kenya']['-0.267:36.100'] = "Nakuru";
$coordinates['Kenya']['0.283:34.783'] = "Kakamega";
$coordinates['Kenya']['-0.367:35.350'] = "Kericho";
$coordinates['Kenya']['-0.467:39.633'] = "Garissa";
$coordinates['Kenya']['-0.500:36.967'] = "Nyeri";
$coordinates['Kenya']['-0.500:37.450'] = "Embu";
$coordinates['Kenya']['0.533:35.283'] = "Eldoret";
$coordinates['Kenya']['-0.667:34.783'] = "Kisii";
$coordinates['Kenya']['1.017:35.000'] = "Kitale";
$coordinates['Kenya']['-1.133:35.833'] = "Narok";
$coordinates['Kenya']['-1.300:36.750'] = "Nairobi / Dagoretti";
$coordinates['Kenya']['-1.317:36.817'] = "Nairobi / Wilson";
$coordinates['Kenya']['-1.317:36.933'] = "Nairobi ACC/FIC/RCC/MET/COM/";
$coordinates['Kenya']['1.750:40.067'] = "Wajir";
$coordinates['Kenya']['-2.267:40.833'] = "Lamu";
$coordinates['Kenya']['-2.283:37.833'] = "Makindu";
$coordinates['Kenya']['2.300:37.900'] = "Marsabit";
$coordinates['Kenya']['3.117:35.617'] = "Lodwar";
$coordinates['Kenya']['-3.233:40.100'] = "Malindi";
$coordinates['Kenya']['-3.400:38.567'] = "Voi";
$coordinates['Kenya']['3.533:39.050'] = "Moyale";
$coordinates['Kenya']['3.933:41.867'] = "Mandera";
$coordinates['Kenya']['-4.033:39.617'] = "Mombasa";
$coordinates['Kiribati']['1.350:172.917'] = "Tarawa";
$coordinates['Kiribati']['-1.350:176.000'] = "Beru";
$coordinates['Kiribati']['-2.667:176.833'] = "Arorae";
$coordinates['Kiribati']['3.033:172.783'] = "Butaritari";
$coordinates['Korea, Democratic People\'s Republic of']['39.033:125.783'] = "Pyongyang";
$coordinates['Korea, Democratic People\'s Republic of']['40.667:129.200'] = "Kimchaek";
$coordinates['Korea, Republic of']['33.200:126.267'] = "Mosulpo Ab";
$coordinates['Korea, Republic of']['33.500:126.500'] = "Cheju International Airport";
$coordinates['Korea, Republic of']['34.833:127.617'] = "Yosu Airport";
$coordinates['Korea, Republic of']['35.083:128.083'] = "Sach'On Ab";
$coordinates['Korea, Republic of']['35.117:126.817'] = "Kwangju Ab";
$coordinates['Korea, Republic of']['35.183:128.933'] = "Pusan / Kimhae International Airport";
$coordinates['Korea, Republic of']['35.550:129.317'] = "Ulsan";
$coordinates['Korea, Republic of']['35.883:128.617'] = "Taegu";
$coordinates['Korea, Republic of']['35.900:128.650'] = "Taegu Ab";
$coordinates['Korea, Republic of']['35.917:126.617'] = "Kunsan Ab";
$coordinates['Korea, Republic of']['35.983:129.417'] = "Pohang Ab";
$coordinates['Korea, Republic of']['36.300:127.400'] = "Taejon";
$coordinates['Korea, Republic of']['36.333:127.383'] = "Taejon Kor-Afb";
$coordinates['Korea, Republic of']['36.400:127.500'] = "Songmu Ab";
$coordinates['Korea, Republic of']['36.550:128.717'] = "Andong";
$coordinates['Korea, Republic of']['36.633:128.350'] = "Yechon Ab";
$coordinates['Korea, Republic of']['36.700:127.500'] = "Chongju Ab";
$coordinates['Korea, Republic of']['36.933:126.450'] = "Mangilsan Ab";
$coordinates['Korea, Republic of']['36.933:127.000'] = "Pyongtaek Ab";
$coordinates['Korea, Republic of']['37.033:126.750'] = "Koon-Ni Range";
$coordinates['Korea, Republic of']['37.033:127.883'] = "Jung Won Rok-Ab";
$coordinates['Korea, Republic of']['37.100:127.033'] = "Osan Ab";
$coordinates['Korea, Republic of']['37.250:127.000'] = "Suwon Ab";
$coordinates['Korea, Republic of']['37.333:127.950'] = "Wonju";
$coordinates['Korea, Republic of']['37.433:127.117'] = "Seoul E Ab";
$coordinates['Korea, Republic of']['37.433:127.950'] = "Hoengsong Ab";
$coordinates['Korea, Republic of']['37.467:126.450'] = "Incheon International Airport";
$coordinates['Korea, Republic of']['37.500:126.933'] = "Seoul / Yongdungp'O Rokaf Wc";
$coordinates['Korea, Republic of']['37.500:129.133'] = "Tonghae Radar Site";
$coordinates['Korea, Republic of']['37.550:126.800'] = "Seoul / Kimp'O International Airport";
$coordinates['Korea, Republic of']['37.567:126.967'] = "Seoul";
$coordinates['Korea, Republic of']['37.750:128.950'] = "Kangnung Ab";
$coordinates['Korea, Republic of']['37.867:127.717'] = "Chunchon Ab";
$coordinates['Korea, Republic of']['37.967:124.667'] = "Paengnyongdo Ab";
$coordinates['Kuwait']['29.217:47.983'] = "Kuwait Internationalairport";
$coordinates['Lao People\'s Democratic Republic']['14.800:106.833'] = "Attopeu";
$coordinates['Lao People\'s Democratic Republic']['15.117:105.167'] = "Pakse";
$coordinates['Lao People\'s Democratic Republic']['15.683:106.433'] = "Saravane";
$coordinates['Lao People\'s Democratic Republic']['16.550:104.650'] = "Savannakhet";
$coordinates['Lao People\'s Democratic Republic']['17.383:104.650'] = "Thakhek";
$coordinates['Lao People\'s Democratic Republic']['17.950:102.567'] = "Vientiane";
$coordinates['Lao People\'s Democratic Republic']['19.233:101.733'] = "Sayaboury";
$coordinates['Lao People\'s Democratic Republic']['19.883:102.133'] = "Luang-Prabang";
$coordinates['Latvia']['56.967:24.050'] = "Riga";
$coordinates['Latvia']['57.400:21.533'] = "Ventspils";
$coordinates['Lebanon']['33.817:35.483'] = "Beyrouth Aeroport";
$coordinates['Lesotho']['-29.450:27.550'] = "Maseru-Mia";
$coordinates['Liberia']['6.250:-10.350'] = "Grand Bassa, Roberts Field";
$coordinates['Libyan Arab Jamahiriya']['24.217:23.300'] = "Kufra";
$coordinates['Libyan Arab Jamahiriya']['25.133:10.150'] = "Ghat";
$coordinates['Libyan Arab Jamahiriya']['27.017:14.450'] = "Sebha";
$coordinates['Libyan Arab Jamahiriya']['30.133:9.500'] = "Ghadames";
$coordinates['Libyan Arab Jamahiriya']['32.100:20.267'] = "Benina";
$coordinates['Libyan Arab Jamahiriya']['32.667:13.150'] = "Tripoli Inter-National Airport";
$coordinates['Lithuania']['54.633:25.100'] = "Vilnius";
$coordinates['Luxembourg']['49.617:6.217'] = "Luxembourg / Luxembourg";
$coordinates['Macau']['22.167:113.567'] = "Taipa";
$coordinates['Macedonia, the Former Yugoslav Republic of']['41.117:20.800'] = "Ohrid";
$coordinates['Macedonia, the Former Yugoslav Republic of']['41.967:21.650'] = "Skopje-Petrovec";
$coordinates['Madagascar']['-12.350:49.300'] = "Diego-Suarez";
$coordinates['Madagascar']['-13.317:48.317'] = "Fascene Nossi-Be";
$coordinates['Madagascar']['-13.367:50.000'] = "Vohemar";
$coordinates['Madagascar']['-14.283:50.167'] = "Sambava";
$coordinates['Madagascar']['-14.633:47.767'] = "Analalava";
$coordinates['Madagascar']['-14.650:49.617'] = "Andapa";
$coordinates['Madagascar']['-14.883:50.250'] = "Antalaha";
$coordinates['Madagascar']['-15.667:46.350'] = "Majunga";
$coordinates['Madagascar']['-16.750:44.483'] = "Besalampy";
$coordinates['Madagascar']['-17.083:49.817'] = "Sainte-Marie Aerodrome";
$coordinates['Madagascar']['-18.050:44.033'] = "Maintirano";
$coordinates['Madagascar']['-18.117:49.400'] = "Tamatave";
$coordinates['Madagascar']['-18.800:47.483'] = "Antananarivo / Ivato";
$coordinates['Madagascar']['-19.817:47.067'] = "Antsirabe";
$coordinates['Madagascar']['-19.833:48.800'] = "Mahanoro";
$coordinates['Madagascar']['-20.283:44.317'] = "Morondava";
$coordinates['Madagascar']['-21.200:48.367'] = "Mananjary";
$coordinates['Madagascar']['-21.450:47.100'] = "Fianarantsoa";
$coordinates['Madagascar']['-21.750:43.367'] = "Morombe";
$coordinates['Madagascar']['-22.550:45.400'] = "Ranohira";
$coordinates['Madagascar']['-22.800:47.833'] = "Farafangana";
$coordinates['Madagascar']['-23.383:43.733'] = "Tulear";
$coordinates['Madagascar']['-25.033:46.950'] = "Fort-Dauphin";
$coordinates['Malawi']['-11.450:34.017'] = "Mzuzu";
$coordinates['Malawi']['-11.883:33.617'] = "Mzimba";
$coordinates['Malawi']['-12.917:34.267'] = "Nkhota Kota";
$coordinates['Malawi']['-13.750:34.583'] = "Salima";
$coordinates['Malawi']['-13.783:33.767'] = "Lilongwe International Airport";
$coordinates['Malawi']['-14.083:34.917'] = "Monkey Bay";
$coordinates['Malawi']['-14.317:34.267'] = "Dedza";
$coordinates['Malawi']['-14.433:35.250'] = "Mangochi";
$coordinates['Malawi']['-15.683:34.967'] = "Chileka";
$coordinates['Malawi']['-9.700:33.267'] = "Chitipa";
$coordinates['Malawi']['-9.950:33.883'] = "Karonga";
$coordinates['Malaysia']['1.483:110.333'] = "Kuching";
$coordinates['Malaysia']['1.633:103.667'] = "Johore Bharu / Senai";
$coordinates['Malaysia']['2.267:102.250'] = "Malacca";
$coordinates['Malaysia']['2.333:111.833'] = "Sibu";
$coordinates['Malaysia']['3.117:101.550'] = "Kuala Lumpur / Subang";
$coordinates['Malaysia']['3.200:113.033'] = "Bintulu";
$coordinates['Malaysia']['3.617:103.217'] = "Kuantan";
$coordinates['Malaysia']['4.217:100.700'] = "Sitiawan";
$coordinates['Malaysia']['4.267:117.883'] = "Tawau";
$coordinates['Malaysia']['4.333:113.983'] = "Miri";
$coordinates['Malaysia']['5.300:100.267'] = "Penang / Bayan Lepas";
$coordinates['Malaysia']['5.300:115.250'] = "Labuan";
$coordinates['Malaysia']['5.900:118.067'] = "Sandakan";
$coordinates['Malaysia']['5.933:116.050'] = "Kota Kinabalu";
$coordinates['Malaysia']['6.167:102.283'] = "Kota Bharu";
$coordinates['Malaysia']['6.333:99.733'] = "Langkawi";
$coordinates['Malaysia']['6.917:116.833'] = "Kudat";
$coordinates['Maldives']['-0.683:73.150'] = "Gan";
$coordinates['Maldives']['4.200:73.533'] = "Male";
$coordinates['Mali']['11.350:-5.683'] = "Sikasso";
$coordinates['Mali']['11.417:-7.500'] = "Bougouni";
$coordinates['Mali']['12.383:-5.467'] = "Koutiala";
$coordinates['Mali']['12.533:-7.950'] = "Bamako / Senou";
$coordinates['Mali']['12.850:-11.233'] = "Kenieba";
$coordinates['Mali']['13.067:-9.467'] = "Kita";
$coordinates['Mali']['13.333:-4.833'] = "San";
$coordinates['Mali']['13.400:-6.150'] = "Segou";
$coordinates['Mali']['14.433:-11.433'] = "Kayes";
$coordinates['Mali']['14.517:-4.100'] = "Mopti";
$coordinates['Mali']['15.167:-7.283'] = "Nara";
$coordinates['Mali']['15.233:-9.350'] = "Nioro Du Sahel";
$coordinates['Mali']['15.333:-1.683'] = "Hombori";
$coordinates['Mali']['15.867:2.217'] = "Menaka";
$coordinates['Mali']['16.267:-0.050'] = "Gao";
$coordinates['Mali']['16.717:-3.000'] = "Tombouctou";
$coordinates['Mali']['18.433:1.350'] = "Kidal";
$coordinates['Mali']['20.200:0.983'] = "Tessalit";
$coordinates['Malta']['35.850:14.483'] = "Luqa";
$coordinates['Marshall Islands']['7.067:171.283'] = "Majuro Atoll, Marshall Islands Int. Airp.";
$coordinates['Marshall Islands']['8.717:167.733'] = "Kwajalein, Bucholz AAF(Kwajalein KMR)(ATOL) Airp.";
$coordinates['Martinique']['14.600:-61.000'] = "Le Lamentin";
$coordinates['Mauritania']['16.150:-13.517'] = "Kaedi";
$coordinates['Mauritania']['16.500:-15.817'] = "Rosso";
$coordinates['Mauritania']['16.600:-7.267'] = "Nema";
$coordinates['Mauritania']['16.633:-11.400'] = "Kiffa";
$coordinates['Mauritania']['16.700:-9.600'] = "Aioun El Atrouss";
$coordinates['Mauritania']['17.533:-14.683'] = "Boutilimit";
$coordinates['Mauritania']['18.100:-15.950'] = "Nouakchott";
$coordinates['Mauritania']['18.567:-11.433'] = "Tidjikja";
$coordinates['Mauritania']['19.750:-14.367'] = "Akjoujt";
$coordinates['Mauritania']['20.517:-13.067'] = "Atar";
$coordinates['Mauritania']['20.933:-17.033'] = "Nouadhibou";
$coordinates['Mauritania']['25.233:-11.617'] = "Bir Moghrein";
$coordinates['Mauritius']['-19.683:63.417'] = "Rodrigues";
$coordinates['Mauritius']['-20.433:57.667'] = "Plaisance Mauritius";
$coordinates['Mexico']['16.750:-93.117'] = "Tuxtla Gutierrez, Chis.";
$coordinates['Mexico']['18.483:-88.300'] = "Chetumal, Q. Roo";
$coordinates['Mexico']['18.883:-99.233'] = "Cuernavaca, Mor.";
$coordinates['Mexico']['19.050:-98.167'] = "Puebla, Pue.";
$coordinates['Mexico']['19.267:-103.583'] = "Colima";
$coordinates['Mexico']['19.850:-90.550'] = "Campeche, Camp.";
$coordinates['Mexico']['20.083:-98.367'] = "Tulancingo";
$coordinates['Mexico']['20.600:-100.383'] = "Queretaro, Qro.";
$coordinates['Mexico']['20.933:-89.650'] = "Merida / lic Manuel Crecencio";
$coordinates['Mexico']['21.517:-104.900'] = "Tepic, Nay.";
$coordinates['Mexico']['21.883:-102.300'] = "Aguascalientes, Ags.";
$coordinates['Mexico']['22.150:-100.983'] = "San Luis Potosi, S. L. P.";
$coordinates['Mexico']['24.817:-107.400'] = "Culiacan, Sin.";
$coordinates['Mexico']['25.450:-100.983'] = "Saltillo, Coah.";
$coordinates['Mexico']['25.533:-103.450'] = "Torreon, Coah.";
$coordinates['Mexico']['25.867:-100.233'] = "Aerop. Internacional Monterrey, N. L.";
$coordinates['Mexico']['26.017:-111.350'] = "Loreto, B. C. S.";
$coordinates['Mexico']['26.883:-101.417'] = "Monclova, Coah.";
$coordinates['Mexico']['27.317:-112.300'] = "Santa Rosalia, B. C. S.";
$coordinates['Mexico']['28.700:-100.517'] = "Piedras Negras, Coah.";
$coordinates['Mexico']['29.067:-110.950'] = "Hermosillo, Son.";
$coordinates['Micronesia, Federated States of']['5.350:162.950'] = "Kosrae Carolines / V";
$coordinates['Micronesia, Federated States of']['5.350:162.950'] = "Kosrae Island, Kosrae Airport";
$coordinates['Micronesia, Federated States of']['6.983:158.200'] = "Pohnpei Island, Pohnpei Int. Airp.";
$coordinates['Micronesia, Federated States of']['7.467:151.850'] = "Weno Island, Chuuk Int. Airp.";
$coordinates['Micronesia, Federated States of']['9.483:138.083'] = "Yap Island, Yap Int. Airp.";
$coordinates['Moldova, Republic of']['47.017:28.983'] = "Kisinev";
$coordinates['Morocco']['28.450:-11.150'] = "Tan-Tan";
$coordinates['Morocco']['29.367:-10.183'] = "Sidi Ifni";
$coordinates['Morocco']['30.333:-9.400'] = "Agadir Al Massira";
$coordinates['Morocco']['30.383:-9.567'] = "Agadir";
$coordinates['Morocco']['30.933:-6.900'] = "Ouarzazate";
$coordinates['Morocco']['31.517:-9.783'] = "Essaouira";
$coordinates['Morocco']['31.617:-8.033'] = "Marrakech";
$coordinates['Morocco']['31.933:-4.400'] = "Errachidia";
$coordinates['Morocco']['32.283:-9.233'] = "Safi";
$coordinates['Morocco']['33.367:-7.583'] = "Nouasseur";
$coordinates['Morocco']['33.500:-5.167'] = "Ifrane";
$coordinates['Morocco']['33.567:-7.667'] = "Casablanca";
$coordinates['Morocco']['33.883:-5.533'] = "Meknes";
$coordinates['Morocco']['33.933:-4.983'] = "Fes-Sais";
$coordinates['Morocco']['34.050:-6.767'] = "Rabat-Sale";
$coordinates['Morocco']['34.217:-4.000'] = "Taza";
$coordinates['Morocco']['34.300:-6.600'] = "Kenitra";
$coordinates['Morocco']['34.783:-1.933'] = "Oujda";
$coordinates['Morocco']['35.150:-2.917'] = "Nador";
$coordinates['Morocco']['35.183:-3.850'] = "Al Hoceima";
$coordinates['Morocco']['35.583:-5.333'] = "Tetuan / Sania Ramel";
$coordinates['Morocco']['35.733:-5.900'] = "Tanger Aerodrome";
$coordinates['Mozambique']['-11.350:40.367'] = "Mocimboa Da Praia";
$coordinates['Mozambique']['-12.983:40.533'] = "Pemba";
$coordinates['Mozambique']['-13.300:35.233'] = "Lichinga";
$coordinates['Mozambique']['-14.817:36.533'] = "Cuamba";
$coordinates['Mozambique']['-15.033:40.667'] = "Lumbo";
$coordinates['Mozambique']['-15.100:39.283'] = "Nampula";
$coordinates['Mozambique']['-16.183:33.583'] = "Tete";
$coordinates['Mozambique']['-17.883:36.883'] = "Quelimane";
$coordinates['Mozambique']['-19.117:33.467'] = "Chimoio";
$coordinates['Mozambique']['-19.800:34.900'] = "Beira";
$coordinates['Mozambique']['-22.000:35.317'] = "Vilanculos";
$coordinates['Mozambique']['-23.867:35.383'] = "Inhambane";
$coordinates['Mozambique']['-25.050:33.633'] = "Xai Xai";
$coordinates['Mozambique']['-25.917:32.567'] = "Maputo / Mavalane";
$coordinates['Myanmar']['12.433:98.600'] = "Mergui";
$coordinates['Myanmar']['14.100:98.217'] = "Dawei";
$coordinates['Myanmar']['14.117:93.367'] = "Coco Island";
$coordinates['Myanmar']['16.500:97.617'] = "Moulmein";
$coordinates['Myanmar']['16.750:97.667'] = "Hpa-An";
$coordinates['Myanmar']['16.767:94.767'] = "Pathein";
$coordinates['Myanmar']['16.767:96.167'] = "Yangon";
$coordinates['Myanmar']['16.900:96.183'] = "Mingaladon";
$coordinates['Myanmar']['18.467:94.350'] = "Sandoway";
$coordinates['Myanmar']['18.800:95.217'] = "Prome";
$coordinates['Myanmar']['19.417:93.550'] = "Kyaukpyu";
$coordinates['Myanmar']['20.133:92.883'] = "Sittwe";
$coordinates['Myanmar']['20.833:95.833'] = "Meiktila";
$coordinates['Myanmar']['21.300:99.617'] = "Kengtung";
$coordinates['Myanmar']['21.983:96.100'] = "Mandalay";
$coordinates['Myanmar']['22.933:97.750'] = "Lashio";
$coordinates['Myanmar']['24.267:97.200'] = "Bhamo";
$coordinates['Myanmar']['24.867:94.917'] = "Homalin";
$coordinates['Myanmar']['25.367:97.400'] = "Myitkyina";
$coordinates['Myanmar']['27.333:97.417'] = "Putao";
$coordinates['Namibia']['-17.917:19.767'] = "Rundu";
$coordinates['Namibia']['-19.600:18.117'] = "Grootfontein";
$coordinates['Namibia']['-22.467:18.967'] = "Gobabis";
$coordinates['Namibia']['-22.483:17.467'] = "J. G. Strijdom";
$coordinates['Namibia']['-26.533:18.117'] = "Keetmanshoop";
$coordinates['Nauru']['-0.533:166.917'] = "Nauru Airport";
$coordinates['Nepal']['26.483:87.267'] = "Biratnagar Airport";
$coordinates['Nepal']['27.167:84.983'] = "Simra Airport";
$coordinates['Nepal']['27.350:87.667'] = "Taplejung";
$coordinates['Nepal']['27.517:83.450'] = "Bhairawa Airport";
$coordinates['Nepal']['27.700:85.367'] = "Kathmandu Airport";
$coordinates['Nepal']['28.217:84.000'] = "Pokhara Airport";
$coordinates['Nepal']['28.600:81.617'] = "Surkhet";
$coordinates['Nepal']['29.283:82.167'] = "Jumla";
$coordinates['Netherlands Antilles']['12.150:-68.283'] = "Flamingo Airport, Bonaire";
$coordinates['Netherlands Antilles']['12.200:-68.967'] = "Hato Airport, Curacao";
$coordinates['Netherlands Antilles']['17.483:-62.983'] = "Roosevelt Airport Saint Eustatius";
$coordinates['Netherlands Antilles']['18.050:-63.117'] = "Juliana Airport, Saint Maarten";
$coordinates['Netherlands']['50.917:5.783'] = "Maastricht Airport Zuid Limburg";
$coordinates['Netherlands']['51.450:4.333'] = "Woensdrecht";
$coordinates['Netherlands']['51.450:5.417'] = "Eindhoven";
$coordinates['Netherlands']['51.567:4.933'] = "Gilze-Rijen";
$coordinates['Netherlands']['51.650:5.700'] = "Volkel";
$coordinates['Netherlands']['51.950:4.450'] = "Rotterdam Airport Zestienhoven";
$coordinates['Netherlands']['52.067:5.883'] = "Deelen";
$coordinates['Netherlands']['52.100:5.183'] = "De Bilt";
$coordinates['Netherlands']['52.133:5.283'] = "Soesterberg";
$coordinates['Netherlands']['52.183:4.417'] = "Valkenburg";
$coordinates['Netherlands']['52.267:6.900'] = "Twenthe";
$coordinates['Netherlands']['52.300:4.767'] = "Amsterdam Airport Schiphol";
$coordinates['Netherlands']['52.450:5.517'] = "Lelystad";
$coordinates['Netherlands']['52.917:4.783'] = "De Kooy";
$coordinates['Netherlands']['53.133:6.583'] = "Groningen Airport Eelde";
$coordinates['Netherlands']['53.217:5.767'] = "Leeuwarden";
$coordinates['Netherlands']['53.250:4.917'] = "Vlieland";
$coordinates['New Caledonia']['-20.567:164.283'] = "Koumac Nlle-Caledonie";
$coordinates['New Caledonia']['-20.650:166.583'] = "Ouloup Ile Ouvea";
$coordinates['New Caledonia']['-20.767:167.233'] = "Ouanaham Ile Lifou";
$coordinates['New Caledonia']['-21.483:168.033'] = "La Roche Ile Mare";
$coordinates['New Caledonia']['-22.017:166.217'] = "La Tontouta Nlle-Caledonie";
$coordinates['New Caledonia']['-22.267:166.450'] = "Noumea Nlle-Caledonie";
$coordinates['New Caledonia']['-22.600:167.450'] = "Moue Ile Des Pins";
$coordinates['New Zealand']['1.983:-157.483'] = "Christmas / Cassidy";
$coordinates['New Zealand']['-29.250:-177.917'] = "Raoul Island, Kermadec Island";
$coordinates['New Zealand']['3.850:-159.367'] = "Fanning Island";
$coordinates['New Zealand']['-36.783:174.633'] = "Whenuapai";
$coordinates['New Zealand']['-37.017:174.800'] = "Auckland Airport";
$coordinates['New Zealand']['-37.667:176.200'] = "Tauranga Aerodrome Aws";
$coordinates['New Zealand']['-38.117:176.317'] = "Rotorua Aerodrome";
$coordinates['New Zealand']['-38.667:177.983'] = "Gisborne Aerodrome";
$coordinates['New Zealand']['-39.017:174.183'] = "New Plymouth Aerodrome";
$coordinates['New Zealand']['-40.200:175.367'] = "Ohakea";
$coordinates['New Zealand']['-40.900:174.983'] = "Paraparaumu Aerodrome";
$coordinates['New Zealand']['-41.333:174.800'] = "Wellington Airport";
$coordinates['New Zealand']['-42.417:173.700'] = "Kaikoura";
$coordinates['New Zealand']['-42.717:170.983'] = "Hokitika Aerodrome";
$coordinates['New Zealand']['-43.483:172.550'] = "Christchurch";
$coordinates['New Zealand']['-43.950:-176.567'] = "Chatham Island";
$coordinates['New Zealand']['-45.933:170.200'] = "Dunedin Aerodrome";
$coordinates['New Zealand']['-46.700:168.550'] = "Invercargill Aerodrome";
$coordinates['Nicaragua']['11.417:-85.833'] = "Rivas";
$coordinates['Nicaragua']['12.000:-86.767'] = "Bluefields";
$coordinates['Nicaragua']['12.100:-85.367'] = "Juigalpa";
$coordinates['Nicaragua']['12.150:-86.167'] = "Managua A. C. Sandino";
$coordinates['Nicaragua']['12.633:-87.133'] = "Chinandega";
$coordinates['Nicaragua']['13.083:-85.983'] = "Jinotega";
$coordinates['Nicaragua']['14.050:-83.367'] = "Puerto Cabezas";
$coordinates['Niger']['11.883:3.450'] = "Gaya";
$coordinates['Niger']['13.233:11.983'] = "Maine-Soroa";
$coordinates['Niger']['13.417:12.783'] = "Diffa";
$coordinates['Niger']['13.467:7.083'] = "Maradi";
$coordinates['Niger']['13.483:2.167'] = "Niamey-Aero";
$coordinates['Niger']['13.783:8.983'] = "Zinder";
$coordinates['Niger']['13.800:5.250'] = "Birni-N'Konni";
$coordinates['Niger']['13.983:10.300'] = "Goure";
$coordinates['Niger']['14.200:1.450'] = "Tillabery";
$coordinates['Niger']['14.900:5.250'] = "Tahoua";
$coordinates['Niger']['16.967:7.983'] = "Agadez";
$coordinates['Niger']['18.683:12.917'] = "Bilma";
$coordinates['Nigeria']['10.600:7.450'] = "Kaduna";
$coordinates['Nigeria']['11.133:7.683'] = "Zaria";
$coordinates['Nigeria']['11.850:13.083'] = "Maiduguri";
$coordinates['Nigeria']['12.050:8.533'] = "Kano";
$coordinates['Nigeria']['12.167:6.700'] = "Gusau";
$coordinates['Nigeria']['13.017:5.250'] = "Sokoto";
$coordinates['Nigeria']['4.850:7.017'] = "Port Harcourt";
$coordinates['Nigeria']['4.967:8.350'] = "Calabar";
$coordinates['Nigeria']['6.467:7.550'] = "Enugu";
$coordinates['Nigeria']['6.583:3.333'] = "Lagos / Ikeja";
$coordinates['Nigeria']['7.433:3.900'] = "Ibadan";
$coordinates['Nigeria']['7.683:8.617'] = "Makurdi";
$coordinates['Nigeria']['7.783:4.483'] = "Oshogbo";
$coordinates['Nigeria']['8.483:4.583'] = "Ilorin";
$coordinates['Nigeria']['9.100:6.017'] = "Bida";
$coordinates['Nigeria']['9.233:12.467'] = "Yola";
$coordinates['Nigeria']['9.867:8.900'] = "Jos";
$coordinates['Norway']['58.100:6.633'] = "Lista Flyplass";
$coordinates['Norway']['58.200:8.083'] = "Kristiansand / Kjevik";
$coordinates['Norway']['58.883:5.633'] = "Stavanger / Sola";
$coordinates['Norway']['59.183:9.567'] = "Skien-Geiteryggen";
$coordinates['Norway']['59.200:10.267'] = "Torp";
$coordinates['Norway']['59.350:5.217'] = "Haugesund / Karmoy";
$coordinates['Norway']['59.383:10.783'] = "Rygge";
$coordinates['Norway']['59.900:10.633'] = "Oslo / Fornebu";
$coordinates['Norway']['60.200:11.083'] = "Oslo / Gardermoen";
$coordinates['Norway']['60.283:5.233'] = "Bergen / Flesland";
$coordinates['Norway']['60.650:6.500'] = "Voss-Bo";
$coordinates['Norway']['61.000:9.300'] = "Fagernes Leirin";
$coordinates['Norway']['61.150:7.133'] = "Sogndal / Haukasen";
$coordinates['Norway']['61.583:5.033'] = "Floro";
$coordinates['Norway']['61.833:6.117'] = "Sandane / Anda";
$coordinates['Norway']['62.183:6.067'] = "Orsta-Volda / Hovden";
$coordinates['Norway']['62.567:6.117'] = "Alesund / Vigra";
$coordinates['Norway']['62.583:11.350'] = "Roros Lufthavn";
$coordinates['Norway']['62.750:7.267'] = "Molde / Aro";
$coordinates['Norway']['63.117:7.833'] = "Kristiansund / Kvernberget";
$coordinates['Norway']['63.467:10.933'] = "Trondheim / Vaernes";
$coordinates['Norway']['63.700:9.600'] = "Orland Iii";
$coordinates['Norway']['64.467:11.583'] = "Namsos Lufthavn";
$coordinates['Norway']['64.833:11.150'] = "Rorvik / Ryum";
$coordinates['Norway']['65.467:12.217'] = "Bronnoysund / Bronnoy";
$coordinates['Norway']['65.800:13.133'] = "Mosjoen Kjaerstad";
$coordinates['Norway']['65.967:12.467'] = "Sandnessjoen / Stokka";
$coordinates['Norway']['66.367:14.300'] = "Mo I Rana / Rossvoll";
$coordinates['Norway']['67.267:14.367'] = "Bodo Vi";
$coordinates['Norway']['67.517:12.100'] = "Rost Flyplass";
$coordinates['Norway']['68.150:13.617'] = "Leknes";
$coordinates['Norway']['68.250:14.667'] = "Svolvaer / Helle";
$coordinates['Norway']['68.467:17.500'] = "Narvik Iii";
$coordinates['Norway']['68.517:16.683'] = "Evenes";
$coordinates['Norway']['68.583:15.017'] = "Storkmarknes / Skagen";
$coordinates['Norway']['69.000:23.033'] = "Kautokeino";
$coordinates['Norway']['69.067:18.533'] = "Bardufoss";
$coordinates['Norway']['69.300:16.150'] = "Andoya";
$coordinates['Norway']['69.683:18.917'] = "Tromso / Langnes";
$coordinates['Norway']['69.733:29.900'] = "Kirkenes Lufthavn";
$coordinates['Norway']['69.783:20.967'] = "Sorkjosen";
$coordinates['Norway']['69.983:23.367'] = "Alta Lufthavn";
$coordinates['Norway']['70.067:24.983'] = "Banak";
$coordinates['Norway']['70.067:29.850'] = "Vadso";
$coordinates['Norway']['70.350:31.050'] = "Svartnes";
$coordinates['Norway']['70.667:23.667'] = "Hammerfest";
$coordinates['Norway']['70.867:29.033'] = "Berlevag";
$coordinates['Norway']['70.933:-8.667'] = "Jan Mayen";
$coordinates['Norway']['71.017:25.983'] = "Honningsvag / Valan";
$coordinates['Norway']['71.033:27.833'] = "Mehamn";
$coordinates['Norway']['74.517:19.017'] = "Bjornoya";
$coordinates['Norway']['76.500:25.067'] = "Hopen";
$coordinates['Norway']['78.250:15.467'] = "Svalbard Lufthavn";
$coordinates['Norway']['78.917:11.933'] = "Ny-Alesund Ii";
$coordinates['Oman']['17.033:54.083'] = "Salalah";
$coordinates['Oman']['17.667:54.033'] = "Thumrait";
$coordinates['Oman']['20.667:58.900'] = "Masirah";
$coordinates['Oman']['22.350:56.483'] = "Fahud";
$coordinates['Oman']['22.533:59.483'] = "Sur";
$coordinates['Oman']['23.067:57.650'] = "Saiq";
$coordinates['Oman']['23.583:58.283'] = "Seeb, International Airport";
$coordinates['Oman']['24.233:55.783'] = "Buraimi";
$coordinates['Oman']['24.467:56.633'] = "Sohar Majis";
$coordinates['Oman']['26.217:56.233'] = "Khassab";
$coordinates['Pakistan']['24.900:67.133'] = "Karachi Airport";
$coordinates['Pakistan']['25.067:61.800'] = "Jiwani";
$coordinates['Pakistan']['25.383:68.417'] = "Hyderabad Airport";
$coordinates['Pakistan']['26.250:68.367'] = "Nawabshah";
$coordinates['Pakistan']['26.967:64.100'] = "Panjgur";
$coordinates['Pakistan']['28.300:68.467'] = "Jacobabad";
$coordinates['Pakistan']['29.550:67.883'] = "Sibi";
$coordinates['Pakistan']['30.200:71.433'] = "Multan";
$coordinates['Pakistan']['30.250:66.883'] = "Quetta Airport";
$coordinates['Pakistan']['31.517:74.400'] = "Lahore Airport";
$coordinates['Pakistan']['31.550:74.333'] = "Lahore City";
$coordinates['Pakistan']['31.817:70.917'] = "Dera Ismail Khan";
$coordinates['Pakistan']['32.050:72.667'] = "Sargodha";
$coordinates['Pakistan']['32.550:71.517'] = "Mianwali";
$coordinates['Pakistan']['33.617:73.100'] = "Islamabad Airport";
$coordinates['Pakistan']['34.017:71.583'] = "Peshawar";
$coordinates['Pakistan']['34.067:71.983'] = "Risalpur";
$coordinates['Palau']['7.367:134.533'] = "Babelthuap Island, Babelthuap/Koror Airport";
$coordinates['Panama']['8.083:-80.950'] = "Santiago";
$coordinates['Panama']['8.400:-82.417'] = "David";
$coordinates['Panama']['8.917:-79.600'] = "Howard Air Force Base";
$coordinates['Panama']['9.050:-79.367'] = "Tocumen";
$coordinates['Panama']['9.333:-79.983'] = "Ft Sherman Rocob";
$coordinates['Papua New Guinea']['-3.567:143.633'] = "Wewak";
$coordinates['Papua New Guinea']['-5.217:145.783'] = "Madang";
$coordinates['Papua New Guinea']['-9.433:147.217'] = "Moresby";
$coordinates['Paraguay']['-20.717:-61.917'] = "Nueva Asuncion";
$coordinates['Paraguay']['-22.017:-60.600'] = "Mariscal Estigarribia";
$coordinates['Paraguay']['-23.417:-57.300'] = "Concepcion";
$coordinates['Paraguay']['-25.267:-57.633'] = "Asuncion / Aeropuerto";
$coordinates['Paraguay']['-27.317:-55.833'] = "Encarnacion";
$coordinates['Peru']['-10.733:-73.783'] = "Atalaya";
$coordinates['Peru']['-12.000:-77.117'] = "Lima-Callao / Aerop. Internacional Jorgechavez";
$coordinates['Peru']['-12.633:-69.200'] = "Puerto Maldonado";
$coordinates['Peru']['-13.133:-74.217'] = "Ayacucho";
$coordinates['Peru']['-13.550:-71.983'] = "Cuzco";
$coordinates['Peru']['-13.717:-73.350'] = "Andahuayla";
$coordinates['Peru']['-13.750:-76.283'] = "Pisco";
$coordinates['Peru']['-15.383:-75.167'] = "San Juan";
$coordinates['Peru']['-15.483:-70.150'] = "Juliaca";
$coordinates['Peru']['-16.317:-71.550'] = "Arequipa";
$coordinates['Peru']['-18.067:-70.300'] = "Tacna";
$coordinates['Peru']['-3.550:-80.400'] = "Tumbes";
$coordinates['Peru']['-3.750:-73.250'] = "Iquitos";
$coordinates['Peru']['-4.567:-81.250'] = "Talara";
$coordinates['Peru']['-5.183:-80.600'] = "Piura";
$coordinates['Peru']['-5.900:-76.083'] = "Yurimaguas";
$coordinates['Peru']['-6.050:-77.150'] = "Rioja";
$coordinates['Peru']['-6.217:-77.833'] = "Chachapoyas";
$coordinates['Peru']['-6.450:-76.383'] = "Tarapoto";
$coordinates['Peru']['-6.783:-79.833'] = "Chiclayo";
$coordinates['Peru']['-7.133:-78.467'] = "Cajamarca";
$coordinates['Peru']['-7.217:-76.717'] = "Juanjui";
$coordinates['Peru']['-8.100:-79.033'] = "Trujillo";
$coordinates['Peru']['-8.417:-74.600'] = "Pucallpa";
$coordinates['Peru']['-9.133:-75.950'] = "Tingo Maria";
$coordinates['Peru']['-9.167:-78.517'] = "Chimbote";
$coordinates['Peru']['-9.350:-77.600'] = "Anta Huaraz";
$coordinates['Peru']['-9.900:-75.750'] = "Huanuco";
$coordinates['Philippines']['10.300:123.967'] = "Mactan";
$coordinates['Philippines']['10.700:122.567'] = "Iloilo";
$coordinates['Philippines']['11.033:126.733'] = "Guiuan";
$coordinates['Philippines']['11.250:125.000'] = "Tacloban";
$coordinates['Philippines']['11.583:122.750'] = "Roxas";
$coordinates['Philippines']['12.350:121.033'] = "San Jose";
$coordinates['Philippines']['12.367:123.617'] = "Masbate";
$coordinates['Philippines']['12.483:124.633'] = "Catarman";
$coordinates['Philippines']['12.583:122.267'] = "Romblon";
$coordinates['Philippines']['13.133:123.733'] = "Legaspi";
$coordinates['Philippines']['13.417:121.183'] = "Calapan";
$coordinates['Philippines']['13.583:124.233'] = "Virac";
$coordinates['Philippines']['14.083:122.017'] = "Alabat";
$coordinates['Philippines']['14.133:122.983'] = "Daet";
$coordinates['Philippines']['14.500:120.917'] = "Sangley Point";
$coordinates['Philippines']['14.517:121.000'] = "Ninoy Aquino Inter-National Airport";
$coordinates['Philippines']['14.800:120.267'] = "Subic Bay Weather Station";
$coordinates['Philippines']['15.167:120.567'] = "Clark Ab";
$coordinates['Philippines']['15.333:119.967'] = "Iba";
$coordinates['Philippines']['15.767:121.567'] = "Baler";
$coordinates['Philippines']['16.417:120.600'] = "Baguio";
$coordinates['Philippines']['17.567:120.383'] = "Vigan";
$coordinates['Philippines']['17.617:121.733'] = "Tuguegarao";
$coordinates['Philippines']['18.183:120.533'] = "Laoag";
$coordinates['Philippines']['18.367:121.633'] = "Aparri";
$coordinates['Philippines']['20.450:121.967'] = "Basco";
$coordinates['Philippines']['6.117:125.183'] = "Gen. Santos";
$coordinates['Philippines']['6.900:122.067'] = "Zamboanga";
$coordinates['Philippines']['7.117:125.650'] = "Davao Airport";
$coordinates['Philippines']['7.167:124.217'] = "Cotobato";
$coordinates['Philippines']['8.150:125.083'] = "Malaybalay";
$coordinates['Philippines']['8.483:124.633'] = "Cagayan De Oro";
$coordinates['Philippines']['8.600:123.350'] = "Dipolog";
$coordinates['Philippines']['9.300:123.300'] = "Dumaguete";
$coordinates['Philippines']['9.600:123.850'] = "Tagbilaran";
$coordinates['Philippines']['9.750:118.733'] = "Puerto Princesa";
$coordinates['Philippines']['9.800:125.500'] = "Surigao";
$coordinates['Philippines']['9.933:125.517'] = "Butuan";
$coordinates['Poland']['50.083:19.800'] = "Krakow";
$coordinates['Poland']['50.100:22.050'] = "Rzeszow-Jasionka";
$coordinates['Poland']['50.233:19.033'] = "Katowice";
$coordinates['Poland']['51.100:16.883'] = "Wroclaw Ii";
$coordinates['Poland']['51.933:15.533'] = "Zielona Gora";
$coordinates['Poland']['52.167:20.967'] = "Warszawa-Okecie";
$coordinates['Poland']['52.417:16.833'] = "Poznan";
$coordinates['Poland']['53.400:14.617'] = "Szczecin";
$coordinates['Poland']['54.200:16.150'] = "Koszalin";
$coordinates['Poland']['54.383:18.467'] = "Gdansk-Rebiechowo";
$coordinates['Portugal']['32.683:-16.767'] = "Funchal / S. Catarina";
$coordinates['Portugal']['33.067:-16.350'] = "Porto Santo";
$coordinates['Portugal']['36.967:-25.167'] = "Santa Maria Acores";
$coordinates['Portugal']['37.017:-7.967'] = "Faro / Aeroporto";
$coordinates['Portugal']['37.733:-25.700'] = "Ponta Delgada / Nordela Acores";
$coordinates['Portugal']['38.017:-7.867'] = "Beja";
$coordinates['Portugal']['38.517:-28.717'] = "Horta / Castelo Branco Acores";
$coordinates['Portugal']['38.767:-27.100'] = "Lajes Acores";
$coordinates['Portugal']['38.767:-9.133'] = "Lisboa / Portela";
$coordinates['Portugal']['39.450:-31.133'] = "Flores Acores";
$coordinates['Portugal']['41.233:-8.683'] = "Porto / Pedras Rubras";
$coordinates['Portugal']['41.267:-7.717'] = "Vila Real";
$coordinates['Portugal']['41.800:-6.733'] = "Braganca";
$coordinates['Qatar']['25.250:51.567'] = "Doha International Airport";
$coordinates['Reunion']['-20.883:55.517'] = "Saint-Denis / Gillot";
$coordinates['Reunion']['-21.333:55.483'] = "Saint-Pierre";
$coordinates['Romania']['44.233:23.867'] = "Craiova";
$coordinates['Romania']['44.333:28.433'] = "Kogalniceanu";
$coordinates['Romania']['44.500:26.133'] = "Bucuresti / Imh";
$coordinates['Romania']['44.550:26.100'] = "Bucuresti Otopeni";
$coordinates['Romania']['45.183:28.817'] = "Tulcea";
$coordinates['Romania']['45.417:22.250'] = "Caransebes";
$coordinates['Romania']['45.767:21.250'] = "Timisoara";
$coordinates['Romania']['45.800:24.150'] = "Sibiu";
$coordinates['Romania']['46.200:21.400'] = "Arad";
$coordinates['Romania']['46.533:24.533'] = "Tirgu Mures";
$coordinates['Romania']['46.583:26.967'] = "Bacau";
$coordinates['Romania']['46.783:23.567'] = "Cluj-Napoca";
$coordinates['Romania']['47.050:21.933'] = "Oradea";
$coordinates['Romania']['47.167:27.633'] = "Iasi";
$coordinates['Romania']['47.650:26.250'] = "Suceava / Salcea";
$coordinates['Romania']['47.667:23.583'] = "Baia Mare";
$coordinates['Romania']['47.800:22.883'] = "Satu Mare";
$coordinates['Russian Federation']['43.117:131.933'] = "Vladivostok";
$coordinates['Russian Federation']['43.433:39.900'] = "Adler";
$coordinates['Russian Federation']['44.233:43.067'] = "Mineral'Nye Vody";
$coordinates['Russian Federation']['45.033:39.150'] = "Krasnodar";
$coordinates['Russian Federation']['46.367:44.333'] = "Elista";
$coordinates['Russian Federation']['46.950:142.717'] = "Yuzhno-Sakhalinsk";
$coordinates['Russian Federation']['47.267:39.817'] = "Rostov-Na-Donu";
$coordinates['Russian Federation']['48.517:135.167'] = "Habarovsk";
$coordinates['Russian Federation']['48.783:44.367'] = "Volgograd";
$coordinates['Russian Federation']['49.450:136.567'] = "Troickoe";
$coordinates['Russian Federation']['51.650:39.250'] = "Voronez";
$coordinates['Russian Federation']['51.833:107.600'] = "Ulan-Ude";
$coordinates['Russian Federation']['52.083:113.483'] = "Chita";
$coordinates['Russian Federation']['52.167:109.783'] = "Horinsk";
$coordinates['Russian Federation']['52.267:104.317'] = "Irkutsk";
$coordinates['Russian Federation']['52.817:104.767'] = "Ust'Ordynskij";
$coordinates['Russian Federation']['53.067:132.983'] = "Ekimchan";
$coordinates['Russian Federation']['53.083:158.583'] = "Petropavlovsk-Kamchatskij";
$coordinates['Russian Federation']['53.117:45.017'] = "Penza";
$coordinates['Russian Federation']['53.200:50.150'] = "Samara";
$coordinates['Russian Federation']['53.250:34.317'] = "Brjansk";
$coordinates['Russian Federation']['53.433:83.517'] = "Barnaul";
$coordinates['Russian Federation']['54.883:99.033'] = "Nizhneudinsk";
$coordinates['Russian Federation']['55.083:82.900'] = "Novosibirsk";
$coordinates['Russian Federation']['56.350:30.617'] = "Velikie Luki";
$coordinates['Russian Federation']['56.833:124.867'] = "Cul'Man";
$coordinates['Russian Federation']['56.833:60.633'] = "Ekaterinburg";
$coordinates['Russian Federation']['56.900:35.883'] = "Tver";
$coordinates['Russian Federation']['57.767:108.067'] = "Kirensk";
$coordinates['Russian Federation']['57.850:114.233'] = "Bodajbo";
$coordinates['Russian Federation']['58.450:92.150'] = "Enisejsk";
$coordinates['Russian Federation']['59.317:39.917'] = "Vologda";
$coordinates['Russian Federation']['59.550:150.783'] = "Magadan";
$coordinates['Russian Federation']['59.883:42.750'] = "Tot'Ma";
$coordinates['Russian Federation']['59.967:30.300'] = "St. Peterburg";
$coordinates['Russian Federation']['61.017:69.033'] = "Hanty-Mansijsk";
$coordinates['Russian Federation']['61.233:46.717'] = "Kotlas";
$coordinates['Russian Federation']['61.250:73.500'] = "Surgut";
$coordinates['Russian Federation']['61.683:53.683'] = "Ust'- Kulom";
$coordinates['Russian Federation']['61.717:50.833'] = "Syktyvkar";
$coordinates['Russian Federation']['62.017:129.717'] = "Jakutsk";
$coordinates['Russian Federation']['64.417:-173.233'] = "Buhta Providenja";
$coordinates['Russian Federation']['64.500:40.733'] = "Arhangel'Sk";
$coordinates['Russian Federation']['64.783:177.567'] = "Anadyr";
$coordinates['Russian Federation']['68.967:33.050'] = "Murmansk";
$coordinates['Rwanda']['-1.667:29.250'] = "Gisenyi";
$coordinates['Rwanda']['-1.967:30.117'] = "Kigali";
$coordinates['Saint Helena']['-7.967:-14.400'] = "Wide Awake Field Ascension Island";
$coordinates['Saint Kitts and Nevis']['17.300:-62.683'] = "Golden Rock";
$coordinates['Saint Lucia']['13.750:-60.950'] = "Hewanorra International Airport";
$coordinates['Saint Lucia']['14.017:-61.000'] = "Vigie";
$coordinates['Saint Pierre and Miquelon']['46.767:-56.167'] = "Saint-Pierre";
$coordinates['Saint Vincent and the Grenadines']['13.133:-61.200'] = "Arnos Vale";
$coordinates['Samoa']['-13.800:-171.783'] = "Apia / Upolu Island";
$coordinates['Samoa']['-13.817:-172.000'] = "Faleolo Intl / Apia";
$coordinates['Sao Tome and Principe']['0.383:6.717'] = "S. Tome";
$coordinates['Sao Tome and Principe']['1.650:7.417'] = "Principe";
$coordinates['Saudi Arabia']['16.900:42.583'] = "Gizan";
$coordinates['Saudi Arabia']['17.467:47.117'] = "Sharurah";
$coordinates['Saudi Arabia']['17.617:44.417'] = "Najran";
$coordinates['Saudi Arabia']['18.233:42.650'] = "Abha";
$coordinates['Saudi Arabia']['18.300:42.800'] = "Khamis Mushait";
$coordinates['Saudi Arabia']['19.983:42.617'] = "Bisha";
$coordinates['Saudi Arabia']['20.300:41.633'] = "Al Baha";
$coordinates['Saudi Arabia']['20.500:45.200'] = "Wadi Al Dawasser Airport";
$coordinates['Saudi Arabia']['21.433:39.767'] = "Makkah";
$coordinates['Saudi Arabia']['21.483:40.550'] = "Taif";
$coordinates['Saudi Arabia']['21.500:39.200'] = "Jeddah";
$coordinates['Saudi Arabia']['21.700:39.183'] = "Jeddah King Abdul Aziz International Airport";
$coordinates['Saudi Arabia']['24.150:38.067'] = "Yenbo";
$coordinates['Saudi Arabia']['24.500:44.350'] = "Dawadmi";
$coordinates['Saudi Arabia']['24.550:39.700'] = "Madinah";
$coordinates['Saudi Arabia']['24.717:46.733'] = "Riyadh";
$coordinates['Saudi Arabia']['24.933:46.717'] = "King Khaled International Airport";
$coordinates['Saudi Arabia']['25.300:49.483'] = "Al Ahsa";
$coordinates['Saudi Arabia']['26.200:36.467'] = "Wejh";
$coordinates['Saudi Arabia']['26.267:50.150'] = "Dhahran";
$coordinates['Saudi Arabia']['26.300:43.767'] = "Gassim";
$coordinates['Saudi Arabia']['26.467:49.783'] = "Dammam-King Fahd International Airport";
$coordinates['Saudi Arabia']['27.433:41.683'] = "Hail";
$coordinates['Saudi Arabia']['27.900:45.533'] = "Hafr Al-Batin";
$coordinates['Saudi Arabia']['28.317:46.117'] = "Al Qaysumah";
$coordinates['Saudi Arabia']['28.367:36.600'] = "Tabuk";
$coordinates['Saudi Arabia']['29.617:43.483'] = "Rafha";
$coordinates['Saudi Arabia']['29.783:40.100'] = "Al-Jouf";
$coordinates['Saudi Arabia']['30.900:41.133'] = "Arar";
$coordinates['Saudi Arabia']['31.400:37.267'] = "Guriat";
$coordinates['Saudi Arabia']['31.683:38.733'] = "Turaif";
$coordinates['Senegal']['12.400:-16.750'] = "Cap-Skirring";
$coordinates['Senegal']['12.550:-16.267'] = "Ziguinchor";
$coordinates['Senegal']['12.567:-12.217'] = "Kedougou";
$coordinates['Senegal']['12.883:-14.967'] = "Kolda";
$coordinates['Senegal']['13.767:-13.683'] = "Tambacounda";
$coordinates['Senegal']['14.133:-16.067'] = "Kaolack";
$coordinates['Senegal']['14.650:-16.233'] = "Diourbel";
$coordinates['Senegal']['14.733:-17.500'] = "Dakar / Yoff";
$coordinates['Senegal']['15.383:-15.117'] = "Linguere";
$coordinates['Senegal']['15.650:-13.250'] = "Matam";
$coordinates['Senegal']['16.050:-16.450'] = "Saint-Louis";
$coordinates['Senegal']['16.650:-14.967'] = "Podor";
$coordinates['Seychelles']['-4.667:55.517'] = "Seychelles Inter-National Airport";
$coordinates['Seychelles']['-4.683:55.533'] = "Seychelles International Airport Rawinsonde Station";
$coordinates['Sierra Leone']['8.617:-13.200'] = "Lungi";
$coordinates['Singapore']['1.367:103.917'] = "Singapore / Paya Lebar";
$coordinates['Singapore']['1.367:103.983'] = "Singapore / Changi Airport";
$coordinates['Slovakia']['48.200:17.200'] = "Bratislava Ivanka";
$coordinates['Slovakia']['48.333:19.733'] = "Lucenec";
$coordinates['Slovakia']['48.617:17.833'] = "Piestany";
$coordinates['Slovakia']['48.650:19.150'] = "Sliac";
$coordinates['Slovakia']['48.667:21.217'] = "Kosice";
$coordinates['Slovakia']['48.933:22.000'] = "Kamenica Nad Cirochou";
$coordinates['Slovakia']['49.067:20.250'] = "Poprad / Tatry";
$coordinates['Slovenia']['45.483:13.617'] = "Portoroz / Secovlje";
$coordinates['Slovenia']['45.517:13.567'] = "Portoroz";
$coordinates['Slovenia']['46.217:14.483'] = "Ljubljana / Brnik";
$coordinates['Slovenia']['46.217:14.483'] = "Ljubljana / Brnik";
$coordinates['Slovenia']['46.483:15.683'] = "Maribor / Slivnica";
$coordinates['Slovenia']['46.650:16.183'] = "Murska Sobota";
$coordinates['Solomon Islands']['-10.700:165.800'] = "Santa Cruz";
$coordinates['Solomon Islands']['-8.333:157.267'] = "Munda";
$coordinates['Solomon Islands']['-9.417:160.050'] = "Honiara / Henderson";
$coordinates['Somalia']['10.417:45.017'] = "Berbera";
$coordinates['Somalia']['2.033:45.350'] = "Mogadiscio";
$coordinates['Somalia']['4.700:45.217'] = "Belet Uen";
$coordinates['Somalia']['9.500:44.083'] = "Hargeisa";
$coordinates['Somalia']['9.500:45.567'] = "Burao";
$coordinates['South Africa']['-23.726:27.688'] = "Ellisras";
$coordinates['South Africa']['-23.867:29.450'] = "Pietersburg";
$coordinates['South Africa']['-23.933:31.150'] = "Phalaborwa";
$coordinates['South Africa']['-24.367:31.033'] = "Hoedspruit";
$coordinates['South Africa']['-25.433:30.983'] = "Nelspruit";
$coordinates['South Africa']['-25.733:28.183'] = "Pretoria";
$coordinates['South Africa']['-25.783:25.533'] = "Mmabatho Airport";
$coordinates['South Africa']['-25.833:28.217'] = "Waterkloof Lmb";
$coordinates['South Africa']['-25.917:28.217'] = "Pretoria Irene";
$coordinates['South Africa']['-26.067:30.117'] = "Carolina";
$coordinates['South Africa']['-26.133:28.233'] = "Jan Smuts";
$coordinates['South Africa']['-26.867:26.717'] = "Klerksdorp";
$coordinates['South Africa']['-26.950:24.633'] = "Vryburg";
$coordinates['South Africa']['-27.267:28.500'] = "Frankfort";
$coordinates['South Africa']['-28.000:26.667'] = "Welkom";
$coordinates['South Africa']['-28.250:28.333'] = "Bethlehem Airport";
$coordinates['South Africa']['-28.400:21.267'] = "Upington";
$coordinates['South Africa']['-28.567:16.533'] = "Alexander Bay";
$coordinates['South Africa']['-28.567:29.767'] = "Ladysmith";
$coordinates['South Africa']['-28.800:24.767'] = "Kimberley";
$coordinates['South Africa']['-28.800:32.100'] = "Richard Bay";
$coordinates['South Africa']['-29.100:26.300'] = "Bloemfontein J. B. M. Hertzog";
$coordinates['South Africa']['-29.667:17.867'] = "Springbok";
$coordinates['South Africa']['-29.967:30.950'] = "Durban Louis Botha";
$coordinates['South Africa']['-30.633:23.917'] = "De Aar";
$coordinates['South Africa']['-30.650:24.017'] = "De Aar";
$coordinates['South Africa']['-30.717:26.717'] = "Aliwal North";
$coordinates['South Africa']['-31.467:19.767'] = "Calvinia";
$coordinates['South Africa']['-31.483:25.033'] = "Middelburg";
$coordinates['South Africa']['-31.533:28.667'] = "Umtata";
$coordinates['South Africa']['-31.633:29.550'] = "Port St Johns";
$coordinates['South Africa']['-31.667:18.500'] = "Vredendal";
$coordinates['South Africa']['-31.900:26.867'] = "Queenstown";
$coordinates['South Africa']['-31.917:21.517'] = "Fraserburg";
$coordinates['South Africa']['-32.250:24.533'] = "Graaff Reinet";
$coordinates['South Africa']['-32.350:22.583'] = "Beaufort West";
$coordinates['South Africa']['-32.967:18.167'] = "Langebaanweg";
$coordinates['South Africa']['-33.033:27.833'] = "East London";
$coordinates['South Africa']['-33.567:22.217'] = "Oudtshoorn";
$coordinates['South Africa']['-33.983:18.600'] = "Cape Town D. F. Malan";
$coordinates['South Africa']['-33.983:25.600'] = "Port Elizabeth";
$coordinates['South Africa']['-34.000:22.383'] = "George Airport";
$coordinates['South Africa']['-34.183:22.150'] = "Mossel Bay Cape Saint Blaize";
$coordinates['South Africa']['-37.050:-12.317'] = "Tristan Da Cunha";
$coordinates['South Africa']['-40.350:-9.883'] = "Gough Island";
$coordinates['South Africa']['-46.883:37.867'] = "Marion Island";
$coordinates['South Georgia and the South Sandwich Islands']['-51.817:-58.450'] = "Mount Pleasant Airport";
$coordinates['Spain']['27.817:-17.883'] = "Hierro / Aeropuerto";
$coordinates['Spain']['27.933:-15.383'] = "Las Palmas De Gran Canaria / Gando";
$coordinates['Spain']['28.050:-16.567'] = "Tenerife Sur";
$coordinates['Spain']['28.450:-13.867'] = "Fuerteventura / Aeropuerto";
$coordinates['Spain']['28.467:-16.317'] = "Tenerife / Los Rodeos";
$coordinates['Spain']['28.617:-17.750'] = "La Palma / Aeropuerto";
$coordinates['Spain']['28.950:-13.600'] = "Lanzarote / Aeropuerto";
$coordinates['Spain']['35.283:-2.950'] = "Melilla";
$coordinates['Spain']['36.650:-6.350'] = "Rota";
$coordinates['Spain']['36.667:-4.483'] = "Malaga / Aeropuerto";
$coordinates['Spain']['36.750:-6.067'] = "Jerez De La Fronteraaeropuerto";
$coordinates['Spain']['36.850:-2.383'] = "Almeria / Aeropuerto";
$coordinates['Spain']['37.150:-5.617'] = "Moron De La Frontera";
$coordinates['Spain']['37.183:-3.783'] = "Granada / Aeropuerto";
$coordinates['Spain']['37.417:-5.900'] = "Sevilla / San Pablo";
$coordinates['Spain']['37.783:-0.800'] = "Murcia / San Javier";
$coordinates['Spain']['37.850:-4.850'] = "Cordoba / Aeropuerto";
$coordinates['Spain']['37.950:-1.233'] = "Murcia / Alcantarilla";
$coordinates['Spain']['38.283:-0.550'] = "Alicante / El Altet";
$coordinates['Spain']['38.517:-5.117'] = "Hinojosa Del Duque";
$coordinates['Spain']['38.867:1.383'] = "Ibiza / Es Codola";
$coordinates['Spain']['38.883:-6.817'] = "Badajoz / Talavera La Real";
$coordinates['Spain']['38.950:-1.850'] = "Albacete / Los Llanos";
$coordinates['Spain']['39.500:-0.467'] = "Valencia / Aeropuerto";
$coordinates['Spain']['39.550:2.733'] = "Palma De Mallorca / Son San Juan";
$coordinates['Spain']['39.867:4.233'] = "Menorca / Mahon";
$coordinates['Spain']['40.300:-3.717'] = "Madrid / Getafe";
$coordinates['Spain']['40.383:-3.783'] = "Madrid / Cuatro Vientos";
$coordinates['Spain']['40.450:-3.550'] = "Madrid / Barajas";
$coordinates['Spain']['40.483:-3.450'] = "Madrid / Torrejon";
$coordinates['Spain']['40.650:-3.733'] = "Madri-Colmenar";
$coordinates['Spain']['40.933:-1.300'] = "Calamocha";
$coordinates['Spain']['40.950:-5.500'] = "Salamanca / Matacan";
$coordinates['Spain']['41.150:1.167'] = "Reus / Aeropuerto";
$coordinates['Spain']['41.283:2.067'] = "Barcelona / Aeropuerto";
$coordinates['Spain']['41.667:-1.017'] = "Zaragoza / Aeropuerto";
$coordinates['Spain']['41.717:-4.850'] = "Valladolid / Villanubla";
$coordinates['Spain']['41.900:2.767'] = "Gerona / Costa Brava";
$coordinates['Spain']['42.217:-8.633'] = "Vigo / Peinador";
$coordinates['Spain']['42.367:-3.633'] = "Burgos / Villafria";
$coordinates['Spain']['42.450:-2.333'] = "Logrono / Agoncillo";
$coordinates['Spain']['42.583:-5.650'] = "Leon / Virgen Del Camino";
$coordinates['Spain']['42.767:-1.633'] = "Pamplona / Noain";
$coordinates['Spain']['42.883:-2.717'] = "Vitoria";
$coordinates['Spain']['42.900:-8.433'] = "Santiago / Labacolla";
$coordinates['Spain']['43.300:-2.933'] = "Bilbao / Sondica";
$coordinates['Spain']['43.300:-8.383'] = "La Coruna / Alvedro";
$coordinates['Spain']['43.350:-1.800'] = "San Sebastian / Fuenterrabia";
$coordinates['Spain']['43.433:-3.817'] = "Santander / Parayas";
$coordinates['Spain']['43.550:-6.033'] = "Asturias / Aviles";
$coordinates['Sri Lanka']['6.817:79.883'] = "Ratmalana";
$coordinates['Sri Lanka']['7.167:79.883'] = "Katunayake";
$coordinates['Sri Lanka']['7.717:81.700'] = "Batticaloa";
$coordinates['Sri Lanka']['8.333:80.417'] = "Anuradhapura";
$coordinates['Sri Lanka']['8.583:81.250'] = "Trincomalee";
$coordinates['Sudan']['11.000:29.717'] = "Kadugli";
$coordinates['Sudan']['11.750:32.783'] = "Renk";
$coordinates['Sudan']['11.783:34.383'] = "Damazine";
$coordinates['Sudan']['12.050:24.883'] = "Nyala";
$coordinates['Sudan']['13.167:30.233'] = "El Obeid";
$coordinates['Sudan']['13.167:32.667'] = "Kosti";
$coordinates['Sudan']['13.483:22.450'] = "Geneina";
$coordinates['Sudan']['13.550:33.617'] = "Sennar";
$coordinates['Sudan']['13.617:25.333'] = "El Fasher";
$coordinates['Sudan']['14.033:35.400'] = "Gedaref";
$coordinates['Sudan']['15.467:36.400'] = "Kassala";
$coordinates['Sudan']['15.600:32.550'] = "Khartoum";
$coordinates['Sudan']['17.700:33.967'] = "Atbara";
$coordinates['Sudan']['19.167:30.483'] = "Dongola";
$coordinates['Sudan']['19.583:37.217'] = "Port Sudan";
$coordinates['Sudan']['21.817:31.483'] = "Wadi Halfa";
$coordinates['Sudan']['4.867:31.600'] = "Juba";
$coordinates['Sudan']['9.550:31.650'] = "Malakal";
$coordinates['Suriname']['5.450:-55.200'] = "Zanderij";
$coordinates['Swaziland']['-26.533:31.300'] = "Manzini / Matsapa Airport";
$coordinates['Sweden']['55.550:13.367'] = "Malmo / Sturup";
$coordinates['Sweden']['55.917:14.083'] = "Kristianstad / Everod";
$coordinates['Sweden']['56.085:13.207'] = "Ljungbyhed, Ljungbyhed (SWE-AFB)";
$coordinates['Sweden']['56.267:15.283'] = "Ronneby";
$coordinates['Sweden']['56.300:12.850'] = "Angelholm";
$coordinates['Sweden']['56.683:12.833'] = "Halmstad Swedish Air Force Base";
$coordinates['Sweden']['56.733:16.300'] = "Kalmar";
$coordinates['Sweden']['56.850:14.833'] = "Vaxjo";
$coordinates['Sweden']['57.300:14.133'] = "Hagshult";
$coordinates['Sweden']['57.517:15.833'] = "Hultsfred Swedish Air Force Base";
$coordinates['Sweden']['57.667:12.300'] = "Goteborg / Landvetter";
$coordinates['Sweden']['57.667:18.350'] = "Visby Flygplats";
$coordinates['Sweden']['57.767:14.083'] = "Jonkoping Flygplats";
$coordinates['Sweden']['57.783:11.883'] = "Goteborg / Save";
$coordinates['Sweden']['58.400:15.517'] = "Linkoping / Malmen";
$coordinates['Sweden']['58.433:12.700'] = "Satenas";
$coordinates['Sweden']['58.450:13.967'] = "Skovde Flygplats";
$coordinates['Sweden']['58.583:16.150'] = "Norrkoping";
$coordinates['Sweden']['59.350:17.950'] = "Stockholm / Bromma";
$coordinates['Sweden']['59.367:13.467'] = "Karlstad Flygplats";
$coordinates['Sweden']['59.583:16.633'] = "Vasteras / Hasslo";
$coordinates['Sweden']['59.650:17.950'] = "Stockholm / Arlanda";
$coordinates['Sweden']['59.883:17.600'] = "Uppsala";
$coordinates['Sweden']['60.433:15.517'] = "Borlange";
$coordinates['Sweden']['60.600:16.950'] = "Gavle / Sandviken Air Force Base";
$coordinates['Sweden']['61.267:17.100'] = "Soderhamn";
$coordinates['Sweden']['62.533:17.450'] = "Sundsvall-Harnosand Flygplats";
$coordinates['Sweden']['63.050:17.767'] = "Kramfors Flygplats";
$coordinates['Sweden']['63.183:14.500'] = "Ostersund / Froson";
$coordinates['Sweden']['63.400:18.967'] = "Ornskoldsvik Airport";
$coordinates['Sweden']['63.800:20.283'] = "Umea Flygplats";
$coordinates['Sweden']['64.633:21.083'] = "Skelleftea Airport";
$coordinates['Sweden']['64.967:17.700'] = "Gunnarn";
$coordinates['Sweden']['65.550:22.133'] = "Lulea / Kallax";
$coordinates['Sweden']['65.867:20.133'] = "Vidsel";
$coordinates['Sweden']['66.633:19.650'] = "Jokkmokk";
$coordinates['Sweden']['67.150:20.650'] = "Gallivare";
$coordinates['Sweden']['67.817:20.333'] = "Kiruna Airport";
$coordinates['Switzerland']['46.000:8.967'] = "Lugano";
$coordinates['Switzerland']['46.217:7.333'] = "Sion";
$coordinates['Switzerland']['46.250:6.133'] = "Geneve-Cointrin";
$coordinates['Switzerland']['46.550:6.617'] = "Lausanne";
$coordinates['Switzerland']['46.817:6.950'] = "Payerne";
$coordinates['Switzerland']['47.000:6.950'] = "Neuchatel";
$coordinates['Switzerland']['47.181:7.416'] = "Grenchen";
$coordinates['Switzerland']['47.483:8.533'] = "Zurich-Kloten";
$coordinates['Switzerland']['47.485:9.562'] = "Saint Gallen-Altenrhein";
$coordinates['Syrian Arab Republic']['33.417:36.517'] = "Damascus Int. Airport";
$coordinates['Syrian Arab Republic']['34.550:38.300'] = "Palmyra";
$coordinates['Syrian Arab Republic']['35.317:40.150'] = "Deir Ezzor";
$coordinates['Syrian Arab Republic']['35.533:35.767'] = "Lattakia";
$coordinates['Syrian Arab Republic']['36.183:37.200'] = "Aleppo International Airport";
$coordinates['Syrian Arab Republic']['37.050:41.217'] = "Kamishli";
$coordinates['Taiwan']['20.667:116.717'] = "Dongsha";
$coordinates['Taiwan']['21.933:120.833'] = "Hengchun";
$coordinates['Taiwan']['22.033:121.550'] = "Lan Yu";
$coordinates['Taiwan']['22.417:120.550'] = "Chia Tung";
$coordinates['Taiwan']['22.467:120.433'] = "Donggang";
$coordinates['Taiwan']['22.583:120.350'] = "Kaohsiung International Airport";
$coordinates['Taiwan']['22.683:120.467'] = "Pingtung South Air Force Base";
$coordinates['Taiwan']['22.700:120.483'] = "Pingtung North Air Force Base";
$coordinates['Taiwan']['22.783:120.267'] = "Kangshan Tw-Afb";
$coordinates['Taiwan']['22.800:121.183'] = "Chihhang Tw-Afb";
$coordinates['Taiwan']['22.950:120.200'] = "Tainan Tw-Afb";
$coordinates['Taiwan']['23.267:119.667'] = "Dongshi";
$coordinates['Taiwan']['23.467:120.383'] = "Chiayi Tw-Afb";
$coordinates['Taiwan']['23.583:119.617'] = "Makung Ab";
$coordinates['Taiwan']['24.033:121.617'] = "Hulien Ab";
$coordinates['Taiwan']['24.183:120.650'] = "Taichung Tw-Afb";
$coordinates['Taiwan']['24.267:120.617'] = "Wuchia Observatory";
$coordinates['Taiwan']['24.433:118.367'] = "Chinmem / Shatou Air Force Base";
$coordinates['Taiwan']['24.750:121.767'] = "Ilan";
$coordinates['Taiwan']['24.817:120.933'] = "Hsinchu Tw-Afb";
$coordinates['Taiwan']['24.933:121.300'] = "Pa Kuei / Bakuai";
$coordinates['Taiwan']['25.067:121.233'] = "Taoyuan Ab = 589650";
$coordinates['Taiwan']['25.067:121.550'] = "Sungshan / Taipei";
$coordinates['Taiwan']['25.083:121.217'] = "Chiang Kai Shek";
$coordinates['Taiwan']['26.167:119.933'] = "Mazu";
$coordinates['Tajikistan']['38.550:68.783'] = "Dushanbe";
$coordinates['Tanzania, United Republic of']['-1.333:31.817'] = "Bukoba";
$coordinates['Tanzania, United Republic of']['-1.500:33.800'] = "Musoma";
$coordinates['Tanzania, United Republic of']['-10.267:40.183'] = "Mtwara";
$coordinates['Tanzania, United Republic of']['-10.350:38.750'] = "Nachingwea";
$coordinates['Tanzania, United Republic of']['-10.683:35.583'] = "Songea";
$coordinates['Tanzania, United Republic of']['-2.467:32.917'] = "Mwanza";
$coordinates['Tanzania, United Republic of']['-3.333:36.617'] = "Arusha";
$coordinates['Tanzania, United Republic of']['-3.350:37.333'] = "Moshi";
$coordinates['Tanzania, United Republic of']['-3.417:37.067'] = "Kilimanjaro Airport";
$coordinates['Tanzania, United Republic of']['-4.083:37.717'] = "Same";
$coordinates['Tanzania, United Republic of']['-4.883:29.633'] = "Kigoma";
$coordinates['Tanzania, United Republic of']['-4.883:38.283'] = "Mombo";
$coordinates['Tanzania, United Republic of']['-5.083:32.833'] = "Tabora Airport";
$coordinates['Tanzania, United Republic of']['-5.083:39.067'] = "Tanga";
$coordinates['Tanzania, United Republic of']['-5.250:39.817'] = "Pemba / Karume Airport";
$coordinates['Tanzania, United Republic of']['-6.167:35.767'] = "Dodoma";
$coordinates['Tanzania, United Republic of']['-6.217:39.217'] = "Zanzibar / Kisauni";
$coordinates['Tanzania, United Republic of']['-6.833:37.650'] = "Morogoro";
$coordinates['Tanzania, United Republic of']['-6.867:39.200'] = "Dar Es Salaam Airport";
$coordinates['Tanzania, United Republic of']['-7.667:35.750'] = "Iringa";
$coordinates['Tanzania, United Republic of']['-8.933:33.467'] = "Mbeya";
$coordinates['Thailand']['10.483:99.183'] = "Chumphon";
$coordinates['Thailand']['11.833:99.833'] = "Prachuap Khirikhan";
$coordinates['Thailand']['12.583:99.950'] = "Hua Hin";
$coordinates['Thailand']['12.600:102.117'] = "Chanthaburi";
$coordinates['Thailand']['12.633:101.350'] = "Rayong";
$coordinates['Thailand']['13.150:100.067'] = "Phetchaburi";
$coordinates['Thailand']['13.367:100.983'] = "Chon Buri";
$coordinates['Thailand']['13.917:100.600'] = "Don Muang";
$coordinates['Thailand']['14.017:99.533'] = "Kanchanaburi";
$coordinates['Thailand']['14.050:101.367'] = "Prachin Buri";
$coordinates['Thailand']['14.967:102.083'] = "Nakhon Ratchasima";
$coordinates['Thailand']['15.250:104.867'] = "Ubon Ratchathani";
$coordinates['Thailand']['15.800:100.167'] = "Nakhon Sawan";
$coordinates['Thailand']['15.800:102.033'] = "Chaiyaphum";
$coordinates['Thailand']['16.050:103.683'] = "Roi Et";
$coordinates['Thailand']['16.433:102.833'] = "Khon Kaen";
$coordinates['Thailand']['16.533:104.717'] = "Mukdahan";
$coordinates['Thailand']['16.667:98.550'] = "Mae Sot";
$coordinates['Thailand']['16.783:100.267'] = "Phitsanulok";
$coordinates['Thailand']['16.883:99.150'] = "Tak";
$coordinates['Thailand']['17.150:104.133'] = "Sakon Nakhon";
$coordinates['Thailand']['17.383:102.800'] = "Udon Thani";
$coordinates['Thailand']['17.417:104.783'] = "Nakhon Phanom";
$coordinates['Thailand']['17.450:101.733'] = "Loei";
$coordinates['Thailand']['17.617:100.100'] = "Uttaradit";
$coordinates['Thailand']['17.867:102.717'] = "Nong Khai";
$coordinates['Thailand']['18.167:100.167'] = "Phrae";
$coordinates['Thailand']['18.167:97.933'] = "Mae Sariang";
$coordinates['Thailand']['18.283:99.517'] = "Lampang";
$coordinates['Thailand']['18.767:100.767'] = "Nan";
$coordinates['Thailand']['18.783:98.983'] = "Chiang Mai";
$coordinates['Thailand']['19.300:97.833'] = "Mae Hong Son";
$coordinates['Thailand']['19.917:99.833'] = "Chiang Rai";
$coordinates['Thailand']['6.650:100.083'] = "Satun";
$coordinates['Thailand']['6.783:101.150'] = "Pattani";
$coordinates['Thailand']['6.917:100.433'] = "Hat Yai";
$coordinates['Thailand']['7.200:100.600'] = "Songkhla";
$coordinates['Thailand']['7.517:99.617'] = "Trang";
$coordinates['Thailand']['8.117:98.317'] = "Phuket Airport";
$coordinates['Thailand']['8.467:99.967'] = "Nakhon Si Thammarat";
$coordinates['Thailand']['9.117:99.350'] = "Surat Thani";
$coordinates['Thailand']['9.983:98.617'] = "Ranong";
$coordinates['Togo']['10.367:0.467'] = "Mango";
$coordinates['Togo']['6.167:1.250'] = "Lome";
$coordinates['Togo']['6.583:1.500'] = "Tabligbo";
$coordinates['Togo']['7.583:1.117'] = "Atakpame";
$coordinates['Togo']['8.983:1.150'] = "Sokode";
$coordinates['Togo']['9.767:1.100'] = "Niamtougou";
$coordinates['Tonga']['-19.800:-174.350'] = "Haapai";
$coordinates['Tonga']['-21.233:-175.150'] = "Fua'Amotu";
$coordinates['Trinidad and Tobago']['10.617:-61.350'] = "Piarco International Airport, Trinidad";
$coordinates['Trinidad and Tobago']['11.150:-60.833'] = "Crown Point Airport, Tobago";
$coordinates['Tunisia']['31.683:9.167'] = "El Borma";
$coordinates['Tunisia']['32.317:10.400'] = "Remada";
$coordinates['Tunisia']['33.867:10.767'] = "Djerba Mellita";
$coordinates['Tunisia']['33.883:10.100'] = "Gabes";
$coordinates['Tunisia']['33.917:8.100'] = "Tozeur";
$coordinates['Tunisia']['34.417:8.817'] = "Gafsa";
$coordinates['Tunisia']['34.717:10.683'] = "Sfax El-Maou";
$coordinates['Tunisia']['35.667:10.100'] = "Kairouan";
$coordinates['Tunisia']['35.667:10.750'] = "Monastir-Skanes";
$coordinates['Tunisia']['36.483:8.800'] = "Jendouba";
$coordinates['Tunisia']['36.833:10.233'] = "Tunis-Carthage";
$coordinates['Tunisia']['36.850:11.083'] = "Kelibia";
$coordinates['Tunisia']['36.950:8.750'] = "Tabarka";
$coordinates['Tunisia']['37.250:9.800'] = "Bizerte";
$coordinates['Turkey']['36.583:36.167'] = "Iskenderun";
$coordinates['Turkey']['36.700:28.783'] = "Dalaman";
$coordinates['Turkey']['36.700:30.733'] = "Antalya";
$coordinates['Turkey']['36.983:35.300'] = "Adana / Sakirpasa";
$coordinates['Turkey']['37.000:35.417'] = "Adana / Incirlik";
$coordinates['Turkey']['37.033:27.417'] = "Bodrum";
$coordinates['Turkey']['37.083:37.367'] = "Gaziantep";
$coordinates['Turkey']['37.133:38.767'] = "Urfa";
$coordinates['Turkey']['37.750:30.550'] = "Isparta";
$coordinates['Turkey']['37.850:27.850'] = "Aydin";
$coordinates['Turkey']['37.867:41.167'] = "Batman";
$coordinates['Turkey']['37.883:40.183'] = "Diyarbakir";
$coordinates['Turkey']['37.967:32.550'] = "Konya";
$coordinates['Turkey']['38.267:27.150'] = "Izmir / Adnan Menderes";
$coordinates['Turkey']['38.433:38.083'] = "Malatya / Erhac";
$coordinates['Turkey']['38.450:43.317'] = "Van";
$coordinates['Turkey']['38.500:27.017'] = "Izmir / Cigli";
$coordinates['Turkey']['38.600:39.283'] = "Elazig";
$coordinates['Turkey']['38.667:29.417'] = "Usak";
$coordinates['Turkey']['38.750:30.533'] = "Afyon";
$coordinates['Turkey']['38.783:35.483'] = "Kayseri / Erkilet";
$coordinates['Turkey']['38.917:27.850'] = "Akhisar";
$coordinates['Turkey']['39.617:27.917'] = "Balikesir";
$coordinates['Turkey']['39.733:39.500'] = "Erzincan";
$coordinates['Turkey']['39.750:37.017'] = "Sivas";
$coordinates['Turkey']['39.783:30.567'] = "Eskisehir";
$coordinates['Turkey']['39.917:41.267'] = "Erzurum";
$coordinates['Turkey']['39.950:32.683'] = "Ankara / Etimesgut";
$coordinates['Turkey']['40.083:32.567'] = "Murted Tur-Afb";
$coordinates['Turkey']['40.117:32.983'] = "Ankara / Esenboga";
$coordinates['Turkey']['40.133:26.400'] = "Canakkale";
$coordinates['Turkey']['40.183:29.067'] = "Bursa";
$coordinates['Turkey']['40.300:36.567'] = "Tokat";
$coordinates['Turkey']['40.317:27.967'] = "Bandirma";
$coordinates['Turkey']['40.600:43.083'] = "Kars";
$coordinates['Turkey']['40.850:35.583'] = "Merzifon";
$coordinates['Turkey']['40.967:28.817'] = "Istanbul / Ataturk";
$coordinates['Turkey']['41.000:39.717'] = "Trabzon";
$coordinates['Turkey']['41.267:36.300'] = "Samsun";
$coordinates['Turkey']['41.450:31.800'] = "Zonguldak";
$coordinates['Tuvalu']['-5.667:176.133'] = "Nanumea";
$coordinates['Tuvalu']['-8.517:179.217'] = "Funafuti";
$coordinates['Uganda']['0.050:32.450'] = "Entebbe Airport";
$coordinates['Uganda']['0.183:30.100'] = "Kasese";
$coordinates['Uganda']['0.450:33.183'] = "Jinja";
$coordinates['Uganda']['-0.617:30.650'] = "Mbarara";
$coordinates['Uganda']['0.683:34.167'] = "Tororo";
$coordinates['Uganda']['-1.250:29.983'] = "Kabale";
$coordinates['Uganda']['1.683:31.717'] = "Masindi";
$coordinates['Uganda']['1.717:33.617'] = "Soroti";
$coordinates['Uganda']['2.750:32.333'] = "Gulu";
$coordinates['Uganda']['3.050:30.917'] = "Arua";
$coordinates['Ukraine']['44.683:34.133'] = "Simferopol";
$coordinates['Ukraine']['46.433:30.767'] = "Odesa";
$coordinates['Ukraine']['49.817:23.950'] = "L'Viv";
$coordinates['Ukraine']['49.967:36.133'] = "Kharkiv";
$coordinates['Ukraine']['50.333:30.967'] = "Boryspil";
$coordinates['Ukraine']['50.400:30.567'] = "Kyiv";
$coordinates['Ukraine']['50.583:26.133'] = "Rivne";
$coordinates['United Arab Emirates']['24.267:55.600'] = "Al Ain International Airport";
$coordinates['United Arab Emirates']['24.433:54.467'] = "Abu Dhabi Bateen Airport";
$coordinates['United Arab Emirates']['24.433:54.650'] = "Abu Dhabi International Airport";
$coordinates['United Arab Emirates']['25.100:56.333'] = "Fujairah";
$coordinates['United Arab Emirates']['25.250:55.333'] = "Dubai International Airport";
$coordinates['United Arab Emirates']['25.333:55.517'] = "Sharjah International Airport";
$coordinates['United Arab Emirates']['25.617:55.933'] = "Ras Al Khaimah International Airport";
$coordinates['United Kingdom']['49.217:-2.200'] = "Jersey Airport";
$coordinates['United Kingdom']['49.433:-2.600'] = "Guernsey Airport";
$coordinates['United Kingdom']['49.917:-6.300'] = "Scilly, Saint Mary'S";
$coordinates['United Kingdom']['50.083:-5.250'] = "Culdrose";
$coordinates['United Kingdom']['50.350:-4.117'] = "Plymouth";
$coordinates['United Kingdom']['50.433:-5.000'] = "Saint Mawgan";
$coordinates['United Kingdom']['50.567:-2.450'] = "Portland / Rnas";
$coordinates['United Kingdom']['50.733:-3.417'] = "Exeter Airport";
$coordinates['United Kingdom']['50.783:-1.833'] = "Bournemouth Airport";
$coordinates['United Kingdom']['50.833:-0.283'] = "Shoreham Airport";
$coordinates['United Kingdom']['50.900:-1.400'] = "Southampton / Weather Centre";
$coordinates['United Kingdom']['51.000:-2.633'] = "Yeovilton";
$coordinates['United Kingdom']['51.083:-4.150'] = "Chivenor";
$coordinates['United Kingdom']['51.150:-0.183'] = "London / Gatwick Airport";
$coordinates['United Kingdom']['51.150:-1.567'] = "Middle Wallop";
$coordinates['United Kingdom']['51.167:-1.750'] = "Boscombe Down";
$coordinates['United Kingdom']['51.233:-0.950'] = "Odiham";
$coordinates['United Kingdom']['51.283:-0.767'] = "Farnborough Military";
$coordinates['United Kingdom']['51.283:-0.767'] = "Farnborough";
$coordinates['United Kingdom']['51.350:1.350'] = "Manston";
$coordinates['United Kingdom']['51.383:-0.783'] = "Bracknell / Beaufort Park";
$coordinates['United Kingdom']['51.400:-3.350'] = "Cardiff-Wales Airport";
$coordinates['United Kingdom']['51.483:-0.450'] = "London / Heathrow Airport";
$coordinates['United Kingdom']['51.500:-1.983'] = "Lyneham";
$coordinates['United Kingdom']['51.517:-0.117'] = "London Weather Centre";
$coordinates['United Kingdom']['51.550:-0.417'] = "Northolt";
$coordinates['United Kingdom']['51.617:-1.083'] = "Benson";
$coordinates['United Kingdom']['51.683:-1.783'] = "Fairford Royal Air Force Base";
$coordinates['United Kingdom']['51.717:-4.367'] = "Pembrey Sands";
$coordinates['United Kingdom']['51.750:-1.583'] = "Brize Norton";
$coordinates['United Kingdom']['51.883:0.233'] = "Stansted Airport";
$coordinates['United Kingdom']['52.117:0.967'] = "Wattisham";
$coordinates['United Kingdom']['52.133:-4.567'] = "Aberporth";
$coordinates['United Kingdom']['52.333:0.767'] = "Honington Royal Air Force Base";
$coordinates['United Kingdom']['52.350:-0.117'] = "Wyton Royal Air Force Base";
$coordinates['United Kingdom']['52.367:-0.217'] = "Alconbury Royal Air Force Base";
$coordinates['United Kingdom']['52.367:0.483'] = "Mildenhall Royal Air Force Base";
$coordinates['United Kingdom']['52.417:0.567'] = "Lakenheath Royal Air Force Base";
$coordinates['United Kingdom']['52.433:1.350'] = "Coltishall";
$coordinates['United Kingdom']['52.450:-1.733'] = "Birmingham / Airport";
$coordinates['United Kingdom']['52.617:-0.467'] = "Wittering";
$coordinates['United Kingdom']['52.633:1.300'] = "Norwich Weather Centre";
$coordinates['United Kingdom']['52.650:0.567'] = "Marham";
$coordinates['United Kingdom']['52.733:-0.650'] = "Cottesmore";
$coordinates['United Kingdom']['52.800:-2.667'] = "Shawbury";
$coordinates['United Kingdom']['52.867:0.150'] = "Holbeach";
$coordinates['United Kingdom']['53.033:-0.500'] = "Cranwell";
$coordinates['United Kingdom']['53.083:-0.167'] = "Coningsby Royal Air Force Base";
$coordinates['United Kingdom']['53.083:0.267'] = "Wainfleet";
$coordinates['United Kingdom']['53.167:-0.517'] = "Waddington";
$coordinates['United Kingdom']['53.167:-2.983'] = "Hawarden";
$coordinates['United Kingdom']['53.250:-4.533'] = "Valley";
$coordinates['United Kingdom']['53.350:-2.283'] = "Manchester Airport";
$coordinates['United Kingdom']['53.767:-3.033'] = "Blackpool Airport";
$coordinates['United Kingdom']['53.833:-1.200'] = "Church Fenton";
$coordinates['United Kingdom']['53.867:-0.433'] = "Leconfield";
$coordinates['United Kingdom']['54.050:-1.250'] = "Linton-On-Ouse";
$coordinates['United Kingdom']['54.083:-4.633'] = "Isle Of Man / Ronaldsway Airport";
$coordinates['United Kingdom']['54.117:-3.250'] = "Walney Island";
$coordinates['United Kingdom']['54.133:-1.417'] = "Disforth";
$coordinates['United Kingdom']['54.300:-1.533'] = "Leeming";
$coordinates['United Kingdom']['54.600:-5.883'] = "Belfast / Harbour";
$coordinates['United Kingdom']['54.650:-6.217'] = "Belfast / Aldergrove Airport";
$coordinates['United Kingdom']['54.850:-4.950'] = "West Freugh";
$coordinates['United Kingdom']['54.933:-2.950'] = "Carlisle";
$coordinates['United Kingdom']['55.050:-2.550'] = "Spadeadam";
$coordinates['United Kingdom']['55.417:-1.600'] = "Boulmer";
$coordinates['United Kingdom']['55.433:-5.700'] = "Machrihanish";
$coordinates['United Kingdom']['55.500:-4.583'] = "Prestwick Airport";
$coordinates['United Kingdom']['55.867:-4.433'] = "Glasgow Airport";
$coordinates['United Kingdom']['55.950:-3.350'] = "Edinburgh Airport";
$coordinates['United Kingdom']['56.383:-2.867'] = "Leuchars";
$coordinates['United Kingdom']['56.500:-6.883'] = "Tiree";
$coordinates['United Kingdom']['57.200:-2.217'] = "Aberdeen / Dyce";
$coordinates['United Kingdom']['57.467:-7.367'] = "Benbecula";
$coordinates['United Kingdom']['57.533:-4.050'] = "Inverness / Dalcross";
$coordinates['United Kingdom']['57.650:-3.567'] = "Kinloss";
$coordinates['United Kingdom']['57.717:-3.317'] = "Lossiemouth";
$coordinates['United Kingdom']['57.817:-3.967'] = "Tain Range";
$coordinates['United Kingdom']['58.217:-6.317'] = "Stornoway";
$coordinates['United Kingdom']['58.450:-3.083'] = "Wick";
$coordinates['United Kingdom']['58.950:-2.900'] = "Kirkwall Airport";
$coordinates['United Kingdom']['59.883:-1.300'] = "Sumburgh Cape";
$coordinates['United States Minor Outlying Islands']['-14.333:-170.717'] = "Pago Pago / Int. Airport";
$coordinates['United States Minor Outlying Islands']['16.733:-169.533'] = "Johnston Island, Johnston Atoll Airport";
$coordinates['United States']['13.483:144.800'] = "Agana, Guam International Airport, GU";
$coordinates['United States']['13.583:144.933'] = "Andersen (Mariana Is), Andersen Air Force Base, GU";
$coordinates['United States']['13.917:144.833'] = "Guam, Mariana Island, GU";
$coordinates['United States']['14.183:145.250'] = "Rota Island (N. Mariana Is), Rota International Airport, GU";
$coordinates['United States']['14.983:145.617'] = "Tinian Island (N. Mariana Is), West Tinian Airport, GU";
$coordinates['United States']['15.117:145.733'] = "Saipan Island, Saipan International Airport, Northern Mariana Islands";
$coordinates['United States']['18.255:-65.643'] = "Roosevelt Roads, Roosevelt Roads Naval Station (Ofstie Field), PR";
$coordinates['United States']['18.500:-67.133'] = "Aquadilla, Rafael Hernandez Airport, PR";
$coordinates['United States']['19.100:-155.750'] = "South Kona / Hawaii, HI";
$coordinates['United States']['19.283:166.650'] = "Wake Island, Wake Island Army Airfield Airport, GU";
$coordinates['United States']['19.722:-155.056'] = "Hilo, Hilo International Airport, HI";
$coordinates['United States']['20.892:-156.437'] = "Kahului, Kahului Airport, HI";
$coordinates['United States']['21.150:-157.100'] = "Molokai Automatic Meteorological Observing System, HI";
$coordinates['United States']['21.308:-158.068'] = "Oahu, Kalaeloa Airport, HI";
$coordinates['United States']['21.328:-157.943'] = "Honolulu, Honolulu International Airport, HI";
$coordinates['United States']['21.454:-157.766'] = "Kaneohe, Marine Corps Air Station, HI";
$coordinates['United States']['21.483:-158.033'] = "Wheeler Air Force Base / Oahu, HI";
$coordinates['United States']['21.984:-159.341'] = "Lihue, Lihue Airport, HI";
$coordinates['United States']['22.036:-159.786'] = "Kekaha, Pacific Missile Test Facility Barking Sands, HI";
$coordinates['United States']['24.554:-81.754'] = "Key West, Key West International Airport, FL";
$coordinates['United States']['25.791:-80.316'] = "Miami, Miami International Airport, FL";
$coordinates['United States']['25.914:-97.423'] = "Brownsville, Brownsville / South Padre Island International Airport, TX";
$coordinates['United States']['26.685:-80.099'] = "West Palm Beach, Palm Beach International Airport, FL";
$coordinates['United States']['27.550:-99.467'] = "Laredo International Airport, TX";
$coordinates['United States']['27.650:-81.333'] = "Avon Park Gunnery Range, FL";
$coordinates['United States']['27.700:-82.400'] = "Tampa Bay Area, FL";
$coordinates['United States']['27.773:-97.513'] = "Corpus Christi, Corpus Christi International Airport, TX";
$coordinates['United States']['27.850:-82.500'] = "Macdill Air Force Base, Fl., FL";
$coordinates['United States']['27.961:-82.540'] = "Tampa, Tampa International Airport, FL";
$coordinates['United States']['28.103:-80.646'] = "Melbourne, Melbourne International Airport, FL";
$coordinates['United States']['28.217:-177.367'] = "Sand Island, Henderson Field Airport, HI";
$coordinates['United States']['28.233:-80.600'] = "Cocoa / Patrick Air Force Base, FL";
$coordinates['United States']['28.417:-81.325'] = "Orlando, Orlando International Airport, FL";
$coordinates['United States']['28.467:-80.550'] = "Cape Kennedy, FL";
$coordinates['United States']['28.863:-96.930'] = "Victoria, Victoria Regional Airport, TX";
$coordinates['United States']['29.270:-94.864'] = "Galveston, Scholes Field, TX";
$coordinates['United States']['29.333:-89.400'] = "Boothville, LA";
$coordinates['United States']['29.375:-100.924'] = "Del Rio, Del Rio International Airport, TX";
$coordinates['United States']['29.533:-98.464'] = "San Antonio, San Antonio International Airport, TX";
$coordinates['United States']['29.550:-83.105'] = "Cross City, Cross City Airport, FL";
$coordinates['United States']['29.727:-85.025'] = "Apalachicola, Apalachicola, FL";
$coordinates['United States']['29.951:-94.021'] = "Beaumont / Port Arthur, Southeast Texas Regional Airport, TX";
$coordinates['United States']['29.992:-95.364'] = "Houston, Houston Intercontinental Airport, TX";
$coordinates['United States']['29.993:-90.251'] = "New Orleans, New Orleans International Airport, LA";
$coordinates['United States']['30.067:-85.583'] = "Tyndall Air Force Base, FL";
$coordinates['United States']['30.126:-93.223'] = "Lake Charles, Lake Charles Regional Airport, LA";
$coordinates['United States']['30.167:-102.417'] = "Sanderson, TX";
$coordinates['United States']['30.333:-89.817'] = "Slidell, LA";
$coordinates['United States']['30.367:-104.017'] = "Marfa, TX";
$coordinates['United States']['30.393:-84.353'] = "Tallahassee, Tallahassee Regional Airport, FL";
$coordinates['United States']['30.417:-86.683'] = "Hurlburt Field, FL";
$coordinates['United States']['30.483:-86.517'] = "Valparaiso / Eglin Air Force Base, FL";
$coordinates['United States']['30.494:-81.693'] = "Jacksonville, Jacksonville International Airport, FL";
$coordinates['United States']['30.511:-99.766'] = "Junction, Kimble County Airport, TX";
$coordinates['United States']['30.688:-88.246'] = "Mobile, Mobile Regional Airport, AL";
$coordinates['United States']['30.967:-83.200'] = "Moody Air Force Base, GA";
$coordinates['United States']['31.033:-93.033'] = "Fort Polk, LA";
$coordinates['United States']['31.100:-97.333'] = "Fort Hood, TX";
$coordinates['United States']['31.133:-92.567'] = "Claiborne Range, Airways Facilities Sector, LA";
$coordinates['United States']['31.250:-82.400'] = "Waycross / Ware County, Ga, GA";
$coordinates['United States']['31.335:-92.559'] = "Alexandria, Alexandria International Airport, LA";
$coordinates['United States']['31.351:-100.494'] = "San Angelo, Mathis Field, TX";
$coordinates['United States']['31.536:-84.194'] = "Albany, Southwest Georgia Regional Airport, GA";
$coordinates['United States']['31.583:-110.333'] = "Fort Huachuca, AZ";
$coordinates['United States']['31.617:-97.228'] = "Waco, Waco Regional Airport, TX";
$coordinates['United States']['31.811:-106.376'] = "El Paso, El Paso International Airport, TX";
$coordinates['United States']['31.831:-104.809'] = "Pine Springs, Guadalupe Mountains National Park, TX";
$coordinates['United States']['31.867:-106.700'] = "Santa Teresa, NM";
$coordinates['United States']['31.883:-81.567'] = "Ft. Stewart, GA";
$coordinates['United States']['31.948:-102.209'] = "Midland, Midland International Airport, TX";
$coordinates['United States']['32.119:-81.202'] = "Savannah, Savannah International Airport, GA";
$coordinates['United States']['32.131:-110.955'] = "Tucson, Tucson International Airport, AZ";
$coordinates['United States']['32.217:-98.183'] = "Stephenville / Clark Field Municipal, Tx., TX";
$coordinates['United States']['32.300:-86.406'] = "Montgomery, Dannelly Field, AL";
$coordinates['United States']['32.320:-90.078'] = "Jackson, Jackson International Airport, MS";
$coordinates['United States']['32.333:-84.833'] = "Fort Benning, GA";
$coordinates['United States']['32.338:-88.748'] = "Meridian, Key Field, MS";
$coordinates['United States']['32.383:-106.483'] = "White Sands, NM";
$coordinates['United States']['32.391:-94.714'] = "Longview, Gregg County Airport, TX";
$coordinates['United States']['32.410:-99.682'] = "Abilene, Abilene Regional Airport, TX";
$coordinates['United States']['32.433:-112.683'] = "Gila Bend U. S. Army Airfield, AZ";
$coordinates['United States']['32.447:-93.824'] = "Shreveport, Shreveport Regional Airport, LA";
$coordinates['United States']['32.633:-108.150'] = "Silver City / Grant, NM";
$coordinates['United States']['32.650:-114.600'] = "Yuma / Yuma International, AZ";
$coordinates['United States']['32.688:-83.654'] = "Macon, Middle Georgia Regional Airport, GA";
$coordinates['United States']['32.734:-117.183'] = "San Diego, San Diego International-Lindbergh Field, CA";
$coordinates['United States']['32.825:-115.661'] = "El Centro, Naval Air Facility, CA";
$coordinates['United States']['32.833:-97.300'] = "Fort Worth, TX";
$coordinates['United States']['32.850:-106.100'] = "Holloman Air Force Base, NM";
$coordinates['United States']['32.868:-117.143'] = "San Diego, Miramar MCAS/Mitscher Field Airport, CA";
$coordinates['United States']['32.897:-97.022'] = "Dallas / Fort Worth, Dallas / Fort Worth International Airport, TX";
$coordinates['United States']['32.899:-80.041'] = "Charleston, Charleston Air Force Base, SC";
$coordinates['United States']['32.900:-87.250'] = "Centreville, AL";
$coordinates['United States']['33.235:-119.453'] = "San Nicholas Island, CA";
$coordinates['United States']['33.237:-107.268'] = "Truth Or Consequences, Truth Or Consequences Municipal Airport, NM";
$coordinates['United States']['33.308:-104.508'] = "Roswell, Roswell Industrial Air Center Airport, NM";
$coordinates['United States']['33.364:-81.963'] = "Augusta, Bush Field, GA";
$coordinates['United States']['33.405:-118.416'] = "Avalon, Catalina Airport, CA";
$coordinates['United States']['33.434:-112.051'] = "Phoenix, Phoenix Sky Harbor International Airport, AZ";
$coordinates['United States']['33.566:-86.745'] = "Birmingham, Birmingham International Airport, AL";
$coordinates['United States']['33.630:-84.442'] = "Atlanta, Hartsfield Atlanta International Airport, GA";
$coordinates['United States']['33.667:-101.821'] = "Lubbock, Lubbock International Airport, TX";
$coordinates['United States']['33.683:-78.933'] = "Myrtle Beach Air Force Base, SC";
$coordinates['United States']['33.812:-118.146'] = "Long Beach, Long Beach Airport, CA";
$coordinates['United States']['33.850:-80.483'] = "Poinsett Range, Sumpter, SC";
$coordinates['United States']['33.900:-106.400'] = "Northrup Landing Strip, NM";
$coordinates['United States']['33.900:-117.250'] = "Riverside / March Air Force Base, CA";
$coordinates['United States']['33.917:-84.517'] = "Marietta / Dobbins Air Force Base, GA";
$coordinates['United States']['33.938:-118.389'] = "Los Angeles, Los Angeles International Airport, CA";
$coordinates['United States']['33.942:-81.118'] = "Columbia, Columbia Metropolitan Airport, SC";
$coordinates['United States']['33.951:-83.328'] = "Athens, Athens Airport, GA";
$coordinates['United States']['33.967:-80.483'] = "Shaw Air Force Base, SC";
$coordinates['United States']['33.979:-98.493'] = "Wichita Falls, Sheppard Air Force Base, TX";
$coordinates['United States']['34.017:-106.900'] = "Socorro Municipal, NM";
$coordinates['United States']['34.124:-119.122'] = "Point Mugu, Naval Air Warfare Center, CA";
$coordinates['United States']['34.200:-118.365'] = "Burbank, Burbank-Glendale-Pasadena Airport, CA";
$coordinates['United States']['34.233:-118.067'] = "Mount Wilson, CA";
$coordinates['United States']['34.268:-88.770'] = "Tupelo, Tupelo Regional Airport, MS";
$coordinates['United States']['34.300:-103.800'] = "Melrose Gunnery Range, NM";
$coordinates['United States']['34.348:-85.161'] = "Rome, R. B. Russell Airport, GA";
$coordinates['United States']['34.517:-96.983'] = "Sulphur Municipal, OK";
$coordinates['United States']['34.600:-98.400'] = "Fort Sill, OK";
$coordinates['United States']['34.630:-118.081'] = "Palmdale, Palmdale Production Flight Plant, CA";
$coordinates['United States']['34.644:-86.786'] = "Huntsville, Huntsville International / Jones Field, AL";
$coordinates['United States']['34.650:-99.267'] = "Altus Air Force Base, OK";
$coordinates['United States']['34.739:-92.278'] = "Little Rock, Heights, AR";
$coordinates['United States']['34.744:-118.724'] = "Sandberg, CA";
$coordinates['United States']['34.750:-120.567'] = "Vandenberg Air Force Base, CA";
$coordinates['United States']['34.783:-76.883'] = "Newport, NC";
$coordinates['United States']['34.833:-92.250'] = "North Little Rock, North Little Rock Airport, AR";
$coordinates['United States']['34.884:-82.221'] = "Greer, Greenville-Spartanburg Airport, SC";
$coordinates['United States']['34.898:-76.881'] = "Cherry Point, Marine Corps Air Station, NC";
$coordinates['United States']['34.899:-120.449'] = "Santa Maria, Santa Maria Public Airport, CA";
$coordinates['United States']['34.917:-117.900'] = "Edwards Air Force Base, CA";
$coordinates['United States']['35.028:-110.721'] = "Winslow, Winslow Municipal Airport, AZ";
$coordinates['United States']['35.033:-85.200'] = "Chattanooga, Lovell Field, TN";
$coordinates['United States']['35.042:-106.615'] = "Albuquerque, Albuquerque International Airport, NM";
$coordinates['United States']['35.061:-89.985'] = "Memphis, Memphis International Airport, TN";
$coordinates['United States']['35.133:-78.933'] = "Fort Bragg / Simmons Army Airfield, NC";
$coordinates['United States']['35.150:-75.300'] = "Diamond Shoals Coast Guard Station, NC";
$coordinates['United States']['35.167:-79.033'] = "Pope Air Force Base, NC";
$coordinates['United States']['35.213:-80.949'] = "Charlotte, Charlotte / Douglas International Airport, NC";
$coordinates['United States']['35.217:-97.450'] = "Norman / Max Westheimer, OK";
$coordinates['United States']['35.220:-101.717'] = "Amarillo, Amarillo International Airport, TX";
$coordinates['United States']['35.258:-113.933'] = "Kingman, Kingman Airport, AZ";
$coordinates['United States']['35.259:-93.093'] = "Russellville, Russellville Regional Airport, AR";
$coordinates['United States']['35.267:-117.433'] = "Cuddleback Gunnery Range, CA";
$coordinates['United States']['35.267:-75.550'] = "Cape Hatteras, NC";
$coordinates['United States']['35.283:-116.617'] = "Bicycle Lake U. S. Army Airfield, Ca, CA";
$coordinates['United States']['35.334:-94.365'] = "Fort Smith, Fort Smith Regional Airport, AR";
$coordinates['United States']['35.389:-97.600'] = "Oklahoma City, Will Rogers World Airport, OK";
$coordinates['United States']['35.400:-96.017'] = "Henryetta Municipal, OK";
$coordinates['United States']['35.417:-97.383'] = "Tinker Air Force Base, OK";
$coordinates['United States']['35.432:-82.537'] = "Asheville, Asheville Regional Airport, NC";
$coordinates['United States']['35.434:-119.057'] = "Bakersfield, Meadows Field Airport, CA";
$coordinates['United States']['35.650:-109.067'] = "Window Rock, Window Rock Airport, AZ";
$coordinates['United States']['35.666:-121.285'] = "Point Piedras Blanca, CA";
$coordinates['United States']['35.667:-75.900'] = "Dare County Gunnery Range, NC";
$coordinates['United States']['35.686:-117.690'] = "China Lake, Naval Air Facility, CA";
$coordinates['United States']['35.818:-83.986'] = "Knoxville, McGhee Tyson Airport, TN";
$coordinates['United States']['35.871:-78.786'] = "Raleigh / Durham, Raleigh-Durham International Airport, NC";
$coordinates['United States']['36.079:-115.155'] = "Las Vegas, McCarran International Airport, NV";
$coordinates['United States']['36.098:-79.944'] = "Greensboro, Piedmont Triad International Airport, NC";
$coordinates['United States']['36.119:-86.689'] = "Nashville, Nashville International Airport, TN";
$coordinates['United States']['36.197:-95.886'] = "Tulsa, Tulsa International Airport, OK";
$coordinates['United States']['36.304:-119.938'] = "Lemoore, Naval Air Station, CA";
$coordinates['United States']['36.333:-117.100'] = "Superior Valley Gunnery Range, CA";
$coordinates['United States']['36.433:-96.383'] = "Hominy Municipal, OK";
$coordinates['United States']['36.437:-99.521'] = "Woodward, West Woodward Airport, OK";
$coordinates['United States']['36.448:-103.153'] = "Clayton, Clayton Municipal Airpark, NM";
$coordinates['United States']['36.533:-115.900'] = "Indian Springs Gunnery Range, NV";
$coordinates['United States']['36.621:-116.028'] = "Mercury, Desert Rock Airport, NV";
$coordinates['United States']['36.667:-87.500'] = "Fort Campbell U. S. Army Airfield, KY";
$coordinates['United States']['36.780:-119.719'] = "Fresno, Fresno Air Terminal, CA";
$coordinates['United States']['36.904:-76.192'] = "Norfolk, Norfolk International Airport, VA";
$coordinates['United States']['36.921:-111.448'] = "Page, Page Municipal Airport, AZ";
$coordinates['United States']['37.000:-101.883'] = "Elkhart / Elkhart-Morton County Airport, KS";
$coordinates['United States']['37.056:-88.774'] = "Paducah, Barkley Regional Airport, KY";
$coordinates['United States']['37.083:-76.350'] = "Langley Air Force Base, VA";
$coordinates['United States']['37.240:-93.390'] = "Springfield, Springfield Regional Airport, MO";
$coordinates['United States']['37.284:-98.553'] = "Medicine Lodge, Medicine Lodge, KS";
$coordinates['United States']['37.317:-79.974'] = "Roanoke, Roanoke Regional Airport, VA";
$coordinates['United States']['37.321:-79.207'] = "Lynchburg, Lynchburg Regional Airport, VA";
$coordinates['United States']['37.367:-120.567'] = "Merced / Castle Air Force Base, CA";
$coordinates['United States']['37.371:-118.358'] = "Bishop, Bishop Airport, CA";
$coordinates['United States']['37.406:-122.048'] = "Mountain View, Moffett Field, CA";
$coordinates['United States']['37.439:-105.861'] = "Alamosa, San Luis Valley Regional Airport, CO";
$coordinates['United States']['37.511:-77.323'] = "Richmond, Richmond International Airport, VA";
$coordinates['United States']['37.612:-114.526'] = "Caliente, NV";
$coordinates['United States']['37.620:-122.365'] = "San Francisco, San Francisco International Airport, CA";
$coordinates['United States']['37.647:-97.429'] = "Wichita, Wichita Mid-Continent Airport, KS";
$coordinates['United States']['37.700:-123.000'] = "Farallon Island, CA";
$coordinates['United States']['37.700:-98.750'] = "Pratt Municipal, KS";
$coordinates['United States']['37.719:-122.235'] = "Oakland, Metro Oakland International Airport, CA";
$coordinates['United States']['37.773:-99.970'] = "Dodge City, Dodge City Regional Airport, KS";
$coordinates['United States']['37.783:-122.317'] = "Alameda Naval Air Station, CA";
$coordinates['United States']['37.795:-81.125'] = "Beckley, Raleigh County Memorial Airport, WV";
$coordinates['United States']['37.890:-121.224'] = "Stockton, Stockton Metropolitan Airport, CA";
$coordinates['United States']['37.900:-85.967'] = "Fort Knox, KY";
$coordinates['United States']['37.941:-75.463'] = "Wallops Island, Wallops Flight Facility Airport, VA";
$coordinates['United States']['38.041:-84.606'] = "Lexington, Blue Grass Airport, KY";
$coordinates['United States']['38.043:-87.520'] = "Evansville, Evansville Regional Airport, IN";
$coordinates['United States']['38.177:-85.730'] = "Louisville, Standiford Field, KY";
$coordinates['United States']['38.267:-121.950'] = "Fairfield / Travis Air Force Base, CA";
$coordinates['United States']['38.279:-76.414'] = "Patuxent River, Naval Air Station, MD";
$coordinates['United States']['38.290:-104.498'] = "Pueblo, Pueblo Memorial Airport, CO";
$coordinates['United States']['38.333:-75.083'] = "Ocean City, MD";
$coordinates['United States']['38.365:-82.555'] = "Huntington, Tri-State Airport, WV";
$coordinates['United States']['38.379:-81.591'] = "Charleston, Yeager Airport, WV";
$coordinates['United States']['38.507:-121.495'] = "Sacramento, Sacramento Executive Airport, CA";
$coordinates['United States']['38.643:-88.964'] = "Salem, Salem-Leckrone Airport, IL";
$coordinates['United States']['38.700:-104.767'] = "Fort Carson, CO";
$coordinates['United States']['38.752:-90.374'] = "St. Louis, Lambert-St. Louis International Airport, MO";
$coordinates['United States']['38.816:-104.711'] = "Colorado Springs, City Of Colorado Springs Municipal Airport, CO";
$coordinates['United States']['38.817:-76.850'] = "Camp Springs / Andrews Air Force Base, MD";
$coordinates['United States']['38.817:-92.218'] = "Columbia, Columbia Regional Airport, MO";
$coordinates['United States']['38.848:-77.034'] = "Washington DC, Reagan National Airport, VA";
$coordinates['United States']['38.885:-79.853'] = "Elkins, Elkins-Randolph County-Jennings Randolph Field, WV";
$coordinates['United States']['38.935:-77.448'] = "Washington DC, Washington-Dulles International Airport, VA";
$coordinates['United States']['38.967:-104.817'] = "Air Force Academy, CO";
$coordinates['United States']['39.043:-84.672'] = "Covington / Cincinnati, Cincinnati / Northern Kentucky International Airport, KY";
$coordinates['United States']['39.073:-95.626'] = "Topeka, Philip Billard Municipal Airport, KS";
$coordinates['United States']['39.100:-96.767'] = "Fort Riley, KS";
$coordinates['United States']['39.134:-108.539'] = "Grand Junction, Walker Field, CO";
$coordinates['United States']['39.167:-76.683'] = "Baltimore, Baltimore-Washington International Airport, MD";
$coordinates['United States']['39.295:-114.845'] = "Ely, Ely Airport, NV";
$coordinates['United States']['39.297:-94.731'] = "Kansas City, Kansas City International Airport, MO";
$coordinates['United States']['39.367:-101.693'] = "Goodland, Renner Field, KS";
$coordinates['United States']['39.400:-123.817'] = "Fort Bragg, CA";
$coordinates['United States']['39.465:-74.587'] = "Atlantic City, Atlantic City International Airport, NJ";
$coordinates['United States']['39.484:-119.771'] = "Reno, Reno Tahoe International Airport, NV";
$coordinates['United States']['39.551:-97.651'] = "Concordia, Blosser Municipal Airport, KS";
$coordinates['United States']['39.609:-110.755'] = "Price, Carbon County Airport, UT";
$coordinates['United States']['39.725:-86.282'] = "Indianapolis, Indianapolis International Airport, IN";
$coordinates['United States']['39.767:-74.100'] = "Barnegat Coast Guard Station, NJ";
$coordinates['United States']['39.768:-94.909'] = "St. Joseph, Rosecrans Memorial Airport, MO";
$coordinates['United States']['39.783:-104.867'] = "Denver / Stapleton International, Co., CO";
$coordinates['United States']['39.833:-104.657'] = "Denver, Denver International Airport, CO";
$coordinates['United States']['39.833:-84.050'] = "Dayton / Wright-Patterson Air Force Base, OH";
$coordinates['United States']['39.845:-89.684'] = "Springfield, Capital Airport, IL";
$coordinates['United States']['39.868:-75.231'] = "Philadelphia, Philadelphia International Airport, PA";
$coordinates['United States']['39.906:-84.219'] = "Dayton, Cox Dayton International Airport, OH";
$coordinates['United States']['39.995:-82.876'] = "Columbus, Port Columbus International Airport, OH";
$coordinates['United States']['40.033:-74.317'] = "Lakehurst Naval Air Station, NJ";
$coordinates['United States']['40.151:-122.252'] = "Red Bluff, Red Bluff Municipal Airport, CA";
$coordinates['United States']['40.167:-112.933'] = "Dugway Proving Grounds, UT";
$coordinates['United States']['40.250:-93.717'] = "Spickard, MO";
$coordinates['United States']['40.300:-109.983'] = "Roosevelt, UT";
$coordinates['United States']['40.493:-107.524'] = "Craig, Craig-Moffat Airport, CO";
$coordinates['United States']['40.504:-80.266'] = "Pittsburgh, Pittsburgh International Airport, PA";
$coordinates['United States']['40.515:-122.297'] = "Redding, Redding Municipal Airport, CA";
$coordinates['United States']['40.639:-73.762'] = "New York, Kennedy International Airport, NY";
$coordinates['United States']['40.651:-75.449'] = "Allentown, Lehigh Valley International Airport, PA";
$coordinates['United States']['40.667:-89.684'] = "Peoria, Greater Peoria Regional Airport, IL";
$coordinates['United States']['40.682:-74.169'] = "Newark, Newark International Airport, NJ";
$coordinates['United States']['40.733:-114.033'] = "Wendover / Air Force Auxillary Field, UT";
$coordinates['United States']['40.778:-111.969'] = "Salt Lake City, Salt Lake City International Airport, UT";
$coordinates['United States']['40.779:-73.880'] = "New York, La Guardia Airport, NY";
$coordinates['United States']['40.800:-124.167'] = "Eureka, CA";
$coordinates['United States']['40.831:-96.764'] = "Lincoln, Lincoln Municipal Airport, NE";
$coordinates['United States']['40.902:-117.807'] = "Winnemucca, Winnemucca Municipal Airport, NV";
$coordinates['United States']['40.918:-81.443'] = "Akron, Akron-Canton Regional Airport, OH";
$coordinates['United States']['40.958:-98.313'] = "Grand Island, Central Nebraska Regional Airport, NE";
$coordinates['United States']['40.978:-85.195'] = "Fort Wayne, Fort Wayne International Airport, IN";
$coordinates['United States']['41.099:-102.986'] = "Sidney, Sidney Municipal Airport, NE";
$coordinates['United States']['41.117:-95.900'] = "Omaha / Offutt Air Force Base, NE";
$coordinates['United States']['41.122:-100.668'] = "North Platte, North Platte Regional Airport, NE";
$coordinates['United States']['41.158:-104.807'] = "Cheyenne, Cheyenne Airport, WY";
$coordinates['United States']['41.158:-73.129'] = "Bridgeport, Sikorsky Memorial Airport, CT";
$coordinates['United States']['41.194:-112.016'] = "Ogden, Ogden-Hinckley Airport, UT";
$coordinates['United States']['41.243:-76.922'] = "Williamsport, Williamsport-Lycoming County Airport, PA";
$coordinates['United States']['41.254:-80.674'] = "Youngstown, Youngstown-Warren Regional Airport, OH";
$coordinates['United States']['41.310:-95.899'] = "Omaha, Eppley Airfield, NE";
$coordinates['United States']['41.317:-96.367'] = "Valley, NE";
$coordinates['United States']['41.339:-75.727'] = "Wilkes-Barre - Scranton, Wilkes-Barre / Scranton International Airport, PA";
$coordinates['United States']['41.367:-88.683'] = "Marseilles Island, IL";
$coordinates['United States']['41.405:-81.853'] = "Cleveland, Cleveland-Hopkins International Airport, OH";
$coordinates['United States']['41.451:-90.515'] = "Moline, Quad-City Airport, IL";
$coordinates['United States']['41.538:-93.666'] = "Des Moines, Des Moines International Airport, IA";
$coordinates['United States']['41.589:-83.801'] = "Toledo, Toledo Express Airport, OH";
$coordinates['United States']['41.594:-109.065'] = "Rock Springs, Rock Springs-Sweetwater County Airport, WY";
$coordinates['United States']['41.650:-70.517'] = "Otis Air National Guard Base, MA";
$coordinates['United States']['41.667:-69.967'] = "Chatham, MA";
$coordinates['United States']['41.709:-86.319'] = "South Bend, South Bend Regional Airport, IN";
$coordinates['United States']['41.724:-71.428'] = "Providence, Theodore Francis Green State Airport, RI";
$coordinates['United States']['41.784:-87.755'] = "Chicago, Chicago Midway Airport, IL";
$coordinates['United States']['41.867:-103.586'] = "Scottsbluff, Heilig Field, NE";
$coordinates['United States']['41.883:-91.724'] = "Cedar Rapids, Cedar Rapids Municipal Airport, IA";
$coordinates['United States']['41.938:-72.683'] = "Windsor Locks, Bradley International Airport, CT";
$coordinates['United States']['41.980:-87.904'] = "Chicago, Chicago-O'Hare International Airport, IL";
$coordinates['United States']['41.981:-97.437'] = "Norfolk, Stefan Memorial Airport, NE";
$coordinates['United States']['42.080:-80.183'] = "Erie, Erie International Airport, PA";
$coordinates['United States']['42.193:-89.093'] = "Rockford, Greater Rockford Airport, IL";
$coordinates['United States']['42.200:-72.533'] = "Chicopee Falls / Westover Air Force Base, MA";
$coordinates['United States']['42.208:-75.981'] = "Binghamton, Binghamton Regional Airport, NY";
$coordinates['United States']['42.231:-83.331'] = "Detroit, Detroit Metropolitan Wayne County Airport, MI";
$coordinates['United States']['42.361:-71.011'] = "Boston, Logan International Airport, MA";
$coordinates['United States']['42.381:-122.872'] = "Medford, Rogue Valley International Airport, OR";
$coordinates['United States']['42.398:-90.704'] = "Dubuque, Dubuque Regional Airport, IA";
$coordinates['United States']['42.402:-96.384'] = "Sioux City, Sioux Gateway Airport, IA";
$coordinates['United States']['42.468:-71.294'] = "Bedford, Hanscom Field, MA";
$coordinates['United States']['42.550:-94.183'] = "Fort Dodge, IA";
$coordinates['United States']['42.554:-92.401'] = "Waterloo, Waterloo Municipal Airport, IA";
$coordinates['United States']['42.579:-110.103'] = "Big Piney, Big Piney-Marbleton Airport, WY";
$coordinates['United States']['42.747:-73.799'] = "Albany, Albany County Airport, NY";
$coordinates['United States']['42.780:-84.579'] = "Lansing, Capital City Airport, MI";
$coordinates['United States']['42.794:-105.382'] = "Douglas, Converse County Airport, WY";
$coordinates['United States']['42.815:-108.728'] = "Lander, WY";
$coordinates['United States']['42.859:-100.551'] = "Valentine, Miller Field, NE";
$coordinates['United States']['42.881:-85.523'] = "Grand Rapids, Gerald R. Ford International Airport, MI";
$coordinates['United States']['42.898:-106.473'] = "Casper, Natrona County International Airport, WY";
$coordinates['United States']['42.920:-112.571'] = "Pocatello, Pocatello Regional Airport, ID";
$coordinates['United States']['42.941:-78.736'] = "Buffalo, Greater Buffalo International Airport, NY";
$coordinates['United States']['42.955:-87.904'] = "Milwaukee, General Mitchell International Airport, WI";
$coordinates['United States']['42.967:-83.749'] = "Flint, Bishop International Airport, MI";
$coordinates['United States']['43.062:-108.446'] = "Riverton, Riverton Regional Airport, WY";
$coordinates['United States']['43.109:-76.103'] = "Syracuse, Syracuse Hancock International Airport, NY";
$coordinates['United States']['43.117:-77.677'] = "Rochester, Greater Rochester International Airport, NY";
$coordinates['United States']['43.141:-89.345'] = "Madison, Dane County Regional-Truax Field, WI";
$coordinates['United States']['43.171:-86.237'] = "Muskegon, Muskegon County Airport, MI";
$coordinates['United States']['43.195:-71.501'] = "Concord, Concord Municipal Airport, NH";
$coordinates['United States']['43.391:-99.843'] = "Winner, Bob Wiley Field Airport, SD";
$coordinates['United States']['43.567:-116.241'] = "Boise, Boise Air Terminal, ID";
$coordinates['United States']['43.577:-96.754'] = "Sioux Falls, Foss Field, SD";
$coordinates['United States']['43.595:-118.956'] = "Burns, Burns Municipal Airport, OR";
$coordinates['United States']['43.642:-70.304'] = "Portland, Portland International Jetport, ME";
$coordinates['United States']['43.767:-99.318'] = "Chamberlain, Chamberlain Municipal Airport, SD";
$coordinates['United States']['43.879:-91.257'] = "La Crosse, La Crosse Municipal Airport, WI";
$coordinates['United States']['43.900:-69.935'] = "Brunswick, Naval Air Station, ME";
$coordinates['United States']['43.904:-92.492'] = "Rochester, Rochester International Airport, MN";
$coordinates['United States']['44.046:-103.054'] = "Rapid City, Rapid City Regional Airport, SD";
$coordinates['United States']['44.050:-75.733'] = "Fort Drum / Wheeler-Sack U. S. Army Airfield, NY";
$coordinates['United States']['44.133:-123.214'] = "Eugene, Mahlon Sweet Field, OR";
$coordinates['United States']['44.267:-71.300'] = "Mount Washington, NH";
$coordinates['United States']['44.339:-105.542'] = "Gillette, Gillette-Campbell County Airport, WY";
$coordinates['United States']['44.351:-84.674'] = "Houghton Lake, Roscommon County Airport, MI";
$coordinates['United States']['44.388:-98.228'] = "Huron, Huron Regional Airport, SD";
$coordinates['United States']['44.419:-72.019'] = "Saint Johnsbury, VT";
$coordinates['United States']['44.468:-73.150'] = "Burlington, Burlington International Airport, VT";
$coordinates['United States']['44.479:-88.137'] = "Green Bay, Austin Straubel International Airport, WI";
$coordinates['United States']['44.517:-109.017'] = "Cody, WY";
$coordinates['United States']['44.533:-70.533'] = "Rumford, ME";
$coordinates['United States']['44.576:-71.179'] = "Berlin, Berlin Municipal Airport, NH";
$coordinates['United States']['44.769:-106.969'] = "Sheridan, Sheridan County Airport, WY";
$coordinates['United States']['44.833:-84.550'] = "Graying Air Force Range, MI";
$coordinates['United States']['44.883:-93.229'] = "Minneapolis, Minneapolis-St. Paul International Airport, MN";
$coordinates['United States']['44.908:-122.995'] = "Salem, McNary Field, OR";
$coordinates['United States']['44.917:-67.000'] = "Eastport, ME";
$coordinates['United States']['44.933:-72.200'] = "Newport, VT";
$coordinates['United States']['45.072:-83.564'] = "Alpena, Alpena County Regional Airport, MI";
$coordinates['United States']['45.443:-98.413'] = "Aberdeen, Aberdeen Regional Airport, SD";
$coordinates['United States']['45.545:-94.052'] = "St. Cloud, St. Cloud Municipal Airport, MN";
$coordinates['United States']['45.591:-122.600'] = "Portland, Portland International Airport, OR";
$coordinates['United States']['45.698:-118.834'] = "Pendleton, Eastern Oregon Regional At Pendleton Airport, OR";
$coordinates['United States']['45.750:-87.033'] = "Escanaba, MI";
$coordinates['United States']['45.807:-108.542'] = "Billings, Billings Logan International Airport, MT";
$coordinates['United States']['45.933:-90.450'] = "Park Falls, WI";
$coordinates['United States']['46.157:-123.882'] = "Astoria, Astoria Regional Airport, OR";
$coordinates['United States']['46.375:-117.014'] = "Lewiston, Lewiston-Nez Perce County Airport, ID";
$coordinates['United States']['46.428:-105.886'] = "Miles City, Frank Wiley Field Airport, MT";
$coordinates['United States']['46.479:-84.357'] = "Sault Ste. Marie, MI";
$coordinates['United States']['46.533:-87.550'] = "Marquette, MI";
$coordinates['United States']['46.564:-120.534'] = "Yakima, Yakima Air Terminal, WA";
$coordinates['United States']['46.567:-119.600'] = "Hanford, WA";
$coordinates['United States']['46.600:-94.317'] = "Pequot Lake, MN";
$coordinates['United States']['46.606:-111.964'] = "Helena, Helena Regional Airport, MT";
$coordinates['United States']['46.683:-68.050'] = "Presque Isle, ME";
$coordinates['United States']['46.782:-100.757'] = "Bismarck, Bismarck Municipal Airport, ND";
$coordinates['United States']['46.843:-92.226'] = "Duluth, Duluth International Airport, MN";
$coordinates['United States']['46.867:-68.013'] = "Caribou, Caribou Municipal Airport, ME";
$coordinates['United States']['46.921:-114.093'] = "Missoula, Missoula International Airport, MT";
$coordinates['United States']['46.925:-96.811'] = "Fargo, Hector International Airport, ND";
$coordinates['United States']['46.973:-122.903'] = "Olympia, Olympia Airport, WA";
$coordinates['United States']['47.117:-122.550'] = "Fort Lewis / Gray U. S. Army Airfield, WA";
$coordinates['United States']['47.150:-122.483'] = "Tacoma / McChord Air Force Base, WA";
$coordinates['United States']['47.168:-88.489'] = "Hancock, Houghton County Memorial Airport, MI";
$coordinates['United States']['47.445:-122.314'] = "Seattle, Seattle-Tacoma International Airport, WA";
$coordinates['United States']['47.473:-111.382'] = "Great Falls, Great Falls International Airport, MT";
$coordinates['United States']['47.500:-94.933'] = "Bemidji, MN";
$coordinates['United States']['47.621:-117.528'] = "Spokane, Spokane International Airport, WA";
$coordinates['United States']['47.750:-101.833'] = "Roseglen, ND";
$coordinates['United States']['47.938:-124.555'] = "Quillayute, Quillayute State Airport, WA";
$coordinates['United States']['48.100:-98.867'] = "Devils Lake, ND";
$coordinates['United States']['48.133:-123.400'] = "Port Angeles Coast Guard Air Station, WA";
$coordinates['United States']['48.174:-103.637'] = "Williston, Sloulin Field International Airport, ND";
$coordinates['United States']['48.214:-106.621'] = "Glasgow, Glasgow International Airport, MT";
$coordinates['United States']['48.304:-114.264'] = "Kalispell, Glacier Park International Airport, MT";
$coordinates['United States']['48.543:-109.763'] = "Havre, Havre City-County Airport, MT";
$coordinates['United States']['48.562:-93.398'] = "International Falls, Falls International Airport, MN";
$coordinates['United States']['48.933:-95.350'] = "Warroad, MN";
$coordinates['United States']['51.890:-176.625'] = "Adak, Naval Air Station, AK";
$coordinates['United States']['52.717:174.117'] = "Shemya, Eareckson As, AK";
$coordinates['United States']['52.950:-168.850'] = "Nikolski, AK";
$coordinates['United States']['53.900:-166.550'] = "Dutch Harbor, AK";
$coordinates['United States']['55.033:-131.567'] = "Annette Island, AK";
$coordinates['United States']['55.221:-162.728'] = "Cold Bay, Cold Bay Airport, AK";
$coordinates['United States']['55.353:-131.722'] = "Ketchikan, Ketchikan International Airport, AK";
$coordinates['United States']['55.583:-133.083'] = "Klawock, Klawock Airport, AK";
$coordinates['United States']['56.483:-132.367'] = "Wrangell, AK";
$coordinates['United States']['56.817:-132.967'] = "Petersburg, AK";
$coordinates['United States']['56.950:-158.617'] = "Port Heiden, AK";
$coordinates['United States']['57.048:-135.365'] = "Sitka, Sitka Airport, AK";
$coordinates['United States']['57.150:-170.217'] = "Saint Paul, AK";
$coordinates['United States']['57.500:-134.583'] = "Angoon, AK";
$coordinates['United States']['57.750:-152.500'] = "Kodiak, AK";
$coordinates['United States']['58.356:-134.563'] = "Juneau, Juneau International Airport, AK";
$coordinates['United States']['58.417:-135.733'] = "Gustavus, AK";
$coordinates['United States']['58.650:-162.067'] = "Cape Newenham Airways Facilities Sector, AK";
$coordinates['United States']['58.684:-156.654'] = "King Salmon, King Salmon Airport, AK";
$coordinates['United States']['59.050:-158.517'] = "Dillingham Municipal, Ak, AK";
$coordinates['United States']['59.433:-146.333'] = "Middleton Island, Ak, AK";
$coordinates['United States']['59.467:-135.300'] = "Skagway, AK";
$coordinates['United States']['59.517:-139.667'] = "Yakutat, AK";
$coordinates['United States']['59.633:-151.500'] = "Homer / Municipal, AK";
$coordinates['United States']['59.750:-154.917'] = "Iliamna / Iliamna Airport, AK";
$coordinates['United States']['59.800:-144.600'] = "Cape Saint Elias, AK";
$coordinates['United States']['60.083:-142.500'] = "Yakataga, AK";
$coordinates['United States']['60.117:-149.450'] = "Seward, AK";
$coordinates['United States']['60.492:-145.478'] = "Cordova, Merle K. (Mudhole) Smith Airport, AK";
$coordinates['United States']['60.580:-151.239'] = "Kenai, Kenai Municipal Airport, AK";
$coordinates['United States']['60.783:-161.833'] = "Bethel / Bethel Airport, AK";
$coordinates['United States']['61.100:-155.567'] = "Sparrevohn Airways Facilities Sector, AK";
$coordinates['United States']['61.174:-149.996'] = "Anchorage, Ted Stevens Anchorage International Airport, AK";
$coordinates['United States']['61.250:-149.800'] = "Anchorage / Elmendorf Air Force Base, AK";
$coordinates['United States']['61.267:-149.650'] = "Ft. Richardson / Bryant U. S. Army Heliport, Ak, AK";
$coordinates['United States']['61.583:-159.533'] = "Aniak, AK";
$coordinates['United States']['61.600:-149.083'] = "Palmer, AK";
$coordinates['United States']['61.783:-166.033'] = "Cape Romanzoff Airways Facilities Sector, AK";
$coordinates['United States']['61.967:-151.183'] = "Skwentna, AK";
$coordinates['United States']['62.100:-152.750'] = "Puntilla, AK";
$coordinates['United States']['62.150:-145.450'] = "Gulkana, Gulkana Airport, AK";
$coordinates['United States']['62.321:-150.094'] = "Talkeetna, Talkeetna Airport, AK";
$coordinates['United States']['62.963:-141.936'] = "Northway, Northway Airport, AK";
$coordinates['United States']['62.967:-155.617'] = "McGrath, McGrath Airport, AK";
$coordinates['United States']['63.767:-171.733'] = "Gambell Automatic Weather Observing / Reporting System, AK";
$coordinates['United States']['63.883:-160.800'] = "Unalakleet, AK";
$coordinates['United States']['63.900:-152.267'] = "Minchumina, AK";
$coordinates['United States']['64.000:-145.733'] = "Fort Greely / Allen U. S. Army Airfield, Ak, AK";
$coordinates['United States']['64.512:-165.436'] = "Nome, Nome Airport, AK";
$coordinates['United States']['64.550:-149.083'] = "Nenana / Mun., AK";
$coordinates['United States']['64.650:-147.067'] = "Fairbanks / Eielson Air Force Base, AK";
$coordinates['United States']['64.733:-156.933'] = "Galena A., AK";
$coordinates['United States']['64.804:-147.876'] = "Fairbanks, Fairbanks International Airport, AK";
$coordinates['United States']['65.167:-152.100'] = "Tanana, Calhoun Memorial Airport, AK";
$coordinates['United States']['65.250:-166.867'] = "Port Clarence, AK";
$coordinates['United States']['65.567:-167.917'] = "Tin City Airways Facilities Sector, AK";
$coordinates['United States']['65.982:-161.152'] = "Buckland, Buckland Airport, AK";
$coordinates['United States']['66.000:-153.700'] = "Indian Mountain Airways Facilities Sector, AK";
$coordinates['United States']['66.567:-145.267'] = "Fort Yukon, AK";
$coordinates['United States']['66.886:-162.604'] = "Kotzebue, Wien Memorial Airport, AK";
$coordinates['United States']['66.917:-151.517'] = "Bettles, Bettles Airport, AK";
$coordinates['United States']['67.100:-157.850'] = "Ambler, Ambler Airport, AK";
$coordinates['United States']['68.883:-166.133'] = "Cape Lisburne Airways Facilities Sector, AK";
$coordinates['United States']['69.367:-152.133'] = "Umiat, AK";
$coordinates['United States']['69.817:-162.917'] = "Point Lay, AK";
$coordinates['United States']['70.133:-143.633'] = "Barter Island, AK";
$coordinates['United States']['70.210:-151.006'] = "Nuiqsut, Nuiqsut Airport, AK";
$coordinates['United States']['70.500:-149.883'] = "Oliktok Distant Early Warning, AK";
$coordinates['United States']['70.633:-159.850'] = "Wainwright, Wainwright Airport, AK";
$coordinates['United States']['71.284:-156.778'] = "Barrow, Post Rogers Memorial Airport, AK";
$coordinates['Uruguay']['-30.383:-56.500'] = "Artigas";
$coordinates['Uruguay']['-30.883:-55.533'] = "Rivera";
$coordinates['Uruguay']['-31.383:-57.950'] = "Salto";
$coordinates['Uruguay']['-31.700:-55.983'] = "Tacuarembo";
$coordinates['Uruguay']['-32.333:-58.033'] = "Paysandu";
$coordinates['Uruguay']['-32.367:-54.217'] = "Melo";
$coordinates['Uruguay']['-33.217:-54.383'] = "Treinta Y Tres";
$coordinates['Uruguay']['-33.250:-58.067'] = "Mercedes";
$coordinates['Uruguay']['-33.350:-56.500'] = "Durazno";
$coordinates['Uruguay']['-34.450:-57.833'] = "Colonia";
$coordinates['Uruguay']['-34.783:-56.250'] = "Melilla";
$coordinates['Uruguay']['-34.833:-56.000'] = "Carrasco";
$coordinates['Uzbekistan']['37.233:67.267'] = "Termez";
$coordinates['Uzbekistan']['39.567:66.950'] = "Samarkand";
$coordinates['Uzbekistan']['40.117:67.833'] = "Dzizak";
$coordinates['Uzbekistan']['41.267:69.267'] = "Tashkent";
$coordinates['Uzbekistan']['41.733:64.617'] = "Tamdy";
$coordinates['Vanuatu']['-13.850:167.550'] = "Sola Vanua Lava";
$coordinates['Vanuatu']['-15.517:167.217'] = "Pekoa Airport Santo";
$coordinates['Vanuatu']['-16.417:167.800'] = "Lamap Malekula";
$coordinates['Vanuatu']['-17.700:168.300'] = "Bauerfield Efate";
$coordinates['Venezuela']['10.067:-69.317'] = "Barquisimeto";
$coordinates['Venezuela']['10.117:-64.683'] = "Barcelona";
$coordinates['Venezuela']['10.167:-67.933'] = "Valencia";
$coordinates['Venezuela']['10.250:-67.650'] = "Maracay-B. A. Sucre";
$coordinates['Venezuela']['10.450:-64.183'] = "Cumana";
$coordinates['Venezuela']['10.500:-66.883'] = "Caracas / La Carlota";
$coordinates['Venezuela']['10.500:-68.000'] = "Pto. Cabello";
$coordinates['Venezuela']['10.567:-71.733'] = "Maracaibo-La Chinita";
$coordinates['Venezuela']['10.583:-62.317'] = "Guiria";
$coordinates['Venezuela']['10.600:-66.983'] = "Caracas / Maiquetia Aerop. Intl. Simon Bolivar";
$coordinates['Venezuela']['11.417:-69.683'] = "Coro";
$coordinates['Venezuela']['11.800:-66.183'] = "La Orchila";
$coordinates['Venezuela']['4.600:-61.117'] = "Santa Elena De Uairen";
$coordinates['Venezuela']['5.600:-67.500'] = "Puerto Ayacucho";
$coordinates['Venezuela']['7.233:-70.800'] = "Guasdualito";
$coordinates['Venezuela']['7.300:-61.450'] = "Tumeremo";
$coordinates['Venezuela']['7.583:-72.067'] = "Sto. Domingo";
$coordinates['Venezuela']['7.850:-72.450'] = "San Antonio Del Tachira";
$coordinates['Venezuela']['7.900:-67.417'] = "San Fernando De Apure";
$coordinates['Venezuela']['8.150:-63.550'] = "Ciudad Bolivar";
$coordinates['Venezuela']['8.600:-71.183'] = "Merida";
$coordinates['Venezuela']['8.617:-70.217'] = "Barinas";
$coordinates['Venezuela']['8.933:-67.417'] = "Calabozo";
$coordinates['Venezuela']['9.017:-62.617'] = "Temblador";
$coordinates['Venezuela']['9.017:-69.733'] = "Guanare";
$coordinates['Venezuela']['9.217:-66.017'] = "Valle De La Pascua";
$coordinates['Venezuela']['9.350:-70.617'] = "Valera";
$coordinates['Venezuela']['9.550:-69.233'] = "Acarigua";
$coordinates['Venezuela']['9.750:-63.183'] = "Maturin";
$coordinates['Venezuela']['9.817:-70.933'] = "Mene Grande";
$coordinates['Venezuela']['9.917:-67.333'] = "San Juan De Los Morros";
$coordinates['Viet Nam']['10.817:106.667'] = "Ho Chi Minh";
$coordinates['Viet Nam']['12.250:109.200'] = "Nha Trang";
$coordinates['Viet Nam']['13.767:109.217'] = "Quy Nhon";
$coordinates['Viet Nam']['13.983:108.000'] = "Pleiku City";
$coordinates['Viet Nam']['16.033:108.183'] = "Da Nang";
$coordinates['Viet Nam']['16.400:107.683'] = "Hue";
$coordinates['Viet Nam']['18.700:105.667'] = "Vinh";
$coordinates['Viet Nam']['21.017:105.800'] = "Ha Noi";
$coordinates['Virgin Islands, British']['18.450:-64.533'] = "Beef Island, Tortola";
$coordinates['Virgin Islands, United States']['17.700:-64.800'] = "Christiansted, Henry E. Rohlsen Airport";
$coordinates['Virgin Islands, United States']['18.333:-64.983'] = "Charlotte Amalie St. Thomas, Cyril E. King Airport";
$coordinates['Western Sahara']['23.700:-15.867'] = "Villa Cisneros";
$coordinates['Yemen']['12.633:53.900'] = "Socotra";
$coordinates['Yemen']['12.667:45.033'] = "Aden";
$coordinates['Yemen']['13.250:43.283'] = "Mokha";
$coordinates['Yemen']['13.250:44.133'] = "Mokha";
$coordinates['Yemen']['13.683:44.133'] = "Taiz";
$coordinates['Yemen']['14.517:46.850'] = "Ataq";
$coordinates['Yemen']['14.650:49.383'] = "Riyan";
$coordinates['Yemen']['14.750:42.983'] = "Hodeidah";
$coordinates['Yemen']['15.433:45.333'] = "Marib";
$coordinates['Yemen']['15.517:44.183'] = "Sana'A";
$coordinates['Yemen']['16.200:44.783'] = "Al-Hazm";
$coordinates['Yugoslavia']['42.367:19.250'] = "Podgorica / Golubovci";
$coordinates['Yugoslavia']['42.400:18.733'] = "Tivat";
$coordinates['Yugoslavia']['42.650:21.150'] = "Pristina";
$coordinates['Yugoslavia']['43.333:21.900'] = "Nis";
$coordinates['Yugoslavia']['43.350:17.800'] = "Mostar";
$coordinates['Yugoslavia']['43.817:18.333'] = "Sarajevo / Butmir";
$coordinates['Yugoslavia']['44.550:18.700'] = "Tuzla";
$coordinates['Yugoslavia']['44.783:17.217'] = "Banja Luka";
$coordinates['Yugoslavia']['44.817:15.883'] = "Bihac";
$coordinates['Yugoslavia']['44.817:20.283'] = "Beograd / Surcin";
$coordinates['Yugoslavia']['45.150:21.317'] = "Vrsac";
$coordinates['Zaire']['0.050:18.267'] = "Mbandaka";
$coordinates['Zaire']['0.133:29.267'] = "Butembo";
$coordinates['Zaire']['-0.217:20.850'] = "Boende";
$coordinates['Zaire']['0.517:25.183'] = "Kisangani";
$coordinates['Zaire']['-1.183:29.450'] = "Rutshuru";
$coordinates['Zaire']['-1.683:29.233'] = "Goma";
$coordinates['Zaire']['-1.967:18.267'] = "Inongo";
$coordinates['Zaire']['-10.717:25.450'] = "Kolwezi";
$coordinates['Zaire']['-11.667:27.483'] = "Lubumbashi-Luano";
$coordinates['Zaire']['-2.950:25.917'] = "Kindu";
$coordinates['Zaire']['3.283:19.783'] = "Gemena";
$coordinates['Zaire']['-3.300:17.350'] = "Bandundu";
$coordinates['Zaire']['-3.483:23.467'] = "Lodja";
$coordinates['Zaire']['-4.333:20.583'] = "Ilebo";
$coordinates['Zaire']['-4.383:15.433'] = "Kinshasa / N'Djili";
$coordinates['Zaire']['-4.917:17.067'] = "Kenge";
$coordinates['Zaire']['-4.967:23.433'] = "Lusambo";
$coordinates['Zaire']['-5.033:18.800'] = "Kikwit";
$coordinates['Zaire']['-5.350:27.000'] = "Kongolo";
$coordinates['Zaire']['-5.517:13.583'] = "Inga";
$coordinates['Zaire']['-5.800:13.433'] = "Matadi";
$coordinates['Zaire']['-5.883:22.417'] = "Kananga";
$coordinates['Zaire']['-5.883:29.183'] = "Kalemie";
$coordinates['Zaire']['-6.000:12.417'] = "Moanda";
$coordinates['Zaire']['-6.167:23.617'] = "Mbuji-Mayi";
$coordinates['Zaire']['-6.417:20.850'] = "Tshikapa";
$coordinates['Zaire']['-7.283:27.433'] = "Manono";
$coordinates['Zaire']['-8.633:25.250'] = "Kamina / Base";
$coordinates['Zambia']['-10.117:32.633'] = "Isoka";
$coordinates['Zambia']['-10.217:31.133'] = "Kasama";
$coordinates['Zambia']['-11.100:28.850'] = "Mansa";
$coordinates['Zambia']['-11.750:24.433'] = "Mwinilunga";
$coordinates['Zambia']['-11.900:31.433'] = "Mpika";
$coordinates['Zambia']['-12.183:26.383'] = "Solwezi";
$coordinates['Zambia']['-12.283:33.200'] = "Lundazi";
$coordinates['Zambia']['-13.000:28.650'] = "Ndola";
$coordinates['Zambia']['-13.233:30.217'] = "Serenje";
$coordinates['Zambia']['-13.533:23.117'] = "Zambezi";
$coordinates['Zambia']['-13.533:25.850'] = "Kasempa";
$coordinates['Zambia']['-13.550:32.583'] = "Chipata";
$coordinates['Zambia']['-13.600:24.200'] = "Kabompo";
$coordinates['Zambia']['-14.250:31.283'] = "Petauke";
$coordinates['Zambia']['-14.450:28.467'] = "Kabwe";
$coordinates['Zambia']['-14.450:28.467'] = "Lusaka City Airport";
$coordinates['Zambia']['-14.800:24.800'] = "Kaoma";
$coordinates['Zambia']['-15.250:23.150'] = "Mongu";
$coordinates['Zambia']['-15.317:28.450'] = "Lusaka Internationalairport";
$coordinates['Zambia']['-16.100:23.267'] = "Senanga";
$coordinates['Zambia']['-16.833:27.067'] = "Choma";
$coordinates['Zambia']['-17.467:24.300'] = "Sesheke";
$coordinates['Zambia']['-17.817:25.817'] = "Livingstone";
$coordinates['Zambia']['-8.850:31.333'] = "Mbala";
$coordinates['Zambia']['-9.800:29.083'] = "Kawambwa";
$coordinates['Zimbabwe']['-16.517:28.883'] = "Kariba";
$coordinates['Zimbabwe']['-16.833:29.617'] = "Karoi";
$coordinates['Zimbabwe']['-17.417:32.217'] = "Mutoko";
$coordinates['Zimbabwe']['-17.617:27.333'] = "Binga";
$coordinates['Zimbabwe']['-17.917:31.133'] = "Harare Kutsaga";
$coordinates['Zimbabwe']['-18.100:25.850'] = "Victoria Falls";
$coordinates['Zimbabwe']['-18.217:28.933'] = "Gokwe";
$coordinates['Zimbabwe']['-18.533:32.133'] = "Rusape";
$coordinates['Zimbabwe']['-18.633:27.000'] = "Hwange National Park";
$coordinates['Zimbabwe']['-19.450:29.850'] = "Gweru";
$coordinates['Zimbabwe']['-20.017:28.617'] = "Bulawayo Airport";
$coordinates['Zimbabwe']['-20.067:30.867'] = "Masvingo";
$coordinates['Zimbabwe']['-20.200:32.617'] = "Chipinge";
$coordinates['Zimbabwe']['-21.017:31.583'] = "Buffalo Range";
$coordinates['Zimbabwe']['-22.217:30.000'] = "Beitbridge";
