/*
 *	HT Editor
 *	htpal.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "global.h"
#include "htatom.h"
#include "htcurses.h"
#include "htctrl.h"
#include "htdialog.h"
#include "htpal.h"
#include "htreg.h"
#include "httag.h"
#include "htstring.h"
#include "tools.h"

#include <stdlib.h>
#include <string.h>

#define ATOM_PALETTE_ENTRY			MAGICD("PAL\x00")
#define ATOM_HT_CREATE_PALETTE_ENTRY	MAGICD("PAL\x10")

/* WINDIALOG - BLACK */
defpal defpal_windialog_black[palcolors_windialog]={
{palidx_windialog_body,				"body", VCP(VC_WHITE, VC_BLACK)},
{palidx_windialog_shortcut, 			"shortcut", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_windialog_frame_focused,		"frame focused", VCP(VC_WHITE, VC_TRANSPARENT)},
{palidx_windialog_frame_unfocused,		"frame unfocused", VCP(VC_WHITE, VC_TRANSPARENT)},
{palidx_windialog_frame_moved, 		"frame moved", VCP(VC_LIGHT(VC_GREEN), VC_TRANSPARENT)},
{palidx_windialog_frame_killer,		"frame icons", VCP(VC_GREEN, VC_TRANSPARENT)},
{palidx_windialog_scrollbar,			"scrollbar", VCP(VC_WHITE, VC_BLACK)},

{palidx_windialog_input_focused,		"input focused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_unfocused,		"input unfocused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_selected,		"input selected", VCP(VC_BLACK, VC_WHITE)},
{palidx_windialog_input_clip,			"input clipping chars", VCP(VC_WHITE, VC_BLUE)},

{palidx_windialog_button_focused,		"button focused", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_button_unfocused,	"button unfocused", VCP(VC_BLACK, VC_GREEN)},
{palidx_windialog_button_shadow,		"button shadow", VCP(VC_LIGHT(VC_BLACK), VC_BLACK)},
{palidx_windialog_button_shortcut,		"button shortcut", VCP(VC_BLACK, VC_WHITE)},

{palidx_windialog_list_focused_selected, "list focused & selected", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_list_focused_unselected, "list focused & unselected", VCP(VC_WHITE, VC_BLACK)},
{palidx_windialog_list_unfocused_selected, "list unfocused & selected", VCP(VC_LIGHT(VC_WHITE), VC_BLACK)},
{palidx_windialog_list_unfocused_unselected, "list unfocused & unselected", VCP(VC_WHITE, VC_BLACK)},

{palidx_windialog_cluster_focused,		"cluster focused", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_cluster_unfocused,	"cluster unfocused", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_cluster_shortcut,	"cluster shortcut", VCP(VC_BLACK, VC_CYAN)},

{palidx_windialog_label_focused,		"label focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)}

};

/* WINDIALOG - SPECIAL */
defpal defpal_windialog_special[palcolors_windialog]={
{palidx_windialog_body,				"body", VCP(VC_WHITE, VC_CYAN)},
{palidx_windialog_shortcut, 			"shortcut", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_frame_focused,		"frame focused", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_frame_unfocused,		"frame unfocused", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_frame_moved, 		"frame moved", VCP(VC_LIGHT(VC_GREEN), VC_CYAN)},
{palidx_windialog_frame_killer,		"frame icons", VCP(VC_LIGHT(VC_GREEN), VC_CYAN)},
{palidx_windialog_scrollbar,			"scrollbar", VCP(VC_CYAN, VC_BLUE)},

{palidx_windialog_input_focused,		"input focused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_unfocused,		"input unfocused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_selected,		"input selected", VCP(VC_BLACK, VC_WHITE)},
{palidx_windialog_input_clip,			"input clipping chars", VCP(VC_WHITE, VC_BLUE)},

{palidx_windialog_button_focused,		"button focused", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_button_unfocused,	"button unfocused", VCP(VC_BLACK, VC_GREEN)},
{palidx_windialog_button_shadow,		"button shadow", VCP(VC_TRANSPARENT, VC_CYAN)},
{palidx_windialog_button_shortcut,		"button shortcut", VCP(VC_BLACK, VC_WHITE)},

{palidx_windialog_list_focused_selected, "list focused & selected", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_list_focused_unselected, "list focused & unselected", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_list_unfocused_selected, "list unfocused & selected", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_list_unfocused_unselected, "list unfocused & unselected", VCP(VC_BLACK, VC_CYAN)},

{palidx_windialog_cluster_focused,		"cluster focused", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_cluster_unfocused,	"cluster unfocused", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_cluster_shortcut,	"cluster shortcut", VCP(VC_BLACK, VC_CYAN)},

{palidx_windialog_label_focused,		"label focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)}

};

/* WINDIALOG - CYAN */
defpal defpal_windialog_cyan[palcolors_windialog]={
{palidx_windialog_body,				"body", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_shortcut, 			"shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_TRANSPARENT)},
{palidx_windialog_frame_focused,		"frame focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_windialog_frame_unfocused,		"frame unfocused", VCP(VC_BLACK, VC_TRANSPARENT)},
{palidx_windialog_frame_moved, 		"frame moved", VCP(VC_LIGHT(VC_GREEN), VC_TRANSPARENT)},
{palidx_windialog_frame_killer,		"frame icons", VCP(VC_LIGHT(VC_GREEN), VC_TRANSPARENT)},
{palidx_windialog_scrollbar,			"scrollbar", VCP(VC_CYAN, VC_BLUE)},

{palidx_windialog_input_focused,		"input focused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_unfocused,		"input unfocused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_selected,		"input selected", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_input_clip,			"input clipping chars", VCP(VC_WHITE, VC_BLUE)},

{palidx_windialog_button_focused,		"button focused", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_button_unfocused,	"button unfocused", VCP(VC_BLACK, VC_GREEN)},
{palidx_windialog_button_shadow,		"button shadow", VCP(VC_LIGHT(VC_BLACK), VC_BLACK)},
{palidx_windialog_button_shortcut,		"button shortcut", VCP(VC_BLACK, VC_WHITE)},

{palidx_windialog_list_focused_selected, "list focused & selected", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_list_focused_unselected, "list focused & unselected", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_list_unfocused_selected, "list unfocused & selected", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_list_unfocused_unselected, "list unfocused & unselected", VCP(VC_BLACK, VC_CYAN)},

{palidx_windialog_cluster_focused,		"cluster focused", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_cluster_unfocused,	"cluster unfocused", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_cluster_shortcut,	"cluster shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_CYAN)},

{palidx_windialog_label_focused,		"label focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)}

};

/* WINDIALOG - BLUE */
defpal defpal_windialog_blue[palcolors_windialog]={
{palidx_windialog_body,				"body", VCP(VC_BLACK, VC_BLUE)},
{palidx_windialog_shortcut, 			"shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_TRANSPARENT)},
{palidx_windialog_frame_focused,		"frame focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_windialog_frame_unfocused,		"frame unfocused", VCP(VC_WHITE, VC_TRANSPARENT)},
{palidx_windialog_frame_moved, 		"frame moved", VCP(VC_LIGHT(VC_GREEN), VC_TRANSPARENT)},
{palidx_windialog_frame_killer,		"frame icons", VCP(VC_LIGHT(VC_GREEN), VC_TRANSPARENT)},
{palidx_windialog_scrollbar,			"scrollbar", VCP(VC_CYAN, VC_BLUE)},

{palidx_windialog_input_focused,		"input focused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_unfocused,		"input unfocused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_selected,		"input selected", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_input_clip,			"input clipping chars", VCP(VC_WHITE, VC_BLUE)},

{palidx_windialog_button_focused,		"button focused", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_button_unfocused,	"button unfocused", VCP(VC_BLACK, VC_GREEN)},
{palidx_windialog_button_shadow,		"button shadow", VCP(VC_LIGHT(VC_BLACK), VC_BLACK)},
{palidx_windialog_button_shortcut,		"button shortcut", VCP(VC_BLACK, VC_WHITE)},

{palidx_windialog_list_focused_selected, "list focused & selected", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_list_focused_unselected, "list focused & unselected", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_list_unfocused_selected, "list unfocused & selected", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_list_unfocused_unselected, "list unfocused & unselected", VCP(VC_BLACK, VC_BLUE)},

{palidx_windialog_cluster_focused,		"cluster focused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_cluster_unfocused,	"cluster unfocused", VCP(VC_BLACK, VC_BLUE)},
{palidx_windialog_cluster_shortcut,	"cluster shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_BLUE)},

{palidx_windialog_label_focused,		"label focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)}

};

/* WINDIALOG - GRAY */
defpal defpal_windialog_gray[palcolors_windialog]={
{palidx_windialog_body,				"body", VCP(VC_BLACK, VC_WHITE)},
{palidx_windialog_shortcut, 			"shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_TRANSPARENT)},
{palidx_windialog_frame_focused,		"frame focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_windialog_frame_unfocused,		"frame unfocused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_windialog_frame_moved, 		"frame moved", VCP(VC_LIGHT(VC_YELLOW), VC_TRANSPARENT)},
{palidx_windialog_frame_killer,		"frame icons", VCP(VC_LIGHT(VC_GREEN), VC_TRANSPARENT)},
{palidx_windialog_scrollbar,			"scrollbar", VCP(VC_CYAN, VC_BLUE)},

{palidx_windialog_input_focused,		"input focused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_unfocused,		"input unfocused", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_windialog_input_selected,		"input selected", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_input_clip,			"input clipping chars", VCP(VC_WHITE, VC_BLUE)},

{palidx_windialog_button_focused,		"button focused", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_button_unfocused,	"button unfocused", VCP(VC_BLACK, VC_GREEN)},
{palidx_windialog_button_shadow,		"button shadow", VCP(VC_BLACK, VC_TRANSPARENT)},
{palidx_windialog_button_shortcut,		"button shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_GREEN)},

{palidx_windialog_list_focused_selected, "list focused & selected", VCP(VC_LIGHT(VC_WHITE), VC_GREEN)},
{palidx_windialog_list_focused_unselected, "list focused & unselected", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_list_unfocused_selected, "list unfocused & selected", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_list_unfocused_unselected, "list unfocused & unselected", VCP(VC_BLACK, VC_CYAN)},

{palidx_windialog_cluster_focused,		"cluster focused", VCP(VC_LIGHT(VC_WHITE), VC_CYAN)},
{palidx_windialog_cluster_unfocused,	"cluster unfocused", VCP(VC_BLACK, VC_CYAN)},
{palidx_windialog_cluster_shortcut,	"cluster shortcut", VCP(VC_LIGHT(VC_YELLOW), VC_CYAN)},

{palidx_windialog_label_focused,		"label focused", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)}
};

/* DESKTOP */
defpal defpal_desktop[palcolors_desktop]={
{palidx_windialog_body,				"body", VCP(VC_BLUE, VC_BLACK)}
};

/* KEYLINE */
defpal defpal_keyline[palcolors_keyline]={
{palidx_keyline_digit,				"digit", VCP(VC_WHITE, VC_BLACK)},
{palidx_keyline_active,				"active", VCP(VC_BLACK, VC_CYAN)},
{palidx_keyline_inactive,			"inactive", VCP(VC_WHITE, VC_CYAN)}
};

/* TAGS */
defpal defpal_tags_black[palcolors_tags]={
{palidx_tag_normal,					"normal", VCP(VC_WHITE, VC_TRANSPARENT)},
{palidx_tag_edit_cursor_sel,			"editable: select-cursor", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_tag_edit_cursor_edit,			"editable: edit-cursor", VCP(VC_LIGHT(VC_WHITE), VC_RED)},
{palidx_tag_edit_cursor_passive,		"editable: passive-cursor", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_tag_edit_selected,			"editable: selected", VCP(VC_TRANSPARENT, VC_WHITE)},
{palidx_tag_edit_modified,			"editable: modified", VCP(VC_RED, VC_TRANSPARENT)},
{palidx_tag_edit_normal,				"editable: normal", VCP(VC_LIGHT(VC_BLACK), VC_TRANSPARENT)},
{palidx_tag_sel_cursor,				"selectable: cursor", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_tag_sel_normal,				"selectable: normal", VCP(VC_CYAN, VC_TRANSPARENT)}
};

defpal defpal_tags_blue[palcolors_tags]={
{palidx_tag_normal,					"normal", VCP(VC_LIGHT(VC_WHITE), VC_TRANSPARENT)},
{palidx_tag_edit_cursor_sel,			"editable: select-cursor", VCP(VC_LIGHT(VC_WHITE), VC_WHITE)},
{palidx_tag_edit_cursor_edit,			"editable: edit-cursor", VCP(VC_LIGHT(VC_WHITE), VC_RED)},
{palidx_tag_edit_cursor_passive,		"editable: passive-cursor", VCP(VC_LIGHT(VC_WHITE), VC_WHITE)},
{palidx_tag_edit_selected,			"editable: selected", VCP(VC_TRANSPARENT, VC_WHITE)},
{palidx_tag_edit_modified,			"editable: modified", VCP(VC_RED, VC_TRANSPARENT)},
{palidx_tag_edit_normal,				"editable: normal", VCP(VC_WHITE, VC_TRANSPARENT)},
{palidx_tag_sel_cursor,				"selectable: cursor", VCP(VC_LIGHT(VC_WHITE), VC_BLUE)},
{palidx_tag_sel_normal,				"selectable: normal", VCP(VC_CYAN, VC_TRANSPARENT)}
};

/*
 *   reg/pal management
 */

int create_pal(char *pal_class, char *pal_name, defpal *p, int entry_count, ht_registry_node_type rnt_pal)
{
	char key[1024], *k=key;	/* FIXME: possible buffer overflow */
	k+=sprintf(k, "%s/%s/%s", palettekey, pal_class, pal_name);
	int e=registry->create_subdir(key);
	if (e) return e;
	k+=sprintf(k, "/");
	for (int i=0; i<entry_count; i++) {
		strcpy(k, p[i].name);
		e=registry->create_node(key, rnt_pal);
		e=registry->set_node(key, rnt_pal, new palette_entry(p[i].idx, p[i].color));
		if (e) return e;
	}
	return 0;
}

vcp getcolorv(palette *pal, UINT index)
{
	if ((index<pal->size) && (pal->data)) return pal->data[index];
	return VCP(VC_WHITE, VC_RED);
}

bool reloadpalettev(char *pal_class, char *pal_name, palette *p)
{
	if ((!pal_name) || (!pal_class)) return 0;
	char key[1024];	/* FIXME: possible buffer overflow ! */
	sprintf(key, "%s/%s/%s", palettekey, pal_class, pal_name);
	ht_registry_node_type t;
	palette_entry *d;
	char *n;
	ht_registry_node_type rnt_pal=registry->lookup_node_type(rnt_palette_name);
	UINT entry_count=0;
	UINT pal_size=0;
	if (registry->enum_first(key, &n, (ht_registry_data**)&d, &t)) {
		do {
			if (t==rnt_pal) {
				if (d->idx+1>pal_size) pal_size=d->idx+1;
				entry_count++;
			}
		} while (registry->enum_next(&n, (ht_registry_data**)&d, &t));
	}

	if ((pal_size==entry_count) && (pal_size)) {
		vcp *pal=(vcp*)malloc(sizeof (vcp) * pal_size);
		if (registry->enum_first(key, &n, (ht_registry_data**)&d, &t)) {
			do {
				if (t==rnt_pal) {
					pal[d->idx]=d->color;
				}
			} while (registry->enum_next(&n, (ht_registry_data**)&d, &t));
		}
		p->data=pal;
		p->size=pal_size;
		return 1;
	}
	return 0;
}


/*
 *	CLASS palette_entry
 */
 
palette_entry::palette_entry(UINT _idx=0, vcp _color=0)
{
	idx=_idx;
	color=_color;
}

bool palette_entry::editdialog(char *keyname)
{
	bool r=0;
	bounds b;
	b.w=50;
	b.h=15;
	b.x=(screen->size.w-b.w)/2;
	b.y=(screen->size.h-b.h)/2;
	
	ht_dialog *d=new ht_dialog();
	d->init(&b, "edit palette entry", FS_TITLE | FS_KILLER);
	
	ht_color_block *fgc, *bgc;
	ht_label *l1, *l2;
	
	BOUNDS_ASSIGN(b, 2, 1, 16, 5);
	fgc=new ht_color_block();
	fgc->init(&b, VCP_FOREGROUND(color), cf_transparent | cf_light);
	d->insert(fgc);

	BOUNDS_ASSIGN(b, 2, 0, 16, 1);
	l1 = new ht_label();
	l1->init(&b, "~foreground", fgc);
	d->insert(l1);
	
	BOUNDS_ASSIGN(b, 20, 1, 16, 5);
	bgc=new ht_color_block();
	bgc->init(&b, VCP_BACKGROUND(color), cf_transparent | cf_light);
	d->insert(bgc);
	
	BOUNDS_ASSIGN(b, 20, 0, 16, 1);
	l2 = new ht_label();
	l2->init(&b, "~background", bgc);
	d->insert(l2);

	if (d->run(0)) {
		ht_color_block_data fgd, bgd;
		fgc->databuf_get(&fgd);
		bgc->databuf_get(&bgd);
		color=VCP(fgd.color, bgd.color);
		r=1;
	}
	
	d->done();
	delete d;
	return r;
}

int palette_entry::load(ht_object_stream *f)
{
	idx=f->get_int_hex(4, 0);
	color=f->get_int_hex(4, 0);
	return f->get_error();
}

OBJECT_ID palette_entry::object_id()
{
	return ATOM_PALETTE_ENTRY;
}

void palette_entry::store(ht_object_stream *f)
{
	f->put_int_hex(idx, 4, 0);
	f->put_int_hex(color, 4, 0);
}

void palette_entry::strvalue(char *buf32bytes)
{
	char *p=buf32bytes;
	char *text;
	int fg=VCP_FOREGROUND(color);
	int bg=VCP_BACKGROUND(color);
	if ((fg==VC_TRANSPARENT) && (bg==VC_TRANSPARENT)) {
		text="transparent";
		fg=VC_WHITE;
		bg=VC_BLACK;
	} else if (fg==VC_TRANSPARENT) {
		text="fgtrans";
		fg=VC_WHITE;
		if (bg==fg) fg=VC_BLACK;
	} else if (bg==VC_TRANSPARENT) {
		text="bgtrans";
		bg=VC_BLACK;
		if (bg==fg) fg=VC_WHITE;
	} else {
		text="normal";
	}
	p=tag_make_color(p, VCP(fg, bg));
	p+=sprintf(p, text);
	p=tag_make_color(p, -1);
	*p=0;
}

ht_registry_data *create_empty_palette_entry()
{
	return new palette_entry();
}

/*
 *	INIT
 */

BUILDER(ATOM_PALETTE_ENTRY, palette_entry);

bool init_pal()
{
	int b=0;
	ht_registry_node_type rnt_pal=registry->have_node_type(rnt_palette_name, create_empty_palette_entry);

	b|=registry->create_subdir(palettekey);

/* WINDIALOG */
	b|=registry->create_subdir(palettekey"/"palclasskey_windialog);

	b|=create_pal(palclasskey_windialog, palkey_windialog_black, defpal_windialog_black, palcolors_windialog, rnt_pal);
	b|=create_pal(palclasskey_windialog, palkey_windialog_special, defpal_windialog_special, palcolors_windialog, rnt_pal);
	b|=create_pal(palclasskey_windialog, palkey_windialog_cyan, defpal_windialog_cyan, palcolors_windialog, rnt_pal);
	b|=create_pal(palclasskey_windialog, palkey_windialog_blue, defpal_windialog_blue, palcolors_windialog, rnt_pal);
	b|=create_pal(palclasskey_windialog, palkey_windialog_gray, defpal_windialog_gray, palcolors_windialog, rnt_pal);

	b|=registry->create_node(palettekey"/"palclasskey_windialog"/"palkey_windialog_window_default, RNT_SYMLINK);
	b|=registry->set_symlink(palettekey"/"palclasskey_windialog"/"palkey_windialog_window_default, palkey_windialog_black);
//     b&=registry->set_symlink(palettekey"/"palclasskey_windialog"/"palkey_windialog_window_default, palkey_windialog_blue);

	b|=registry->create_node(palettekey"/"palclasskey_windialog"/"palkey_windialog_dialog_default, RNT_SYMLINK);
	b|=registry->set_symlink(palettekey"/"palclasskey_windialog"/"palkey_windialog_dialog_default, palkey_windialog_gray);

/* DESKTOP */
	b|=registry->create_subdir(palettekey"/"palclasskey_desktop);

	b|=create_pal(palclasskey_desktop, palkey_desktop_default, defpal_desktop, palcolors_desktop, rnt_pal);

/* KEYLINE */
	b|=registry->create_subdir(palettekey"/"palclasskey_keyline);

	b|=create_pal(palclasskey_keyline, palkey_keyline_default, defpal_keyline, palcolors_keyline, rnt_pal);

/* TAGS */
	b|=registry->create_subdir(palettekey"/"palclasskey_tags);

	b|=create_pal(palclasskey_tags, palkey_tags_black, defpal_tags_black, palcolors_tags, rnt_pal);
	b|=create_pal(palclasskey_tags, palkey_tags_blue, defpal_tags_blue, palcolors_tags, rnt_pal);

	b|=registry->create_node(palettekey"/"palclasskey_tags"/"palkey_tags_default, RNT_SYMLINK);
	b|=registry->set_symlink(palettekey"/"palclasskey_tags"/"palkey_tags_default, palkey_tags_black);

	REGISTER(ATOM_PALETTE_ENTRY, palette_entry);
	register_atom(ATOM_HT_CREATE_PALETTE_ENTRY, (void*)create_empty_palette_entry);
	return b ? false : true;
}

/*
 *	DONE
 */

void done_pal()
{
	UNREGISTER(ATOM_PALETTE_ENTRY, palette_entry);
	unregister_atom(ATOM_HT_CREATE_PALETTE_ENTRY);
}

