/*
 *	HT Editor
 *	htanaly.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Sebastian Biallas (sb@web-productions.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __TOOLS_H__
#define __TOOLS_H__

#include <stdlib.h>
#include "global.h"

int *random_permutation(int max);
double calc_entropy(byte *buf, int size);
int calc_entropy2(byte *buf, int size);

#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX(a, b) ((a) > (b) ? (a) : (b))

/* actually a str => bigendian-int */
#define MAGICW(magic) (unsigned short)(((unsigned char)magic[0]<<8) | (unsigned char)magic[1])
#define MAGICD(magic) (unsigned long)(((unsigned char)magic[0]<<24) | ((unsigned char)magic[1]<<16) | ((unsigned char)magic[2]<<8) | (unsigned char)magic[3])

#define OUT_OF_MEMORY_FAIL 0
#define OUT_OF_MEMORY_IGNORE 1
#define OUT_OF_MEMORY_RETRY 2
extern int (*out_of_memory_func)(int size);
int out_of_memory(int size);

// savety mallocs
void *smalloc(size_t size);
void *smalloc0(size_t size);

#endif /* __TOOLS_H__ */
