///////
   //    SchedulerEntry .cc
   //    Scheduler Entry Class definitions
   //
   //    Class for interfacing the Schedule table of the DB
   //
   //    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: SchedulerEntry.cc,v 1.14 2002/02/18 10:44:59 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 14.09.1999
///////

#include "_Server.h"
#include "SchedulerEntry.h"

   // Static variables initialization
      int SchedulerEntry::debug = 0;

///////
   //    Construction
///////

SchedulerEntry::SchedulerEntry(const String &u)
{
   SetNewUrl(u);
}

///////
   //    Destruction
///////

SchedulerEntry::~SchedulerEntry ()
{
}

///////
   //    Reset the schedule content
///////

void SchedulerEntry::Reset()
{
   ScheduleUrl.trunc();
   IDSchedule=0;
   IDServer=0;
   IDReferer=0;
   HopCount=0;
   server=0;
   Status=Url_Empty;
   is_malformed=false;
}


///////
   //    Set the new url to the schedule
///////

void SchedulerEntry::SetNewUrl(const String &u)
{
   Reset();
   SetScheduleUrl(u);
}


///////
   //    Converts the Schedule_Status value into the corresponding
   //    String value
///////

void SchedulerEntry::RetrieveStatus(String &Status) const
{

   switch(GetStatus())
   {
      case (Url_Empty):
         Status="";
         break;
      case (Url_ToBeRetrieved):
         Status="ToBeRetrieved";
         break;
      case (Url_Retrieved):
         Status="Retrieved";
         break;
      case (Url_CheckIfExists):
         Status="CheckIfExists";
         break;
      case (Url_Checked):
         Status="Checked";
         break;
      case (Url_BadQueryString):
         Status="BadQueryString";
         break;
      case (Url_BadExtension):
         Status="BadExtension";
         break;
      case (Url_MaxHopCount):
         Status="MaxHopCount";
         break;
      case (Url_FileProtocol):
         Status="FileProtocol";
         break;
      case (Url_EMail):
         Status="EMail";
         break;
      case (Url_Javascript):
         Status="Javascript";
         break;
      case (Url_NotValidService):
         Status="NotValidService";
         break;
      case (Url_Malformed):
         Status="Malformed";
         break;
   }

}


///////
   //    Set the server ID, given a server
   //    if the server is null, ID is set to 0
///////

void SchedulerEntry::SetServer (_Server *s)
{
   server = s;
   if (s) IDServer = s->GetID();
   else IDServer = 0;
}


///////
   //    Converts the Status string value
   //    into the corresponding Schedule_Status value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int SchedulerEntry::SetStatus(const String &Status)
{

   if (!strcmp(Status, ""))
      SetStatus (Url_Empty);
   if (!strcmp(Status, "ToBeRetrieved"))
      SetStatus (Url_ToBeRetrieved);
   else if (!strcmp(Status, "Retrieved"))
      SetStatus (Url_Retrieved);
   else if (!strcmp(Status, "CheckIfExists"))
      SetStatus (Url_CheckIfExists);
   else if (!strcmp(Status, "Checked"))
      SetStatus (Url_Checked);
   else if (!strcmp(Status, "BadQueryString"))
      SetStatus (Url_BadQueryString);
   else if (!strcmp(Status, "BadExtension"))
      SetStatus (Url_BadExtension);
   else if (!strcmp(Status, "MaxHopCount"))
      SetStatus (Url_MaxHopCount);
   else if (!strcmp(Status, "FileProtocol"))
      SetStatus (Url_FileProtocol);
   else if (!strcmp(Status, "EMail"))
      SetStatus (Url_EMail);
   else if (!strcmp(Status, "Javascript"))
      SetStatus (Url_Javascript);
   else if (!strcmp(Status, "NotValidService"))
      SetStatus (Url_NotValidService);
   else if (!strcmp(Status, "Malformed"))
      SetStatus (Url_Malformed);
   else return 0;
   
   return 1;
}


///////
   //    Output SchedulerEntry object
///////
ostream& operator<<( ostream &output, const SchedulerEntry &s)
{
   output << s.ScheduleUrl;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (ID: " << s.IDSchedule << " / "
      << "IDServer: " << s.IDServer << " / ";

   String Status="";

   s.RetrieveStatus(Status);

   if (!strcmp ((char *)Status, ""))
      Status = "Not yet assigned";
      
   output << (int) s.Status << " - " << Status << " )";
   
   if (s.server)
      output << " Server: " << s.server->host() << ":" << s.server->port();
   
   return output;
}
