/* http.h
 * - HTTP function declarations
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_HTTP_H
#define __ICECAST_HTTP_H

typedef struct 
{
	char *name;                   /* User printable name of the function. */
	icecast_function *func;               /* Function to call to do the job. */
	int wrap;
	char *argument;
} http_command_t;

typedef struct
{
	int message_type;
	char *html;
} html_wrapper_t;

int updinfo (connection_t *con, vartree_t *request_vars);
void handle_http_admin_command (connection_t *con, vartree_t *request_vars);
int http_admin_command (connection_t *con, request_t *req);
void display_admin_page (connection_t *con, request_t *req);
void write_http_header (sock_t sockfd, int error, const char *msg);
int print_http_variable (vartree_t *request_vars, const char *name, connection_t *clicon, int fd);
char *url_encode(const char *string, char **result_p);
char *url_decode (const char *string);
char *html_escape(const char *string);
const char *parse_template_file (connection_t *clicon, connection_t *sourcecon, const char *ptr, int fd, vartree_t *variables);
int write_template_parsed_html_page (connection_t *clicon, connection_t *sourcecon, const char *template_file, int fd, vartree_t *variables);
const char *http_loop_sources (char *ident, connection_t *clicon, const char *ptr, int fd, vartree_t *variables);
const char *http_loop_admins (char *ident, connection_t *clicon, const char *ptr, int fd, vartree_t *variables);
const char *http_loop_listeners (char *ident, connection_t *clicon, const char *ptr, int fd, vartree_t *variables);
const char *http_loop_directory (char *ident, connection_t *clicon, const char *ptr, int fd, vartree_t *variables);
char *ice_uptime ();
char *ice_starttime ();
const void *get_http_variable (vartree_t *request_vars, const char *name);
void write_http_code_page (connection_t *con, int code, const char *msg);
void write_401 (connection_t *con, char *realm);
void write_didnt_find_html_page (connection_t *con, char *file);
void display_generic_admin_page (connection_t *con);
int http_write_string (const com_request_t *req, const int message_type, const char *buff);
const http_command_t *find_http_command (const char *name, const http_command_t *el);
int http_display (com_request_t *req);
void write_no_such_command (connection_t *con, const char *name);
int http_help (com_request_t *req);
int http_change (com_request_t *req);
void update_metadata_on_relays (connection_t *con, const char *mount, const char *song, const char *msg, const char *length, const char *url);
void update_metadata_on_relay (connection_t *con, const char *mount, const char *song, const char *msg, const char *length, const char *url);
void http_puke_file_to_socket (SOCKET s, const char *template_file);
#endif





